/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.gamification.badging.api;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.gamification.badging.api.BadgeCollection;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.PageInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBadgeCollection
extends BaseSocialComponent
implements BadgeCollection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBadgeCollection.class);
    private final CommunityContext context;
    protected CollectionPagination pagination = CollectionPagination.DEFAULT_PAGINATION;
    private PageInfo pageInfo;
    private List<Object> badges;

    public AbstractBadgeCollection(Resource resource, ClientUtilities clientUtils, CollectionPagination pagination) {
        this(resource, clientUtils);
        this.setPagination(pagination);
        this.pageInfo = new PageInfo(this, clientUtils, this.pagination);
    }

    public AbstractBadgeCollection(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);
        this.context = resource.adaptTo(CommunityContext.class);
        this.pageInfo = new PageInfo(this, clientUtils, this.pagination);
    }

    @Override
    public int getTotalSize() {
        if (this.badges == null) {
            this.badges = this.getItems();
        }
        return this.badges.size();
    }

    @Override
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        this.pagination = pagination;
        this.badges = null;
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
    }

    @Override
    public List<Object> getItems() {
        if (this.badges == null) {
            this.badges = new ArrayList<Object>();
            Iterable<Resource> userBadges = null;
            try {
                userBadges = this.getBadges();
            }
            catch (OperationException oe) {
                LOG.error("Failed to get the list of badges.", oe);
                return this.badges;
            }
            if (this.badges == null) {
                LOG.error("Failed to get the list of badges.");
                return this.badges;
            }
            this.fetchBadgeList(userBadges);
        }
        return this.badges;
    }

    private void fetchBadgeList(Iterable<Resource> badgeIterator) {
        for (Resource resource : badgeIterator) {
            if (resource == null) continue;
            if (resource.getValueMap().get("jcr:primaryType", String.class) != "cq:Page" && resource.isResourceType("social/gamification/components/hbs/badgecollection/badge")) {
                this.addBadgeComponent(resource);
                continue;
            }
            for (Resource badge : resource.getChildren()) {
                if (badge != null && badge.isResourceType("social/gamification/components/hbs/badgecollection/badge")) {
                    this.addBadgeComponent(badge);
                    continue;
                }
                LOG.debug("No Badges found");
            }
        }
    }

    private void addBadgeComponent(Resource resource) {
        SocialComponent component;
        SocialComponentFactory factory = this.clientUtils.getSocialComponentFactoryManager().getSocialComponentFactory(resource);
        if (factory != null && (component = factory.getSocialComponent(resource)) != null) {
            this.badges.add(component);
        }
    }

    protected CommunityContext getContext() {
        return this.context;
    }

    protected abstract Iterable<Resource> getBadges() throws OperationException;
}

