/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.gamification.badging.api.utils;

import com.adobe.cq.social.commons.Attachment;
import com.adobe.cq.social.scf.ClientUtilities;
import com.day.text.Text;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentUtils.class);

    public static Attachment getAttachment(final Resource attachmentResource, ClientUtilities clientUtils) {
        final Node attNode = attachmentResource.adaptTo(Node.class);
        String mime = "";
        try {
            mime = attNode == null ? "" : attNode.getProperty("jcr:content/jcr:mimeType").getString();
        }
        catch (ValueFormatException valueFormatException) {
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        final String mimeType = mime;
        Attachment attachment = new Attachment(){

            @Override
            public boolean isImage() {
                return mimeType.contains("image");
            }

            @Override
            public String getType() {
                return mimeType;
            }

            @Override
            public String getPath() {
                return attachmentResource.getPath();
            }

            @Override
            public String getThumbnailUrl() {
                return attachmentResource.getPath();
            }

            @Override
            public String getName() {
                String fileName = "";
                try {
                    fileName = attNode.hasProperty("name") ? attNode.getProperty("name").getString() : Text.getName(this.getPath());
                }
                catch (ValueFormatException e) {
                    LOG.error("Error getting attachment node path as String", e);
                }
                catch (PathNotFoundException e) {
                    LOG.error("Error getting attachment node path as its not found", e);
                }
                catch (RepositoryException e) {
                    LOG.error("Error getting attachment node path", e);
                }
                return fileName;
            }
        };
        return attachment;
    }
}

