/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ideation.client.api;

import com.adobe.cq.social.ideation.client.api.IdeaComment;
import com.adobe.cq.social.ideation.client.api.Ideation;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.SocialEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IdeationEvent
extends SocialEvent<IdeationActions> {
    private static final long serialVersionUID = 1L;
    public static final String IDEATION_TOPIC = "ideation";
    protected static final String IDEATION_PATH = "IDEATION_PATH";
    private static final String MENTIONS = "mentions";

    public IdeationEvent(IdeaComment ideationEntry, String userId, IdeationActions action) {
        super(IDEATION_TOPIC, ideationEntry.getResource().getPath(), userId, action, new SocialEvent.BaseEventObject(IdeationEvent.getDisplayName(ideationEntry, action), ideationEntry.getResource().getPath(), ideationEntry.isTopic() ? "collection" : "comment"), new SocialEvent.BaseEventObject(IdeationEvent.getDisplayName(ideationEntry.getParentComponent(), action), ideationEntry.getParentComponent().getId().getResourceIdentifier(), ideationEntry.isTopic() ? "collection" : "comment"), IdeationEvent.additionalData(ideationEntry, action));
    }

    private static Map<String, Object> additionalData(IdeaComment ideaComment, IdeationActions action) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        IdeationEvent.addMentionsData(ideaComment, action, data);
        return data;
    }

    private static void addMentionsData(IdeaComment ideaComment, IdeationActions action, Map<String, Object> data) {
        if (!action.getVerb().equals("delete") && ideaComment.getProperties().get(MENTIONS) != null) {
            data.put(MENTIONS, ideaComment.getProperties().get(MENTIONS));
        }
    }

    private static String getDisplayName(SocialComponent ideationEntry, IdeationActions action) {
        if (ideationEntry instanceof IdeaComment) {
            String name;
            String string = name = action.getVerb().equals("delete") ? "" : ((IdeaComment)ideationEntry).getSubject();
            if (StringUtils.isNotEmpty(name)) {
                return name;
            }
            return ((IdeaComment)ideationEntry).isTopic() ? "an idea" : "a comment";
        }
        if (ideationEntry instanceof Ideation) {
            return ((Ideation)ideationEntry).getTitle();
        }
        return null;
    }

    public static enum IdeationActions implements SocialEvent.SocialActions
    {
        CREATED,
        EDITED,
        DELETED,
        REPLY_CREATED,
        REPLY_EDITED,
        REPLY_DELETED,
        CHANGESTATE,
        REPLY_CHANGESTATE;


        @Override
        public String getVerb() {
            switch (this) {
                case CREATED: {
                    return "post";
                }
                case REPLY_CREATED: {
                    return "add";
                }
                case EDITED: 
                case REPLY_EDITED: {
                    return "update";
                }
                case DELETED: 
                case REPLY_DELETED: {
                    return "delete";
                }
                case CHANGESTATE: 
                case REPLY_CHANGESTATE: {
                    return "Updated status";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

