/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.journal.client.api;

import com.adobe.cq.social.journal.client.api.Journal;
import com.adobe.cq.social.journal.client.api.JournalEntryComment;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.SocialEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JournalEvent
extends SocialEvent<JournalActions> {
    private static final long serialVersionUID = 1L;
    public static final String JOURNAL_TOPIC = "journal";
    protected static final String JOURNAL_PATH = "JOURNAL_PATH";
    private static final String MENTIONS = "mentions";

    public JournalEvent(JournalEntryComment journalEntry, String userId, JournalActions action) {
        super(JOURNAL_TOPIC, journalEntry.getResource().getPath(), userId, action, new SocialEvent.BaseEventObject(JournalEvent.getDisplayName(journalEntry, action), journalEntry.getResource().getPath(), journalEntry.isTopic() ? "collection" : "comment"), new SocialEvent.BaseEventObject(JournalEvent.getDisplayName(journalEntry.getParentComponent(), action), journalEntry.getParentComponent().getId().getResourceIdentifier(), journalEntry.isTopic() ? "collection" : "comment"), JournalEvent.additionalData(journalEntry, action));
    }

    private static Map<String, Object> additionalData(JournalEntryComment journalEntryComment, JournalActions action) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        JournalEvent.addMentionsData(journalEntryComment, action, data);
        return data;
    }

    private static void addMentionsData(JournalEntryComment journalEntryComment, JournalActions action, Map<String, Object> data) {
        if (!action.getVerb().equals("delete") && journalEntryComment.getProperties().get(MENTIONS) != null) {
            data.put(MENTIONS, journalEntryComment.getProperties().get(MENTIONS));
        }
    }

    private static String getDisplayName(SocialComponent journalEntry, JournalActions action) {
        if (journalEntry instanceof JournalEntryComment) {
            String name;
            String string = name = action.getVerb().equals("delete") ? "" : ((JournalEntryComment)journalEntry).getSubject();
            if (StringUtils.isNotEmpty(name)) {
                return name;
            }
            return ((JournalEntryComment)journalEntry).isTopic() ? "a journal" : "a comment";
        }
        if (journalEntry instanceof Journal) {
            return ((Journal)journalEntry).getTitle();
        }
        return null;
    }

    public static enum JournalActions implements SocialEvent.SocialActions
    {
        CREATED,
        EDITED,
        DELETED,
        REPLY_CREATED,
        REPLY_EDITED,
        REPLY_DELETED;


        @Override
        public String getVerb() {
            switch (this) {
                case CREATED: {
                    return "post";
                }
                case REPLY_CREATED: {
                    return "add";
                }
                case EDITED: 
                case REPLY_EDITED: {
                    return "update";
                }
                case DELETED: 
                case REPLY_DELETED: {
                    return "delete";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

