/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.moderation.spamdetector.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtilities {
    private static final Logger logger = LoggerFactory.getLogger(FileUtilities.class.getName());
    private static final String NT_FOLDER = "nt:folder";
    private static final String NT_FILE = "nt:file";
    private static final String NT_SLING_FOLDER = "sling:Folder";

    private static String readFromFile(InputStream in, boolean sorted) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (sorted) {
                    stringBuilder.append(line);
                    stringBuilder.append(ls);
                    continue;
                }
                lines.add(line);
            }
            reader.close();
        }
        catch (IOException ex) {
            logger.error("File read failed" + ex);
        }
        if (!sorted) {
            Collections.sort(lines, String.CASE_INSENSITIVE_ORDER);
            for (String line : lines) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
        }
        return stringBuilder.toString();
    }

    public static File createFile(String fileNameLocation, String fileContent) {
        File file = new File(fileNameLocation);
        String stringOutput = fileContent;
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(stringOutput);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException ex) {
            logger.error("File creation filed" + ex);
        }
        return file;
    }

    private static void copyFolder(Resource res, String tempDirPath, Map<String, String> overlays) {
        File f = new File(tempDirPath);
        if (f != null) {
            f.delete();
            f.mkdir();
            for (Resource child : res.getChildren()) {
                Resource overlaidChild;
                boolean sorted = true;
                if (overlays != null && overlays.containsKey(child.getName()) && (overlaidChild = res.getResourceResolver().getResource(overlays.get(child.getName()))) != null) {
                    child = overlaidChild;
                    sorted = false;
                }
                if (child.getResourceType().equals(NT_FILE)) {
                    InputStream in = child.adaptTo(InputStream.class);
                    String strOutput = null;
                    strOutput = FileUtilities.readFromFile(in, sorted);
                    String fileLocationName = tempDirPath + File.separatorChar + child.getName();
                    if (strOutput == null) continue;
                    FileUtilities.createFile(fileLocationName, strOutput);
                    continue;
                }
                if (!child.getResourceType().equals(NT_SLING_FOLDER) && !child.getResourceType().equals(NT_FOLDER)) continue;
                FileUtilities.copyFolder(child, tempDirPath + File.separatorChar + child.getName(), overlays);
            }
        } else {
            logger.info("File creation failed");
        }
    }

    static File setProfile(ResourceResolver resolver, File slingHomePath, String folderPath, String folderName, Map<String, String> overlays) {
        File tempDir = null;
        Resource res = resolver.getResource(folderPath);
        if (res != null) {
            try {
                tempDir = File.createTempFile(folderName, "", slingHomePath);
            }
            catch (IOException e) {
                logger.error("Temp file creation failed");
            }
            if (tempDir != null) {
                FileUtilities.copyFolder(res, tempDir.getAbsolutePath(), overlays);
            }
        }
        return tempDir;
    }

    static File deleteDir(File dir) throws RuntimeException {
        try {
            if (dir != null) {
                FileUtils.deleteDirectory(dir);
            }
        }
        catch (Exception e) {
            logger.error(dir + " could NOT be deleted.");
            return dir;
        }
        return null;
    }
}

