/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.moderation.spamdetector.core;

import com.adobe.cq.social.commons.moderation.api.ModerationOperations;
import com.adobe.cq.social.moderation.spamdetector.core.FileUtilities;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.ugcbase.moderation.AutoModerationProcess;
import com.adobe.cq.social.ugcbase.moderation.AutoModerationProcessException;
import com.adobe.g11n.ta.SpamDetector;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="SpamDetector", description="Automoderate UGC", immediate=true, metatype=false)
@Service(value={AutoModerationProcess.class})
public class SpamProcess
implements AutoModerationProcess {
    private static final String JCR_DESCRIPTION = "jcr:description";
    private static final String PROFILES = "profiles";
    private static final String COMPARE_CATEGORY = "Cat: 0";
    private static final String SPAM_WORDS = "spam_words.txt";
    private static final String CRX_PATH = "settings/community/sites/moderation/spamdetector-conf/";
    private static final String SPAM_RESOURCES = "SpamResources";
    private static final String COMMUNITIES_USER_ADMIN = "communities-user-admin";
    private static final String CONFIGURATION_DEFAULT_PATH = "/libs/settings/community/sites/moderation/spamdetector-conf/";
    private static final String SPAM_WORDS_OVERLAY_PATH = "/apps/settings/community/sites/moderation/spamdetector-conf/profiles/spam_words.txt";
    private ResourceResolver userAdminResolver;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ComponentContext context;
    private Boolean isResourceLoaded = false;
    private File resourceDir = null;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private ModerationOperations moderationOps;

    @Activate
    protected void activate(ComponentContext context) throws LoginException {
        this.context = context;
    }

    private Map<String, String> getOverlayMap(ResourceResolver userAdminResolver) {
        HashMap<String, String> overlayMap = new HashMap<String, String>();
        if (userAdminResolver.getResource(SPAM_WORDS_OVERLAY_PATH) != null) {
            overlayMap.put(SPAM_WORDS, SPAM_WORDS_OVERLAY_PATH);
        }
        return overlayMap;
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        SpamDetector.unloadProfile();
        this.context = null;
    }

    @Override
    public void execute(Resource resource) throws AutoModerationProcessException {
        if (resource == null) {
            throw new AutoModerationProcessException("Can't execute on a null resource.");
        }
        if (this.isResourceLoaded.booleanValue()) {
            this.processResource(resource);
        } else {
            this.loadProfile();
            if (this.isResourceLoaded.booleanValue()) {
                this.processResource(resource);
            } else {
                this.logger.error("Can't load spamdetection profile");
            }
        }
    }

    private void loadProfile() {
        try {
            File slingHome;
            this.logger.debug("Activating spam process service.");
            this.userAdminResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", COMMUNITIES_USER_ADMIN));
            if (!this.isResourceLoaded.booleanValue() && this.userAdminResolver != null && (slingHome = new File(this.settingsService.getSlingHomePath())) != null) {
                this.resourceDir = FileUtilities.setProfile(this.userAdminResolver, slingHome, CONFIGURATION_DEFAULT_PATH, SPAM_RESOURCES, this.getOverlayMap(this.userAdminResolver));
                if (this.resourceDir != null) {
                    SpamDetector.loadProfile((String)(this.resourceDir.getAbsolutePath() + File.separatorChar + PROFILES));
                    this.isResourceLoaded = true;
                }
                this.resourceDir = FileUtilities.deleteDir(this.resourceDir);
            }
        }
        catch (LoginException logEx) {
            this.logger.error("Can't load spamdetection profile");
        }
    }

    private void processResource(Resource resource) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.hasProperty(resource, JCR_DESCRIPTION)) {
            String strIn = this.getProperty(resource, JCR_DESCRIPTION, String.class);
            list.add(strIn);
            List predicted = SpamDetector.predictRT(list);
            String predictString = predicted.toString();
            String[] splits = predictString.split(",");
            String compare = COMPARE_CATEGORY;
            for (String s : splits) {
                Session session = this.userAdminResolver.adaptTo(Session.class);
                if (!s.contains(compare)) continue;
                this.moderationOps.deny(resource, session);
                break;
            }
        }
        list.clear();
    }

    private boolean hasProperty(Resource resource, String propName) {
        ValueMap valMap = resource.adaptTo(ValueMap.class);
        return valMap.containsKey(propName);
    }

    private <T> T getProperty(Resource resource, String propName, Class<T> type) {
        ValueMap valMap = resource.adaptTo(ValueMap.class);
        return (T)valMap.get(propName, type);
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindModerationOps(ModerationOperations moderationOperations) {
        this.moderationOps = moderationOperations;
    }

    protected void unbindModerationOps(ModerationOperations moderationOperations) {
        if (this.moderationOps == moderationOperations) {
            this.moderationOps = null;
        }
    }
}

