/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.notifications.channel;

import com.adobe.cq.social.notifications.api.Notification;
import com.adobe.cq.social.notifications.channel.Channel;
import com.adobe.cq.social.notifications.channel.ChannelException;
import com.adobe.cq.social.notifications.channel.ChannelExtension;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jcr.Session;

public abstract class AbstractChannel<T extends ChannelExtension>
implements Channel {
    protected SortedSet<T> extensionProviders = new TreeSet<T>(new Comparator<T>(){

        @Override
        public int compare(T a, T b) {
            return a.getOrder() - b.getOrder();
        }
    });
    protected Map<String, Object> configuration = new HashMap<String, Object>();

    @Override
    public boolean accept(String resourceType) {
        return true;
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    protected synchronized void addChannelExtension(T extension) {
        this.extensionProviders.add(extension);
    }

    protected synchronized void removeChannelExtension(T extension) {
        this.extensionProviders.remove(extension);
    }

    @Override
    public void performBeforeDeliver(Notification notification, String userId, Session session, Map<String, Object> configuration) throws ChannelException {
        for (ChannelExtension extension : this.extensionProviders) {
            extension.beforeDeliver(notification, userId, session, configuration);
        }
    }

    @Override
    public void performAfterDeliver(Notification notification, String userId, Session session, Map<String, Object> configuration) throws ChannelException {
        for (ChannelExtension extension : this.extensionProviders) {
            extension.afterDeliver(notification, userId, session, configuration);
        }
    }
}

