/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.notifications.collection.endpoint;

import com.adobe.cq.social.notifications.api.NotificationManager;
import com.adobe.cq.social.notifications.api.Status;
import com.adobe.cq.social.notifications.client.api.AbstractSocialNotificationCollection;
import com.adobe.cq.social.notifications.collection.endpoint.NotificationCollectionOperationService;
import com.adobe.cq.social.notifications.collection.endpoint.NotificationCollectionOperationsExtension;
import com.adobe.cq.social.notifications.endpoint.NotificationOperationsExtension;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.ugc.api.UgcFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractNotificationCollectionOperationService<T extends NotificationCollectionOperationsExtension, U extends NotificationOperationsExtension.NotificationOperations>
extends AbstractOperationService<T, U, SocialComponent>
implements NotificationCollectionOperationService {
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;
    @Reference
    private NotificationManager notificationManager;
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    protected static final String UGC_WRITER = "ugc-writer";
    protected static final int MAX_VALUE = 2048;
    private static Logger LOG = LoggerFactory.getLogger(AbstractNotificationCollectionOperationService.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SocialComponent markAllRead(@Nonnull SlingHttpServletRequest request, @Nonnull ResourceResolverFactory rrf) throws OperationException {
        Resource resource = request.getResource();
        if (!resource.isResourceType("social/notifications/components/hbs/notifications")) {
            throw new OperationException("The target resource is not the SocialNotificationCollection resource", 400);
        }
        ResourceResolver resolver = this.getPrivilegedResolver(rrf);
        try {
            if (resolver == null) throw new OperationException("Failed to obtain resource resolver", 500);
            Map<String, Object> requestParams = Collections.emptyMap();
            U operation = this.getMarkAllReadOperation();
            Session session = resolver.adaptTo(Session.class);
            this.performBeforeActions(operation, session, request.getResource(), requestParams);
            UgcFilter filters = new UgcFilter();
            filters.and(AbstractSocialNotificationCollection.getPathConstraint(request.getResource()));
            ValueMap propMap = resource.adaptTo(ValueMap.class);
            String channelId = null;
            if (propMap.containsKey("channelId")) {
                channelId = (String)((Object)propMap.get("channelId", String.class));
                LOG.debug("channelId: {}", (Object)channelId);
            }
            try {
                SocialComponentFactory factory;
                SocialComponent component;
                Iterable<Resource> resources = this.notificationManager.getUnreadResource(request.getResourceResolver(), AbstractSocialNotificationCollection.getPathConstraint(resource), channelId);
                boolean hasChanges = resources.iterator().hasNext();
                for (Resource res : resources) {
                    Resource notificationRes = resolver.getResource(res.getPath());
                    ModifiableValueMap valueMap = notificationRes.adaptTo(ModifiableValueMap.class);
                    valueMap.put("status_s", Status.READ.toString());
                }
                if (hasChanges) {
                    resolver.commit();
                }
                SocialComponent socialComponent = component = (factory = this.componentFactoryManager.getSocialComponentFactory(request.getResource())) != null ? factory.getSocialComponent(request.getResource(), request) : null;
                if (component != null) {
                    this.performAfterActions(operation, session, component, requestParams);
                } else {
                    LOG.warn("Failed to obtain the social component");
                }
                SocialComponent socialComponent2 = component;
                return socialComponent2;
            }
            catch (RepositoryException e) {
                try {
                    LOG.error("Failed to obtain list of unread resources", e);
                    throw new OperationException("Failed to obtain resource resolver", 500);
                }
                catch (PersistenceException e2) {
                    if (resolver != null && resolver.isLive()) {
                        resolver.revert();
                    }
                    LOG.error("Failed to change status of {}", (Object)request.getResource().getPath());
                    throw new OperationException("Failed to update notification", 500);
                }
            }
        }
        finally {
            if (resolver != null && resolver.isLive()) {
                resolver.close();
            }
        }
    }

    protected boolean checkPermission(Resource resource) throws RepositoryException {
        ResourceResolver resolver = resource.getResourceResolver();
        String userId = resolver.getUserID();
        UserManager usrMgr = resolver.adaptTo(UserManager.class);
        if (usrMgr != null) {
            Authorizable authorizable = usrMgr.getAuthorizable(userId);
            if (resource.getPath().contains(authorizable.getPath())) {
                return true;
            }
        }
        return false;
    }

    private ResourceResolver getPrivilegedResolver(ResourceResolverFactory rrf) {
        HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
        authenticationInfo.put("sling.service.subservice", UGC_WRITER);
        try {
            return this.serviceUserWrapper.getServiceResourceResolver(rrf, authenticationInfo);
        }
        catch (LoginException e) {
            LOG.error("Failed to obtain privilieged resolver", e);
            return null;
        }
    }

    protected String getResourceType() {
        return "social/notifications/components/hbs/notifications";
    }

    protected abstract U getMarkReadOperation();

    protected abstract U getMarkAllReadOperation();

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    protected void unbindNotificationManager(NotificationManager notificationManager) {
        if (this.notificationManager == notificationManager) {
            this.notificationManager = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }
}

