/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.provider.jcr.internal;

import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public final class PathResource
extends AbstractResource {
    private final ResourceResolver resolver;
    private final String path;
    private Resource resource;
    private String resourceType;
    private String superResourceType;
    private ResourceMetadata resourceMetadata;
    private boolean needSource = true;

    public PathResource(ResourceResolver resolver, String path) {
        this.resolver = resolver;
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Resource getParent() {
        if ("/".equals(this.path)) {
            return null;
        }
        this.requireResource();
        Resource parent = null;
        if (this.resource != null) {
            parent = this.resource.getParent();
        }
        if (parent == null) {
            parent = this.resolver.getResource(ResourceUtil.getParent(this.path));
        }
        if (parent == null && !"/".equals(this.path)) {
            return new PathResource(this.resolver, ResourceUtil.getParent(this.path));
        }
        return parent;
    }

    @Override
    public String getResourceType() {
        this.requireResource();
        return this.resourceType;
    }

    private void requireResource() {
        if (!this.needSource) {
            return;
        }
        this.needSource = false;
        this.resource = this.resolver.getResource(this.path);
        if (this.resource == null) {
            this.resourceType = "sling:Folder";
            this.superResourceType = null;
            this.resourceMetadata = new ResourceMetadata();
        }
    }

    @Override
    public String getResourceSuperType() {
        this.requireResource();
        return this.superResourceType;
    }

    @Override
    public ResourceMetadata getResourceMetadata() {
        if (this.resourceMetadata != null) {
            return this.resourceMetadata;
        }
        this.requireResource();
        return this.resourceMetadata;
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }
}

