/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.review.client.api;

import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.review.client.endpoints.ReviewOperations;
import com.adobe.cq.social.review.client.impl.ReviewCollectionSocialComponentImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.ugc.api.UgcSearch;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class ReviewCollectionSocialComponentFactory
extends AbstractSocialComponentFactory
implements SocialComponentFactory {
    @Reference
    private CommentSocialComponentListProviderManager listProviderManager;
    @Reference
    private UgcSearch search;
    private static final Logger LOG = LoggerFactory.getLogger(ReviewOperations.class);

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        return new ReviewCollectionSocialComponentImpl(resource, this.getClientUtilities(resource.getResourceResolver()), this.listProviderManager, this.search);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        if (resource.isResourceType("social/reviews/components/hbs/summary")) {
            ClientUtilities clientUtils = this.getClientUtilities(request);
            ValueMap componentConfigProperties = ResourceUtil.isNonExistingResource(resource) ? clientUtils.getDesignProperties(resource, resource.getResourceType()) : resource.getValueMap();
            String targetReviewsPath = componentConfigProperties.get("reviewPath", resource.getPath());
            Resource reviewResource = resource.getResourceResolver().resolve(targetReviewsPath);
            if (ResourceUtil.isNonExistingResource(reviewResource)) {
                Resource targetResource = resource.getResourceResolver().resolve(targetReviewsPath);
                reviewResource = new SyntheticResource(resource.getResourceResolver(), targetResource.getResourceMetadata(), resource.getResourceType());
            }
            ReviewCollectionSocialComponentImpl rc = new ReviewCollectionSocialComponentImpl(reviewResource, this.getClientUtilities(request), this.getQueryRequestInfo(request), this.listProviderManager, this.search);
            boolean includeHistogram = componentConfigProperties.get("includeHistogram", false);
            rc.setIncludeHistogram(includeHistogram);
            return rc;
        }
        return new ReviewCollectionSocialComponentImpl(resource, this.getClientUtilities(request), this.getQueryRequestInfo(request), this.listProviderManager, this.search);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo) {
        return new ReviewCollectionSocialComponentImpl(resource, clientUtils, queryInfo, this.listProviderManager, this.search);
    }

    @Override
    public String getSupportedResourceType() {
        return "social/reviews/components/hbs/reviews";
    }

    protected void bindListProviderManager(CommentSocialComponentListProviderManager commentSocialComponentListProviderManager) {
        this.listProviderManager = commentSocialComponentListProviderManager;
    }

    protected void unbindListProviderManager(CommentSocialComponentListProviderManager commentSocialComponentListProviderManager) {
        if (this.listProviderManager == commentSocialComponentListProviderManager) {
            this.listProviderManager = null;
        }
    }

    protected void bindSearch(UgcSearch ugcSearch) {
        this.search = ugcSearch;
    }

    protected void unbindSearch(UgcSearch ugcSearch) {
        if (this.search == ugcSearch) {
            this.search = null;
        }
    }
}

