/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.SocialCollectionComponent;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.wcm.api.Page;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;

public class PageInfo {
    private String urlPattern;
    private long totalItems = -1L;
    private final CollectionPagination pagination;
    private final String params;
    private final String basePageURL;
    private final SocialCollectionComponent component;
    private final Resource includedResource;

    public PageInfo(SocialCollectionComponent component, ClientUtilities clientUtils, CollectionPagination pagination) {
        this(component, clientUtils, pagination, null);
    }

    private String getRefererPath(ClientUtilities clientUtils, String path) {
        String refererPath = clientUtils.getRequest().getHeader("referer");
        if (refererPath != null) {
            String refererLanguage = StringUtils.substringAfterLast(LanguageUtil.getLanguageRoot(refererPath.replaceAll(".html", "")), "/");
            String commentPostPageLanguage = StringUtils.substringAfterLast(LanguageUtil.getLanguageRoot(path), "/");
            if (refererLanguage != null && commentPostPageLanguage != null && !refererLanguage.equals(commentPostPageLanguage)) {
                String leftPath = StringUtils.substringBeforeLast(LanguageUtil.getLanguageRoot(path), "/");
                String rightPath = StringUtils.substringAfterLast(path, "/");
                if (leftPath != null && rightPath != null) {
                    StringBuilder refererLanguagePath = new StringBuilder();
                    refererLanguagePath.append(leftPath).append("/");
                    if (!rightPath.equals(commentPostPageLanguage)) {
                        refererLanguagePath.append(refererLanguage).append("/");
                        refererLanguagePath.append(rightPath);
                    }
                    return refererLanguagePath.toString();
                }
            }
        }
        return path;
    }

    public PageInfo(SocialCollectionComponent component, ClientUtilities clientUtils, CollectionPagination pagination, String params) {
        this.pagination = pagination;
        Page page = clientUtils.getContainingPage(component.getId().toString());
        this.basePageURL = page != null && !StringUtils.isEmpty(pagination.getSortIndex()) ? clientUtils.externalLink(this.getRefererPath(clientUtils, page.getPath()) + "." + pagination.getSortIndex(), false) : (page != null ? clientUtils.externalLink(this.getRefererPath(clientUtils, page.getPath()), false) : null);
        this.urlPattern = !StringUtils.isEmpty(pagination.getSortIndex()) ? clientUtils.externalLink(component.getId() + ".social", false) + "." + pagination.getSortIndex() + ".${startIndex}." + Long.valueOf(this.getSignedPageSize()).toString() + "." + clientUtils.getRequestExtension() : clientUtils.externalLink(component.getId() + ".social", false) + ".${startIndex}." + Long.valueOf(this.getSignedPageSize()).toString() + "." + clientUtils.getRequestExtension();
        if (StringUtils.isNotBlank(params)) {
            this.urlPattern = this.urlPattern + "?" + params;
        }
        this.params = params;
        this.component = component;
        this.includedResource = clientUtils.getIncludedResource();
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public long getSelectedPage() {
        Double pagesSeen = Math.ceil((long)this.pagination.getOffset() / Math.abs(this.getPageSize()));
        if (this.pagination.getSize() == 0) {
            return pagesSeen.longValue();
        }
        return Double.valueOf(pagesSeen + 1.0).longValue();
    }

    public long getTotalPages() {
        return Double.valueOf(Math.ceil((double)this.getTotalItems() * 1.0 / (double)Math.abs(this.getPageSize()))).longValue();
    }

    public boolean getHasMultiplePages() {
        return this.getTotalPages() > 1L;
    }

    public long getLastPage() {
        return (this.getTotalPages() - 1L) * this.getPageSize();
    }

    public long getPageSize() {
        return Math.abs(this.pagination.getSize()) > 0 ? (long)Math.abs(this.pagination.getSignedSize()) : (long)this.pagination.getPageSizeConfig();
    }

    private long getSignedPageSize() {
        return Math.abs(this.pagination.getSize()) > 0 ? (long)this.pagination.getSignedSize() : (long)this.pagination.getPageSizeConfig();
    }

    public boolean getHasNextPage() {
        return this.getCurrentIndex() != this.getNextOffset();
    }

    public boolean getHasPreviousPage() {
        return this.getCurrentIndex() != this.getPreviousOffset();
    }

    public long getCurrentIndex() {
        return Math.abs(this.pagination.getOffset());
    }

    public String getNextPageURL() {
        String nextPage = StringUtils.replace(this.getURLPattern(), "${startIndex}", Long.valueOf(this.getNextOffset()).toString());
        return nextPage;
    }

    public String getPreviousPageURL() {
        String nextPage = StringUtils.replace(this.getURLPattern(), "${startIndex}", Long.valueOf(this.getPreviousOffset()).toString());
        return nextPage;
    }

    public String getNextSuffix() {
        return this.getNextOffset() + "." + this.getSignedPageSize();
    }

    public String getPreviousSuffix() {
        return this.getPreviousOffset() + "." + this.getSignedPageSize();
    }

    public String getSortIndex() {
        return this.pagination.getSortIndex();
    }

    public String getBasePageURL() {
        return this.basePageURL;
    }

    public String getIncludedPath() {
        if (this.includedResource != null) {
            return this.includedResource.getPath();
        }
        return null;
    }

    private long getTotalItems() {
        if (this.totalItems < 0L) {
            this.totalItems = this.component.getTotalSize();
        }
        return this.totalItems;
    }

    private long getNextOffset() {
        return this.getTotalItems() <= (long)(Math.abs(this.pagination.getSize()) + this.pagination.getOffset()) ? this.getCurrentIndex() : (long)(Math.abs(this.pagination.getSize()) + this.pagination.getOffset());
    }

    private long getPreviousOffset() {
        return 0 >= this.pagination.getOffset() - Math.abs(this.pagination.getSize()) ? 0L : (long)(this.pagination.getOffset() - Math.abs(this.pagination.getSize()));
    }

    public boolean isOrderReversed() {
        return this.pagination.getSignedSize() < 0;
    }
}

