/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf.core;

import com.adobe.cq.social.SocialException;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseQueryRequestInfo
implements QueryRequestInfo {
    private static final Logger LOG = LoggerFactory.getLogger(BaseQueryRequestInfo.class);
    private static String PN_QUERY_FILTER = "filter";
    private static String PN_SORT_ASCENDING = "ASC";
    private static String NOCACHE_SELECTOR = "nocache";
    private static Set<String> PN_QUERY_SORT = new HashSet<String>(Arrays.asList("sortby", "sort_by"));
    private final boolean isQueryRequest;
    private final Map<String, String[]> predicates;
    private List<Map.Entry<String, Boolean>> sortFields;
    private CollectionPagination pagination;
    private CollectionSortedOrder order = CollectionSortedOrder.DEFAULT_ORDER;
    private List<String> sortBy;
    public static QueryRequestInfo DEFAULT_QUERY_REQUEST = new BaseQueryRequestInfo();
    private boolean isTranslateRequest;
    private boolean isSortRequest = false;

    private BaseQueryRequestInfo() {
        this.pagination = CollectionPagination.DEFAULT_PAGINATION;
        this.isQueryRequest = false;
        this.predicates = Collections.emptyMap();
    }

    public BaseQueryRequestInfo(SlingHttpServletRequest request) {
        this(request, true);
    }

    public BaseQueryRequestInfo(SlingHttpServletRequest request, boolean isFilterQuery) {
        this.pagination = this.getPaginationFromRequest(request);
        this.isQueryRequest = this.isQueryRequest(request, isFilterQuery);
        this.predicates = this.isQueryRequest ? request.getParameterMap() : Collections.emptyMap();
        this.isTranslateRequest = this.isTranslateRequest(request);
        this.isSortRequest = this.doesRequestContainsSort(request) || this.doesRequestSelectorConstainsSort(request);
        this.sortFields = this.constructSortFields(request);
    }

    public BaseQueryRequestInfo(boolean isQueryRequest, Map<String, String[]> predicates, CollectionPagination pagination) {
        this.isQueryRequest = isQueryRequest;
        this.predicates = predicates;
        this.pagination = pagination;
    }

    public BaseQueryRequestInfo(boolean isQueryRequest, Map<String, String[]> predicates, CollectionPagination pagination, boolean isTranslateRequest) {
        this.isQueryRequest = isQueryRequest;
        this.predicates = predicates;
        this.pagination = pagination;
        this.isTranslateRequest = isTranslateRequest;
    }

    public BaseQueryRequestInfo(boolean isQueryRequest, Map<String, String[]> predicates, CollectionPagination pagination, CollectionSortedOrder order) {
        this.isQueryRequest = isQueryRequest;
        this.predicates = predicates;
        this.pagination = pagination;
        this.order = order;
    }

    public BaseQueryRequestInfo(boolean isQueryRequest, Map<String, String[]> predicates, CollectionPagination pagination, CollectionSortedOrder order, List<String> sortBy) {
        this.isQueryRequest = isQueryRequest;
        this.predicates = predicates;
        this.pagination = pagination;
        this.order = order;
        this.sortBy = sortBy;
    }

    protected CollectionPagination getPaginationFromRequest(SlingHttpServletRequest request) {
        if (request != null) {
            String[] selectors = ArrayUtils.removeElement(ArrayUtils.removeElement(request.getRequestPathInfo().getSelectors(), "social"), NOCACHE_SELECTOR);
            if (selectors != null && selectors.length >= 2) {
                try {
                    int maxIndex = selectors.length - 1;
                    int offset = Integer.parseInt(selectors[maxIndex - 1]);
                    int size = Integer.parseInt(selectors[maxIndex]);
                    boolean ascendingOrder = false;
                    if (size < 0) {
                        ascendingOrder = true;
                        this.order = CollectionSortedOrder.REVERSED_ORDER;
                    }
                    String sortIndex = null;
                    if (this.doesRequestSelectorConstainsSort(request)) {
                        sortIndex = this.isTranslateRequest ? selectors[1] : selectors[0];
                    }
                    CollectionPagination pagination = new CollectionPagination(offset, size, 0, sortIndex);
                    return pagination;
                }
                catch (NumberFormatException e) {
                    LOG.error("Bad pagination request to " + request.getPathInfo(), e);
                }
            } else if ("csv".equals(request.getRequestPathInfo().getExtension())) {
                return new CollectionPagination(0, 0);
            }
        }
        return CollectionPagination.DEFAULT_PAGINATION;
    }

    private boolean isQueryRequest(SlingHttpServletRequest request, boolean isFilterQuery) {
        boolean query = false;
        if (request != null) {
            RequestPathInfo info = request.getRequestPathInfo();
            String selector = info.getSelectorString();
            boolean bl = query = selector != null && selector.contains("social.query");
            if (!query) {
                query = isFilterQuery ? "GET".equalsIgnoreCase(request.getMethod()) && request.getParameterMap().containsKey(PN_QUERY_FILTER) : "GET".equalsIgnoreCase(request.getMethod()) && !request.getParameterMap().isEmpty();
            }
        }
        return query;
    }

    private boolean doesRequestContainsSort(SlingHttpServletRequest request) {
        boolean isGet = false;
        boolean hasSort = false;
        if (request != null) {
            isGet = "GET".equalsIgnoreCase(request.getMethod());
            for (Object predicateKey : request.getParameterMap().keySet()) {
                if (!PN_QUERY_SORT.contains(predicateKey.toString().toLowerCase())) continue;
                hasSort = true;
            }
        }
        return isGet && hasSort;
    }

    private boolean doesRequestSelectorConstainsSort(SlingHttpServletRequest request) {
        if (request != null) {
            RequestPathInfo info = request.getRequestPathInfo();
            String[] selectors = ArrayUtils.removeElement(ArrayUtils.removeElement(info.getSelectors(), "social"), NOCACHE_SELECTOR);
            int selectorsLength = selectors.length;
            if (selectors != null && (selectorsLength == 1 || selectorsLength == 3)) {
                return selectorsLength != 1 || !SCF_SELECTORS.contains(selectors[0]);
            }
            if (this.isTranslateRequest) {
                return selectors != null && (selectorsLength == 2 || selectorsLength == 4);
            }
            return false;
        }
        return false;
    }

    private boolean isTranslateRequest(SlingHttpServletRequest request) {
        RequestPathInfo info = request.getRequestPathInfo();
        String selector = info.getSelectorString();
        boolean isTranslate = selector != null && selector.contains("social.translate");
        return isTranslate;
    }

    @Override
    public boolean isQuery() {
        return this.isQueryRequest;
    }

    @Override
    public Map<String, String[]> getPredicates() {
        return this.predicates;
    }

    @Override
    public CollectionPagination getPagination() {
        return this.pagination;
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        this.pagination = pagination;
    }

    @Override
    public void setSortBy(List<String> sortBy) {
        this.sortBy = sortBy;
    }

    @Override
    public List<String> getSortBy() {
        return this.sortBy;
    }

    @Override
    public void setSortOrder(CollectionSortedOrder order) {
        this.order = order;
    }

    @Override
    public CollectionSortedOrder getSortOrder() {
        return this.order;
    }

    @Override
    public boolean isTranslationRequest() {
        return this.isTranslateRequest;
    }

    @Override
    public void setTranslationRequest(boolean isTranslationRequest) {
        this.isTranslateRequest = isTranslationRequest;
    }

    @Override
    public List<Map.Entry<String, Boolean>> getSortFields() {
        if (this.sortFields != null) {
            return this.sortFields;
        }
        return Collections.emptyList();
    }

    private List<Map.Entry<String, Boolean>> constructSortFields(SlingHttpServletRequest request) {
        if (request != null && (this.doesRequestContainsSort(request) || this.doesRequestSelectorConstainsSort(request))) {
            return this.extractSortFields(request);
        }
        return Collections.emptyList();
    }

    @Override
    public void setSortFields(List<Map.Entry<String, Boolean>> sortFields) {
        this.sortFields = sortFields;
        if (this.pagination != null && sortFields != null && !sortFields.isEmpty() && this.isSortRequest()) {
            CollectionPagination newpagination;
            this.pagination = newpagination = new CollectionPagination(this.pagination.getOffset(), this.pagination.getSignedSize(), this.pagination.getEmbedLevel(), sortFields.get(0).getKey());
        }
    }

    private String[] getSortOrderFieldFromRequest(SlingHttpServletRequest request) {
        if (request != null) {
            for (Object requestKey : request.getParameterMap().keySet()) {
                if (!PN_QUERY_SORT.contains(requestKey.toString().toLowerCase())) continue;
                return request.getParameterValues(requestKey.toString());
            }
        }
        return null;
    }

    private List<Map.Entry<String, Boolean>> extractSortFields(SlingHttpServletRequest request) {
        ArrayList<Map.Entry<String, Boolean>> sortFieldsFromQuery = new ArrayList<Map.Entry<String, Boolean>>();
        if (request != null) {
            if (this.doesRequestSelectorConstainsSort(request)) {
                this.extractSortFieldsFromSelector(request, sortFieldsFromQuery);
            } else {
                this.extractSortFieldsFromRequest(request, sortFieldsFromQuery);
            }
        }
        return sortFieldsFromQuery;
    }

    private void extractSortFieldsFromRequest(SlingHttpServletRequest request, List<Map.Entry<String, Boolean>> sortFieldsFromQuery) {
        String[] sortOrderFieldsFromRequest;
        if (request != null && (sortOrderFieldsFromRequest = this.getSortOrderFieldFromRequest(request)) != null) {
            for (String sortOrderFieldFromRequest : sortOrderFieldsFromRequest) {
                this.parseSortFieldString(sortOrderFieldFromRequest, sortFieldsFromQuery);
            }
        }
    }

    private void extractSortFieldsFromSelector(SlingHttpServletRequest request, List<Map.Entry<String, Boolean>> sortFieldsFromQuery) {
        String[] selectors = ArrayUtils.removeElement(ArrayUtils.removeElement(request.getRequestPathInfo().getSelectors(), "social"), NOCACHE_SELECTOR);
        int selectorsLength = selectors.length;
        if (selectors.length < 1) {
            throw new SocialException("Bad Sort Request " + request.getPathInfo());
        }
        try {
            int maxIndex = selectors.length - 1;
            int size = 1;
            if (selectorsLength == 3) {
                size = Integer.parseInt(selectors[maxIndex]);
            }
            boolean ascendingOrder = false;
            if (size < 0) {
                ascendingOrder = true;
            }
            String sortIndex = null;
            if (this.isTranslateRequest) {
                if (selectorsLength >= 2) {
                    sortIndex = selectors[1];
                }
            } else {
                sortIndex = selectors[0];
            }
            sortFieldsFromQuery.add(new AbstractMap.SimpleEntry<String, Boolean>(sortIndex, ascendingOrder));
        }
        catch (NumberFormatException e) {
            LOG.error("Bad sort request to " + request.getPathInfo(), e);
            throw new SocialException("Bad Sort Request " + request.getPathInfo(), e);
        }
    }

    private void parseSortFieldString(String sortOrderFieldFromRequest, List<Map.Entry<String, Boolean>> sortFieldsFromQuery) {
        String escapedSortOrderFieldFromRequest = sortOrderFieldFromRequest;
        try {
            if (!StringUtils.startsWith(sortOrderFieldFromRequest, "[")) {
                escapedSortOrderFieldFromRequest = "[" + sortOrderFieldFromRequest + "]";
            }
            JSONArray jsonArray = new JSONArray(escapedSortOrderFieldFromRequest);
            for (int i = 0; i < jsonArray.length(); ++i) {
                Object o = jsonArray.get(i);
                if (o instanceof String) {
                    sortFieldsFromQuery.add(new AbstractMap.SimpleEntry<String, Boolean>(o.toString(), false));
                    continue;
                }
                if (!(o instanceof JSONObject)) continue;
                Iterator<String> keys = ((JSONObject)o).keys();
                while (keys.hasNext()) {
                    String key = keys.next();
                    String value = ((JSONObject)o).getString(key);
                    boolean boolValue = false;
                    if (StringUtils.equalsIgnoreCase(value, PN_SORT_ASCENDING)) {
                        boolValue = true;
                    }
                    sortFieldsFromQuery.add(new AbstractMap.SimpleEntry<String, Boolean>(key, boolValue));
                }
            }
        }
        catch (JSONException e) {
            LOG.error("Unable to parse the sort requestField {}", (Object)sortFieldsFromQuery);
        }
    }

    @Override
    public boolean isSortRequest() {
        return this.isSortRequest;
    }

    @Override
    public void setSortRequest(boolean isSortRequest) {
        this.isSortRequest = isSortRequest;
    }

    @Override
    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        boolean firstParam = true;
        try {
            for (Map.Entry<String, String[]> ks : this.predicates.entrySet()) {
                String key = ks.getKey();
                String[] value = ks.getValue();
                for (int i = 0; i < value.length; ++i) {
                    if (!firstParam) {
                        sb.append("&");
                    } else {
                        firstParam = false;
                    }
                    sb.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(value[i], "UTF-8"));
                }
            }
            String retVal = sb.toString();
            return retVal.isEmpty() ? null : retVal;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error encoding params.  " + sb.toString());
            return null;
        }
    }
}

