/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.site.endpoints;

import com.adobe.cq.social.blueprint.api.SiteActivationService;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.site.api.BaseSite;
import com.adobe.cq.social.site.api.CommunitySiteService;
import com.adobe.cq.social.site.endpoints.PublishOperation;
import com.day.cq.replication.ReplicationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;

public abstract class AbstractPublishOperationService<T extends OperationExtension, U extends Operation, S extends BaseSite>
extends AbstractOperationService<T, U, S>
implements PublishOperation {
    private static final String USER_ADMIN = "communities-user-admin";
    private static final String MSM_SERVICE = "msm-service";

    @Override
    public SocialComponent publish(SlingHttpServletRequest request) throws OperationException {
        SiteActivationService activationService = this.getActivationService();
        CommunitySiteService communitySiteService = this.getCommunitySiteService();
        if (communitySiteService == null) {
            throw new OperationException("Failed to get SiteService.", 500);
        }
        if (activationService == null) {
            throw new OperationException("Failed to get activationService.", 500);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        String sitePath = request.getParameter("path");
        if (StringUtils.isEmpty(sitePath)) {
            throw new OperationException("Missing request parameter path", 400);
        }
        props.put("path", sitePath);
        String nestedActivation = request.getParameter("nestedActivation");
        boolean supportNestedActivation = Boolean.parseBoolean(nestedActivation);
        props.put("nestedActivation", supportNestedActivation);
        Resource resource = request.getResource();
        U publishOperation = this.getPublishOperation();
        this.getExtensionParameters(publishOperation, request, props);
        this.performBeforeActions(publishOperation, resource.getResourceResolver().adaptTo(Session.class), resource, props);
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        if (!communitySiteService.mayPost(request, session)) {
            throw new OperationException("User " + session.getUserID() + " has no permission to publish community site or group:" + resource.getPath(), 403);
        }
        ResourceResolver userAdminResolver = null;
        ResourceResolver msmResolver = null;
        try {
            Resource clientLibResource;
            String themeId;
            msmResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            Resource community = resolver.getResource(sitePath);
            if (community == null) {
                throw new OperationException("Failed to find site @" + sitePath, 404);
            }
            CommunityContext context = community.adaptTo(CommunityContext.class);
            Resource content = community.getChild("jcr:content");
            Resource config = community.getChild("configuration");
            Node node = content.adaptTo(Node.class);
            node.setProperty("formPayload", context.getSitePayloadPath() + sitePath);
            if (config != null && StringUtils.isNotBlank(themeId = (String)((Object)config.getValueMap().get("theme", String.class))) && (clientLibResource = resolver.getResource(themeId)) != null) {
                String[] clientLibCategory;
                ValueMap clientLibResourceProperties = clientLibResource.adaptTo(ValueMap.class);
                for (String clientLib : clientLibCategory = (String[])clientLibResourceProperties.get("categories", String[].class)) {
                    if (!StringUtils.contains((CharSequence)clientLib, "cq.social.console.theme.custom.")) continue;
                    node.setProperty("themePayload", themeId);
                }
            }
            activationService.activateCommunity(userAdminResolver, msmResolver, sitePath, supportNestedActivation);
            S component = this.getSocialComponent(community, request);
            this.performAfterActions(publishOperation, session, component, props);
            S s = component;
            return s;
        }
        catch (SlingException e) {
            throw new OperationException("Failed to activate community site or group; ", e, 403);
        }
        catch (ReplicationException e) {
            throw new OperationException("Failed to activate community site or group; ", e, 403);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to activate community site or group; ", e, 403);
        }
        catch (LoginException e) {
            throw new OperationException("Failed to activate community site or group; ", e, 403);
        }
        finally {
            if (userAdminResolver != null && userAdminResolver.isLive()) {
                userAdminResolver.close();
            }
            if (msmResolver != null && msmResolver.isLive()) {
                msmResolver.close();
            }
        }
    }

    @Override
    public SocialComponent unpublish(SlingHttpServletRequest request) throws OperationException {
        SiteActivationService activationService = this.getActivationService();
        CommunitySiteService communitySiteService = this.getCommunitySiteService();
        if (communitySiteService == null) {
            throw new OperationException("Failed to get SiteService.", 500);
        }
        if (activationService == null) {
            throw new OperationException("Failed to get activationService.", 500);
        }
        String sitePath = request.getParameter("path");
        if (StringUtils.isEmpty(sitePath)) {
            throw new OperationException("Missing request parameter path", 400);
        }
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        if (!communitySiteService.mayPost(request, session)) {
            throw new OperationException("User " + session.getUserID() + " has no permission to unpublish community site " + resource.getPath(), 403);
        }
        try {
            Resource community = resolver.getResource(sitePath);
            if (community == null) {
                throw new OperationException("Failed to find site @" + sitePath, 404);
            }
            activationService.deactivateCommunity(resolver, sitePath);
            return this.getSocialComponent(community, request);
        }
        catch (SlingException e) {
            throw new OperationException("Failed to activate community site; ", e, 403);
        }
        catch (ReplicationException e) {
            throw new OperationException("Failed to activate community site; ", e, 403);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to activate community site; ", e, 403);
        }
    }

    protected abstract S getSocialComponent(Resource var1, SlingHttpServletRequest var2);

    protected abstract U getPublishOperation();

    protected abstract U getUnpublishOperation();

    protected abstract CommunitySiteService getCommunitySiteService();

    protected abstract SiteActivationService getActivationService();

    protected abstract void getExtensionParameters(U var1, SlingHttpServletRequest var2, Map<String, Object> var3) throws OperationException;

    protected abstract ServiceUserWrapper getServiceUserWrapper();

    protected abstract ResourceResolverFactory getBundleLocalResourceResolverFactory();
}

