/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.site.endpoints;

import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.ugc.api.ComparisonType;
import com.adobe.cq.social.ugc.api.ConstraintGroup;
import com.adobe.cq.social.ugc.api.PathConstraint;
import com.adobe.cq.social.ugc.api.PathConstraintType;
import com.adobe.cq.social.ugc.api.SearchResults;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.cq.social.ugc.api.UgcSearch;
import com.adobe.cq.social.ugc.api.ValueConstraint;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteContentUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SiteContentUtils.class);
    protected static final int STEP = 1000;
    protected static final String TARGET_PROP = "targetid_s";
    protected static final String END_PROP = "endid_s";
    protected static final String PARENT_PROP = "social:parentid";
    protected static final String RESOURCE_TYPE_PROP = "sling:resourceType";
    protected static final String NOTIFICATION_RESOURCE_TYPE = "social/notifications/components/hbs/notifications/notification";
    protected static final String ACTIVITY_RESOURCE_TYPE = "social/activitystreams/components/activity";
    protected static final String UG_ROOT = "/content/usergenerated";
    protected static final String GROUP_ROOT = "/home/groups/community";
    protected static final String VAR_CONTENT_ROOT = "/var/community/create";
    protected static final String SOCIAL_ROOT = "/content/sites/social";
    protected static final String RELATIONSHIPS_ROOT = "/content/sites/social/relationships";
    protected static final String GROUP_PRIMARY_TYPE = "rep:Group";
    protected static final String AUTHORIZABLE_ID = "rep:authorizableId";
    protected static final String PATH_SEPARATOR = "/";
    private final Resource resource;
    private final ResourceResolver resolver;
    private final SocialUtils socialUtils;
    private final ValueMap configMap;
    private String asiPath;

    public SiteContentUtils(Resource resource, SocialUtils socialUtils) {
        this.resource = this.getRootResource(resource);
        this.resolver = resource.getResourceResolver();
        this.socialUtils = socialUtils != null ? socialUtils : this.resolver.adaptTo(SocialUtils.class);
        this.configMap = this.getConfigurationMap();
        this.getAsiPath();
    }

    public SiteContentUtils(Resource resource, SocialUtils socialUtils, ResourceResolver resourceResolver) {
        this.resource = this.getRootResource(resource);
        this.resolver = resourceResolver;
        this.socialUtils = socialUtils != null ? socialUtils : this.resolver.adaptTo(SocialUtils.class);
        this.configMap = this.getConfigurationMap();
        this.getAsiPath();
    }

    public void deleteSite() throws OperationException {
        this.deleteSite(false);
    }

    public void deleteSite(boolean ignoreAssets) throws OperationException {
        try {
            this.deleteUserGeneratedContent();
            this.deleteGroups();
            this.deleteSiteFolders(ignoreAssets);
            this.commit();
        }
        catch (RuntimeException e) {
            this.revert();
            LOG.error("Unable to delete the community site.", e);
            throw new OperationException(e, 500);
        }
    }

    public void deleteGroups() {
        if (StringUtils.isNotEmpty(this.getSiteId())) {
            try {
                Session session = this.resolver.adaptTo(Session.class);
                UserManager userManager = AccessControlUtil.getUserManager(session);
                Resource root = this.resolver.getResource(this.getGroupsRootPath());
                if (root != null) {
                    this.delete(userManager, root);
                    this.delete(root);
                }
            }
            catch (RepositoryException e) {
                LOG.error("Failed to delete groups.", e);
            }
        }
    }

    public void deleteUserGeneratedContent() {
        this.delete(this.getContentConstraintGroup());
        this.delete(this.getNotificationsConstraintGroup());
        this.delete(this.getActivitiesConstraintGroup());
        this.delete(this.getRelationshipsConstraintGroup());
        this.delete(this.getAsiPagePath());
        Resource siteBase = this.getAsiRootResource();
        if (siteBase != null && !siteBase.hasChildren()) {
            this.delete(siteBase);
        }
    }

    public void deleteSiteFolders(boolean ignoreAssets) {
        Resource siteBase;
        String assetsRoot;
        String resourcesRoot = this.configMap.get("siteResourcesPath", "");
        if (StringUtils.isNotEmpty(resourcesRoot)) {
            this.delete(resourcesRoot);
        }
        if (StringUtils.isNotEmpty(this.getSitePagePath())) {
            this.delete(UG_ROOT + this.getSitePagePath());
        }
        if (!ignoreAssets && StringUtils.isNotEmpty(assetsRoot = this.configMap.get("siteAssetsPath", ""))) {
            Resource assetsResource = this.resolver.getResource(assetsRoot);
            Resource siteAssets = assetsResource != null ? assetsResource.getParent() : null;
            this.delete(siteAssets != null && siteAssets.getName().equals(this.getSiteId()) ? siteAssets : assetsResource);
        }
        String baseLanguage = this.configMap.get("baseLanguage", "");
        String sitePath = this.getSitePagePath();
        String configName = this.configMap.get("name", "") + "_" + baseLanguage;
        this.delete("/libs/settings/cloudconfigs/translation/translationcfg/" + configName);
        String varContentPath = VAR_CONTENT_ROOT + this.getSitePagePath();
        Resource varContentResource = this.resolver.getResource(varContentPath);
        Resource varContentSiteBase = varContentResource != null ? varContentResource.getParent() : null;
        this.delete(varContentResource);
        if (varContentSiteBase != null && !varContentSiteBase.hasChildren()) {
            this.delete(varContentSiteBase);
        }
        Resource resource = siteBase = this.resource != null ? this.resource.getParent() : null;
        if (StringUtils.isNotEmpty(this.getSitePagePath())) {
            this.delete(this.getSitePagePath());
        }
        if (siteBase != null && siteBase.getChild("jcr:content") != null) {
            Resource content = siteBase.getChild("jcr:content");
            ValueMap contentMap = content.adaptTo(ValueMap.class);
            String[] languages = (String[])contentMap.get("languageCopies", String[].class);
            if (languages == null) {
                LOG.warn("Unable to process language params from site resource.");
                return;
            }
            ArrayList<String> languageList = new ArrayList<String>();
            languageList.addAll(Arrays.asList(languages));
            languageList.remove(baseLanguage);
            if (languageList.size() == 0) {
                this.delete(UG_ROOT + siteBase.getPath());
                this.delete(siteBase);
            } else {
                try {
                    Node contentNode = content.adaptTo(Node.class);
                    JcrUtil.setProperty(contentNode, "languageCopies", languageList.toArray(new String[languageList.size()]));
                    String redirectTarget = contentMap.get("redirectTarget", "");
                    if (redirectTarget.contains(sitePath)) {
                        String redirectPath = sitePath.substring(0, sitePath.length() - baseLanguage.length()) + (String)languageList.get(0);
                        JcrUtil.setProperty(contentNode, "redirectTarget", redirectPath);
                    }
                }
                catch (RepositoryException e) {
                    LOG.warn("Unable to process baseLanguage param from base site resource.", e);
                }
            }
        }
    }

    protected Resource getAsiRootResource() {
        return StringUtils.isNotEmpty(this.getAsiRootPath()) ? this.resolver.getResource(this.getAsiRootPath()) : null;
    }

    protected String getAsiPagePath() {
        return this.socialUtils.resourceToUGCStoragePath(this.resource);
    }

    protected String getAsiRootPath() {
        return this.resource != null ? this.socialUtils.resourceToUGCStoragePath(this.resource.getParent()) : "";
    }

    protected Resource getRootResource(Resource resource) {
        return resource != null && resource.getName().equals("configuration") ? resource.getParent() : resource;
    }

    protected Resource getConfigurationResource() {
        return this.resource != null ? this.resource.getChild("configuration") : null;
    }

    protected Resource getResource() {
        return this.resource;
    }

    protected ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    protected SocialUtils getSocialUtils() {
        return this.socialUtils;
    }

    protected ValueMap getConfiguration() {
        return this.configMap;
    }

    private ValueMap getConfigurationMap() {
        Resource config = this.getConfigurationResource();
        return config != null ? config.getValueMap() : new ValueMapDecorator(new HashMap<String, Object>());
    }

    protected String getSitePagePath() {
        return this.resource != null ? this.resource.getPath() : "";
    }

    protected String getSiteRootPath() {
        return this.resource != null && this.resource.getParent() != null ? this.resource.getParent().getPath() : "";
    }

    protected String getSiteId() {
        return this.configMap.get("siteId", "");
    }

    protected String getGroupsRootPath() {
        return "/home/groups/community/" + this.getSiteId();
    }

    private List<Resource> ugcSearch(ConstraintGroup constraintGroup, int offset, int limit) {
        UgcSearch ugcSearch = this.resolver.adaptTo(UgcSearch.class);
        UgcFilter filter = new UgcFilter();
        filter.addConstraint(constraintGroup);
        SearchResults<Resource> searchResults = null;
        try {
            searchResults = ugcSearch.find(null, this.resolver, filter, offset, limit, false);
        }
        catch (RepositoryException e) {
            LOG.error("Unable to get the site content: ", e);
        }
        List<Resource> results = new ArrayList<Resource>();
        if (searchResults != null && searchResults.getResults() != null) {
            results = searchResults.getResults();
        }
        return results;
    }

    protected ConstraintGroup getContentConstraintGroup() {
        return this.getPathConstraintGroup(this.getAsiPagePath());
    }

    protected ConstraintGroup getPathConstraintGroup(String path) {
        ConstraintGroup constraintGroup = new ConstraintGroup();
        constraintGroup.and(new PathConstraint(path, PathConstraintType.IsDescendantNode));
        return constraintGroup;
    }

    protected ConstraintGroup getNotificationsConstraintGroup() {
        ConstraintGroup constraintGroup = new ConstraintGroup();
        constraintGroup.and(this.getValueConstraintGroupForSitePath(TARGET_PROP));
        constraintGroup.and(new ValueConstraint<String>(RESOURCE_TYPE_PROP, NOTIFICATION_RESOURCE_TYPE, ComparisonType.Equals));
        return constraintGroup;
    }

    protected ConstraintGroup getActivitiesConstraintGroup() {
        ConstraintGroup constraintGroup = new ConstraintGroup();
        constraintGroup.and(this.getValueConstraintGroupForSitePath(TARGET_PROP));
        constraintGroup.and(new ValueConstraint<String>(RESOURCE_TYPE_PROP, ACTIVITY_RESOURCE_TYPE, ComparisonType.Equals));
        return constraintGroup;
    }

    protected ConstraintGroup getRelationshipsConstraintGroup() {
        if (StringUtils.isNotEmpty(this.getAsiPath(SOCIAL_ROOT)) && StringUtils.isNotEmpty(this.getAsiPath(RELATIONSHIPS_ROOT))) {
            ConstraintGroup constraintGroup = this.getPathConstraintGroup(this.getAsiPath(SOCIAL_ROOT));
            constraintGroup.and(this.getValueConstraintGroupForSitePath(END_PROP));
            constraintGroup.and(new ValueConstraint<String>(PARENT_PROP, this.getAsiPath(RELATIONSHIPS_ROOT), ComparisonType.Equals));
            return constraintGroup;
        }
        return null;
    }

    protected ConstraintGroup getValueConstraintGroupForSitePath(String name) {
        ConstraintGroup constraintGroup = new ConstraintGroup();
        constraintGroup.or(new ValueConstraint<String>(name, this.getSitePagePath(), ComparisonType.BeginsWith));
        constraintGroup.or(new ValueConstraint<String>(name, this.getAsiPagePath(), ComparisonType.BeginsWith));
        return constraintGroup;
    }

    protected String getAsiPath() {
        if (this.asiPath != null && !this.asiPath.isEmpty()) {
            return this.asiPath;
        }
        this.asiPath = this.socialUtils.resourceToUGCStoragePath(this.resolver.getResource(UG_ROOT));
        if (this.asiPath == null) {
            this.asiPath = "";
        }
        if (this.asiPath.length() > 1 && this.asiPath.endsWith(PATH_SEPARATOR)) {
            this.asiPath = this.asiPath.substring(0, this.asiPath.length() - 1);
        }
        return this.asiPath;
    }

    protected String getAsiPath(String path) {
        return this.getAsiPath() + path;
    }

    protected boolean isGroup(Resource group) {
        return group.getValueMap().get("jcr:primaryType", "").equals(GROUP_PRIMARY_TYPE);
    }

    protected String getGroupAuthorizableId(Resource group) {
        return group.getValueMap().get(AUTHORIZABLE_ID, "");
    }

    protected void delete(UserManager userManager, Resource root) {
        if (root != null && root.hasChildren()) {
            Iterable<Resource> children = root.getChildren();
            for (Resource child : children) {
                if (this.isGroup(child)) {
                    String authId = this.getGroupAuthorizableId(child);
                    if (!StringUtils.isNotEmpty(authId)) continue;
                    this.delete(userManager, authId);
                    continue;
                }
                this.delete(userManager, child);
            }
        }
    }

    protected void delete(UserManager manager, String groupId) {
        if (StringUtils.isNotEmpty(groupId)) {
            try {
                Authorizable authorizable = manager.getAuthorizable(groupId);
                if (authorizable.isGroup()) {
                    Group group = (Group)authorizable;
                    Iterator<Group> parents = group.declaredMemberOf();
                    while (parents.hasNext()) {
                        parents.next().removeMember(group);
                    }
                    Iterator<Authorizable> members = group.getDeclaredMembers();
                    while (members.hasNext()) {
                        group.removeMember(members.next());
                    }
                    group.remove();
                }
            }
            catch (RepositoryException e) {
                LOG.error("Unable to delete the group: " + groupId, e);
            }
        }
    }

    protected void sort(List<Resource> resources) {
        Collections.sort(resources, new Comparator<Resource>(){

            @Override
            public int compare(Resource r1, Resource r2) {
                return Double.compare(r2.getPath().length(), r1.getPath().length());
            }
        });
    }

    protected void delete(ConstraintGroup constraintGroup) {
        List<Resource> resources;
        if (constraintGroup == null) {
            return;
        }
        int offset = 0;
        int limit = 1000;
        do {
            resources = this.ugcSearch(constraintGroup, offset, limit);
            this.sort(resources);
            this.delete(resources);
            offset = limit;
            limit += 1000;
        } while (resources != null && !resources.isEmpty());
    }

    protected void delete(List<Resource> resources) {
        if (resources != null && !resources.isEmpty()) {
            for (Resource resource : resources) {
                this.delete(resource);
            }
        }
    }

    protected boolean delete(String path) {
        return this.delete(this.resolver.getResource(path));
    }

    protected boolean delete(Resource resource) {
        try {
            if (this.resourceExists(resource)) {
                this.resolver.delete(resource);
                return true;
            }
        }
        catch (PersistenceException e) {
            LOG.error("Unable to delete the resource: " + resource.getPath(), e);
        }
        return false;
    }

    protected boolean resourceExists(Resource resource) {
        return this.resolver != null && resource != null && this.resolver.getResource(resource.getPath()) != null;
    }

    protected boolean commit() {
        try {
            if (this.resolver != null && this.resolver.hasChanges()) {
                this.resolver.commit();
                return true;
            }
        }
        catch (PersistenceException e) {
            LOG.error("Unable to commit the changes", e);
            throw new RuntimeException(e);
        }
        return false;
    }

    protected void revert() {
        if (this.resolver != null && this.resolver.hasChanges()) {
            this.resolver.revert();
        }
    }
}

