/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.site.endpoints;

import com.adobe.cq.social.blueprint.api.SiteBlueprintUtil;
import com.adobe.cq.social.blueprint.api.TemplateRolloutService;
import com.adobe.cq.social.console.utils.api.FunctionDefinitionUtils;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.templates.api.FunctionDefinition;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteOperationUtils {
    private static final int NUMBER_OF_RANDOM_CHAR = 5;
    private static final Logger LOG = LoggerFactory.getLogger(SiteOperationUtils.class);
    private static final String OLD_HOME_PAGE_URL_NAME = "oldHome";
    static SiteOperationUtils SINGLETON = new SiteOperationUtils();
    private static final String NODE_JCR_CONTENT = "jcr:content";

    public static SiteOperationUtils getInstance() {
        return SINGLETON;
    }

    public static synchronized String generateUniqueSiteId(SocialUtils socialUtils, ResourceResolver resolver, String name, String root) throws OperationException {
        int num = 0;
        do {
            String siteId;
            if (SiteBlueprintUtil.validateGroupName(resolver, siteId = SiteOperationUtils.createUniqueNameHint(socialUtils, name, 5), root)) {
                return siteId;
            }
            LOG.debug("failed with {}", (Object)siteId);
        } while (++num < 10);
        throw new OperationException("Failed to generate a unique community site id with name " + name, 500);
    }

    public Page moveHomePage(TemplateRolloutService siteBlueprintService, PageManager pageManager, JSONArray newStructure, Resource site, ResourceResolver resolver, String templatePath, List<String> deletedPages) throws WCMException, JSONException, PersistenceException, RepositoryException {
        if (siteBlueprintService == null) {
            throw new IllegalArgumentException("site blueprint service value can't be null");
        }
        Page oldHome = pageManager.copy(pageManager.getPage(site.getPath()), site.getPath() + "/" + OLD_HOME_PAGE_URL_NAME, null, true, true);
        JSONObject newHomeFunc = newStructure.getJSONObject(0);
        Resource oldHomeContent = site.getChild(NODE_JCR_CONTENT);
        pageManager.delete(oldHomeContent, false);
        Node siteRoot = site.adaptTo(Node.class);
        String newHomeUrl = newHomeFunc.has("origUrl") ? newHomeFunc.getString("origUrl") : newHomeFunc.getString("url");
        Node newHomeContent = site.getChild(newHomeUrl + "/jcr:content").adaptTo(Node.class);
        JcrUtil.copy(newHomeContent, siteRoot, NODE_JCR_CONTENT);
        pageManager.copy(site.getChild(newHomeUrl + "/jcr:content"), site.getPath() + "/" + NODE_JCR_CONTENT, null, false, true);
        deletedPages.add(newHomeUrl);
        deletedPages.add(OLD_HOME_PAGE_URL_NAME);
        Resource homeContent = resolver.getResource(oldHomeContent.getPath());
        siteBlueprintService.configureHomePage(this.getSiteRootConfig(resolver, templatePath), homeContent);
        ModifiableValueMap oldContentProps = oldHome.getContentResource().adaptTo(ModifiableValueMap.class);
        boolean homeHasCommunitySiteProperty = oldContentProps.containsKey("cq:isCommunitySite");
        if (homeHasCommunitySiteProperty) {
            oldContentProps.remove("cq:isCommunitySite");
            ModifiableValueMap homeContentProps = homeContent.adaptTo(ModifiableValueMap.class);
            homeContentProps.put("cq:isCommunitySite", true);
        }
        return oldHome;
    }

    public void reorderFunctions(TemplateRolloutService siteBlueprintService, JSONArray newStructure, Resource site, ResourceResolver resolver, String templatePath, List<String> deletedPages) throws JSONException, WCMException, PersistenceException, RepositoryException {
        PageManager pageManager = resolver.adaptTo(PageManager.class);
        if (siteBlueprintService == null) {
            throw new IllegalArgumentException("site blueprint service value can't be null");
        }
        Page oldHome = this.fixHomePage(siteBlueprintService, newStructure, templatePath, site, resolver, deletedPages, pageManager);
        for (int i = newStructure.length() - 1; i > 0; --i) {
            boolean hasUrlChanged;
            JSONObject function = newStructure.getJSONObject(i);
            FunctionDefinition funcDef = (FunctionDefinition)function.get("funcDef");
            String child = function.has("origUrl") ? function.getString("origUrl") : funcDef.getUrl();
            StructureActions action = function.has("action") ? (StructureActions)((Object)function.get("action")) : null;
            Resource resourceBeingTouched = site.getChild(child);
            Page pageToTouch = this.findPageToTouch(pageManager, oldHome, resourceBeingTouched);
            boolean bl = function.has("origUrl") ? !StringUtils.equals(function.getString("origUrl"), funcDef.getUrl()) : (hasUrlChanged = false);
            if (action == StructureActions.DELETED) {
                deletedPages.add(pageToTouch.getName());
                continue;
            }
            String nextFuncUrl = null;
            if (i + 1 != newStructure.length()) {
                JSONObject nextFunction = newStructure.getJSONObject(i + 1);
                FunctionDefinition nextFunDefc = (FunctionDefinition)nextFunction.get("funcDef");
                nextFuncUrl = nextFunDefc.getUrl();
            }
            if (hasUrlChanged) {
                this.markForMove(pageToTouch, site.getPath() + "/" + funcDef.getUrl(), nextFuncUrl, resolver, deletedPages, pageManager);
                continue;
            }
            if (pageToTouch == null || !StringUtils.isNotBlank(nextFuncUrl)) continue;
            pageManager.move(pageToTouch, site.getPath() + "/" + funcDef.getUrl(), nextFuncUrl, false, true, null);
        }
    }

    public void applyConfigurations(TemplateRolloutService siteBlueprintService, Node functionsNode, Resource site, ResourceResolver resolver) throws RepositoryException {
        if (siteBlueprintService == null) {
            throw new IllegalArgumentException("site blueprint service value can't be null");
        }
        Resource functionsFolder = resolver.getResource(functionsNode.getPath());
        boolean isHomePage = true;
        PageManager pageManager = resolver.adaptTo(PageManager.class);
        for (Resource function : functionsFolder.getChildren()) {
            Page functionPage;
            ValueMap functionProps = function.adaptTo(ValueMap.class);
            String functionPath = functionProps.get("function", "");
            Resource functionMeta = resolver.getResource(functionPath);
            if (isHomePage) {
                functionPage = pageManager.getPage(site.getPath());
            } else {
                String functionName = functionProps.get("url", "");
                Resource resource = site.getChild(functionName);
                if (resource != null) {
                    functionPage = pageManager.getPage(resource.getPath());
                } else {
                    functionPage = null;
                    LOG.warn("Unable to obtain resource page for {}", (Object)functionProps.get("url", ""));
                }
            }
            if (functionPage != null) {
                siteBlueprintService.applyFunctionConfig(resolver, function, functionMeta, functionPage);
            }
            isHomePage = false;
        }
    }

    public void deleteFunctions(Node functionsNode, List<String> deletedPages, Resource site, PageManager pageMgr, ResourceResolver resolver) throws WCMException, RepositoryException {
        for (int i = 0; i < deletedPages.size(); ++i) {
            this.markPageForDeletion(site.getChild(deletedPages.get(i)), pageMgr, deletedPages, resolver.getUserID());
        }
        functionsNode.setProperty("toBeDeleted", deletedPages.toArray(new String[deletedPages.size()]));
    }

    public void applyActions(TemplateRolloutService siteBlueprintService, Resource site, ResourceResolver resolver, FunctionDefinitionUtils funcDefUtils, JSONArray functions, JSONArray newStructure) throws JSONException, OperationException, RepositoryException, WCMException {
        if (siteBlueprintService == null) {
            throw new IllegalArgumentException("site blueprint service value can't be null");
        }
        Resource groupFolder = resolver.getResource(site.getPath());
        for (int i = 0; i < functions.length(); ++i) {
            JSONObject function = functions.getJSONObject(i);
            FunctionDefinition funcDef = funcDefUtils.createFunctionDefinition(function, resolver);
            function.put("funcDef", funcDef);
            StructureActions action = function.has("action") ? StructureActions.fromString(function.getString("action")) : null;
            function.put("action", (Object)action);
            if (i > 0 && action == null) {
                Resource functionResource;
                String functionName;
                String string = functionName = function.has("origUrl") ? function.getString("origUrl") : function.getString("url");
                if (StringUtils.isNotBlank(functionName) && (functionResource = groupFolder.getChild(functionName)) == null) {
                    action = StructureActions.NEW;
                }
            }
            if (action != StructureActions.DELETED) {
                newStructure.put(function);
            }
            if (action == StructureActions.NEW) {
                siteBlueprintService.rolloutFunction(site.getPath(), funcDef, resolver);
            }
            functions.put(i, function);
        }
    }

    private void markPageForDeletion(Resource page, PageManager pageMgr, List<String> deletedPages, String userId) throws WCMException {
        Page pageToBeDeleted = pageMgr.getPage(page.getPath());
        if (pageToBeDeleted != null) {
            Resource contentResource = pageToBeDeleted.getContentResource();
            ModifiableValueMap properties = contentResource.adaptTo(ModifiableValueMap.class);
            properties.put("deleted", Calendar.getInstance());
            properties.put("deletedBy", userId);
            properties.put("hideInNav", true);
        }
    }

    private boolean hasHomePageMoved(JSONArray newStructure, Resource site, JSONObject function, StructureActions action) throws JSONException {
        if (action == StructureActions.MOVED || action == StructureActions.NEW) {
            return true;
        }
        return site.getChild(function.getString("origUrl")) != null;
    }

    private void markForMove(Page pageToTouch, String newUrl, String nextFuncUrl, ResourceResolver resolver, List<String> deletedPages, PageManager pageManager) throws WCMException {
        deletedPages.add(pageToTouch.getName());
        pageManager.copy(pageToTouch, newUrl, nextFuncUrl, false, false);
    }

    private Resource getSiteRootConfig(ResourceResolver resolver, String templatePath) {
        Resource template = resolver.getResource(templatePath);
        ValueMap templateProps = template.getValueMap();
        String baseTemplatePath = templateProps.get("sitePath", "/content/communities/templates/basetemplate");
        Resource siteWideFunctions = resolver.getResource(baseTemplatePath);
        return siteWideFunctions.getChild("siteRootConfig");
    }

    private Page findPageToTouch(PageManager pageManager, Page oldHome, Resource resourceBeingMoved) {
        if (resourceBeingMoved == null) {
            return oldHome;
        }
        Page potentialMatch = pageManager.getPage(resourceBeingMoved.getPath());
        Resource contentResource = potentialMatch.getContentResource();
        ValueMap resourceProps = contentResource.getValueMap();
        if (resourceProps.containsKey("deleted")) {
            return oldHome;
        }
        return potentialMatch;
    }

    private Page fixHomePage(TemplateRolloutService siteBlueprintService, JSONArray newStructure, String templatePath, Resource site, ResourceResolver resolver, List<String> deletedPages, PageManager pageManager) throws PersistenceException, JSONException, WCMException, RepositoryException {
        StructureActions action;
        if (siteBlueprintService == null) {
            throw new IllegalArgumentException("site blueprint service value can't be null");
        }
        JSONObject function = newStructure.getJSONObject(0);
        FunctionDefinition funcDef = (FunctionDefinition)function.get("funcDef");
        String child = function.has("origUrl") ? function.getString("origUrl") : funcDef.getUrl();
        StructureActions structureActions = action = function.has("action") ? (StructureActions)((Object)function.get("action")) : null;
        if (this.hasHomePageMoved(newStructure, site, function, action)) {
            return this.moveHomePage(siteBlueprintService, pageManager, newStructure, site, resolver, templatePath, deletedPages);
        }
        return null;
    }

    private static String createUniqueNameHint(SocialUtils socialUtils, String nameBase, int numRandomChars) {
        String base = nameBase;
        if (base.length() > 20) {
            base = base.substring(0, 20);
        }
        base = base.replaceAll("\\<.*?>", "");
        base = base.replaceAll("\\&.*?\\;", "");
        StringBuilder name = new StringBuilder(base);
        String suffix = socialUtils.generateRandomString(numRandomChars);
        name.append("-");
        name.append(suffix);
        return name.toString().toLowerCase();
    }

    private static enum StructureActions {
        NEW("NEW"),
        MOVED("MOV"),
        DELETED("DEL");

        private final String actionString;

        private StructureActions(String actionString) {
            this.actionString = actionString;
        }

        public String getActionString() {
            return this.actionString;
        }

        public static StructureActions fromString(String actionString) {
            for (StructureActions action : StructureActions.values()) {
                if (!StringUtils.equals(actionString, action.getActionString())) continue;
                return action;
            }
            return null;
        }
    }
}

