/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.internal;

import com.adobe.cq.social.srp.internal.CacheEntry;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCache<Y, X> {
    public static final boolean DEFAULT_CACHE_ON = true;
    public static final long DEFAULT_CACHE_TTL = 5000L;
    public static final int DEFAULT_START_CACHE_SIZE = 100;
    public static final int DEFAULT_MAX_CACHE_SIZE = 2500;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCache.class);
    private static final long serialVersionUID = 1L;
    private boolean useCache = true;
    private Cache<Y, CacheEntry<X>> cache;

    public AbstractCache(int concurrencyLevel, int cacheStartSize, int cacheMaxSize, long ttl) {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(cacheStartSize).maximumSize(cacheMaxSize).expireAfterWrite(ttl, TimeUnit.MILLISECONDS).build();
    }

    public AbstractCache() {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(4).initialCapacity(100).maximumSize(2500L).expireAfterWrite(5000L, TimeUnit.MILLISECONDS).build();
    }

    public void put(Y key, CacheEntry<X> doc) {
        if (key == null || doc == null) {
            return;
        }
        LOG.debug("Updating cache for {}: {}", (Object)key, (Object)doc.get());
        this.cache.put(key, doc);
    }

    public void remove(Object key) {
        this.cache.invalidate(key);
    }

    public void removeAll(Iterable<?> keys) {
        this.cache.invalidateAll(keys);
    }

    public abstract void merge(Y var1, X var2, X var3);

    public CacheEntry<X> get(Object key) {
        if (!this.useCache) {
            LOG.debug("Cache not used for: {}", key);
            return null;
        }
        CacheEntry<X> doc = this.cache.getIfPresent(key);
        if (LOG.isDebugEnabled()) {
            if (doc != null) {
                LOG.debug("Cache --HIT--: {}", key);
            } else {
                LOG.debug("Cache MISS or EXPIRED: {}", key);
            }
        }
        return doc;
    }

    public void setCacheMode(boolean mode) {
        this.useCache = mode;
        LOG.debug("Cache is on?: {}", (Object)mode);
    }

    public Set<Y> keySet() {
        return this.cache.asMap().keySet();
    }

    public void clear() {
        this.cache.invalidateAll();
    }
}

