/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.internal;

import com.adobe.cq.social.srp.SocialResource;
import com.adobe.cq.social.srp.SocialResourceProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.List;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;

public class SocialPropertyResourceImpl
extends AbstractResource
implements SocialResource {
    private final ResourceResolver resourceResolver;
    private final String path;
    private final String resourceType;
    private final ResourceMetadata metadata;
    private final SocialResourceProvider provider;
    private final Object propertyValue;

    public SocialPropertyResourceImpl(String path, String parentResourceType, SocialResourceProvider provider, ResourceResolver resourceResolver, String propertyName, Object propertyValue) {
        this.resourceResolver = resourceResolver;
        this.path = path;
        this.resourceType = parentResourceType + "/" + propertyName;
        this.metadata = new ResourceMetadata();
        this.metadata.setResolutionPath(path);
        this.provider = provider;
        this.propertyValue = propertyValue;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getResourceSuperType() {
        return null;
    }

    @Override
    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    @Override
    public SocialResourceProvider getResourceProvider() {
        return this.provider;
    }

    @Override
    public Resource getRootJCRNode() {
        return null;
    }

    private String getString(Object o) {
        return o.toString();
    }

    private Boolean getBoolean(Object o) {
        return o instanceof Boolean ? (Boolean)o : Boolean.valueOf(o.toString());
    }

    private Long getLong(Object o) {
        return o instanceof Long ? (Long)o : Long.valueOf(Long.parseLong(o.toString()));
    }

    private Double getDouble(Object o) {
        return o instanceof Double ? (Double)o : new Double(Double.parseDouble(o.toString()));
    }

    @Override
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == InputStream.class) {
            try {
                return (AdapterType)new ByteArrayInputStream(this.getString(this.propertyValue).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        if (type == String.class) {
            return (AdapterType)this.getString(this.propertyValue);
        }
        if (type == Boolean.class) {
            return (AdapterType)this.getBoolean(this.propertyValue);
        }
        if (type == Long.class) {
            return (AdapterType)this.getLong(this.propertyValue);
        }
        if (type == Double.class) {
            return (AdapterType)this.getDouble(this.propertyValue);
        }
        if (type == Calendar.class) {
            if (this.propertyValue instanceof Calendar) {
                return (AdapterType)this.propertyValue;
            }
        } else {
            if (type == String[].class) {
                if (this.propertyValue instanceof List) {
                    String[] result = new String[((List)this.propertyValue).size()];
                    for (int i = 0; i < ((List)this.propertyValue).size(); ++i) {
                        result[i] = this.getString(((List)this.propertyValue).get(i));
                    }
                    return (AdapterType)result;
                }
                return (AdapterType)new String[]{this.getString(this.propertyValue)};
            }
            if (type == Boolean[].class) {
                if (this.propertyValue instanceof List) {
                    Boolean[] result = new Boolean[((List)this.propertyValue).size()];
                    for (int i = 0; i < ((List)this.propertyValue).size(); ++i) {
                        result[i] = this.getBoolean(((List)this.propertyValue).get(i));
                    }
                    return (AdapterType)result;
                }
                return (AdapterType)new Boolean[]{this.getBoolean(this.propertyValue)};
            }
            if (type == Long[].class) {
                if (this.propertyValue instanceof List) {
                    Long[] result = new Long[((List)this.propertyValue).size()];
                    for (int i = 0; i < ((List)this.propertyValue).size(); ++i) {
                        result[i] = this.getLong(((List)this.propertyValue).get(i));
                    }
                    return (AdapterType)result;
                }
                return (AdapterType)new Long[]{this.getLong(this.propertyValue)};
            }
            if (type == Double[].class) {
                if (this.propertyValue instanceof List) {
                    Double[] result = new Double[((List)this.propertyValue).size()];
                    for (int i = 0; i < ((List)this.propertyValue).size(); ++i) {
                        result[i] = this.getDouble(((List)this.propertyValue).get(i));
                    }
                    return (AdapterType)result;
                }
                return (AdapterType)new Double[]{this.getDouble(this.propertyValue)};
            }
        }
        return super.adaptTo(type);
    }

    @Override
    public boolean checkPermissions(String permission) {
        throw new UnsupportedOperationException("Attempting to check permissions on a property. This is not supported.");
    }
}

