/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.internal;

import com.adobe.cq.social.srp.APICommand;
import com.adobe.cq.social.srp.APIException;
import com.adobe.cq.social.srp.APIResult;
import com.adobe.cq.social.srp.FacetRangeField;
import com.adobe.cq.social.srp.FacetSearchResult;
import com.adobe.cq.social.srp.IntervalFacetRangeField;
import com.adobe.cq.social.srp.ProviderMetaData;
import com.adobe.cq.social.srp.SearchSortField;
import com.adobe.cq.social.srp.SocialResourcePrefetch;
import com.adobe.cq.social.srp.SocialResourceSearchResult;
import com.adobe.cq.social.srp.config.ASRPConfiguration;
import com.adobe.cq.social.srp.config.DSRPConfiguration;
import com.adobe.cq.social.srp.config.MSRPConfiguration;
import com.adobe.cq.social.srp.config.SRPConfigurationError;
import com.adobe.cq.social.srp.config.SRPConfigurationFactory;
import com.adobe.cq.social.srp.config.SocialResourceConfiguration;
import com.adobe.cq.social.srp.internal.AbstractCache;
import com.adobe.cq.social.srp.internal.AbstractProviderMetaData;
import com.adobe.cq.social.srp.internal.AbstractSchemaMapper;
import com.adobe.cq.social.srp.internal.AttachmentResult;
import com.adobe.cq.social.srp.internal.CacheEntry;
import com.adobe.cq.social.srp.internal.CachingResourceProvider;
import com.adobe.cq.social.srp.internal.CommandResource;
import com.adobe.cq.social.srp.internal.CountCache;
import com.adobe.cq.social.srp.internal.DocumentResult;
import com.adobe.cq.social.srp.internal.ErrorResult;
import com.adobe.cq.social.srp.internal.FacetResults;
import com.adobe.cq.social.srp.internal.LuceneToSolr;
import com.adobe.cq.social.srp.internal.MapResource;
import com.adobe.cq.social.srp.internal.MapResourceImpl;
import com.adobe.cq.social.srp.internal.ProviderCache;
import com.adobe.cq.social.srp.internal.SocialDataService;
import com.adobe.cq.social.srp.internal.SocialPropertyResourceImpl;
import com.adobe.cq.social.srp.internal.SocialProviderUtils;
import com.adobe.cq.social.srp.internal.SocialResourceUtils;
import com.adobe.cq.social.srp.internal.SolrQueryParser;
import com.adobe.cq.social.srp.internal.StringListCache;
import com.adobe.cq.social.srp.utilities.api.SocialResourceUtilities;
import com.adobe.cq.social.srp.utilities.internal.InternalSocialResourceUtilities;
import com.adobe.granite.crypto.CryptoSupport;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.commons.Externalizer;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.apache.sling.api.SlingIOException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UGCCResourceProvider
implements CachingResourceProvider {
    private static final String SINGLE_AND = "\\((\\w*) AND (\\w*)\\)";
    private static final String SINGLE_OR = "\\((\\w*) OR (\\w*)\\)";
    private static final String AND_PLUS_OR = "\\(\\(((\\w*) AND (\\w*)\\)) OR \\(((\\w*) AND (\\w*))\\)\\)";
    private static final String FIELD_STATE_APPROVED = "approved";
    private static final String FIELD_STATE_PENDING = "pending";
    private static final String FIELD_STATE_DENIED = "denied";
    private static final String FIELD_STATE_SPAM = "spam";
    private static final int VISIBLE_ONLY_COUNT = 0;
    private static final int ALL_COUNT = 1;
    public static final Integer QUERY_MAX_LENGTH = 4400;
    private static final String RANGE_DATE_FORMAT = "yyyy-MM-dd-HH";
    static final String USER_NAME_PROPERTY = "userIdentifier";
    private static final String APPROVED_STRING = "-" + AbstractSchemaMapper.getSchemaApprovedKey() + ":false";
    private static final String PENDING_STRING = "-" + AbstractSchemaMapper.getSchemaApprovedKey() + ":[\"\" TO *]";
    private static final String DENIED_STRING = AbstractSchemaMapper.getSchemaApprovedKey() + ":false";
    private static final Map<String, Object> ROOT_DOC;
    private static final Logger LOGGER;
    private static final String ATTACHMENT = "attachments";
    private static final String NAME = "name";
    private static final String TALLYCOUNT_NODE = "/tallycount";
    private static final String CC_ASIPATH = "asipath";
    private static final String CC_HOST_URL = "hosturl";
    private static final String CC_REPORT_SUITE = "reportsuite";
    private static final String CC_CONSUMER_KEY = "consumerkey";
    private static final String CC_SECRET_KEY = "secret";
    private final SocialDataService dsClient;
    private final String providerBase;
    private final Map<String, CommandResource> commandsQueue = new LinkedHashMap<String, CommandResource>();
    private final Map<String, LinkedList<CommandResource>> commandsAttachmentQueue = new LinkedHashMap<String, LinkedList<CommandResource>>();
    private final Externalizer externalizer;
    private final CryptoSupport cryptoSupport;
    private final AbstractSchemaMapper mapper;
    private final SRPConfigurationFactory srpConfigFactory;
    private final ProviderCache documentCache;
    private final CountCache visibleCountCache;
    private final CountCache allCountCache;
    private final AbstractCache<String, Map<String, Map<String, Integer>>> facetCache;
    private final StringListCache stringListCache;
    private boolean configSet;
    private ProviderMetaData metaData;

    public UGCCResourceProvider(SocialDataService client, String providerBase, Externalizer externalizer, CryptoSupport cryptoSupport, ProviderCache documentCache, CountCache allCountCache, CountCache visibleCountCache, AbstractCache<String, Map<String, Map<String, Integer>>> facetCache, StringListCache stringListCache, AbstractSchemaMapper mapper, SRPConfigurationFactory srpConfigFactory) {
        this.dsClient = client;
        this.providerBase = providerBase;
        this.externalizer = externalizer;
        this.cryptoSupport = cryptoSupport;
        this.documentCache = documentCache;
        this.visibleCountCache = visibleCountCache;
        this.allCountCache = allCountCache;
        this.mapper = mapper;
        this.facetCache = facetCache;
        this.stringListCache = stringListCache;
        this.srpConfigFactory = srpConfigFactory;
        ROOT_DOC.put("type", client.getDSClient());
        ROOT_DOC.put("sling:resourceType", "social/asi/resourceprovider");
    }

    @Override
    @Deprecated
    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
        return this.getResource(resourceResolver, path);
    }

    public SocialDataService getSocialDataService() {
        return this.dsClient;
    }

    @Override
    public Resource getResource(ResourceResolver resourceResolver, String path) {
        if (!StringUtils.startsWith(path, this.providerBase)) {
            return null;
        }
        return this.getResourceWithoutCheck(resourceResolver, path);
    }

    public Resource getResourceWithoutCheck(ResourceResolver resourceResolver, String path) {
        return this.getResourceWithoutCheck(resourceResolver, path, false);
    }

    private CacheEntry<Long> createEntry(Long result) {
        return new CacheEntry<Long>(result);
    }

    private Resource getPendingResource(ResourceResolver resolver, String path) {
        if (this.commandsQueue.containsKey(path)) {
            CommandResource command = this.commandsQueue.get(path);
            if (command.methodType == 3) {
                return new NonExistingResource(resolver, path);
            }
            if (command.methodType == 1) {
                LOGGER.debug("Returning {} from pending creates cache.", (Object)path);
            } else {
                LOGGER.debug("Returning {} from pending updates cache.", (Object)path);
            }
            MapResource cachedResource = command.getResource();
            cachedResource.unlockMetadata();
            return cachedResource;
        }
        if (this.commandsAttachmentQueue.containsKey(path)) {
            LinkedList<CommandResource> commands = this.commandsAttachmentQueue.get(path);
            CommandResource lastCommand = commands.getLast();
            if (lastCommand.methodType == 3) {
                return new NonExistingResource(resolver, path);
            }
            LOGGER.debug("Returning {} from pending creates cache.", (Object)path);
            MapResource cachedResource = lastCommand.getResource();
            cachedResource.unlockMetadata();
            return cachedResource;
        }
        return null;
    }

    private Resource getResourceWithoutCheck(ResourceResolver resourceResolver, String path, boolean recursedOnce) {
        if (StringUtils.equals(this.providerBase, path)) {
            return new MapResourceImpl(resourceResolver, this, path, ROOT_DOC, false);
        }
        if (SocialProviderUtils.isExtraneousSlingPath(resourceResolver, this, path)) {
            return null;
        }
        if (!SocialResourceUtils.checkPermission(resourceResolver, this.getJcrAclPath(path), "read").booleanValue()) {
            return null;
        }
        if (this.noConfig()) {
            return null;
        }
        Resource pendingResource = this.getPendingResource(resourceResolver, path);
        if (pendingResource != null) {
            if (ResourceUtil.isNonExistingResource(pendingResource)) {
                return null;
            }
            return pendingResource;
        }
        Map<Object, Object> doc = Collections.emptyMap();
        boolean isAttach = this.isAttachment(path);
        CacheEntry cacheVal = this.documentCache.get(path);
        if (cacheVal != null) {
            LOGGER.debug("Got {} from cache.", (Object)path);
            doc = new HashMap((Map)cacheVal.get());
        } else if (isAttach) {
            try {
                doc = this.dsClient.readAttachment(path);
            }
            catch (IOException e1) {
                throw new SlingIOException(e1);
            }
            doc = this.mapper.fromAttachmentSchema(doc);
            this.documentCache.put(path, this.documentCache.createEntry(doc, Collections.<String, Object>emptyMap()));
        } else {
            try {
                doc = this.dsClient.readDocument(path);
            }
            catch (IOException e) {
                LOGGER.error("Received exception when reading " + path, e);
                throw new SlingIOException(e);
            }
            if (!doc.isEmpty()) {
                doc = this.mapper.fromSchema(doc);
            }
            this.documentCache.put(path, this.documentCache.createEntry(doc, Collections.<String, Object>emptyMap()));
        }
        if (doc.isEmpty()) {
            if (recursedOnce || isAttach) {
                return null;
            }
            int index = path.lastIndexOf(47);
            if (index == -1) {
                return null;
            }
            String parentPath = path.substring(0, index);
            Resource resource = this.getResourceWithoutCheck(resourceResolver, parentPath, true);
            if (resource != null) {
                Object resType;
                String propertyKey = path.substring(index + 1);
                ValueMap map = resource.adaptTo(ValueMap.class);
                Object value = map.get(propertyKey);
                if (value != null && (resType = map.get("sling:resourceType")) != null) {
                    return new SocialPropertyResourceImpl(path, (String)resType, this, resourceResolver, propertyKey, value);
                }
            }
            return null;
        }
        return new MapResourceImpl(resourceResolver, this, path, doc, isAttach);
    }

    @Override
    public Resource create(ResourceResolver resourceResolver, String path, Map<String, Object> properties) throws PersistenceException {
        String commitPath;
        boolean isAttachment = false;
        if (!SocialResourceUtils.checkPermission(resourceResolver, this.getJcrAclPath(path), "add_node").booleanValue()) {
            throw new PersistenceException(String.format("Not allowed to create resource at : %s", path));
        }
        if (StringUtils.equals(path, this.providerBase)) {
            return null;
        }
        HashMap<String, Object> propertiesCopy = new HashMap<String, Object>(properties == null ? Collections.emptyMap() : properties);
        if (propertiesCopy.containsKey("nt:file") && propertiesCopy.get("nt:file") instanceof InputStream) {
            String[] info = this.getPathSuffix(path);
            commitPath = StringUtils.removeEnd(path, info[1]);
            commitPath = StringUtils.stripEnd(commitPath, "/");
            commitPath = StringUtils.stripEnd(commitPath, info[0]);
            commitPath = commitPath + ATTACHMENT + "/" + info[1];
            propertiesCopy.put(AbstractSchemaMapper.getSocoKey(), commitPath);
            isAttachment = true;
        } else {
            if (!propertiesCopy.containsKey(AbstractSchemaMapper.getSocoParentIdKey())) {
                String parentId = ResourceUtil.getParent(path);
                propertiesCopy.put(AbstractSchemaMapper.getSocoParentIdKey(), parentId);
            }
            commitPath = path;
        }
        MapResourceImpl res = new MapResourceImpl(resourceResolver, this, commitPath, propertiesCopy, isAttachment);
        if (isAttachment) {
            LinkedList<Object> commandResources;
            String name;
            if (propertiesCopy.containsKey(NAME) && !StringUtils.isEmpty(name = (String)propertiesCopy.get(NAME)) && (name.contains("[") || name.contains("]") || name.contains("/") || name.contains(":") || name.contains("|") || name.contains("*"))) {
                throw new PersistenceException("FileName contains not supporting characters");
            }
            if (this.commandsAttachmentQueue.containsKey(commitPath)) {
                commandResources = this.commandsAttachmentQueue.get(commitPath);
                commandResources.add(new CommandResource(path, 1, res));
            } else {
                commandResources = new LinkedList<CommandResource>();
                commandResources.add(new CommandResource(path, 1, res));
                this.commandsAttachmentQueue.put(commitPath, commandResources);
            }
        } else {
            this.commandsQueue.put(commitPath, new CommandResource(path, 1, res));
        }
        return res;
    }

    @Override
    public void delete(ResourceResolver resourceResolver, String path) throws PersistenceException {
        if (StringUtils.isEmpty(path)) {
            return;
        }
        if (!SocialResourceUtils.checkPermission(resourceResolver, this.getJcrAclPath(path), "remove").booleanValue()) {
            throw new PersistenceException(String.format("Not allowed to delete resource at : %s", path));
        }
        if (this.isAttachment(path)) {
            if (this.commandsAttachmentQueue.containsKey(path)) {
                LinkedList<CommandResource> commandResources = this.commandsAttachmentQueue.get(path);
                commandResources.add(new CommandResource(path, 3, null));
            } else {
                LinkedList<CommandResource> commandResources = new LinkedList<CommandResource>();
                commandResources.add(new CommandResource(path, 3, null));
                this.commandsAttachmentQueue.put(path, commandResources);
            }
        } else {
            this.commandsQueue.put(path, new CommandResource(path, 3, null));
        }
    }

    @Override
    public void revert(ResourceResolver resourceResolver) {
        this.commandsAttachmentQueue.clear();
        this.commandsQueue.clear();
    }

    private void addModerationDetails(ResourceResolver resolver, Map<String, Object> map) {
        if (map.containsKey("social:entity") && !map.containsKey(AbstractSchemaMapper.getSocoEntityUrlKey())) {
            LOGGER.debug("Updating an existing entity URL which was previously not allowed: {}", map.get("social:entity"));
        }
        if (this.externalizer != null && map.containsKey("social:entity") && !StringUtils.isEmpty((String)map.get("social:entity"))) {
            map.put(AbstractSchemaMapper.getSocoEntityUrlKey(), this.externalizer.publishLink(resolver, (String)map.remove("social:entity")));
        }
        this.addSocialSpecificFields(resolver, map);
    }

    private void addSocialSpecificFields(ResourceResolver resolver, Map<String, Object> map) {
        if (map.containsKey("social:rootCommentSystem") && map.containsKey("social:parentid")) {
            String root;
            String parent = (String)map.get("social:parentid");
            map.put("social:isReply", !StringUtils.equals(parent, root = (String)map.get("social:rootCommentSystem")));
        }
        if (map.containsKey(USER_NAME_PROPERTY) && map.containsKey("social:rootCommentSystem")) {
            UserProperties up = SocialResourceUtils.getUserProperties(resolver, (String)map.get(USER_NAME_PROPERTY));
            if (up != null) {
                try {
                    String displayName = up.getDisplayName();
                    map.put(AbstractSchemaMapper.getSocoAuthorDisplayNameKey(), displayName);
                }
                catch (RepositoryException e) {
                    LOGGER.error("Could not get display name!", e);
                }
            } else {
                LOGGER.warn("Could not get user properties.");
            }
        }
    }

    @Override
    public void commit(ResourceResolver resourceResolver) throws PersistenceException {
        try {
            MapResource res = null;
            ArrayList<APICommand> commandList = new ArrayList<APICommand>();
            for (String key : this.commandsQueue.keySet()) {
                Map map;
                APICommand batchCommand;
                CommandResource command = this.commandsQueue.get(key);
                if (command.methodType == 3) {
                    batchCommand = new APICommand(command.methodType, command.key, null);
                } else if (command.methodType == 4) {
                    res = command.getResource();
                    map = res.adaptTo(ModifiableValueMap.class);
                    if (!map.containsKey("$inc") || !(map.get("$inc") instanceof Map)) {
                        throw new PersistenceException("Command to increment sent without an increment map");
                    }
                    HashMap<String, Object> incMap = new HashMap<String, Object>();
                    incMap.put("$inc", map.get("$inc"));
                    Map<String, Object> temp = this.mapper.toSchema(incMap, command.key);
                    if (temp.containsKey("$inc")) {
                        incMap.put("$inc", temp.get("$inc"));
                    } else {
                        incMap.remove("$inc");
                    }
                    if (temp.containsKey("cqdata")) {
                        incMap.put("cqdata", temp.get("cqdata"));
                    }
                    batchCommand = new APICommand(2, command.key, incMap, Collections.singletonMap("$inc", map.get("$inc")));
                } else {
                    res = command.getResource();
                    map = res.adaptTo(Map.class);
                    this.addModerationDetails(resourceResolver, map);
                    Map<String, Object> documentData = this.mapper.toSchema(map, command.key);
                    batchCommand = new APICommand(command.methodType, command.key, documentData, map);
                }
                commandList.add(batchCommand);
            }
            ArrayList<Integer> errorCodes = new ArrayList<Integer>();
            ArrayList<String> errorKeys = new ArrayList<String>();
            ArrayList<Integer> errorMethodTypes = new ArrayList<Integer>();
            if (!commandList.isEmpty()) {
                List<APIResult> apiResults = this.dsClient.batchCommit(commandList);
                for (int i = 0; i < apiResults.size(); ++i) {
                    APIResult apiResult = apiResults.get(i);
                    APICommand apiCommand = (APICommand)commandList.get(i);
                    if (apiResult.getResult()) {
                        switch (apiCommand.methodType) {
                            case 1: {
                                CacheEntry<Map<String, Object>> entry = this.documentCache.createEntry(apiCommand.map, ((DocumentResult)apiResult).getDocument());
                                this.documentCache.put(apiCommand.providerId, entry);
                                ArrayList<String> cacheKey = new ArrayList<String>(1);
                                ArrayList<String> cacheKeyWithBase = new ArrayList<String>(2);
                                cacheKey.add(apiCommand.providerId);
                                cacheKeyWithBase.add(apiCommand.providerId);
                                Long cacheCounts = 0L;
                                this.visibleCountCache.put(cacheKey, new CacheEntry<Long>(cacheCounts));
                                this.allCountCache.put(cacheKey, new CacheEntry<Long>(cacheCounts));
                                cacheKeyWithBase.add((String)apiCommand.map.get("social:baseType"));
                                this.visibleCountCache.put(cacheKeyWithBase, new CacheEntry<Long>(cacheCounts));
                                this.allCountCache.put(cacheKeyWithBase, new CacheEntry<Long>(cacheCounts));
                                LOGGER.debug("Creating cache entry for {}: {}", (Object)apiCommand.providerId, (Object)entry);
                                if (!apiCommand.map.containsKey(AbstractSchemaMapper.getSocoParentIdKey())) break;
                                String parentKey = (String)apiCommand.map.get(AbstractSchemaMapper.getSocoParentIdKey());
                                this.removeAllMatchesFromCountCache(parentKey);
                                this.deleteListChildrenCache(parentKey);
                                this.facetCache.remove(parentKey);
                                break;
                            }
                            case 2: 
                            case 4: {
                                this.mergeCacheContents(apiCommand.providerId, apiCommand.map, this.mapper.fromSchema(((DocumentResult)apiResult).getDocument()));
                                break;
                            }
                            case 3: {
                                this.deleteDocumentFromCache(apiCommand.providerId);
                            }
                        }
                        continue;
                    }
                    ErrorResult errorResult = (ErrorResult)apiResult;
                    if (apiCommand.methodType == 1 && errorResult.getCode() == 101) {
                        this.deleteDocumentFromCache(apiCommand.providerId);
                    } else {
                        LOGGER.error(errorResult.toString());
                    }
                    errorCodes.add(errorResult.getCode());
                    errorKeys.add(apiCommand.providerId);
                    errorMethodTypes.add(apiCommand.methodType);
                }
            }
            for (String key : this.commandsAttachmentQueue.keySet()) {
                LinkedList<CommandResource> commandResources = this.commandsAttachmentQueue.get(key);
                for (CommandResource command : commandResources) {
                    switch (command.methodType) {
                        case 1: {
                            res = command.getResource();
                            Map map = res.adaptTo(Map.class);
                            Map<String, Object> mappedMap = this.mapper.toAttachmentSchema(map, key);
                            this.dsClient.addAttachment(key, mappedMap);
                            break;
                        }
                        case 3: {
                            this.dsClient.deleteAttachment(key);
                        }
                    }
                }
            }
            this.commandsAttachmentQueue.clear();
            this.commandsQueue.clear();
            if (!errorKeys.isEmpty()) {
                throw new APIException("Some of the modification operations failed", errorCodes, errorKeys, errorMethodTypes);
            }
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new PersistenceException("Could not commit changes", e);
        }
    }

    private void mergeCacheContents(String key, Map<String, Object> data, Map<String, Object> returnedResult) {
        this.documentCache.merge(key, data, returnedResult);
        CacheEntry cached = this.documentCache.get(key);
        if (cached != null) {
            Map docCacheEntry = (Map)cached.get();
            if (docCacheEntry != null && docCacheEntry.containsKey(AbstractSchemaMapper.getSocoParentIdKey())) {
                this.facetCache.remove(docCacheEntry.get(AbstractSchemaMapper.getSocoParentIdKey()));
            }
        } else {
            LOGGER.debug("Did not find key {} in document cache, so did not delete the parent in facet cache.", (Object)key);
        }
    }

    @Override
    public boolean hasChanges(ResourceResolver resourceResolver) {
        return !this.commandsAttachmentQueue.isEmpty() || !this.commandsQueue.isEmpty();
    }

    @Override
    public long countChildren(Resource parent) {
        return this.countChildren(parent, false);
    }

    @Override
    public long countChildren(Resource parent, boolean visibleOnly) {
        return this.countChildren(parent, null, visibleOnly);
    }

    @Override
    public long countChildren(Resource parent, String childType) {
        return this.countChildren(parent, childType, false);
    }

    @Override
    public Map<String, Long> countChildren(List<Resource> parent, String baseType, boolean visibleOnly) {
        HashMap<String, Long> retVal = new HashMap<String, Long>();
        CountCache countCache = visibleOnly ? this.visibleCountCache : this.allCountCache;
        ArrayList<String> toFetch = new ArrayList<String>(parent.size());
        for (Resource resource : parent) {
            CacheEntry cacheEntry;
            if (!SocialResourceUtils.checkPermission(resource.getResourceResolver(), this.getJcrAclPath(resource.getPath()), "read").booleanValue()) {
                retVal.put(resource.getPath(), 0L);
                continue;
            }
            ArrayList<String> cacheKey = new ArrayList<String>(2);
            cacheKey.add(resource.getPath());
            if (StringUtils.isNotEmpty(baseType)) {
                cacheKey.add(baseType);
            }
            if ((cacheEntry = countCache.get(cacheKey)) != null) {
                Long cacheCounts = (Long)cacheEntry.get();
                if (cacheCounts != null && cacheCounts >= 0L) {
                    retVal.put(resource.getPath(), cacheCounts);
                    continue;
                }
                toFetch.add(resource.getPath());
                continue;
            }
            toFetch.add(resource.getPath());
        }
        if (!toFetch.isEmpty()) {
            Map<String, Long> fetched = this.countChildren(toFetch, visibleOnly, baseType);
            retVal.putAll(fetched);
        }
        return retVal;
    }

    @Override
    public Iterator<Resource> listChildren(Resource parent) {
        return this.listChildren(parent.getPath(), parent.getResourceResolver(), 0, -1, Collections.EMPTY_LIST);
    }

    @Override
    public Iterator<Resource> listChildren(String path, ResourceResolver resourceResolver, int offset, int size, List<Map.Entry<String, Boolean>> sortBy) {
        return this.listChildren(path, null, resourceResolver, offset, size, sortBy, false);
    }

    @Override
    public Iterator<Resource> listChildren(String path, String baseType, ResourceResolver resourceResolver, int offset, int size, List<Map.Entry<String, Boolean>> sortBy) {
        return this.listChildren(path, baseType, resourceResolver, offset, size, sortBy, false);
    }

    private ChildCountAndList childrenListFromCache(ResourceResolver resolver, List<String> stringList) {
        ChildCountAndList resourceList = new ChildCountAndList();
        for (String path : stringList) {
            CacheEntry cacheVal = this.documentCache.get(path);
            if (cacheVal != null) {
                HashMap<String, Object> doc = new HashMap<String, Object>((Map)cacheVal.get());
                if (doc.isEmpty()) {
                    return null;
                }
                resourceList.add(new MapResourceImpl(resolver, this, path, doc, false));
                continue;
            }
            return null;
        }
        return resourceList;
    }

    private String buildListChildrenCacheKey(String path, String baseType, int offset, int size, List<Map.Entry<String, Boolean>> sortBy, boolean visibleOnly) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(path);
        key.add(baseType);
        key.add(offset);
        key.add(size);
        key.add(sortBy);
        key.add(visibleOnly);
        return ((Object)key).toString();
    }

    private void updateListChildrenCacheList(String parent, String cacheKey) {
        if (parent == null || cacheKey == null) {
            return;
        }
        CacheEntry cacheVal = this.stringListCache.get(parent);
        if (cacheVal != null) {
            List cacheEntries = (List)cacheVal.get();
            cacheEntries.add(cacheKey);
            this.stringListCache.put(parent, new CacheEntry<List>(cacheEntries));
        } else {
            ArrayList<String> entry = new ArrayList<String>();
            entry.add(cacheKey);
            this.stringListCache.put(parent, new CacheEntry(entry));
        }
    }

    private void deleteListChildrenCache(String parent) {
        CacheEntry cacheVal = this.stringListCache.get(parent);
        if (cacheVal != null) {
            List values = (List)cacheVal.get();
            for (String entry : values) {
                this.stringListCache.remove(entry);
            }
        }
        this.stringListCache.remove(parent);
    }

    private Map<String, Long> countChildrenNonSearch(List<String> children, boolean visible, String baseType) {
        Map<String, Long> childCounts;
        if (this.noConfig()) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> retVal = new HashMap<String, Long>(children.size());
        long start = 0L;
        if (LOGGER.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        CountCache countCache = visible ? this.visibleCountCache : this.allCountCache;
        try {
            childCounts = this.dsClient.countChildren(children, baseType, visible);
        }
        catch (IOException e) {
            LOGGER.error("Could not prefetch children including " + children.get(0), e);
            return retVal;
        }
        for (String child : children) {
            Long cacheCounts = childCounts.get(child);
            ArrayList<String> cacheKey = new ArrayList<String>();
            cacheKey.add(child);
            if (StringUtils.isNotEmpty(baseType)) {
                cacheKey.add(baseType);
            }
            countCache.put(cacheKey, this.createEntry(cacheCounts));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reply counts for: " + child + " " + cacheCounts);
            }
            retVal.put(child, cacheCounts);
        }
        if (LOGGER.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            LOGGER.debug("Call to prefetchChildrenCount for list {} completed in {} ms", (Object)children.toString(), (Object)Long.toString(end - start));
        }
        return retVal;
    }

    private Map<String, Long> countChildren(List<String> children, boolean visible, String baseType) {
        List<Map<String, Object>> results;
        HashMap<String, Long> retVal = new HashMap<String, Long>(children.size());
        long start = 0L;
        if (LOGGER.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        CountCache countCache = visible ? this.visibleCountCache : this.allCountCache;
        StringBuilder facetPart = new StringBuilder("&facet=true&facet.field=\"");
        facetPart.append(AbstractSchemaMapper.getSocoParentIdKey());
        facetPart.append("\"&facet.mincount=1&rows=0");
        StringBuilder filterPart = new StringBuilder("AND (-(");
        filterPart.append(AbstractSchemaMapper.getSocoFlaggedHiddenKey()).append(":true) -(");
        filterPart.append(AbstractSchemaMapper.getSocoDraftKey()).append(":true) +(");
        filterPart.append(AbstractSchemaMapper.getSocoApprovedKey()).append(":true)) ");
        StringBuilder baseTypePart = new StringBuilder("");
        if (StringUtils.isNotEmpty(baseType)) {
            baseTypePart.append(" AND (").append(AbstractSchemaMapper.getSchemaBaseType()).append(":\"").append(baseType).append("\")");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(AbstractSchemaMapper.escapeForSolr(AbstractSchemaMapper.getSocoParentIdKey()));
        sb.append(":(");
        boolean firstTime = true;
        for (String s : children) {
            if (!firstTime) {
                sb.append(" OR ");
            }
            sb.append("\"");
            sb.append(s);
            sb.append("\" ");
            firstTime = false;
        }
        sb.append(") ");
        StringBuilder theQuery = new StringBuilder(sb);
        if (visible) {
            theQuery.append((CharSequence)filterPart);
        }
        theQuery.append((CharSequence)baseTypePart);
        theQuery.append((CharSequence)facetPart);
        if (theQuery.toString().length() > QUERY_MAX_LENGTH) {
            return this.countChildrenNonSearch(children, visible, baseType);
        }
        try {
            results = this.searchDocuments(theQuery.toString());
        }
        catch (IOException e) {
            LOGGER.error("Could not prefetch children including " + children.get(0), e);
            return retVal;
        }
        Map<Object, Object> map = Collections.emptyMap();
        if (results != null && !results.isEmpty()) {
            map = results.get(0);
        }
        for (String child : children) {
            Object oVal = map.get(child);
            Long cacheCounts = oVal != null ? Long.valueOf(((Integer)oVal).longValue()) : Long.valueOf(0L);
            ArrayList<String> cacheKey = new ArrayList<String>();
            cacheKey.add(child);
            if (StringUtils.isNotEmpty(baseType)) {
                cacheKey.add(baseType);
            }
            countCache.put(cacheKey, this.createEntry(cacheCounts));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reply counts for: " + child + " " + cacheCounts);
            }
            retVal.put(child, cacheCounts);
        }
        if (LOGGER.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            LOGGER.debug("Call to prefetchChildrenCount for list {} completed in {} ms", (Object)children.toString(), (Object)Long.toString(end - start));
        }
        return retVal;
    }

    private String parseQuery(String query) {
        Query parsedCQQuery;
        String baseQuery = StringUtils.substringBefore(query, "&");
        WhitespaceAnalyzer analyzer = new WhitespaceAnalyzer(Version.LUCENE_47);
        SolrQueryParser parser = new SolrQueryParser(this.mapper, Version.LUCENE_47, "f", analyzer);
        try {
            parsedCQQuery = parser.parse(baseQuery);
        }
        catch (ParseException e) {
            LOGGER.error("Could not parse Lucene query:", e);
            return null;
        }
        return parsedCQQuery.toString();
    }

    private List<Map<String, Object>> searchDocuments(String query) throws IOException {
        if (this.noConfig()) {
            return Collections.emptyList();
        }
        String queryInSchema = this.parseQuery(query);
        if (null == queryInSchema) {
            return Collections.emptyList();
        }
        String facetInfo = StringUtils.substringAfter(query, "&");
        if (StringUtils.contains((CharSequence)facetInfo, "facet=true")) {
            return this.facetedSearch(facetInfo, queryInSchema);
        }
        List<Map<String, Object>> schemaDocs = this.dsClient.nonFacetedSearch(queryInSchema);
        ArrayList<Map<String, Object>> returnDocs = new ArrayList<Map<String, Object>>(schemaDocs.size());
        for (Map<String, Object> schemaDoc : schemaDocs) {
            returnDocs.add(this.mapper.fromSchema(schemaDoc));
        }
        if (StringUtils.contains((CharSequence)facetInfo, "cache.empty=true")) {
            this.cacheResultsAndEmptyResources(queryInSchema, returnDocs);
        }
        return returnDocs;
    }

    private void cacheResultsAndEmptyResources(String query, List<Map<String, Object>> results) {
        if (query == null) {
            return;
        }
        HashMap<String, Map> docsToCache = new HashMap<String, Map>();
        String[] tokens = StringUtils.split(query);
        for (String str : tokens) {
            String resourcePath = this.resourceFromQuery(str, AbstractSchemaMapper.getSchemaProviderIdKey());
            if (!StringUtils.isNotEmpty(resourcePath)) continue;
            docsToCache.put(resourcePath, Collections.emptyMap());
        }
        for (Map map : results) {
            String key = (String)map.get(AbstractSchemaMapper.getSocoKey());
            if (key == null) continue;
            docsToCache.put(key, map);
        }
        for (Map.Entry entry : docsToCache.entrySet()) {
            this.documentCache.put(entry.getKey(), this.documentCache.createEntry((Map)entry.getValue(), Collections.<String, Object>emptyMap()));
            LOGGER.debug("\nCaching doc done in a query {}", (Object)entry);
        }
    }

    private List<Map<String, Object>> facetedSearch(String facetInfo, String queryInSchema) throws IOException {
        if (this.noConfig()) {
            return Collections.emptyList();
        }
        boolean isPivot = false;
        ArrayList<String> facetFields = new ArrayList<String>();
        ArrayList<String> pivotFields = new ArrayList<String>();
        String numRows = null;
        String mincount = null;
        ArrayList<String> commands = new ArrayList<String>(Arrays.asList(StringUtils.split(facetInfo, "&")));
        Object[] pivot = null;
        for (String command : commands) {
            if (StringUtils.equals(command, "facet=true")) continue;
            if (StringUtils.startsWith(command, "facet.field=")) {
                String facet = StringUtils.removeStart(command, "facet.field=");
                facetFields.add(this.mapper.toSchemaKey(StringUtils.remove(facet, "\"")));
                continue;
            }
            if (StringUtils.startsWith(command, "facet.pivot=")) {
                isPivot = true;
                pivot = StringUtils.split(StringUtils.removeStart(command, "facet.pivot="), ',');
                for (int i = 0; i < pivot.length; ++i) {
                    pivot[i] = this.mapper.toSchemaKey(StringUtils.remove((String)pivot[i], "\""));
                }
                pivotFields.add(StringUtils.join(pivot, ','));
                continue;
            }
            if (StringUtils.startsWith(command, "rows=")) {
                numRows = StringUtils.removeStart(command, "rows=");
                continue;
            }
            if (!StringUtils.startsWith(command, "facet.mincount=")) continue;
            mincount = StringUtils.removeStart(command, "facet.mincount=");
        }
        FacetResults results = this.dsClient.facetedSearch(queryInSchema, facetFields, pivotFields, numRows, mincount, isPivot);
        if (results == null) {
            return Collections.emptyList();
        }
        if (StringUtils.contains((CharSequence)facetInfo, "cache.empty=true")) {
            this.cacheTallyFacetPivotResources(queryInSchema, results.getPivotAggregation(), (String[])pivot);
        }
        ArrayList<Map<String, Object>> unmappedDocs = new ArrayList<Map<String, Object>>(results.getDocs().size());
        for (Map<String, Object> schemaDoc : results.getDocs()) {
            unmappedDocs.add(this.mapper.fromSchema(schemaDoc));
        }
        return unmappedDocs;
    }

    private void cacheTallyFacetPivotResources(String query, Map<String, Object> pivotResults, String[] pivotFields) {
        String[] tokens;
        if (query == null || pivotFields == null) {
            return;
        }
        ArrayList<String> cacheFields = new ArrayList<String>();
        for (String pivotField : pivotFields) {
            if (AbstractSchemaMapper.getSchemaParentIdKey().equals(pivotField)) continue;
            cacheFields.add(this.mapper.fromSchemaKey(pivotField) + ":0");
        }
        if (cacheFields.size() != 1) {
            return;
        }
        for (String str : tokens = StringUtils.split(query)) {
            CacheEntry<Map<String, Map<String, Integer>>> entry;
            String parentPath = this.resourceFromQuery(str, AbstractSchemaMapper.getSchemaParentIdKey());
            if (!StringUtils.isNotEmpty(parentPath)) continue;
            Map result = (Map)pivotResults.get(parentPath);
            if (result == null) {
                result = Collections.emptyMap();
            }
            Map<Object, Map<Object, Object>> cacheValue = (entry = this.facetCache.get(parentPath)) != null && entry.get() != null ? entry.get() : new HashMap();
            cacheValue.put(cacheFields.get(0), result);
            this.facetCache.put(parentPath, new CacheEntry(cacheValue));
            LOGGER.debug("tallycount stored in cache: {}", (Object)parentPath);
        }
    }

    private String resourceFromQuery(String query, String property) {
        if (query == null) {
            return null;
        }
        return query.replace("\"", "").replace(property + ":", "");
    }

    @Override
    public Iterator<Resource> findResources(ResourceResolver resourceResolver, String queryString, String language) {
        List<Map<String, Object>> docs;
        try {
            docs = this.searchDocuments(queryString);
        }
        catch (IOException e) {
            throw new SlingIOException(e);
        }
        if (docs.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        ArrayList<MapResourceImpl> resources = new ArrayList<MapResourceImpl>();
        for (Map<String, Object> doc : docs) {
            MapResourceImpl res = new MapResourceImpl(resourceResolver, this, (String)doc.get(AbstractSchemaMapper.getSocoKey()), doc, false);
            if (res.getPath() != null && !SocialResourceUtils.checkPermission(resourceResolver, this.getJcrAclPath(res.getPath()), "read").booleanValue()) continue;
            resources.add(res);
        }
        return resources.iterator();
    }

    @Override
    public Iterator<ValueMap> queryResources(ResourceResolver resourceResolver, String query, String language) {
        return null;
    }

    @Override
    public void update(Resource resource) {
        if (!SocialResourceUtils.checkPermission(resource.getResourceResolver(), this.getJcrAclPath(resource.getPath()), "set_property").booleanValue()) {
            LOGGER.error("Not allowed to update resource at: {}", (Object)resource.getPath());
            return;
        }
        String path = resource.getPath();
        if (!this.commandsQueue.containsKey(path)) {
            this.commandsQueue.put(path, new CommandResource(path, 2, (MapResource)resource));
        }
    }

    private boolean isAttachment(String resourcePath) {
        if (resourcePath.startsWith(this.providerBase)) {
            if (resourcePath.length() <= this.providerBase.length() + 1) {
                return false;
            }
            String info = resourcePath.substring(this.providerBase.length() + 1);
            int slashPos = info.indexOf(47);
            if (slashPos != -1) {
                return ATTACHMENT.equals(info.substring(0, slashPos));
            }
        }
        return false;
    }

    private String[] getPathSuffix(String resourcePath) {
        if (resourcePath.startsWith(this.providerBase)) {
            if (resourcePath.length() <= this.providerBase.length() + 1) {
                return new String[0];
            }
            String info = resourcePath.substring(this.providerBase.length() + 1);
            int slashPos = info.indexOf(47);
            if (slashPos != -1) {
                return new String[]{info.substring(0, slashPos), info.substring(slashPos + 1)};
            }
        }
        return new String[0];
    }

    @Deprecated
    public void setCloudConfig(Configuration cloudConfig) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deprecated setCloudConfig called.");
            LOGGER.debug("StackTrace: ", new Throwable("Deprecated setCloudConfig"));
        }
        if (this.configSet) {
            return;
        }
        String asiPath = cloudConfig.get(CC_ASIPATH, null);
        String hostUrl = cloudConfig.get(CC_HOST_URL, null);
        String reportSuite = cloudConfig.get(CC_REPORT_SUITE, null);
        String consumerKey = cloudConfig.get(CC_CONSUMER_KEY, null);
        String secretKey = cloudConfig.get(CC_SECRET_KEY, null);
        ValueMapDecorator vm = new ValueMapDecorator(new HashMap<String, Object>());
        vm.put(CC_ASIPATH, asiPath);
        vm.put(CC_HOST_URL, hostUrl);
        vm.put(CC_REPORT_SUITE, reportSuite);
        vm.put(CC_CONSUMER_KEY, consumerKey);
        vm.put(CC_CONSUMER_KEY, secretKey);
        try {
            this.setConfig(this.srpConfigFactory.createConfiguration(vm));
        }
        catch (SRPConfigurationError e) {
            LOGGER.error("Could not configure the provider: ", e);
        }
    }

    @Override
    public void setConfig(SocialResourceConfiguration socialConfiguration) {
        if (this.configSet) {
            return;
        }
        if (socialConfiguration instanceof ASRPConfiguration) {
            ASRPConfiguration asrpConfig = (ASRPConfiguration)socialConfiguration;
            this.mapper.setReportSuite(asrpConfig.getReportSuite());
        } else if (socialConfiguration instanceof MSRPConfiguration) {
            MSRPConfiguration msrpConfig = (MSRPConfiguration)socialConfiguration;
            this.mapper.setReportSuite(msrpConfig.getTenantId());
        } else if (socialConfiguration instanceof DSRPConfiguration) {
            DSRPConfiguration dsrpConfig = (DSRPConfiguration)socialConfiguration;
            this.mapper.setReportSuite(dsrpConfig.getTenantId());
        }
        this.dsClient.setConfiguration(socialConfiguration);
        this.configSet = true;
    }

    @Override
    public String getASIPath() {
        return this.providerBase;
    }

    @Override
    public Iterator<Resource> getMLTResults(ResourceResolver resolver, String query, String statusFilter, String resourceTypeFilter, String componentFilter, String[] mltFields, int maxResults, int minTermFreq, int minDocFreq) {
        throw new UnsupportedOperationException("getMLTResults is not currently implemented");
    }

    public String getJcrAclPath(String path) {
        return MapResourceImpl.getAclPathGivenBase(path, this.providerBase);
    }

    private String getSolrStatusQuery(String status) {
        if (FIELD_STATE_APPROVED.equals(status)) {
            return APPROVED_STRING;
        }
        if (FIELD_STATE_PENDING.equals(status)) {
            return PENDING_STRING;
        }
        if (FIELD_STATE_DENIED.equals(status)) {
            return DENIED_STRING;
        }
        if (FIELD_STATE_SPAM.equals(status)) {
            return DENIED_STRING;
        }
        return null;
    }

    private String convertStatusFilter(String statusFilter) {
        if (statusFilter == null) {
            return null;
        }
        String[] pieces = statusFilter.split(":");
        if (pieces.length != 2) {
            return null;
        }
        return this.getSolrStatusQuery(pieces[1].trim());
    }

    public static String convertResourceTypeFilter(String resourceTypeFilter) {
        if (resourceTypeFilter == null) {
            return null;
        }
        String filter = resourceTypeFilter;
        if (!resourceTypeFilter.startsWith("(")) {
            filter = "(" + resourceTypeFilter + ")";
        }
        String replaced = filter;
        Pattern pattern = Pattern.compile(SINGLE_AND);
        Matcher matcher = pattern.matcher(filter);
        if (matcher.find()) {
            replaced = matcher.replaceAll("\\(*$1*$2\\)");
        } else {
            pattern = Pattern.compile(SINGLE_OR);
            matcher = pattern.matcher(filter);
            if (matcher.find()) {
                replaced = matcher.replaceAll("\\(*$1 OR *$2\\)");
            } else {
                pattern = Pattern.compile(AND_PLUS_OR);
                matcher = pattern.matcher(filter);
                if (matcher.find()) {
                    replaced = matcher.replaceAll("\\(\\(*$2*$3\\) OR \\(*$5*$6\\)\\)");
                }
            }
        }
        return replaced;
    }

    @Override
    public Iterator<Resource> getMLTResults(ResourceResolver resolver, String query, String statusFilter, String resourceTypeFilter, String componentFilter, String mltField, int maxResults, int minTermFreq, int minDocFreq) {
        List<Map<String, Object>> docs;
        if (this.noConfig()) {
            return Collections.emptyList().iterator();
        }
        try {
            docs = this.dsClient.getMLTResults(query, this.convertStatusFilter(statusFilter), UGCCResourceProvider.convertResourceTypeFilter(resourceTypeFilter), componentFilter, this.mapper.toSchemaKeys(mltField), maxResults, minTermFreq, minDocFreq);
        }
        catch (IOException e) {
            throw new SlingIOException(e);
        }
        if (docs.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        ArrayList<MapResourceImpl> resources = new ArrayList<MapResourceImpl>();
        for (Map<String, Object> document : docs) {
            Map<String, Object> mappedDoc = this.mapper.fromSchema(document);
            this.documentCache.put((String)mappedDoc.get(AbstractSchemaMapper.getSocoKey()), this.documentCache.createEntry(mappedDoc, Collections.<String, Object>emptyMap()));
            if (!SocialResourceUtils.checkPermission(resolver, this.getJcrAclPath((String)mappedDoc.get(AbstractSchemaMapper.getSocoKey())), "read").booleanValue()) continue;
            resources.add(new MapResourceImpl(resolver, this, (String)mappedDoc.get(AbstractSchemaMapper.getSocoKey()), mappedDoc, false));
        }
        return resources.iterator();
    }

    @Override
    public SocialResourceSearchResult<Resource> find(ResourceResolver resolver, String component, String luceneQuery, List<SearchSortField> sortFields, int offset, int limit, boolean requiresTotal) {
        return this.find(resolver, component, luceneQuery, sortFields, offset, limit, requiresTotal, null, null);
    }

    @Override
    public SocialResourceSearchResult<Resource> find(ResourceResolver resolver, String component, String luceneQuery, List<SearchSortField> sortFields, int offset, int limit, boolean requiresTotal, String fieldLanguage, Map<String, Object> signals) {
        SocialResourceSearchResult<Map<String, Object>> docs;
        if (this.noConfig()) {
            return new SocialResourceSearchResult<Resource>();
        }
        LOGGER.debug("AS side of SocialResourceSearchResult find Component: {} query: {}", (Object)component, (Object)luceneQuery);
        ArrayList<SearchSortField> mappedSortFields = new ArrayList<SearchSortField>();
        if (sortFields.size() > 0) {
            for (SearchSortField sortField : sortFields) {
                String sortProperty = sortField.getPropertyName();
                String mappedName = this.mapper.toSchemaKey(sortProperty);
                mappedSortFields.add(new SearchSortField(mappedName, sortField.isAscending()));
            }
        }
        LuceneToSolr l2s = new LuceneToSolr(this.mapper, luceneQuery);
        String solrQueryString = l2s.getSolrQuery();
        try {
            docs = this.dsClient.find(component, solrQueryString, mappedSortFields, offset, limit, signals);
        }
        catch (IOException e) {
            throw new SlingIOException(e);
        }
        SocialResourceSearchResult<Resource> searchResult = new SocialResourceSearchResult<Resource>();
        for (Map map : docs) {
            Map<String, Object> mappedDocument = this.mapper.fromSchema(map);
            this.documentCache.put((String)mappedDocument.get(AbstractSchemaMapper.getSocoKey()), this.documentCache.createEntry(mappedDocument, Collections.<String, Object>emptyMap()));
            if (!SocialResourceUtils.checkPermission(resolver, this.getJcrAclPath((String)mappedDocument.get(AbstractSchemaMapper.getSocoKey())), "read").booleanValue()) continue;
            searchResult.add(new MapResourceImpl(resolver, this, (String)mappedDocument.get(AbstractSchemaMapper.getSocoKey()), mappedDocument, false));
        }
        searchResult.setNumFound(docs.getNumFound());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AS side of SocialResourceSearchResult find.  Num Solr hits {}", (Object)docs.getNumFound());
        }
        return searchResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SocialResourceSearchResult<Map<String, Object>> findFacets(ResourceResolver resolver, List<String> parentFilter, List<String> fieldNames, List<FacetRangeField> facetRanges, String scoredQueryString, int maxFacetCount, List<SearchSortField> sortFields, int offset, int pageSize) {
        if (this.noConfig()) {
            return new SocialResourceSearchResult<Map<String, Object>>();
        }
        String scoredQueryInSchema = this.parseQuery(scoredQueryString);
        if (null == scoredQueryInSchema) {
            return new SocialResourceSearchResult<Map<String, Object>>();
        }
        ArrayList<String> pathFilter = new ArrayList<String>();
        ArrayList<String> pathExclusions = new ArrayList<String>();
        InternalSocialResourceUtilities isru = resolver.adaptTo(InternalSocialResourceUtilities.class);
        SocialResourceUtilities sru = resolver.adaptTo(SocialResourceUtilities.class);
        if (null != parentFilter && !parentFilter.isEmpty()) {
            Resource root = null;
            for (String string : parentFilter) {
                void var17_18;
                if (!string.startsWith(this.getASIPath())) {
                    root = resolver.getResource(string);
                    String string2 = sru.resourceToUGCStoragePath(root);
                } else {
                    root = resolver.getResource(sru.ugcToResourcePath(string));
                }
                if (null == root || root instanceof NonExistingResource) {
                    LOGGER.warn("attempted to search a non-existing resource path");
                    continue;
                }
                if (!SocialResourceUtils.checkPermission(resolver, (String)var17_18, "read").booleanValue()) continue;
                pathFilter.add((String)var17_18);
                List<String> exc = isru.getUnreadableDescendants(resolver, root, Collections.<Resource>emptyList());
                pathExclusions.addAll(exc);
            }
        } else {
            LOGGER.error("attempted to search without any parent paths");
            return new SocialResourceSearchResult<Map<String, Object>>();
        }
        if (pathFilter.isEmpty()) {
            return new SocialResourceSearchResult<Map<String, Object>>();
        }
        Collections.sort(pathFilter);
        if (!pathExclusions.isEmpty()) {
            Collections.sort(pathExclusions);
        }
        StringBuilder baseKey = new StringBuilder("q=" + scoredQueryString.replaceAll("&", "&amp;"));
        baseKey.append("&in=");
        boolean first = true;
        for (String path : pathFilter) {
            if (first) {
                first = false;
            } else {
                baseKey.append(",");
            }
            baseKey.append(path.replaceAll("&", "&amp;"));
        }
        if (!pathExclusions.isEmpty()) {
            first = true;
            baseKey.append("&notIn=");
            for (String path : pathExclusions) {
                if (first) {
                    first = false;
                } else {
                    baseKey.append(",");
                }
                baseKey.append(path.replaceAll("&", "&amp;"));
            }
        }
        String string = baseKey.toString();
        Map<String, Map<String, Integer>> fromCache = null;
        if (this.facetCache.get(string) != null) {
            fromCache = this.facetCache.get(string).get();
        }
        LinkedHashMap<String, Map<String, Integer>> unmappedCountResult = new LinkedHashMap<String, Map<String, Integer>>();
        ArrayList<String> mappedCountFields = new ArrayList<String>();
        if (null != fieldNames && !fieldNames.isEmpty()) {
            for (String fieldName : fieldNames) {
                if (fromCache != null && fromCache.containsKey(fieldName)) {
                    unmappedCountResult.put(fieldName, fromCache.get(fieldName));
                    continue;
                }
                mappedCountFields.add(this.mapper.toSchemaKey(fieldName));
            }
        }
        LinkedHashMap<String, Map<String, Integer>> unmappedRangeResult = new LinkedHashMap<String, Map<String, Integer>>();
        ArrayList<FacetRangeField> mappedRangeFields = new ArrayList<FacetRangeField>();
        if (null != facetRanges && !facetRanges.isEmpty()) {
            for (FacetRangeField rangeField : facetRanges) {
                void var27_39;
                String key = this.facetRangeFieldHash(rangeField);
                if (fromCache != null && fromCache.containsKey(key)) {
                    unmappedRangeResult.put(rangeField.getFieldName(), fromCache.get(key));
                    continue;
                }
                String string3 = this.mapper.toSchemaKey(rangeField.getFieldName());
                if (rangeField.getIsDateRange()) {
                    if (rangeField instanceof IntervalFacetRangeField) {
                        IntervalFacetRangeField intervalFacetRangeField = new IntervalFacetRangeField(string3, rangeField.getStartDate(), rangeField.getEndDate(), ((IntervalFacetRangeField)rangeField).getGaps());
                    } else {
                        FacetRangeField facetRangeField = new FacetRangeField(string3, rangeField.getStartDate(), rangeField.getEndDate(), rangeField.getDateGap());
                    }
                } else {
                    FacetRangeField facetRangeField = new FacetRangeField(string3, rangeField.getStartValue(), rangeField.getEndValue(), rangeField.getGapValue());
                }
                mappedRangeFields.add((FacetRangeField)var27_39);
            }
        }
        SocialResourceSearchResult<Map<String, Object>> searchResult = new SocialResourceSearchResult<Map<String, Object>>();
        ArrayList<SearchSortField> sortFieldsInSchema = new ArrayList<SearchSortField>();
        if (null != sortFields && sortFields.size() > 0) {
            for (SearchSortField searchSortField : sortFields) {
                sortFieldsInSchema.add(new SearchSortField(this.mapper.toSchemaKey(searchSortField.getPropertyName()), searchSortField.isAscending()));
            }
        }
        try {
            SocialResourceSearchResult<Map<String, Object>> result = this.dsClient.findFacets(pathFilter, pathExclusions, mappedCountFields, mappedRangeFields, scoredQueryInSchema, maxFacetCount, sortFieldsInSchema, offset, pageSize);
            for (Map map : result) {
                Map<String, Object> unmappedDocument = this.mapper.fromSchema(map);
                this.documentCache.put((String)unmappedDocument.get(AbstractSchemaMapper.getSocoKey()), this.documentCache.createEntry(unmappedDocument, Collections.<String, Object>emptyMap()));
                searchResult.add(unmappedDocument);
            }
            FacetSearchResult facetSearchResult = result.getFacetSearchResult();
            if (!mappedCountFields.isEmpty()) {
                Map<String, Map<String, Integer>> map = facetSearchResult.getCountResult();
                for (String mappedFacetField : map.keySet()) {
                    unmappedCountResult.put(this.mapper.fromSchemaKey(mappedFacetField), map.get(mappedFacetField));
                }
            }
            if (!mappedRangeFields.isEmpty()) {
                Map<String, Map<String, Integer>> map = facetSearchResult.getRangeResult();
                for (String mappedFacetField : map.keySet()) {
                    unmappedRangeResult.put(this.mapper.fromSchemaKey(mappedFacetField), map.get(mappedFacetField));
                }
            }
            searchResult.setFacetSearchResult(new FacetSearchResult(unmappedCountResult, unmappedRangeResult));
            searchResult.setNumFound(result.getNumFound());
            return searchResult;
        }
        catch (IOException e) {
            throw new SlingIOException(e);
        }
    }

    @Override
    public Map<String, Map<String, Integer>> findFacets(ResourceResolver resolver, List<String> fieldNames, String resourceTypeFilter, String componentFilter, int count) {
        return this.findFacets(resolver, fieldNames, resourceTypeFilter, componentFilter, count, false);
    }

    @Override
    public Map<String, Map<String, Integer>> findFacets(ResourceResolver resolver, List<String> fieldNames, String resourceTypeFilter, String componentFilter, int count, boolean visibleOnly) {
        return this.findFacets(resolver, fieldNames, resourceTypeFilter, componentFilter, count, visibleOnly, false);
    }

    @Override
    public Map<String, Map<String, Integer>> findFacets(ResourceResolver resolver, List<String> fieldNames, String resourceTypeFilter, String componentFilter, int count, boolean visibleOnly, boolean includeChildren) {
        FacetSearchResult facets = this.findFacets(resolver, fieldNames, Collections.<FacetRangeField>emptyList(), resourceTypeFilter, componentFilter, count, visibleOnly, includeChildren);
        return facets.getCountResult();
    }

    @Override
    public Map<String, Map<String, Integer>> findFacetRanges(ResourceResolver resolver, List<FacetRangeField> rangeFields, String resourceTypeFilter, String componentFilter, int count) {
        return this.findFacetRanges(resolver, rangeFields, resourceTypeFilter, componentFilter, count, false);
    }

    @Override
    public Map<String, Map<String, Integer>> findFacetRanges(ResourceResolver resolver, List<FacetRangeField> rangeFields, String resourceTypeFilter, String componentFilter, int count, boolean visibleOnly) {
        FacetSearchResult facets = this.findFacets(resolver, Collections.<String>emptyList(), rangeFields, resourceTypeFilter, componentFilter, count, visibleOnly);
        return facets.getRangeResult();
    }

    @Override
    public FacetSearchResult findFacets(ResourceResolver resolver, List<String> countFields, List<FacetRangeField> rangeFields, String resourceTypeFilter, String componentFilter, int count) {
        return this.findFacets(resolver, countFields, rangeFields, resourceTypeFilter, componentFilter, count, false);
    }

    @Override
    public FacetSearchResult findFacets(ResourceResolver resolver, List<String> countFields, List<FacetRangeField> rangeFields, String resourceTypeFilter, String componentFilter, int count, boolean visibleOnly) {
        return this.findFacets(resolver, countFields, rangeFields, resourceTypeFilter, componentFilter, count, visibleOnly, false);
    }

    @Override
    public FacetSearchResult findFacets(ResourceResolver resolver, List<String> countFields, List<FacetRangeField> rangeFields, String resourceTypeFilter, String componentFilter, int count, boolean visibleOnly, boolean includeChidren) {
        String facetCacheKey;
        if (this.noConfig()) {
            return new FacetSearchResult();
        }
        Map<String, Map<String, Integer>> fromCache = null;
        if (componentFilter != null) {
            facetCacheKey = resourceTypeFilter != null ? componentFilter + ":" + resourceTypeFilter : componentFilter;
            if (this.facetCache.get(facetCacheKey) != null) {
                fromCache = this.facetCache.get(facetCacheKey).get();
            }
        } else {
            throw new SlingIOException(new IOException("componentFilter not specified for faceted search"));
        }
        String pathToCheck = componentFilter.startsWith(this.getASIPath()) ? componentFilter : this.getASIPath() + componentFilter;
        if (!SocialResourceUtils.checkPermission(resolver, pathToCheck, "read").booleanValue()) {
            return new FacetSearchResult();
        }
        boolean doSearch = false;
        LinkedHashMap<String, Map<String, Integer>> unmappedCountResult = new LinkedHashMap<String, Map<String, Integer>>();
        ArrayList<String> mappedCountFields = new ArrayList<String>();
        for (String fieldName : countFields) {
            Object key;
            Object object = key = visibleOnly ? fieldName + ":1" : fieldName + ":0";
            if (fromCache != null && fromCache.containsKey(key)) {
                unmappedCountResult.put(fieldName, fromCache.get(key));
                continue;
            }
            mappedCountFields.add(this.mapper.toSchemaKey(fieldName));
            doSearch = true;
        }
        LinkedHashMap<String, Map<String, Integer>> unmappedRangeResult = new LinkedHashMap<String, Map<String, Integer>>();
        ArrayList<FacetRangeField> mappedRangeFields = new ArrayList<FacetRangeField>();
        for (FacetRangeField rangeField : rangeFields) {
            String string;
            String facetRangeHash = this.facetRangeFieldHash(rangeField);
            String string2 = string = visibleOnly ? (String)facetRangeHash + ":1" : (String)facetRangeHash + ":0";
            if (fromCache != null && fromCache.containsKey(string)) {
                unmappedRangeResult.put(rangeField.getFieldName(), fromCache.get(string));
                continue;
            }
            doSearch = true;
            String string3 = this.mapper.toSchemaKey(rangeField.getFieldName());
            FacetRangeField mappedField = rangeField.getIsDateRange() ? (rangeField instanceof IntervalFacetRangeField ? new IntervalFacetRangeField(string3, rangeField.getStartDate(), rangeField.getEndDate(), ((IntervalFacetRangeField)rangeField).getGaps()) : new FacetRangeField(string3, rangeField.getStartDate(), rangeField.getEndDate(), rangeField.getDateGap())) : new FacetRangeField(string3, rangeField.getStartValue(), rangeField.getEndValue(), rangeField.getGapValue());
            mappedRangeFields.add(mappedField);
        }
        FacetSearchResult searchResult = null;
        try {
            if (doSearch) {
                searchResult = this.dsClient.findFacets(mappedCountFields, mappedRangeFields, resourceTypeFilter, componentFilter, count, visibleOnly, includeChidren);
                Map<String, Map<String, Integer>> countResult = searchResult.getCountResult();
                for (Map.Entry entry : countResult.entrySet()) {
                    String string = this.mapper.fromSchemaKey((String)entry.getKey());
                    unmappedCountResult.put(string, (Map<String, Integer>)entry.getValue());
                }
                Map<String, Map<String, Integer>> rangeResult = searchResult.getRangeResult();
                for (Map.Entry<String, Map<String, Integer>> entry : rangeResult.entrySet()) {
                    String unmappedName = this.mapper.fromSchemaKey(entry.getKey());
                    unmappedRangeResult.put(unmappedName, entry.getValue());
                }
                HashMap hashMap = new HashMap();
                for (FacetRangeField rangeField : rangeFields) {
                    String facetRangeHash = this.facetRangeFieldHash(rangeField);
                    String key = visibleOnly ? facetRangeHash + ":1" : facetRangeHash + ":0";
                    hashMap.put(key, unmappedRangeResult.get(rangeField.getFieldName()));
                }
                for (String countField : countFields) {
                    String key = visibleOnly ? countField + ":1" : countField + ":0";
                    hashMap.put(key, unmappedCountResult.get(countField));
                }
                this.facetCache.put(facetCacheKey, new CacheEntry(hashMap));
            }
            searchResult = new FacetSearchResult(unmappedCountResult, unmappedRangeResult);
        }
        catch (IOException e) {
            throw new SlingIOException(e);
        }
        return searchResult;
    }

    private void deleteDocumentFromCache(String key) {
        CacheEntry cached = this.documentCache.get(key);
        if (cached != null) {
            Map docCacheEntry = (Map)cached.get();
            if (docCacheEntry != null && docCacheEntry.containsKey(AbstractSchemaMapper.getSocoParentIdKey())) {
                this.removeAllMatchesFromCountCache((String)docCacheEntry.get(AbstractSchemaMapper.getSocoParentIdKey()));
                this.facetCache.remove(docCacheEntry.get(AbstractSchemaMapper.getSocoParentIdKey()));
            }
        } else {
            LOGGER.debug("Did not find key {} in document cache, so did not delete the parent in count cache.", (Object)key);
        }
        this.documentCache.remove(key);
        this.removeAllMatchesFromCountCache(key);
        this.facetCache.remove(key);
    }

    private void removeAllMatchesFromCountCache(String key) {
        ArrayList<List> toRemove = new ArrayList<List>();
        for (List keys : this.allCountCache.keySet()) {
            if (keys.size() <= 0 || !((String)keys.get(0)).equals(key)) continue;
            toRemove.add(keys);
        }
        this.allCountCache.removeAll(toRemove);
        toRemove = new ArrayList();
        for (List keys : this.visibleCountCache.keySet()) {
            if (keys.size() <= 0 || !((String)keys.get(0)).equals(key)) continue;
            toRemove.add(keys);
        }
        this.visibleCountCache.removeAll(toRemove);
    }

    public void clearCache() {
        this.documentCache.clear();
        this.visibleCountCache.clear();
        this.allCountCache.clear();
        this.facetCache.clear();
    }

    @Override
    public void incrementBy(Resource resource, Map<String, Long> incrementMap) throws SlingIOException, PersistenceException {
        MapResourceImpl mapResource;
        ModifiableValueMap map;
        if (!SocialResourceUtils.checkPermission(resource.getResourceResolver(), this.getJcrAclPath(resource.getPath()), "set_property").booleanValue()) {
            LOGGER.error("Not allowed to update resource at: {}", (Object)resource.getPath());
            return;
        }
        boolean inQueue = false;
        CommandResource commandResource = null;
        if (this.commandsQueue.containsKey(resource.getPath())) {
            commandResource = this.commandsQueue.get(resource.getPath());
            if (commandResource.methodType == 3) {
                throw new PersistenceException("attempting to increment a resource that is being deleted - " + resource.getPath());
            }
            map = commandResource.getResource().adaptTo(ModifiableValueMap.class);
            inQueue = true;
        } else {
            map = resource.adaptTo(ModifiableValueMap.class);
        }
        if (map.containsKey("$inc") && map.get("$inc") != null && !(map.get("$inc") instanceof Map)) {
            throw new PersistenceException("The $inc field has already been used by an invalid (non-map) property - " + resource.getPath());
        }
        Map mergedIncrementMap = map.containsKey("$inc") && map.get("$inc") != null ? (Map)map.get("$inc") : new HashMap();
        for (Map.Entry<String, Long> incEntry : incrementMap.entrySet()) {
            String property = incEntry.getKey();
            Long increment = incEntry.getValue();
            if (map.containsKey(property) && !(map.get(property) instanceof Long)) {
                try {
                    Long.parseLong(map.get(property).toString());
                }
                catch (NumberFormatException e) {
                    throw new SlingIOException(new IOException("attempted to increment a non-integer property - " + resource.getPath(), e));
                }
            }
            if (mergedIncrementMap.containsKey(property)) {
                mergedIncrementMap.put(property, (Long)mergedIncrementMap.get(property) + increment);
                continue;
            }
            mergedIncrementMap.put(property, increment);
        }
        map.put("$inc", mergedIncrementMap);
        if (!inQueue) {
            mapResource = new MapResourceImpl(resource.getResourceResolver(), this, resource.getPath(), map, false);
            commandResource = new CommandResource(resource.getPath(), 4, mapResource);
        } else {
            mapResource = new MapResourceImpl(resource.getResourceResolver(), this, resource.getPath(), map, false);
            commandResource = new CommandResource(resource.getPath(), commandResource.methodType, mapResource);
        }
        this.commandsQueue.put(resource.getPath(), commandResource);
    }

    @Override
    public void incrementBy(Resource resource, String property, Long increment) throws SlingIOException, PersistenceException {
        HashMap<String, Long> incrementMap = new HashMap<String, Long>();
        incrementMap.put(property, increment);
        this.incrementBy(resource, incrementMap);
    }

    @Override
    public void increment(Resource resource, String property) throws PersistenceException {
        this.incrementBy(resource, property, 1L);
    }

    @Override
    public void decrement(Resource resource, String property) throws PersistenceException {
        this.incrementBy(resource, property, -1L);
    }

    @Override
    public long getCount(Resource resource, String property) {
        ValueMap map = resource.adaptTo(ValueMap.class);
        if (map.containsKey(property)) {
            Object value = map.get(property);
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
        }
        return 0L;
    }

    @Override
    public List<String> getLanguages() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("SOLRQUERY");
        return result;
    }

    @Override
    public String getContentType() {
        return "cq:Comment";
    }

    @Override
    public ProviderMetaData getMetaData() {
        if (this.metaData == null) {
            boolean bMSRPClient = false;
            if (this.dsClient != null) {
                bMSRPClient = !this.dsClient.getDSClient().equals("ASRP");
            }
            this.metaData = new AbstractProviderMetaData(bMSRPClient){};
        }
        return this.metaData;
    }

    public String facetRangeFieldHash(FacetRangeField rangeField) {
        StringBuilder facetRangeHash = new StringBuilder(rangeField.getFieldName()).append("-");
        if (rangeField.getIsDateRange()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(RANGE_DATE_FORMAT);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String startRange = dateFormat.format(rangeField.getStartDate());
            String endRange = dateFormat.format(rangeField.getEndDate());
            if (rangeField instanceof IntervalFacetRangeField) {
                facetRangeHash.append(startRange).append(endRange).append(StringUtils.join((Object[])((IntervalFacetRangeField)rangeField).getGaps(), ","));
            } else {
                facetRangeHash.append(startRange).append(endRange).append(rangeField.getDateGap());
            }
        } else {
            facetRangeHash.append(rangeField.getStartValue()).append("-").append(rangeField.getEndValue()).append("-").append(rangeField.getGapValue());
        }
        return facetRangeHash.toString();
    }

    @Override
    public Map<String, Resource> getResources(ResourceResolver resolver, List<String> paths) {
        if (this.noConfig()) {
            return Collections.emptyMap();
        }
        ArrayList<String> fetchPaths = new ArrayList<String>();
        HashMap<String, Resource> retVal = new HashMap<String, Resource>(paths.size());
        ArrayList<String> allowedPaths = new ArrayList<String>();
        for (String path : paths) {
            if (!StringUtils.startsWith(path, this.providerBase)) {
                retVal.put(path, new NonExistingResource(resolver, path));
                continue;
            }
            if (!SocialResourceUtils.checkPermission(resolver, this.getJcrAclPath(path), "read").booleanValue()) {
                retVal.put(path, new NonExistingResource(resolver, path));
                continue;
            }
            allowedPaths.add(path);
        }
        for (String path : allowedPaths) {
            Resource pendingRes = this.getPendingResource(resolver, path);
            if (pendingRes != null) {
                retVal.put(path, pendingRes);
                continue;
            }
            CacheEntry cacheVal = this.documentCache.get(path);
            if (cacheVal != null) {
                LOGGER.debug("Got {} from cache.", (Object)path);
                HashMap<String, Object> doc = new HashMap<String, Object>((Map)cacheVal.get());
                retVal.put(path, new MapResourceImpl(resolver, this, path, doc, false));
                continue;
            }
            fetchPaths.add(path);
        }
        if (!fetchPaths.isEmpty()) {
            Map<String, APIResult> results;
            try {
                results = this.dsClient.readDocuments(fetchPaths);
            }
            catch (IOException e) {
                throw new SlingIOException(e);
            }
            this.postProcessDocuments(resolver, results, retVal);
        }
        return retVal;
    }

    private void postProcessDocuments(ResourceResolver resolver, Map<String, APIResult> results, Map<String, Resource> retVal) {
        for (Map.Entry<String, APIResult> result : results.entrySet()) {
            if (result.getValue() instanceof DocumentResult) {
                Map<String, Object> mappedDocument = this.mapper.fromSchema(((DocumentResult)result.getValue()).getDocument());
                this.documentCache.put(result.getKey(), this.documentCache.createEntry(mappedDocument, Collections.<String, Object>emptyMap()));
                if (retVal == null) continue;
                retVal.put(result.getKey(), new MapResourceImpl(resolver, this, result.getKey(), mappedDocument, false));
                continue;
            }
            if (result.getValue() instanceof AttachmentResult) {
                Map<String, Object> mappedAttachment = this.mapper.fromAttachmentSchema(((AttachmentResult)result.getValue()).getAttachment());
                this.documentCache.put(result.getKey(), this.documentCache.createEntry(mappedAttachment, Collections.<String, Object>emptyMap()));
                if (retVal == null) continue;
                retVal.put(result.getKey(), new MapResourceImpl(resolver, this, result.getKey(), mappedAttachment, true));
                continue;
            }
            if (!(result.getValue() instanceof ErrorResult)) continue;
            ErrorResult err = (ErrorResult)result.getValue();
            if (err.getCode() == 100) {
                this.documentCache.put(result.getKey(), this.documentCache.createEntry(Collections.<String, Object>emptyMap(), Collections.<String, Object>emptyMap()));
            } else {
                LOGGER.warn("Could not fetch document {}. Error was {}", (Object)result.getKey(), (Object)err.getCode());
            }
            if (retVal == null) continue;
            retVal.put(result.getKey(), new NonExistingResource(resolver, result.getKey()));
        }
    }

    @Override
    public InputStream getAttachmentInputStream(ResourceResolver resolver, String path) throws IOException {
        if (this.noConfig() || !StringUtils.startsWith(path, this.providerBase) || !SocialResourceUtils.checkPermission(resolver, this.getJcrAclPath(path), "read").booleanValue()) {
            return null;
        }
        return this.dsClient.getAttachmentInputStream(path);
    }

    @Override
    public Resource move(ResourceResolver resolver, String srcAbsPath, String destAbsPath) throws PersistenceException {
        if (!SocialResourceUtils.checkPermission(resolver, this.getJcrAclPath(destAbsPath), "add_node").booleanValue()) {
            LOGGER.error("Not allowed to update resource at: {}", (Object)destAbsPath);
            return null;
        }
        Resource src = resolver.getResource(srcAbsPath);
        if (null == src) {
            throw new PersistenceException("Resource to be moved not found at: " + srcAbsPath);
        }
        Resource parent = resolver.getResource(destAbsPath);
        if (null == parent) {
            throw new PersistenceException("Intended parent of a moved resource not found at: " + destAbsPath);
        }
        Resource newResource = null;
        try {
            newResource = this.copy(resolver, src, parent, null);
            this.delete(resolver, srcAbsPath);
            return newResource;
        }
        catch (PersistenceException e) {
            if (null != newResource) {
                resolver.delete(newResource);
            }
            throw e;
        }
    }

    private Resource copy(ResourceResolver resolver, Resource child, Resource parent, String rootCommentSystem) throws PersistenceException {
        String newPath;
        Map props = child.adaptTo(Map.class);
        String parentPath = parent.getPath();
        props.put(AbstractSchemaMapper.getSocoParentIdKey(), parentPath);
        if (!SocialResourceUtils.isCloudUGC(parentPath)) {
            SocialResourceUtilities socialResourceUtils = child.getResourceResolver().adaptTo(SocialResourceUtilities.class);
            newPath = socialResourceUtils.resourceToUGCStoragePath(parent) + "/" + child.getName();
            rootCommentSystem = parentPath;
            props.put("social:rootCommentSystem", rootCommentSystem);
        } else {
            String cqdata = AbstractSchemaMapper.getSchemaCQData();
            if (child.getName().equals("translation") && props.containsKey(cqdata) && props.get(cqdata) instanceof Map && ((Map)props.get(cqdata)).containsKey("id")) {
                ((Map)props.get(cqdata)).put("id", parentPath);
            }
            newPath = parentPath + "/" + child.getName();
        }
        if (newPath.equals(child.getPath())) {
            throw new PersistenceException("Cannot move item: Origin path and destination path are the same");
        }
        props.put(AbstractSchemaMapper.getSocoKey(), newPath);
        Resource newChild = this.create(resolver, newPath, props);
        if (null == newChild) {
            throw new PersistenceException("Failed to copy resource at " + child.getPath() + " to " + newPath);
        }
        if (props.containsKey("social:attachments")) {
            String[] attachments = (String[])props.get("social:attachments");
            this.moveAttachments(resolver, newChild, attachments, rootCommentSystem, newPath);
        }
        if (child.hasChildren()) {
            try {
                for (Resource grandchild : child.getChildren()) {
                    if (this.isAttachment(grandchild.getPath())) continue;
                    this.copy(resolver, grandchild, newChild, rootCommentSystem);
                }
            }
            catch (PersistenceException e) {
                this.delete(resolver, newPath);
                throw e;
            }
        }
        return newChild;
    }

    private void moveAttachments(ResourceResolver resolver, Resource newChild, String[] attachments, String rootCommentSystem, String newPath) throws PersistenceException {
        ArrayList<String> newAttachments = new ArrayList<String>();
        for (String attachment : attachments) {
            Resource attResource = this.getResource(resolver, attachment);
            if (null == attResource) continue;
            Map mvm = attResource.adaptTo(Map.class);
            if (null != rootCommentSystem) {
                mvm.put("social:rootCommentSystem", rootCommentSystem);
            }
            mvm.put(AbstractSchemaMapper.getSocoParentIdKey(), newPath);
            mvm.put(AbstractSchemaMapper.getSocoKey(), newPath + "/" + attResource.getName());
            try {
                mvm.put("nt:file", this.getAttachmentInputStream(resolver, attachment));
                ((InputStream)mvm.get("nt:file")).reset();
            }
            catch (IOException e) {
                throw new PersistenceException("Could not get attachment input stream", e);
            }
            if (mvm.containsKey("added")) {
                mvm.remove("added");
            }
            Resource newAttResource = this.create(resolver, newPath + "/" + attResource.getName(), mvm);
            newAttachments.add(newAttResource.getPath());
        }
        newChild.adaptTo(ModifiableValueMap.class).put("social:attachments", newAttachments.toArray(attachments));
    }

    private boolean noConfig() {
        if (this.dsClient.isConfigured()) {
            return false;
        }
        LOGGER.warn("SRP being used without configuration.");
        LOGGER.debug("Stack trace:", new RepositoryException(""));
        return true;
    }

    @Override
    public int getCommentIndex(String path, String baseType, ResourceResolver resourceResolver, String commentToCheck, boolean visibleOnly) {
        int index = 0;
        if (!this.noConfig() && SocialResourceUtils.checkPermission(resourceResolver, this.getJcrAclPath(path), "read").booleanValue()) {
            index = this.dsClient.getCommentIndex(AbstractSchemaMapper.getSchemaParentIdKey(), path, commentToCheck, baseType, visibleOnly);
        } else {
            LOGGER.warn("Missing srp client config or persmission not granted. Direct link to comment won't work");
        }
        return index;
    }

    @Override
    public SocialResourceSearchResult<Resource> getCountAndListChildren(String path, String baseType, ResourceResolver resourceResolver, int offset, int size, List<Map.Entry<String, Boolean>> sortBy, boolean visibleOnly) {
        return this.getCountAndListChildren(path, baseType, resourceResolver, offset, size, sortBy, visibleOnly, visibleOnly ? SocialDataService.Counts.VISIBLE_ONLY : SocialDataService.Counts.ALL);
    }

    private SocialResourceSearchResult<Resource> getCountAndListChildren(final String path, final String baseType, ResourceResolver resourceResolver, int offset, int size, List<Map.Entry<String, Boolean>> sortBy, final boolean visibleOnly, SocialDataService.Counts counts) {
        Object cachePaths;
        CacheEntry cacheVal;
        Long cacheCounts;
        if (this.noConfig() || !SocialResourceUtils.checkPermission(resourceResolver, this.getJcrAclPath(path), "read").booleanValue()) {
            return new SocialResourceSearchResult<Resource>();
        }
        final CountCache countCache = counts == SocialDataService.Counts.VISIBLE_ONLY ? this.visibleCountCache : this.allCountCache;
        final ArrayList<String> cacheKey = new ArrayList<String>();
        if (counts != SocialDataService.Counts.NONE) {
            cacheKey.add(path);
            if (StringUtils.isNotEmpty(baseType)) {
                cacheKey.add(baseType);
            }
            CacheEntry cacheEntry = null;
            cacheEntry = countCache.get(cacheKey);
            cacheCounts = cacheEntry != null ? (Long)cacheEntry.get() : Long.valueOf(-1L);
        } else {
            cacheCounts = -1L;
        }
        boolean countCacheHit = cacheCounts != null && cacheCounts >= 0L;
        boolean getChildren = offset >= 0;
        int fetchSize = getChildren ? size : 1;
        ChildCountAndList resourcesFromCache = null;
        String key = null;
        if (getChildren && (cacheVal = this.stringListCache.get(key = this.buildListChildrenCacheKey(path, baseType, offset, size, sortBy, visibleOnly))) != null && (resourcesFromCache = this.childrenListFromCache(resourceResolver, (List<String>)(cachePaths = (List)cacheVal.get()))) != null) {
            LOGGER.debug("listChildren results from cache with parent {}.", (Object)path);
        }
        if (getChildren && resourcesFromCache == null) {
            ArrayList<Map.Entry<String, Boolean>> mappedSortBy = null;
            if (sortBy != null && offset >= 0) {
                mappedSortBy = new ArrayList<Map.Entry<String, Boolean>>(sortBy.size());
                for (Map.Entry entry : sortBy) {
                    mappedSortBy.add(new AbstractMap.SimpleEntry(this.mapper.toSchemaKey((String)entry.getKey()), entry.getValue()));
                }
            }
            try {
                long count;
                SocialDataService.BrowseDocumentsResult result = this.dsClient.browseDocuments(AbstractSchemaMapper.getSchemaParentIdKey(), path, baseType, size, (int)Math.floor((double)offset / (double)fetchSize), mappedSortBy, visibleOnly, countCacheHit ? SocialDataService.Counts.NONE : counts);
                List<Map<String, Object>> list = result != null ? result.getDocuments() : Collections.emptyList();
                resourcesFromCache = this.updateCachesForListChildren(resourceResolver, list, path, key);
                if (result != null && SocialResourcePrefetch.getPrefetches().hasNext()) {
                    Map<String, Map<String, Long>> allBaseTypeCounts = result.getBaseTypeCounts();
                    for (Map.Entry<String, Map<String, Long>> e : allBaseTypeCounts.entrySet()) {
                        String countBaseType = e.getKey();
                        Map<String, Long> baseTypeCounts = e.getValue();
                        for (Map.Entry<String, Long> ce : baseTypeCounts.entrySet()) {
                            String countPath = ce.getKey();
                            Long count2 = ce.getValue();
                            ArrayList<String> countCacheKey = new ArrayList<String>();
                            countCacheKey.add(countPath);
                            if (StringUtils.isNotEmpty(countBaseType)) {
                                countCacheKey.add(countBaseType);
                            }
                            countCache.put(countCacheKey, this.createEntry(count2));
                        }
                    }
                    this.postProcessDocuments(resourceResolver, result.getRelatedDocuments(), null);
                    this.postProcessDocuments(resourceResolver, result.getAttachments(), null);
                }
                if (counts != SocialDataService.Counts.NONE && !countCacheHit && result != null && (count = result.getCount()) >= 0L) {
                    countCache.put(cacheKey, this.createEntry(count));
                    resourcesFromCache.setNumFound(count);
                    return resourcesFromCache;
                }
            }
            catch (IOException e) {
                throw new SlingIOException(e);
            }
        }
        if (resourcesFromCache == null) {
            resourcesFromCache = new ChildCountAndList();
        }
        if (countCacheHit) {
            resourcesFromCache.setNumFound(cacheCounts);
        } else {
            resourcesFromCache.setCountChildren(new Callable<Long>(){

                @Override
                public Long call() {
                    try {
                        long count = UGCCResourceProvider.this.dsClient.countChildren(path, baseType, visibleOnly);
                        countCache.put(cacheKey, UGCCResourceProvider.this.createEntry(count));
                        return count;
                    }
                    catch (IOException ioe) {
                        LOGGER.warn("Count of children of {} on {} failed.", (Object)baseType, (Object)path);
                        return -1L;
                    }
                }
            });
        }
        return resourcesFromCache;
    }

    private ChildCountAndList updateCachesForListChildren(ResourceResolver resourceResolver, List<Map<String, Object>> docs, String path, String key) {
        if (docs.isEmpty()) {
            this.stringListCache.put(key, new CacheEntry(Collections.emptyList()));
            this.updateListChildrenCacheList(path, key);
            return new ChildCountAndList();
        }
        ArrayList<String> children = new ArrayList<String>(docs.size());
        ChildCountAndList resources = new ChildCountAndList();
        for (Map<String, Object> document : docs) {
            Map<String, Object> mappedDocument = this.mapper.fromSchema(document);
            this.documentCache.put((String)mappedDocument.get(AbstractSchemaMapper.getSocoKey()), this.documentCache.createEntry(mappedDocument, Collections.<String, Object>emptyMap()));
            children.add((String)mappedDocument.get(AbstractSchemaMapper.getSocoKey()));
            resources.add(new MapResourceImpl(resourceResolver, this, (String)mappedDocument.get(AbstractSchemaMapper.getSocoKey()), mappedDocument, false));
        }
        this.stringListCache.put(key, new CacheEntry(children));
        this.updateListChildrenCacheList(path, key);
        return resources;
    }

    @Override
    public long countChildren(Resource parent, String baseType, boolean visibleOnly) {
        return this.getCountAndListChildren(parent.getPath(), baseType, parent.getResourceResolver(), -1, 1, null, visibleOnly).getNumFound();
    }

    @Override
    public Iterator<Resource> listChildren(String path, String baseType, ResourceResolver resourceResolver, int offset, int size, List<Map.Entry<String, Boolean>> sortBy, boolean visibleOnly) {
        return this.getCountAndListChildren(path, baseType, resourceResolver, offset, size, sortBy, visibleOnly, SocialDataService.Counts.NONE).iterator();
    }

    static {
        LOGGER = LoggerFactory.getLogger(UGCCResourceProvider.class);
        ROOT_DOC = new HashMap<String, Object>();
        ROOT_DOC.put("jcr:title", "Social Resource Provider Root");
    }

    private class ChildCountAndList
    extends SocialResourceSearchResult<Resource> {
        private static final long serialVersionUID = 1L;
        private Callable<Long> countChildren;

        ChildCountAndList() {
            this.setNumFound(-1L);
        }

        public void setCountChildren(Callable<Long> countChildren) {
            this.countChildren = countChildren;
        }

        @Override
        public long getNumFound() {
            long numFound = super.getNumFound();
            if (numFound < 0L && this.countChildren != null) {
                try {
                    return this.countChildren.call();
                }
                catch (Exception e) {
                    LOGGER.warn("Calling count children failed.", e);
                    return -1L;
                }
            }
            return numFound;
        }
    }
}

