/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.tally.client.api;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.tally.RatingComponent;
import com.adobe.cq.social.tally.client.api.AbstractTally;
import com.adobe.cq.social.tally.client.api.Rating;
import com.adobe.cq.social.tally.client.api.RatingSocialComponent;
import com.adobe.cq.social.tally.client.api.Response;
import com.adobe.cq.social.tally.client.api.ResponseValue;
import com.adobe.cq.social.tally.client.api.TallyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;

public abstract class AbstractRating
extends AbstractTally
implements RatingSocialComponent {
    private RatingComponent rating;
    private String currentUser;
    private List<String[]> ratingResults;
    protected String[] allowedResponses = new String[]{"5.0", "4.0", "3.0", "2.0", "1.0"};

    public AbstractRating(Resource resource) {
        super(resource, null);
        this.initComponent();
    }

    public AbstractRating(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);
        this.initComponent();
    }

    private void initComponent() {
        this.rating = this.getResource().adaptTo(RatingComponent.class);
        this.currentUser = this.getResource().getResourceResolver().getUserID();
        this.tally = this.rating;
    }

    @Override
    public String getName() {
        return this.rating.getName();
    }

    @Override
    public Long getTotalNumberOfResponses() {
        return this.rating.getTotalNumberOfResponses();
    }

    @Override
    public ResponseValue getCurrentUserResponse() throws TallyException {
        try {
            Response resp = this.rating.getUserResponse(this.currentUser);
            if (resp == null) {
                return null;
            }
            return resp.getResponseValue();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public Map<String, Long> getResponseTallies() {
        HashMap<String, Long> local = new HashMap<String, Long>();
        Map responses = this.rating.getResponseTallies();
        for (Map.Entry entry : responses.entrySet()) {
            local.put(((Rating)entry.getKey()).getResponseValue(), entry.getValue());
        }
        return local;
    }

    @Override
    public void addResponse(String value) {
        try {
            this.rating.setUserResponse(this.currentUser, value);
        }
        catch (TallyException tallyException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    public void removeCurrentUserResponse() {
        try {
            this.rating.unsetUserResponse(this.currentUser);
        }
        catch (TallyException tallyException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    public Float getAverageRating() {
        return this.rating.getAverageRating();
    }

    @Override
    public String getFormattedAverageRating() {
        return String.format("%.2f", this.rating.getAverageRating());
    }

    @Override
    public List<String[]> getRatingResults() {
        if (null == this.ratingResults) {
            this.buildRatingResults();
        }
        return this.ratingResults;
    }

    private void buildRatingResults() {
        Map<String, Long> responseTallies = this.getResponseTallies();
        this.ratingResults = new ArrayList<String[]>(this.allowedResponses.length);
        for (String allowedResponse : this.allowedResponses) {
            String[] values = new String[]{"0", "0", "0", allowedResponse.substring(0, allowedResponse.indexOf("."))};
            if (responseTallies.containsKey(allowedResponse) && this.getTotalNumberOfResponses() > 0L) {
                values[0] = Long.toString(responseTallies.get(allowedResponse));
                values[1] = Float.toString(responseTallies.get(allowedResponse).floatValue() / (float)this.getTotalNumberOfResponses().longValue());
                values[2] = Float.toString(responseTallies.get(allowedResponse).floatValue() * 100.0f / (float)this.getTotalNumberOfResponses().longValue());
                this.ratingResults.add(values);
                continue;
            }
            this.ratingResults.add(values);
        }
    }

    @Override
    public boolean getCanUserRespond() {
        return this.rating.canUserRespond();
    }
}

