/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.tally.client.api;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.tally.Poll;
import com.adobe.cq.social.tally.Tally;
import com.adobe.cq.social.tally.Voting;
import com.adobe.cq.social.tally.client.api.Response;
import com.adobe.cq.social.tally.client.api.ResponseValue;
import com.adobe.cq.social.tally.client.api.TallyException;
import com.adobe.cq.social.tally.client.api.TallySocialComponent;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.wcm.api.Page;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTally
extends BaseSocialComponent
implements TallySocialComponent {
    private final Resource resource;
    protected Tally<?> tally;
    protected final String currentUser;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTally.class);

    public AbstractTally(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);
        this.resource = resource;
        ResourceResolver resolver = this.resource.getResourceResolver();
        this.tally = resolver.isResourceType(this.resource, "social/tally/components/poll") ? (Tally)resource.adaptTo(Poll.class) : (resolver.isResourceType(this.resource, "social/tally/components/hbs/voting") ? (Tally)resource.adaptTo(Voting.class) : null);
        this.currentUser = resolver.getUserID();
    }

    @Override
    public String getName() {
        return this.tally.getName();
    }

    @Override
    public Long getTotalNumberOfResponses() {
        return this.tally.getTotalNumberOfResponses();
    }

    @Override
    public ResponseValue getCurrentUserResponse() throws TallyException {
        try {
            if (this.clientUtils.userIsAnonymous()) {
                return null;
            }
            Response<?> resp = this.tally.getUserResponse(this.currentUser);
            if (resp == null) {
                return null;
            }
            return resp.getResponseValue();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public Map<String, Long> getResponseTallies() {
        HashMap<String, Long> local = new HashMap<String, Long>();
        Map<?, Long> responses = this.tally.getResponseTallies();
        for (Map.Entry<?, Long> entry : responses.entrySet()) {
            local.put(((ResponseValue)entry.getKey()).getResponseValue(), entry.getValue());
        }
        return local;
    }

    @Deprecated
    public void addResponse(String value) {
        try {
            this.tally.setUserResponse(this.currentUser, value);
        }
        catch (TallyException tallyException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Deprecated
    public void removeCurrentUserResponse() {
        try {
            this.tally.unsetUserResponse(this.currentUser);
        }
        catch (TallyException tallyException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    public boolean getCanUserRespond() {
        return this.tally.canUserRespond();
    }

    @Override
    public String getFriendlyUrl() {
        SocialUtils socialUtils = this.clientUtils.getSocialUtils();
        if (socialUtils != null) {
            Page page = socialUtils.getContainingPage(this.resource);
            if (page != null) {
                return this.clientUtils.externalLink(page.getPath(), false) + ".html";
            }
            return this.clientUtils.externalLink(this.resource.getPath(), false) + ".html";
        }
        return null;
    }
}

