/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.templates.api;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.adobe.cq.social.templates.api.CommunityTemplate;
import com.adobe.cq.social.templates.api.CommunityTemplateCollection;
import com.adobe.granite.confmgr.Conf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommunityTemplateCollectionImpl
extends BaseSocialComponent
implements CommunityTemplateCollection {
    protected List<CommunityTemplate> communityTemplates = new ArrayList<CommunityTemplate>();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommunityTemplateCollectionImpl.class);

    public AbstractCommunityTemplateCollectionImpl(Resource resource, ClientUtilities clientUtilities) {
        super(resource, clientUtilities);
        this.init(resource, clientUtilities);
    }

    protected void init(Resource resource, ClientUtilities clientUtilities) {
        this.getTemplates(this.getRootPath(resource), clientUtilities);
        if (this.getUserCreatedTemplateLocation(resource) != null) {
            this.getTemplates(this.getUserCreatedTemplateLocation(resource), clientUtilities);
        }
    }

    protected String getRootPath(Resource resource) {
        return "/etc/community/templates";
    }

    protected String getUserCreatedTemplateLocation(Resource resource) {
        return "/etc/community/templates";
    }

    protected String getTemplateResourceType() {
        return "social/console/components/hbs/communitytemplates/communitytemplate";
    }

    protected void getTemplates(String path, ClientUtilities clientUtilities) {
        if (!StringUtils.isEmpty(path) && this.resource != null) {
            Iterator<Resource> resourceIterator = null;
            if (!path.startsWith("/")) {
                Conf confMgr = this.resource.adaptTo(Conf.class);
                List<Resource> list = confMgr.getListResources(path);
                if (list != null) {
                    resourceIterator = list.listIterator();
                }
            } else {
                Resource resource = this.resource.getResourceResolver().getResource(path);
                if (resource != null) {
                    resourceIterator = resource.listChildren();
                }
            }
            if (resourceIterator != null) {
                SocialComponentFactory blueprintSocialFactory = clientUtilities.getSocialComponentFactoryManager().getSocialComponentFactory(this.getTemplateResourceType());
                String templateResourceType = this.getTemplateResourceType();
                while (resourceIterator.hasNext()) {
                    CommunityTemplate template;
                    Resource child = resourceIterator.next();
                    if (!child.isResourceType(templateResourceType) || (template = (CommunityTemplate)blueprintSocialFactory.getSocialComponent(child)) == null) continue;
                    this.communityTemplates.add(template);
                }
            }
        }
    }

    public List getItems() {
        return this.communityTemplates;
    }

    @Override
    public int getTotalSize() {
        return this.communityTemplates.size();
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
    }
}

