/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.tenant.endpoints;

import com.adobe.cq.social.SocialException;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.community.api.CommunityUserGroup;
import com.adobe.cq.social.console.utils.JCRUtils;
import com.adobe.cq.social.console.utils.api.UserUtils;
import com.adobe.cq.social.console.utils.api.internal.PropertiesUtils;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.tenant.api.CommunityTenant;
import com.adobe.cq.social.tenant.endpoints.TenantOperations;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.security.user.UserPropertiesService;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.Replicator;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.tenant.Tenant;
import org.apache.sling.tenant.TenantManager;
import org.apache.sling.tenant.TenantProvider;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractTenantOperationService<T extends OperationExtension, U extends Operation>
extends AbstractOperationService<T, U, CommunityTenant>
implements TenantOperations,
EventListener {
    private static final String TENANT_SERVICE_USER_NON_PRODUCTION = "TENANT-SERVICE-USER-NON-PRODUCTION";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTenantOperationService.class);
    private static final int PARAM_NAME_INDEX = 0;
    private static final int PARAM_CLASS_INDEX = 1;
    private static final int PARAM_REQUIRED_INDEX = 2;
    private static final Object[][] requestParams = new Object[][]{{"tenantId", String.class, Boolean.TRUE}, {"description", String.class, Boolean.FALSE}, {"admin", String[].class, Boolean.TRUE}, {"hostName", String.class, Boolean.TRUE}};
    private static final Map<String, String> NO_RESTRICTIONS = null;
    private static final String CQ_PAGE_TYPE = "cq:Page";
    private static final String NT_SLING_FOLDER = "sling:Folder";
    @Reference
    TenantManager tenantManager;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    UserPropertiesService userPropertiesService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    SocialComponentFactoryManager componentFactoryManager;
    @Reference
    private SlingRepository repository;
    @Reference
    private Replicator replicator;
    @Reference
    UserUtils userUtils;
    @Reference
    ServiceUserWrapper serviceUserWrapper;
    private Session adminSession;
    private ResourceResolver resolver;
    private BundleContext bundleContext;

    @Override
    public CommunityTenant create(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props);
            this.getCustomProperties(request, props, session);
            return this.create(resource, props);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to create community site.", e, 500);
        }
    }

    @Override
    public CommunityTenant create(Resource resource, Map<String, Object> requestParameters) throws OperationException {
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        try {
            U createOperation = this.getCreateOperation();
            this.performBeforeActions(createOperation, session, resource, requestParameters);
            CommunityTenant tenant = this.performCreateOperation(requestParameters, resolver);
            this.performAfterActions(createOperation, session, tenant, requestParameters);
            return tenant;
        }
        catch (OperationException e) {
            this.cleanupFailure(session);
            throw e;
        }
        catch (Exception e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to create community site.", e, 500);
        }
    }

    public void onEvent(EventIterator eventIterator) {
        while (eventIterator.hasNext()) {
            this.processEvent(eventIterator.nextEvent());
        }
    }

    protected void processEvent(Event event) {
        try {
            LOG.info("process tenant creation event at : {}", (Object)event.getPath());
            ResourceResolver resolver = this.getResourceResolver();
            Resource resource = resolver.getResource(event.getPath());
            if (resource != null && resource.isResourceType("social/console/components/hbs/tenants/tenant")) {
                CommunityContext context = this.getContext(resolver, resource.getName());
                UserManager userManager = AccessControlUtil.getUserManager(resolver.adaptTo(Session.class));
                this.setupTenant(context, resolver);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to provess event.", e);
        }
    }

    protected void setupTenant(CommunityContext context, ResourceResolver resolver) {
        try {
            TenantResourceHandler tenantResourceHandler = new TenantResourceHandler(context, resolver);
            tenantResourceHandler.create();
            this.createTenantUserAndGroup(context, null, resolver);
            tenantResourceHandler.setupACL(false);
            Session session = resolver.adaptTo(Session.class);
            session.save();
            HashMap<String, Object> props = new HashMap<String, Object>();
            Node tenantRoot = tenantResourceHandler.getContentNode();
            props.put("tenant.name", context.getTenantId());
            String value = (String)JCRUtils.getValue((String)"description", (Node)tenantRoot);
            if (StringUtils.isNotEmpty(value)) {
                props.put("tenant.description", value);
            }
            if (StringUtils.isNotEmpty(value = (String)JCRUtils.getValue((String)"hostName", (Node)tenantRoot))) {
                props.put("tenant.community.hostname", value);
            }
            tenantResourceHandler.addTenantResourcePaths(props);
            try {
                this.tenantManager.create(context.getTenantId(), props);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Tenant {} already exists", (Object)context.getTenantId());
            }
        }
        catch (RepositoryException e) {
            LOG.error("Failed to create tenant {}", (Object)context.getTenantId(), (Object)e);
        }
        catch (OperationException e) {
            LOG.error("Failed to create tenant {}", (Object)context.getTenantId(), (Object)e);
        }
    }

    protected CommunityTenant performCreateOperation(Map<String, Object> requestParameters, ResourceResolver resolver) throws OperationException {
        String tenantId = (String)requestParameters.get("tenantId");
        Tenant tenant = null;
        if (this.tenantManager instanceof TenantProvider) {
            tenant = ((TenantProvider)((Object)this.tenantManager)).getTenant(tenantId);
        }
        if (tenant == null) {
            Session session = null;
            String hostName = (String)requestParameters.get("hostName");
            if (StringUtils.isEmpty(hostName)) {
                throw new OperationException("Must specifiy a hostname for the tenant", 500);
            }
            try {
                session = resolver.adaptTo(Session.class);
                if (session == null) {
                    throw new OperationException("Failed to create admin session", 500);
                }
                CommunityContext context = this.getContext(resolver, tenantId);
                TenantResourceHandler tenantResourceHandler = new TenantResourceHandler(context, resolver);
                tenantResourceHandler.create();
                this.createTenantUserAndGroup(context, (String[])requestParameters.get("admin"), resolver);
                Node tenantRoot = tenantResourceHandler.getContentNode();
                JcrUtil.setProperty(tenantRoot, "tenant.name", tenantId);
                String value = (String)requestParameters.get("description");
                if (StringUtils.isNotEmpty(value)) {
                    JcrUtil.setProperty(tenantRoot, "tenant.description", value);
                }
                tenantResourceHandler.setupACL(true);
                if (StringUtils.isNotEmpty(value)) {
                    JcrUtil.setProperty(tenantRoot, "tenant.community.hostname", hostName);
                }
                session.save();
                try {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("tenant.name", tenantId);
                    value = (String)JCRUtils.getValue((String)"description", (Node)tenantRoot);
                    if (StringUtils.isNotEmpty(value)) {
                        props.put("tenant.description", value);
                    }
                    if (StringUtils.isNotEmpty(value = (String)JCRUtils.getValue((String)"hostName", (Node)tenantRoot))) {
                        props.put("tenant.community.hostname", value);
                    }
                    tenantResourceHandler.addTenantResourcePaths(props);
                    Tenant newTenant = this.tenantManager.create(tenantId, props);
                    tenantResourceHandler.replicateTenant();
                    Resource tenantResource = resolver.getResource(tenantRoot.getPath());
                    SocialComponentFactory socialFactory = this.componentFactoryManager.getSocialComponentFactory(tenantResource);
                    SocialComponent component = socialFactory.getSocialComponent(tenantResource);
                    return (CommunityTenant)component;
                }
                catch (IllegalArgumentException e) {
                    throw new OperationException("CommunityTenant " + tenantId + " already exists", 400);
                }
            }
            catch (RepositoryException e) {
                LOG.error("failed to create tenant {}", (Object)tenantId, (Object)e);
                throw new OperationException(e, 500);
            }
        }
        throw new OperationException("CommunityTenant " + tenantId + " already exists", 400);
    }

    protected void getDefaultProperties(SlingHttpServletRequest request, Map<String, Object> props) throws RepositoryException, OperationException {
        for (int i = 0; i < requestParams.length; ++i) {
            Object[] params = requestParams[i];
            Class clazz = (Class)params[1];
            String name = (String)params[0];
            if (clazz.isArray()) {
                String[] values = request.getParameterValues(name);
                if (values == null && ((Boolean)params[2]).booleanValue()) {
                    throw new OperationException("Community tenant value '" + name + "' is empty", 400);
                }
                if (clazz != String[].class || values == null) continue;
                props.put(name, values);
                continue;
            }
            String value = request.getParameter(name);
            if (value == null && ((Boolean)params[2]).booleanValue()) {
                throw new OperationException("Community tenant value '" + name + "' is empty", 400);
            }
            if (value == null) continue;
            props.put(name, PropertiesUtils.toObject(value, clazz));
        }
    }

    protected void activate(BundleContext context) {
        LOG.info("AbstractTenantOperationService activate");
        this.bundleContext = context;
        if (this.isPublishMode()) {
            try {
                this.resolver = this.getResourceResolver();
                this.adminSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 1, "/content/sites/tenants", true, null, new String[]{NT_SLING_FOLDER}, true);
            }
            catch (Exception e) {
                throw new SocialException("unable to register session", e);
            }
        }
    }

    protected void deactivate() {
        if (this.resolver != null) {
            this.resolver.close();
        }
        if (this.adminSession != null) {
            this.adminSession.logout();
        }
    }

    protected void getCustomProperties(SlingHttpServletRequest request, Map<String, Object> props, Session session) throws RepositoryException, OperationException {
    }

    protected void getProp(SlingHttpServletRequest request, String key, String defaultValue, Map<String, Object> props) {
        String value = request.getParameter(key);
        props.put(key, StringUtils.isBlank(value) ? "" : value);
    }

    protected Session getAdminSession() throws RepositoryException {
        if (this.adminSession == null) {
            this.adminSession = this.serviceUserWrapper.loginService(this.repository, TENANT_SERVICE_USER_NON_PRODUCTION);
        } else if (!this.adminSession.isLive()) {
            this.adminSession = this.serviceUserWrapper.loginService(this.repository, TENANT_SERVICE_USER_NON_PRODUCTION);
        }
        return this.adminSession;
    }

    protected ResourceResolver getResourceResolver() throws RepositoryException, OperationException {
        if (this.resolver == null || !this.resolver.isLive()) {
            this.adminSession = this.getAdminSession();
            this.resolver = JCRUtils.getResourceResolver((Session)this.adminSession, (ResourceResolverFactory)this.resourceResolverFactory);
        }
        return this.resolver;
    }

    protected abstract U getCreateOperation();

    protected abstract U getDeleteOperation();

    protected abstract U getUpdateOperation();

    private CommunityContext getContext(ResourceResolver resolver, String tenantId) {
        SyntheticResource resource = new SyntheticResource(resolver, "/community/tenants/" + tenantId, "social/console/components/hbs/tenants/tenant");
        return resource.adaptTo(CommunityContext.class);
    }

    private void createTenantUserAndGroup(CommunityContext context, String[] admins, ResourceResolver resolver) throws RepositoryException, OperationException {
        Session session = resolver.adaptTo(Session.class);
        UserManager userManager = ((JackrabbitSession)resolver.adaptTo(Session.class)).getUserManager();
        UserPropertiesManager propManager = this.userPropertiesService.createUserPropertiesManager(resolver);
        Group tenantAdministrators = this.userUtils.getOrCreateCommunityUserGroup(context, CommunityUserGroup.ADMINISTRATOR, userManager);
        Group tenantUsers = this.userUtils.getOrCreateCommunityUserGroup(context, CommunityUserGroup.MEMBER, userManager);
        Group socialAuthorGroup = this.userUtils.getOrCreateSocialAuthorGroup(session, userManager, context.getTenantGroupRootPath());
        socialAuthorGroup.addMember(tenantAdministrators);
        Group communityGroupAdmin = this.userUtils.getOrCreateGroupAdministratorsGroup(context, session, userManager);
        try {
            JCRUtils.setACL((Session)session, (Authorizable)tenantAdministrators, (String)communityGroupAdmin.getPath(), NO_RESTRICTIONS, (boolean)true, (String[])UserUtils.TENANT_ADMINISTRATORS_PRIVELEGES);
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
        if (admins != null) {
            for (int i = 0; i < admins.length; ++i) {
                AdminAccount adminAccount = new AdminAccount(admins[i]);
                User admin = (User)userManager.getAuthorizable(adminAccount.getAdminId());
                if (admin != null) {
                    throw new RepositoryException("User " + adminAccount.getAdminId() + " already existed.");
                }
                admin = this.userUtils.getOrCreateCommunityUser(context, adminAccount.getAdminId(), adminAccount.getPassword(), userManager, propManager);
                tenantAdministrators.addMember(admin);
                tenantUsers.addMember(admin);
            }
        } else {
            this.userUtils.createCommunityUserFolder(session, context);
        }
    }

    private void cleanupFailure(Session session) {
        try {
            session.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.info("Failed to refresh the session", e);
        }
    }

    private boolean isPublishMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("publish");
    }

    protected void bindTenantManager(TenantManager tenantManager) {
        this.tenantManager = tenantManager;
    }

    protected void unbindTenantManager(TenantManager tenantManager) {
        if (this.tenantManager == tenantManager) {
            this.tenantManager = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindUserPropertiesService(UserPropertiesService userPropertiesService) {
        this.userPropertiesService = userPropertiesService;
    }

    protected void unbindUserPropertiesService(UserPropertiesService userPropertiesService) {
        if (this.userPropertiesService == userPropertiesService) {
            this.userPropertiesService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindUserUtils(UserUtils userUtils) {
        this.userUtils = userUtils;
    }

    protected void unbindUserUtils(UserUtils userUtils) {
        if (this.userUtils == userUtils) {
            this.userUtils = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }

    private class TenantResourceHandler {
        private final CommunityContext context;
        private final Session session;
        private final ResourceResolver resolver;
        private Node designsNode;
        private Node contentNode;
        private Node ugcNode;
        private Node tempNode;
        private Node activityStreamNode;
        private boolean hasTenantRoot;

        public TenantResourceHandler(CommunityContext context, ResourceResolver resolver) {
            this.context = context;
            this.session = resolver.adaptTo(Session.class);
            this.resolver = resolver;
        }

        public void create() throws OperationException {
            try {
                this.hasTenantRoot = this.session.itemExists("/content/sites/tenants");
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            String tenantRootPath = this.context.getContentRootPath();
            Node tenantsRoot = this.createTenantsRootContent(this.session);
            this.contentNode = this.createTenantRootContent(this.context, this.session);
            this.designsNode = this.createTenantFolder(this.context.getDesignRootPath(), AbstractTenantOperationService.NT_SLING_FOLDER, this.session);
            this.ugcNode = this.createTenantUGC(this.resolver, tenantRootPath);
            this.tempNode = this.createTenantFolder("/var/tenants", AbstractTenantOperationService.NT_SLING_FOLDER, this.session);
            this.activityStreamNode = this.createActivityStreamRoot(this.session, this.ugcNode);
        }

        public Node getThemeNode() {
            return this.designsNode;
        }

        public Node getUgcNode() {
            return this.ugcNode;
        }

        public Node getContentNode() {
            return this.contentNode;
        }

        public String getThemePath() throws OperationException {
            if (this.getThemeNode() == null) {
                throw new IllegalStateException("The theme node has not been created.");
            }
            try {
                return this.designsNode.getPath();
            }
            catch (RepositoryException e) {
                throw new OperationException("Failed to obtain theme path for tenant " + this.context.getTenantId(), e, 500);
            }
        }

        public String getContentPath() throws OperationException {
            if (this.getContentNode() == null) {
                throw new IllegalStateException("The content node has not been created.");
            }
            try {
                return this.contentNode.getPath();
            }
            catch (RepositoryException e) {
                throw new OperationException("Failed to obtain content path for tenant " + this.context.getTenantId(), e, 500);
            }
        }

        public String getUgcPath() throws OperationException {
            if (this.getUgcNode() == null) {
                throw new IllegalStateException("The ugc node has not been created.");
            }
            try {
                return this.ugcNode.getPath();
            }
            catch (RepositoryException e) {
                throw new OperationException("Failed to obtain UGC path for tenant " + this.context.getTenantId(), e, 500);
            }
        }

        public void setupACL(boolean setupAdminGroup) throws OperationException, RepositoryException {
            if (this.contentNode == null || this.ugcNode == null || this.designsNode == null) {
                throw new IllegalStateException("The resource of this instance has not been created.");
            }
            UserManager userManager = AccessControlUtil.getUserManager(this.session);
            AbstractTenantOperationService.this.userUtils.denyEveryoneAllButReadPrivilege(this.session, userManager, this.getContentPath());
            AbstractTenantOperationService.this.userUtils.denyEveryoneAllButReadPrivilege(this.session, userManager, this.getUgcPath());
            AbstractTenantOperationService.this.userUtils.denyEveryoneAllButReadPrivilege(this.session, userManager, this.getThemePath());
            AbstractTenantOperationService.this.userUtils.allowEveryoneReadProfilePrivilege(this.session, userManager, this.context.getTenantUserRootPath());
            if (setupAdminGroup) {
                try {
                    Group tenantAdministrators = AbstractTenantOperationService.this.userUtils.getOrCreateCommunityUserGroup(this.context, CommunityUserGroup.ADMINISTRATOR, userManager);
                    JCRUtils.setACL((Session)this.session, (Authorizable)tenantAdministrators, (String)this.getContentPath(), (Map)NO_RESTRICTIONS, (boolean)true, (String[])UserUtils.TENANT_ADMINISTRATORS_PRIVELEGES);
                    JCRUtils.setACL((Session)this.session, (Authorizable)tenantAdministrators, (String)this.getUgcPath(), (Map)NO_RESTRICTIONS, (boolean)true, (String[])UserUtils.TENANT_ADMINISTRATORS_PRIVELEGES);
                    JCRUtils.setACL((Session)this.session, (Authorizable)tenantAdministrators, (String)this.getThemePath(), (Map)NO_RESTRICTIONS, (boolean)true, (String[])UserUtils.TENANT_ADMINISTRATORS_PRIVELEGES);
                    JCRUtils.setACL((Session)this.session, (Authorizable)tenantAdministrators, (String)this.context.getUserRootPath(), (Map)NO_RESTRICTIONS, (boolean)true, (String[])UserUtils.TENANT_ADMINISTRATORS_PRIVELEGES);
                    JCRUtils.setACL((Session)this.session, (Authorizable)tenantAdministrators, (String)this.context.getUserGroupRootPath(), (Map)NO_RESTRICTIONS, (boolean)true, (String[])UserUtils.TENANT_ADMINISTRATORS_PRIVELEGES);
                }
                catch (RepositoryException e) {
                    throw new OperationException("Failed to apply acl to tenant admin group ", e, 500);
                }
            }
            try {
                Group tenantUsers = AbstractTenantOperationService.this.userUtils.getOrCreateCommunityUserGroup(this.context, CommunityUserGroup.MEMBER, userManager);
                JCRUtils.setACL((Session)this.session, (Authorizable)tenantUsers, (String)this.getContentPath(), (Map)NO_RESTRICTIONS, (boolean)true, (String[])UserUtils.TENANT_USERS_PRIVELEGES);
                JCRUtils.setACL((Session)this.session, (Authorizable)tenantUsers, (String)this.getUgcPath(), (Map)NO_RESTRICTIONS, (boolean)true, (String[])UserUtils.TENANT_USERS_PRIVELEGES);
            }
            catch (RepositoryException e) {
                throw new OperationException("Failed to apply acl to tenant user group ", e, 500);
            }
        }

        public void addTenantResourcePaths(Map<String, Object> props) throws OperationException {
            props.put("tenant.community.contentpath", this.getContentPath());
            props.put("tenant.community.ugcpath", this.getUgcPath());
            props.put("tenant.community.themepath", this.getThemePath());
            props.put("tenant.community.sitespath", this.context.getSiteThemePath());
        }

        public void replicateTenant() {
            try {
                if (this.hasTenantRoot) {
                    AbstractTenantOperationService.this.replicator.replicate(this.session, ReplicationActionType.ACTIVATE, this.contentNode.getParent().getPath());
                }
                AbstractTenantOperationService.this.replicator.replicate(this.session, ReplicationActionType.ACTIVATE, this.contentNode.getPath());
            }
            catch (Exception e) {
                LOG.error("Failed replicate {}", (Object)this.context.getTenantId(), (Object)e);
            }
        }

        private Node createTenantFolder(String path, String nodeType, Session session) throws OperationException {
            try {
                return JcrUtil.createPath(path, AbstractTenantOperationService.NT_SLING_FOLDER, session);
            }
            catch (RepositoryException e) {
                throw new OperationException("Failed to create tenant folder " + path, e, 500);
            }
        }

        private Node createTenantUGC(ResourceResolver resolver, String contentRootPath) throws OperationException {
            SocialUtils socialUtils = resolver.adaptTo(SocialUtils.class);
            try {
                Resource ugcResource = socialUtils.getUGCResource(resolver.getResource(contentRootPath));
                Session session = resolver.adaptTo(Session.class);
                return session.getNode(ugcResource.getPath());
            }
            catch (PathNotFoundException e) {
                LOG.error("Failed to retrieve ugc node for {}", (Object)contentRootPath, (Object)e);
                throw new OperationException("Failed to create ugc root ", e, 500);
            }
            catch (RepositoryException e) {
                LOG.error("Failed to create UGC root for {}", (Object)contentRootPath, (Object)e);
                throw new OperationException("Failed to create ugc root ", e, 500);
            }
        }

        private Node createActivityStreamRoot(Session session, Node ugcNode) throws OperationException {
            Node as = null;
            try {
                as = JcrUtil.createPath(ugcNode, "activitystreams", false, AbstractTenantOperationService.CQ_PAGE_TYPE, AbstractTenantOperationService.CQ_PAGE_TYPE, session, false);
                JcrUtil.createPath(as, "jcr:content", false, "nt:unstructured", "nt:unstructured", session, false);
                return as;
            }
            catch (RepositoryException e) {
                throw new OperationException("Failed to create tenant activity root node " + this.context.getActivityStreamRootPath(), e, 500);
            }
        }

        private Node createTenantsRootContent(Session session) throws OperationException {
            String tenantsRootPath = "/content/sites/tenants";
            Node root = null;
            try {
                root = JcrUtil.createPath("/content/sites/tenants", AbstractTenantOperationService.NT_SLING_FOLDER, session);
                if (!root.hasProperty("sling:resourceType")) {
                    root.setProperty("sling:resourceType", "social/console/components/hbs/tenants");
                }
                return root;
            }
            catch (RepositoryException e) {
                throw new OperationException("Failed to create tenant root node /content/sites/tenants", e, 500);
            }
        }

        private Node createTenantRootContent(CommunityContext context, Session session) throws OperationException {
            String contentRootPath = context.getContentRootPath();
            Node root = null;
            try {
                root = JcrUtil.createPath(contentRootPath, AbstractTenantOperationService.NT_SLING_FOLDER, session);
                if (!root.hasProperty("sling:resourceType")) {
                    root.setProperty("sling:resourceType", "social/console/components/hbs/tenants/tenant");
                }
                return root;
            }
            catch (RepositoryException e) {
                LOG.error("Failed to create tenant content root path " + contentRootPath, e);
                throw new OperationException("Failed to create tenant root path", e, 500);
            }
        }
    }

    private static class AdminAccount {
        private static final int ADMIN_ACCOUNT_INFO_LENGTH = 2;
        private static final int ADMIN_ID_INDEX = 0;
        private static final int ADMIN_PASSWORD_INDEX = 1;
        private static final String SEPARATOR = ":";
        private static final String ADMIN_DEFAULT_PASSWORD = "admin";
        String[] accountInfo;

        public AdminAccount(String value) throws OperationException {
            this.accountInfo = value.split(SEPARATOR);
        }

        public String getAdminId() {
            return this.accountInfo[0];
        }

        public String getPassword() {
            if (this.accountInfo.length != 2) {
                return ADMIN_DEFAULT_PASSWORD;
            }
            return this.accountInfo[1];
        }
    }
}

