/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.translation;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.srp.SocialResource;
import com.adobe.cq.social.translation.TranslationResults;
import com.adobe.cq.social.translation.TranslationVariables;
import com.adobe.cq.social.translation.UGCTranslationMeta;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.TranslationUpdate;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationManager;
import com.adobe.granite.translation.api.TranslationResult;
import com.adobe.granite.translation.api.TranslationService;
import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.translation.core.MachineTranslationUtil;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TranslationUtil.class);
    public static final String TRANSLATION_NODE_NAME = "translation";
    public static final String LANGUAGE_PROP = "language";
    public static final String AS_LANGUAGE_PROP = "mtlanguage";
    public static final String TRANSLATION_DATE_PROP = "translationDate";
    public static final String LANGUAGE_DETECTED_DATE_PROP = "languageDetectedDate";
    public static final String POST_EDITED_PROP = "postEdited";
    public static final String JCR_CONTENT_STR = "_jcr_content";
    public static final String USER_PROFILE = "profile";
    public static final String USER_PREFERENCES = "preferences";
    public static final String CONTENT_CATEGORY = "general";
    public static final String UGC_WRITER = "ugc-writer";
    public static final String AVAILABLE_LANGUAGES = "availableLanguages";
    public static final String BROWSER_LANGUAGE = "Accept-Language";
    public static final String LANGUAGE_MAPPING_PATH = "/libs/social/translation/languageOpts/languageMapping";
    public static final String DEFAULT_LANGUAGE_CODE = "default";
    public static final String DEFAULT_LANGUAGE_NAME = "Default";
    public static final String LANGUAGE_CODE = "languageCode";
    public static final String LANGUAGE_NAME = "languageName";
    private static final String ALLOW_MC_TRANSLATION = "allowMachineTranslation";
    public static final String REFERER = "referer";
    public static final String CACHE_WHEN_POST = "cache_when_post";
    public static final String CACHE_WHEN_CALL = "cache_when_call";
    public static final String NO_CACHING = "no_caching";
    public static final String SLING_RESOURCETYPE = "sling:resourceType";
    public static final String TRANSLATION_SLING_RESOURCETYPE = "/translation";

    public static String addLanguageCode(Resource resource, Session session, String property, TranslationConstants.ContentType contentType, TranslationManager tm) {
        LOG.trace("In function: addLanguageCode");
        String lanCode = null;
        ValueMap resourceProperties = resource.adaptTo(ModifiableValueMap.class);
        String determineString = null;
        if (property != null) {
            determineString = resourceProperties.get(property, (String)null);
        }
        try {
            if (determineString != null) {
                lanCode = TranslationUtil.getLanguageCode(determineString, contentType, resource, tm);
                if (lanCode != null) {
                    Resource translationResource = TranslationUtil.getTranslationNode(resource, true);
                    if (translationResource != null) {
                        ValueMap translationResourceProperties = translationResource.adaptTo(ModifiableValueMap.class);
                        if (resource instanceof SocialResource) {
                            translationResourceProperties.put(AS_LANGUAGE_PROP, lanCode);
                        } else {
                            translationResourceProperties.put(LANGUAGE_PROP, lanCode);
                        }
                        Resource commentResource = translationResource.getParent();
                        if (commentResource != null && TranslationUtil.isLanguageSupported(commentResource, lanCode)) {
                            ValueMap commentProperties = commentResource.adaptTo(ModifiableValueMap.class);
                            commentProperties.put(AS_LANGUAGE_PROP, lanCode);
                        }
                        translationResource.getResourceResolver().commit();
                    }
                } else {
                    LOG.debug("Either the session or the translation node were null, not saving");
                }
            }
        }
        catch (PersistenceException pe) {
            LOG.error("Error setting language property.", pe);
        }
        return lanCode;
    }

    private static Resource getTranslationNode(Resource resource, boolean bCreate) {
        LOG.trace("In getTranslationNode");
        Resource translationNode = null;
        try {
            if (resource != null && (translationNode = resource.getChild(TRANSLATION_NODE_NAME)) == null && bCreate) {
                LOG.debug("Didn't find Translation node, creating");
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("jcr:primaryType", "sling:Folder");
                ResourceResolver rr = resource.getResourceResolver();
                translationNode = rr.create(resource, TRANSLATION_NODE_NAME, properties);
            }
        }
        catch (Exception ex) {
            LOG.error("Error while getting/creating Translation node.", ex);
        }
        return translationNode;
    }

    public static String getLanguageCode(String content, TranslationConstants.ContentType contentType, Resource resource, TranslationManager tm) {
        LOG.debug("In function: getLanguageCode");
        String lanCode = null;
        try {
            if (tm != null) {
                TranslationService ts = tm.createTranslationService(TranslationUtil.getNonUgcResource(resource));
                if (ts != null) {
                    lanCode = ts.detectLanguage(content, contentType);
                } else {
                    LOG.debug("TranslationService was null for resource: {}", (Object)resource.getPath());
                }
            } else {
                LOG.debug("TranslationManager was null, returning null for detected string");
            }
        }
        catch (TranslationException te) {
            if (te.getErrorCode() == TranslationException.ErrorCode.MISSING_CREDENTIALS) {
                LOG.debug("Applied credentials were null or blank.  The default configuration might be applied");
            }
            LOG.error(te.toString());
        }
        LOG.debug("lanCode: {}", (Object)lanCode);
        return TranslationUtil.changeLanguageCode(lanCode);
    }

    public static Resource getNonUgcResource(Resource resource) {
        Page nonUgcPage;
        LOG.trace("In Function: getNonUgcResource");
        ResourceResolver rr = resource.getResourceResolver();
        SocialUtils socialUtils = rr.adaptTo(SocialUtils.class);
        if (socialUtils != null && (nonUgcPage = socialUtils.getContainingPage(resource)) != null) {
            String resourcePath;
            String nonUgcPath = nonUgcPage.getPath();
            if (LOG.isDebugEnabled()) {
                LOG.debug("resource.getPath(): {}", (Object)resource.getPath());
                LOG.debug("nonUgcPath: {}", (Object)nonUgcPath);
            }
            if (StringUtils.equals(resourcePath = socialUtils.mapUGCPath(resource), nonUgcPath)) {
                return resource;
            }
            LOG.debug("Using non UGC resource");
            if (StringUtils.contains(nonUgcPath, JCR_CONTENT_STR)) {
                nonUgcPath = StringUtils.substringBeforeLast(nonUgcPath, JCR_CONTENT_STR);
            }
            LOG.debug("nonUgcPath AFTER: {}", (Object)nonUgcPath);
            Resource nonUgcResource = rr.resolve(nonUgcPath);
            if (nonUgcResource != null) {
                return nonUgcResource;
            }
            LOG.warn("Cannot get the associated content resource");
        }
        return resource;
    }

    public static boolean doDisplayTranslation(ResourceResolver resourceResolver, Resource resource, ClientUtilities clientUtils) {
        if (resourceResolver == null) {
            return false;
        }
        if (!clientUtils.isTranslationServiceConfigured(resource)) {
            return false;
        }
        String ugcLan = TranslationUtil.getUGCLanguage(resource);
        if (ugcLan == null) {
            return false;
        }
        boolean languageSupported = TranslationUtil.isLanguageSupported(resource, ugcLan);
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        if (context == null) {
            return false;
        }
        String ALLOW_MC_TRANSLATION = ALLOW_MC_TRANSLATION;
        String[] availableLanguages = null;
        String siteID = context.getSiteId();
        if (StringUtils.isEmpty(siteID) && null != (context = TranslationUtil.getCommunityContextWithReferer(resource))) {
            siteID = context.getSiteId();
        }
        if (!StringUtils.isEmpty(siteID)) {
            String sitePath = context.getSitePath();
            Resource siteResource = resource.getResourceResolver().getResource(sitePath);
            if (siteResource != null) {
                ValueMap configProperties = siteResource.adaptTo(ValueMap.class);
                Boolean allowTranslation = (Boolean)((Object)configProperties.get(ALLOW_MC_TRANSLATION, Boolean.class));
                if (allowTranslation == null || !allowTranslation.booleanValue()) {
                    LOG.trace("TranslationUtils.doDisplayTranslation: Machine Translation not allowed, returning false.");
                    return false;
                }
                availableLanguages = configProperties.get(AVAILABLE_LANGUAGES, (String[])null);
            }
        } else {
            availableLanguages = TranslationVariables.getLanguageCode();
        }
        String toLang = null;
        if (clientUtils != null) {
            LOG.debug("Comment user: {}", (Object)clientUtils.getAuthorizedUserId());
            String strRequestURI = null;
            String strReferer = null;
            String strRequestLanguage = null;
            if (clientUtils.getRequest() != null) {
                strRequestURI = clientUtils.getRequest().getRequestURI();
                strReferer = clientUtils.getRequest().getHeader(REFERER);
                strRequestLanguage = clientUtils.getRequest().getHeader(BROWSER_LANGUAGE);
            }
            toLang = TranslationUtil.getTranslationTargetLanguage(resourceResolver, TranslationUtil.getNonUgcResource(resource), clientUtils.getAuthorizedUserId(), strRequestURI, strReferer, strRequestLanguage, clientUtils);
        }
        if (toLang == null) {
            return false;
        }
        languageSupported = TranslationUtil.isLanguageSupported(availableLanguages, ugcLan);
        if (languageSupported) {
            languageSupported = TranslationUtil.isLanguageSupported(availableLanguages, toLang);
        }
        if (!languageSupported) {
            return languageSupported;
        }
        if (TranslationUtil.languagesAreEquivalent(ugcLan, toLang).booleanValue()) {
            return false;
        }
        SocialUtils socialUtils = clientUtils.getSocialUtils();
        TranslationManager translationManager = socialUtils.getTranslationManager();
        if (translationManager != null) {
            try {
                TranslationService translationService = translationManager.createTranslationService(TranslationUtil.getNonUgcResource(resource));
                return translationService.isDirectionSupported(ugcLan, toLang);
            }
            catch (TranslationException e) {
                LOG.error(e.toString());
            }
        } else {
            LOG.debug("translationManager is null");
        }
        return false;
    }

    public static String[] getAvailableLanguages(Resource resource) {
        Resource siteResource;
        String[] availableLanguages = null;
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        String siteID = context.getSiteId();
        String sitePath = context.getSitePath();
        if (null == siteID && null != (context = TranslationUtil.getCommunityContextWithReferer(resource))) {
            siteID = context.getSiteId();
            sitePath = context.getSitePath();
        }
        if (!StringUtils.isEmpty(siteID) && (siteResource = resource.getResourceResolver().getResource(sitePath)) != null) {
            ValueMap configProperties = siteResource.adaptTo(ValueMap.class);
            availableLanguages = configProperties.get(AVAILABLE_LANGUAGES, (String[])null);
        }
        if (availableLanguages == null) {
            availableLanguages = TranslationVariables.getLanguageCode();
        }
        return availableLanguages;
    }

    private static boolean isLanguageSupported(String[] availableLanguages, String languageCode) {
        boolean languageSupported = false;
        if (null != availableLanguages && !StringUtils.isEmpty(languageCode)) {
            for (String supportLan : availableLanguages) {
                if (!TranslationUtil.languagesAreEquivalent(supportLan, languageCode).booleanValue()) continue;
                languageSupported = true;
                break;
            }
        }
        return languageSupported;
    }

    public static String checkLanguageCode(String toLang, Resource resource) {
        String[] availableLanguages = TranslationUtil.getAvailableLanguages(resource);
        if (toLang.length() > 2) {
            for (int i = 0; i < availableLanguages.length; ++i) {
                if (availableLanguages[i].length() <= 2) continue;
                String toLangLeftStr = toLang.substring(0, 2);
                String toLangRightStr = toLang.substring(3, toLang.length());
                String avlblLeftStr = availableLanguages[i].substring(0, 2);
                String avlblRightStr = availableLanguages[i].substring(3, availableLanguages[i].length());
                if (!toLangLeftStr.equalsIgnoreCase(avlblLeftStr) || !toLangRightStr.equalsIgnoreCase(avlblRightStr)) continue;
                toLang = availableLanguages[i];
                return toLang;
            }
            String baseLanguage = toLang.substring(0, 2);
            if (Arrays.asList(availableLanguages).contains(baseLanguage)) {
                return baseLanguage;
            }
        }
        return toLang;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCaching(Resource resource) {
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        if (null == context) {
            LOG.error("TranslationUtil: CommunityContext is null.");
            return null;
        }
        String caching = null;
        String siteID = context.getSiteId();
        if (null == siteID && null != (context = TranslationUtil.getCommunityContextWithReferer(resource))) {
            siteID = context.getSiteId();
        }
        if (StringUtils.isEmpty(siteID)) return TranslationVariables.getCaching();
        LOG.trace("Inside updateEditTranslation: This is a community site.");
        String sitePath = context.getSitePath();
        LOG.trace("updateEditTranslation - Site path of community site: {}", (Object)sitePath);
        ResourceResolver resourceResolver = resource.getResourceResolver();
        Resource siteResource = resourceResolver.getResource(sitePath);
        if (siteResource == null) return caching;
        ValueMap configProperties = siteResource.adaptTo(ValueMap.class);
        Object persistenceOption = configProperties.get("persistTranslation", null);
        if (persistenceOption == null) return NO_CACHING;
        if (persistenceOption instanceof Boolean) {
            Boolean persistOptionBoolean = persistenceOption;
            if (persistOptionBoolean == null) return caching;
            if (persistOptionBoolean == false) return NO_CACHING;
            return CACHE_WHEN_CALL;
        }
        String persistOptionString = persistenceOption;
        if (persistOptionString.equalsIgnoreCase("TRANSLATE_ON_USER_REQUEST")) {
            return CACHE_WHEN_CALL;
        }
        if (!persistOptionString.equalsIgnoreCase("TRANSLATE_AUTOMATICALLY")) return NO_CACHING;
        return CACHE_WHEN_POST;
    }

    public static CommunityContext getCommunityContextWithReferer(Resource resource) {
        CommunityContext context;
        String siteID;
        String path;
        Resource r;
        ResourceResolver rr;
        String referer;
        ValueMap vm;
        if (resource != null && (vm = resource.adaptTo(ValueMap.class)) != null && (referer = (String)((Object)vm.get(REFERER, String.class))) != null && (rr = resource.getResourceResolver()) != null && null != (r = rr.resolve(path = (String)((Object)vm.get(REFERER, String.class)))) && null != (siteID = (context = r.adaptTo(CommunityContext.class)).getSiteId())) {
            return context;
        }
        return null;
    }

    public static String getTranslationTargetLanguage(ResourceResolver resourceResolver, Resource resource, String strUserID, String strRequestURI, String strReferer, String strRequestAcceptLanguage, ClientUtilities clientUtils) {
        LOG.trace("In getTranslationTargetLanguageWithClientUtils");
        String toLang = TranslationUtil.getUserLanguage(resource, clientUtils, strUserID);
        return TranslationUtil.getTranslationTargetLanguageBackend(resourceResolver, resource, strRequestURI, strReferer, strRequestAcceptLanguage, toLang);
    }

    private static String getTranslationTargetLanguageBackend(ResourceResolver resourceResolver, Resource resource, String strRequestURI, String strReferer, String strRequestAcceptLanguage, String toLang) {
        if (StringUtils.isEmpty(toLang) && StringUtils.isEmpty(toLang = TranslationUtil.getBrowserLanguage(strRequestAcceptLanguage))) {
            toLang = TranslationUtil.getPageLanguage(resourceResolver, TranslationUtil.getNonUgcResource(resource), strRequestURI, strReferer);
        }
        if (null != (toLang = TranslationUtil.changeLanguageCode(toLang))) {
            toLang = TranslationUtil.checkLanguageCode(toLang, resource);
        }
        LOG.debug("Returning toLang: {}", (Object)toLang);
        return toLang;
    }

    public static String getTranslationTargetLanguage(ResourceResolver resourceResolver, Resource resource, String strUserID, String strRequestURI, String strReferer, String strRequestAcceptLanguage) {
        LOG.trace("In getTranslationTargetLanguage");
        String toLang = TranslationUtil.getUserLanguage(resourceResolver, strUserID);
        return TranslationUtil.getTranslationTargetLanguageBackend(resourceResolver, resource, strRequestURI, strReferer, strRequestAcceptLanguage, toLang);
    }

    public static String getUserLanguage(Resource resource, ClientUtilities clientUtils, String userId) {
        String userLanguage = "";
        try {
            UserProperties userProps = null;
            if (!StringUtils.isEmpty(userId)) {
                userProps = clientUtils.getUserProperties(userId, USER_PROFILE);
            } else {
                userId = clientUtils.getAuthorizedUserId();
                LOG.debug("Getting language for user {}", (Object)userId);
                userProps = clientUtils.getUserProperties(userId, USER_PROFILE);
            }
            if (userProps != null) {
                userLanguage = userProps.getProperty(LANGUAGE_PROP);
                if (StringUtils.isEmpty(userLanguage) && (userProps = clientUtils.getUserProperties(userId, USER_PREFERENCES)) != null) {
                    userLanguage = userProps.getProperty(LANGUAGE_PROP);
                }
                if (!StringUtils.isEmpty(userLanguage) && resource != null) {
                    userLanguage = TranslationUtil.checkLanguageCode(userLanguage, resource);
                }
            }
        }
        catch (RepositoryException re) {
            LOG.error(re.toString());
        }
        return userLanguage;
    }

    public static String getUserLanguage(Resource resource, ResourceResolver resourceResolver, String userId) {
        String userLanguage = "";
        UserPropertiesManager userPropertiesManager = resourceResolver.adaptTo(UserPropertiesManager.class);
        if (userPropertiesManager != null) {
            try {
                UserProperties userProps = null;
                if (!StringUtils.isEmpty(userId)) {
                    userProps = userPropertiesManager.getUserProperties(userId, USER_PROFILE);
                } else {
                    userId = resourceResolver.getUserID();
                    LOG.debug("Getting language for user {}", (Object)userId);
                    userProps = userPropertiesManager.getUserProperties(userId, USER_PROFILE);
                }
                if (userProps != null) {
                    userLanguage = userProps.getProperty(LANGUAGE_PROP);
                    if (StringUtils.isEmpty(userLanguage) && (userProps = userPropertiesManager.getUserProperties(userId, USER_PREFERENCES)) != null) {
                        userLanguage = userProps.getProperty(LANGUAGE_PROP);
                    }
                    if (!StringUtils.isEmpty(userLanguage) && resource != null) {
                        userLanguage = TranslationUtil.checkLanguageCode(userLanguage, resource);
                    }
                }
            }
            catch (RepositoryException re) {
                LOG.error(re.toString());
            }
        }
        return userLanguage;
    }

    public static String getUserLanguage(ResourceResolver resourceResolver, String userId) {
        return TranslationUtil.getUserLanguage(null, resourceResolver, userId);
    }

    public static String getUGCLanguage(Resource resource) {
        ValueMap properties = null;
        String retVal = null;
        if (resource != null) {
            Resource translationNode = TranslationUtil.getTranslationNode(resource, false);
            if (translationNode != null) {
                properties = translationNode.adaptTo(ValueMap.class);
                String strLanguageKey = AS_LANGUAGE_PROP;
                if (!properties.containsKey(AS_LANGUAGE_PROP)) {
                    strLanguageKey = LANGUAGE_PROP;
                }
                retVal = properties.get(strLanguageKey, (String)null);
                return retVal;
            }
            LOG.debug("translationNode was null");
        } else {
            LOG.debug("resource was null");
        }
        return retVal;
    }

    public static String getPageLanguage(ResourceResolver resourceResolver, Resource ugcResource, String uri, String referer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("uri: {}", (Object)uri);
            LOG.debug("referer: {}", (Object)referer);
        }
        if (resourceResolver == null) {
            LOG.warn("resourceResolver was null!");
            return null;
        }
        String pageLang = "";
        if (!StringUtils.isEmpty(uri)) {
            Resource uriResource;
            String uriResourcePath = TranslationUtil.uriToResourcePath(uri);
            LOG.debug("uriResourcePath: {}", (Object)uriResourcePath);
            if (!uriResourcePath.startsWith("/content/usergenerated") && (uriResource = resourceResolver.getResource(LanguageUtil.getLanguageRoot(uriResourcePath))) != null) {
                LOG.debug("Getting pageLang from uri");
                pageLang = TranslationUtil.getResourceLanguage(resourceResolver, uriResource);
            }
        }
        if (StringUtils.isEmpty(pageLang)) {
            Resource commentsNodeResource = TranslationUtil.getNonUgcResource(ugcResource);
            MachineTranslationUtil mtu = resourceResolver.adaptTo(MachineTranslationUtil.class);
            MachineTranslationCloudConfig cloudConfig = mtu.getAppliedMachineTranslationCloudConfigs(commentsNodeResource);
            String strCloudConfigUgcPath = null;
            if (cloudConfig != null) {
                strCloudConfigUgcPath = cloudConfig.getUgcPath();
            }
            if (!StringUtils.isEmpty(strCloudConfigUgcPath)) {
                LOG.debug("Getting pageLang from user");
                pageLang = TranslationUtil.getUserLanguage(resourceResolver, null);
            } else {
                LOG.debug("Getting pageLang from UGC");
                pageLang = TranslationUtil.getResourceLanguage(resourceResolver, ugcResource);
            }
        }
        if (StringUtils.isEmpty(pageLang)) {
            LOG.debug("Getting pageLang from referer");
            String refererPath = TranslationUtil.uriToResourcePath(referer);
            pageLang = TranslationUtil.getResourceLanguage(resourceResolver, resourceResolver.getResource(LanguageUtil.getLanguageRoot(refererPath)));
        }
        LOG.debug("Returning pageLang: {}", (Object)pageLang);
        return pageLang;
    }

    public static String getResourceLanguage(ResourceResolver rr, Resource resource) {
        Page containingPage;
        PageManager pm = rr.adaptTo(PageManager.class);
        Page page = containingPage = pm != null ? pm.getContainingPage(resource) : null;
        if (containingPage == null) {
            return null;
        }
        Locale language = containingPage.getLanguage(false);
        if (language == null) {
            return null;
        }
        return language.toString();
    }

    public static String uriToResourcePath(String uri) {
        if (StringUtils.isEmpty(uri)) {
            return null;
        }
        String resourcePath = "";
        int slashslash = uri.indexOf("//");
        resourcePath = slashslash > -1 ? uri.substring(uri.indexOf(47, slashslash + 2)) : uri;
        return StringUtils.substringBefore(resourcePath, ".");
    }

    public static UGCTranslationMeta ugcTranslationMeta(ResourceResolver resourceResolver, Resource resource, String toLanguage, String[] properties, String pagePath, String userId) {
        LOG.trace("In function: ugcTranslationMeta");
        UGCTranslationMeta meta = new UGCTranslationMeta();
        String ugcLan = "";
        String pageLanguage = toLanguage;
        if (StringUtils.isEmpty(pageLanguage)) {
            if (!StringUtils.isEmpty(userId)) {
                pageLanguage = TranslationUtil.getUserLanguage(resourceResolver, userId);
            }
            if (StringUtils.isEmpty(pageLanguage)) {
                pageLanguage = TranslationUtil.getPageLanguage(resourceResolver, TranslationUtil.getNonUgcResource(resource), pagePath, null);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("pageLanguage: {}", (Object)pageLanguage);
            LOG.debug("resource path: {}", (Object)resource.getPath());
        }
        meta.setPageLanguage(pageLanguage);
        ugcLan = TranslationUtil.getUGCLanguage(resource);
        if (ugcLan != null) {
            LOG.debug("ugcLan: {}", (Object)ugcLan);
            for (String supportLan : TranslationVariables.getLanguageCode()) {
                if (!TranslationUtil.languagesAreEquivalent(supportLan, ugcLan).booleanValue()) continue;
                meta.setUgcLanuage(ugcLan);
            }
        } else {
            LOG.warn("ugcLang returned null");
        }
        if (properties != null && properties.length > 0) {
            ValueMap commentProperties = resource.adaptTo(ValueMap.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("commentProperties: {}", (Object)commentProperties.keySet());
            }
            ArrayList<String> toBeTranslated = new ArrayList<String>();
            for (String property : properties) {
                String prop;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Checking for property: {}", (Object)property);
                }
                if ((prop = commentProperties.get(property, (String)null)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding prop {} to toBeTranslated ArrayList", (Object)prop);
                }
                toBeTranslated.add(prop);
            }
            meta.setToBeTranslated(toBeTranslated);
        } else {
            LOG.warn("properties was null");
        }
        return meta;
    }

    public static TranslationResult getTranslation(String fromLang, String toLang, String str, Resource resource, TranslationManager tm) {
        LOG.debug("In function: getTranslationFromAPI");
        TranslationResult result = null;
        String fromLangTemp = TranslationUtil.changeLanguageCode(fromLang);
        String toLangTemp = TranslationUtil.changeLanguageCode(toLang);
        if (TranslationUtil.languagesAreEquivalent(fromLangTemp, toLangTemp).booleanValue()) {
            LOG.debug("From language is the same as to language, returning null TranslationResult", (Object)fromLangTemp);
            return null;
        }
        try {
            if (tm != null) {
                TranslationService ts = tm.createTranslationService(TranslationUtil.getNonUgcResource(resource));
                if (ts != null) {
                    result = ts.translateString(str, fromLangTemp, toLangTemp, TranslationConstants.ContentType.HTML, CONTENT_CATEGORY);
                } else {
                    LOG.warn("Failed to get a Translation Service for resource path: {}", (Object)resource.getPath());
                }
            } else {
                LOG.warn("TranslationManager was null");
            }
        }
        catch (TranslationException te) {
            LOG.error(te.toString());
        }
        return result;
    }

    public static boolean isTranslationSupported(String fromLan, String toCode, TranslationManager tm, Resource resource) {
        boolean bRetVal = false;
        try {
            TranslationService ts = tm.createTranslationService(TranslationUtil.getNonUgcResource(resource));
            bRetVal = ts.isDirectionSupported(fromLan, toCode);
        }
        catch (TranslationException ex) {
            LOG.debug("Translation direction not supported" + ex);
        }
        return bRetVal;
    }

    private static String changeLanguageCode(String langCode) {
        if (!StringUtils.isEmpty(langCode)) {
            if (langCode.equals("no")) {
                return "nb";
            }
            if (langCode.equals("in")) {
                return "id";
            }
            if (langCode.equals("iw")) {
                return "he";
            }
            if (langCode.equals("zh_hk")) {
                return "zh_tw";
            }
            if (langCode.equals("zh_sg")) {
                return "zh_cn";
            }
            if (langCode.equals("zh")) {
                return "zh_cn";
            }
        }
        return langCode;
    }

    public static void saveTranslation(String toLan, Map<String, String> translation, Resource commentResource, Session adminSession) {
        try {
            LOG.trace("Inside fn saveTranslation");
            if (commentResource != null) {
                ValueMap commentResourceProperties = commentResource.adaptTo(ModifiableValueMap.class);
                Resource translationResource = TranslationUtil.getTranslationNode(commentResource, true);
                if (translationResource != null) {
                    Resource languageResource = translationResource.getChild(toLan);
                    if (languageResource == null) {
                        HashMap<String, Object> properties = new HashMap<String, Object>();
                        ResourceResolver rr = translationResource.getResourceResolver();
                        languageResource = rr.create(translationResource, toLan, properties);
                        rr.commit();
                    }
                    if (languageResource != null) {
                        ValueMap languageResourceProperties = languageResource.adaptTo(ModifiableValueMap.class);
                        languageResourceProperties.put(POST_EDITED_PROP, false);
                        if (commentResourceProperties.containsKey(SLING_RESOURCETYPE)) {
                            languageResourceProperties.put(SLING_RESOURCETYPE, commentResourceProperties.get(SLING_RESOURCETYPE) + TRANSLATION_SLING_RESOURCETYPE);
                        }
                        for (String s : translation.keySet()) {
                            if ("true".equals(s)) {
                                languageResourceProperties.put(s, true);
                                continue;
                            }
                            languageResourceProperties.put(s, translation.get(s));
                        }
                        languageResourceProperties.put(TRANSLATION_DATE_PROP, new GregorianCalendar());
                        languageResource.getResourceResolver().commit();
                    }
                    if (adminSession != null) {
                        adminSession.save();
                    }
                } else {
                    LOG.trace("Translation node is null");
                }
            } else {
                LOG.trace("comment Resource is null");
            }
        }
        catch (PersistenceException ex) {
            LOG.error("Error while saving translation", ex);
        }
        catch (RepositoryException ex) {
            LOG.error("Error while saving translation", ex);
        }
    }

    public static void translateOnSave(String fromLan, String toLan, Resource resource, Session session, TranslationManager tm, String[] properties) {
        LOG.debug("Resource path: {}", (Object)resource.getPath());
        TranslationResults translation = TranslationUtil.getTranslation(fromLan, toLan, properties, resource, tm);
        if ("Success".equals(translation.getStatus())) {
            TranslationUtil.saveTranslation(toLan, translation.getTranslation(), resource, session);
        }
    }

    public static TranslationUpdate getTranslationUpdate(String fromLan, String toLan, Resource resource, TranslationManager tm, String[] properties) {
        TranslationResults translation = TranslationUtil.getTranslation(fromLan, toLan, properties, resource, tm);
        if ("Success".equals(translation.getStatus())) {
            return new TranslationUpdate(resource.getPath(), toLan, translation.getTranslation());
        }
        return null;
    }

    public static TranslationResults getTranslation(String fromLan, String toLan, String[] properties, Resource resource, TranslationManager tm) {
        TranslationResults result = null;
        if (TranslationUtil.languagesAreEquivalent(fromLan, toLan).booleanValue()) {
            LOG.trace("From language was the same as to Language, returnin gnull TranslatioNResults", (Object)toLan);
            return null;
        }
        String resultStatus = "";
        boolean hasSuccess = false;
        boolean failed = false;
        HashMap<String, String> propertiesThatExistOnResource = new HashMap<String, String>();
        ValueMap resourceValueMap = resource.adaptTo(ValueMap.class);
        for (String property : properties) {
            String tempValue = resourceValueMap.get(property, "");
            if (tempValue.isEmpty()) continue;
            propertiesThatExistOnResource.put(property, tempValue);
        }
        HashMap<String, String> translated = new HashMap<String, String>();
        Set entrySet = propertiesThatExistOnResource.entrySet();
        if (entrySet.size() > 0) {
            for (Map.Entry thisEntry : entrySet) {
                String temp;
                boolean tried = false;
                String property = (String)thisEntry.getKey();
                TranslationResult translationResult = null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("property: {}", (Object)property);
                }
                if ((translationResult = TranslationUtil.getTranslation(fromLan, toLan, temp = (String)thisEntry.getValue(), resource, tm)) != null) {
                    translated.put(property, translationResult.getTranslation());
                    hasSuccess = true;
                    continue;
                }
                translated.put(property, temp);
                failed = true;
            }
            if (hasSuccess && failed) {
                resultStatus = "Partial Success";
            }
            if (hasSuccess && !failed) {
                resultStatus = "Success";
            }
            if (!hasSuccess) {
                resultStatus = "Fail";
            }
        } else {
            resultStatus = "Not processing empty properties / keySet";
        }
        String attribution = null;
        try {
            attribution = tm.createTranslationService(TranslationUtil.getNonUgcResource(resource)).getTranslationServiceInfo().getTranslationServiceAttribution();
        }
        catch (Exception e) {
            LOG.trace("error getting attribution ", e);
        }
        result = new TranslationResults(resultStatus, translated, attribution);
        return result;
    }

    public static Boolean languagesAreEquivalent(String fromLan, String toLan) {
        if (fromLan == null || toLan == null) {
            return false;
        }
        int fromLength = fromLan.length();
        int toLength = toLan.length();
        if (fromLength < 2 || toLength < 2) {
            return false;
        }
        if (fromLength == toLength) {
            return StringUtils.equalsIgnoreCase(fromLan, toLan);
        }
        return StringUtils.equalsIgnoreCase(fromLan.substring(0, 2), toLan.substring(0, 2));
    }

    public static boolean storeModifiedTranslation(Resource resource, TranslationManager transMgr, String originalText, String srcLang, String targetLang, String modifiedText, TranslationConstants.ContentType contentType, String userID, int rating) {
        boolean retVal = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inside storeModifiedTranslations");
            LOG.debug("originalText: {}", (Object)originalText);
            LOG.debug("sourceLanguage: {}", (Object)srcLang);
            LOG.debug("targetLanguage: {}", (Object)targetLang);
            LOG.debug("modifiedTranslatedText: {}", (Object)modifiedText);
            LOG.debug("userID: {}", (Object)userID);
            LOG.debug("rating: {}", (Object)rating);
        }
        try {
            Resource nonugcResource;
            TranslationService transSrvc;
            if (resource != null && transMgr != null && (transSrvc = transMgr.createTranslationService(nonugcResource = TranslationUtil.getNonUgcResource(resource))) != null) {
                transSrvc.storeTranslation(originalText, srcLang, targetLang, modifiedText, contentType, CONTENT_CATEGORY, userID, rating, resource.getPath());
                retVal = true;
            }
        }
        catch (TranslationException ex) {
            LOG.error("Error while updating modified translations. ", (Object)ex.toString());
        }
        return retVal;
    }

    public static String getBrowserLanguage(String languageRequestHeader) {
        String browserLanguage = null;
        String langDelimiter = ",";
        String preferenceDelimiter = ";";
        if (StringUtils.isNotEmpty(languageRequestHeader)) {
            if (languageRequestHeader.contains(",")) {
                for (String language : languageRequestHeader.split(",")) {
                    if (language.contains(";")) continue;
                    browserLanguage = language;
                    break;
                }
            } else {
                browserLanguage = languageRequestHeader;
            }
        }
        return browserLanguage;
    }

    private static String[] getAvailableLanguages(ResourceResolver resourceResolver, String strReferer) {
        String languageRoot = LanguageUtil.getLanguageRoot(strReferer);
        String resourcePath = TranslationUtil.uriToResourcePath(languageRoot);
        Resource resource = resourceResolver.resolve(resourcePath);
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        String[] availableLanguages = null;
        if (null == context) {
            return null;
        }
        String siteID = context.getSiteId();
        if (StringUtils.isNotEmpty(siteID)) {
            String sitePath = context.getSitePath();
            Resource siteResource = resource.getResourceResolver().getResource(sitePath);
            if (siteResource != null) {
                ValueMap configProperties = siteResource.adaptTo(ValueMap.class);
                availableLanguages = configProperties.get(AVAILABLE_LANGUAGES, (String[])null);
            }
        } else {
            availableLanguages = TranslationVariables.getLanguageCode();
        }
        return availableLanguages;
    }

    public static Properties[] getAvailableLanguageMapping(Resource resource) {
        ResourceResolver resolver = resource.getResourceResolver();
        Resource langMappingResource = resolver.resolve(LANGUAGE_MAPPING_PATH);
        Iterator<Resource> iterator = langMappingResource.getChildren().iterator();
        String langCode = "";
        String langName = "";
        HashMap<String, String> languageMapping = new HashMap<String, String>();
        while (iterator.hasNext()) {
            Resource child = iterator.next();
            ValueMap vm = child.adaptTo(ValueMap.class);
            langCode = vm.get(LANGUAGE_CODE, (String)null);
            langName = vm.get(LANGUAGE_NAME, (String)null);
            if (langCode == null || langName == null) continue;
            languageMapping.put(langCode, langName);
        }
        String[] availableLanguageCodes = TranslationUtil.getAvailableLanguages(resolver, resource.getPath());
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        Properties property = new Properties();
        property.put(LANGUAGE_CODE, DEFAULT_LANGUAGE_CODE);
        property.put(LANGUAGE_NAME, DEFAULT_LANGUAGE_NAME);
        propertiesList.add(property);
        if (availableLanguageCodes != null) {
            for (int i = 0; i < availableLanguageCodes.length; ++i) {
                String key = availableLanguageCodes[i];
                String value = (String)languageMapping.get(key);
                if (value == null) continue;
                property = new Properties();
                property.put(LANGUAGE_CODE, key);
                property.put(LANGUAGE_NAME, value);
                propertiesList.add(property);
            }
        }
        Properties[] propertiesArr = propertiesList.toArray(new Properties[propertiesList.size()]);
        return propertiesArr;
    }

    public static boolean isLanguageSupported(Resource resource, String ugcLanguage) {
        boolean languageSupported = false;
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        if (context == null || resource == null) {
            return false;
        }
        String[] availableLanguages = null;
        String siteID = context.getSiteId();
        if (StringUtils.isNotEmpty(siteID)) {
            String sitePath = context.getSitePath();
            Resource siteResource = resource.getResourceResolver().getResource(sitePath);
            if (siteResource != null) {
                ValueMap configProperties = siteResource.adaptTo(ValueMap.class);
                Boolean allowTranslation = (Boolean)((Object)configProperties.get(ALLOW_MC_TRANSLATION, Boolean.class));
                if (allowTranslation == null || !allowTranslation.booleanValue()) {
                    LOG.trace("TranslationUtils.doDisplayTranslation: Machine Translation not allowed, returning false.");
                    return false;
                }
                availableLanguages = configProperties.get(AVAILABLE_LANGUAGES, (String[])null);
            }
        } else {
            availableLanguages = TranslationVariables.getLanguageCode();
        }
        for (String supportLan : availableLanguages) {
            if (!TranslationUtil.languagesAreEquivalent(supportLan, ugcLanguage).booleanValue()) continue;
            languageSupported = true;
            break;
        }
        return languageSupported;
    }
}

