/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugcbase.core.attachments;

import com.adobe.cq.social.ugcbase.core.attachments.FileDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sling.api.request.RequestParameter;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;

public class AttachmentDataSource
implements FileDataSource {
    private final RequestParameter fileRequestParameter;

    public AttachmentDataSource(RequestParameter fileRequestParameter) {
        this.fileRequestParameter = fileRequestParameter;
    }

    public String getContentType() {
        try {
            TikaConfig config = TikaConfig.getDefaultConfig();
            Detector detector = config.getDetector();
            TikaInputStream stream = TikaInputStream.get(this.getInputStream());
            Metadata metadata = new Metadata();
            metadata.add("resourceName", this.getName());
            MediaType mediaType = detector.detect(stream, metadata);
            return mediaType.getBaseType().toString();
        }
        catch (IOException e) {
            return this.getName();
        }
    }

    @Override
    public String getType() {
        try {
            TikaConfig config = TikaConfig.getDefaultConfig();
            Detector detector = config.getDetector();
            TikaInputStream stream = TikaInputStream.get(this.getInputStream());
            Metadata metadata = new Metadata();
            metadata.add("resourceName", this.getName());
            MediaType mediaType = detector.detect(stream, metadata);
            MimeType mimeType = config.getMimeRepository().forName(mediaType.toString());
            return mimeType.getExtension();
        }
        catch (IOException e) {
            return this.getName();
        }
        catch (MimeTypeException e) {
            return this.getName();
        }
    }

    @Override
    public String getTypeFromFileName() {
        String fileName = this.getName();
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            return fileName.substring(index);
        }
        return null;
    }

    @Override
    public long getSize() {
        return this.fileRequestParameter.getSize();
    }

    public InputStream getInputStream() throws IOException {
        return this.fileRequestParameter.getInputStream();
    }

    public String getName() {
        return this.fileRequestParameter.getFileName();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }
}

