/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugcbase.core.attachments;

import com.adobe.cq.social.ugcbase.core.attachments.FileDataSource;
import com.adobe.cq.social.ugcbase.core.attachments.FileUploadSizeLimit;
import com.adobe.cq.social.ugcbase.osgi.BundleServices;
import com.adobe.cq.social.ugcbase.security.AttachmentTypeBlacklistService;
import java.util.ArrayList;
import java.util.Set;
import javax.activation.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentUtils.class);

    private AttachmentUtils() {
    }

    public static Iterable<DataSource> getAttachmentsFromDataSources(Iterable<FileDataSource> attachmentList, FileUploadSizeLimit fileUploadSizeLimit, Set<String> whitelist, String[] blacklist) {
        ArrayList<DataSource> attachments = new ArrayList<DataSource>();
        for (FileDataSource attachmentDataSource : attachmentList) {
            FileDataSource filteredAttachment = AttachmentUtils.getAttachmentFromDataSource(attachmentDataSource, fileUploadSizeLimit, whitelist, blacklist);
            if (filteredAttachment == null) continue;
            attachments.add(filteredAttachment);
        }
        return attachments;
    }

    public static FileDataSource getAttachmentFromDataSource(FileDataSource attachmentDataSource, FileUploadSizeLimit fileUploadSizeLimit, Set<String> whitelist, String[] blacklistIn) {
        AttachmentTypeBlacklistService attachmentTypeBlacklistService = BundleServices.getService(AttachmentTypeBlacklistService.class);
        Object[] blacklist = blacklistIn;
        if (attachmentTypeBlacklistService != null) {
            blacklist = attachmentTypeBlacklistService.getBlacklist(blacklistIn);
        }
        if (fileUploadSizeLimit.fits(attachmentDataSource)) {
            String contentFileType = attachmentDataSource.getTypeFromFileName();
            String contentType = attachmentDataSource.getType();
            if (StringUtils.isNotBlank(contentFileType) && !ArrayUtils.contains(blacklist, contentFileType)) {
                if (whitelist != null && !whitelist.isEmpty()) {
                    if (StringUtils.isNotBlank(contentType) && whitelist.contains(contentType) && !ArrayUtils.contains(blacklist, contentType)) {
                        return attachmentDataSource;
                    }
                    if (StringUtils.isNotBlank(contentType)) {
                        LOG.info("File of type " + contentType + " is blacklisted for security reasons. To upload edit the servlet's attachment black list");
                    } else {
                        LOG.info("Tika couldn't figure out the file type. Not attaching it as it is suspicious");
                    }
                } else {
                    if (StringUtils.isNotBlank(contentType) && !ArrayUtils.contains(blacklist, contentType)) {
                        return attachmentDataSource;
                    }
                    if (StringUtils.isNotBlank(contentType)) {
                        LOG.info("File of type " + contentType + " is blacklisted for security reasons. To upload edit the servlet's attachment black list");
                    } else {
                        LOG.info("Tika couldn't figure out the file type. Not attaching it as it is suspicious");
                    }
                }
            } else if (StringUtils.isNotBlank(contentFileType)) {
                LOG.info("File of type " + contentFileType + "with name " + attachmentDataSource.getName() + " is blacklisted for security reasons. To upload edit the servlet's attachment black list");
            } else {
                LOG.info("File doesn't have a valid extension. Not attaching it as it is suspicious");
            }
        } else {
            LOG.info("File bigger than specified size, so ignoring the attachment");
        }
        return null;
    }
}

