/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.user.internal.validator;

import com.adobe.cq.social.user.internal.TunnelValidator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;

public class AclTunnelValidator
implements TunnelValidator {
    private final String path;
    private final List<String> acls;

    public AclTunnelValidator(String path, List<String> acls) {
        this.path = path;
        this.acls = acls;
    }

    @Override
    public boolean isValidUser(ResourceResolver resolver) {
        Session session = resolver.adaptTo(Session.class);
        for (String acl : this.acls) {
            try {
                if (session.hasPermission(this.path, acl)) continue;
                return false;
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Cannot perform permission check", e);
            }
        }
        return true;
    }
}

