/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTableHarvester;
import java.util.Map;

class ContextFormat2Harvester
implements LookupTableHarvester.CoverageLookupHarvester,
LayoutTable.ClassConsumer {
    private Map lookups;
    private Subset gids;
    private boolean classCoveredBySet;
    private final LookupTableHarvester harvester;

    ContextFormat2Harvester(LookupTableHarvester harvester, Map lookups) {
        this.lookups = lookups;
        this.harvester = harvester;
    }

    public boolean glyph(int glyphID, int classID) throws UnsupportedFontException, InvalidFontException {
        if (this.gids.getExistingSubsetGid(glyphID) != -1) {
            this.classCoveredBySet = true;
            return false;
        }
        return true;
    }

    public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
        this.gids = gids;
        int classDefOffset = this.harvester.lookupTable.data.getOffset(stOffset, 4);
        int classIndex = this.harvester.lookupTable.getClassIndex(coverageGlyph, classDefOffset);
        int subclassSetOffset = this.harvester.lookupTable.data.getOffset(stOffset, 8 + 2 * classIndex);
        if (subclassSetOffset == 0) {
            return false;
        }
        boolean applies = false;
        int subclassRuleCount = this.harvester.lookupTable.data.getuint16(subclassSetOffset);
        for (int i = 0; i < subclassRuleCount; ++i) {
            int j;
            int subclassRuleOffset = this.harvester.lookupTable.data.getOffset(subclassSetOffset, 2 + 2 * i);
            int classCount = this.harvester.lookupTable.data.getuint16(subclassRuleOffset);
            this.classCoveredBySet = true;
            for (j = 0; j < classCount - 1; ++j) {
                this.classCoveredBySet = false;
                int theClass = this.harvester.lookupTable.data.getuint16(subclassRuleOffset + 4 + 2 * j);
                this.harvester.lookupTable.iterateClass(classDefOffset, this.harvester.numGlyphs, this, theClass);
                if (!this.classCoveredBySet) break;
            }
            if (!this.classCoveredBySet) continue;
            int lookupCount = this.harvester.lookupTable.data.getuint16(subclassRuleOffset + 2);
            for (j = 0; j < lookupCount; ++j) {
                int lookupIndex = this.harvester.lookupTable.data.getuint16(subclassRuleOffset + 4 + 2 * (classCount - 1) + 4 * j + 2);
                this.harvester.harvest(gids, lookupIndex, this.lookups);
            }
            applies = true;
        }
        return applies;
    }

    public boolean keepGoing() {
        return true;
    }
}

