/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.CScan;
import com.adobe.fontengine.font.CatalogDescription;
import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.EmbeddingPermission;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.StemFinder;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.SubsetSimpleType1;
import com.adobe.fontengine.font.TTScan;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.cff.CFFFont;
import com.adobe.fontengine.font.cff.CFFScaler;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.cff.NameKeyedSubset;
import com.adobe.fontengine.font.opentype.Base;
import com.adobe.fontengine.font.opentype.Cff;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.Cvt;
import com.adobe.fontengine.font.opentype.Fond;
import com.adobe.fontengine.font.opentype.Fpgm;
import com.adobe.fontengine.font.opentype.Gasp;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.Glyf;
import com.adobe.fontengine.font.opentype.GlyfRaw;
import com.adobe.fontengine.font.opentype.GlyphNames;
import com.adobe.fontengine.font.opentype.Gpos;
import com.adobe.fontengine.font.opentype.GposHarvester;
import com.adobe.fontengine.font.opentype.Gsub;
import com.adobe.fontengine.font.opentype.Head;
import com.adobe.fontengine.font.opentype.Hhea;
import com.adobe.fontengine.font.opentype.Hmtx;
import com.adobe.fontengine.font.opentype.HmtxRaw;
import com.adobe.fontengine.font.opentype.Kern;
import com.adobe.fontengine.font.opentype.LocaRaw;
import com.adobe.fontengine.font.opentype.Ltsh;
import com.adobe.fontengine.font.opentype.Maxp;
import com.adobe.fontengine.font.opentype.Name;
import com.adobe.fontengine.font.opentype.NoVORGVertOrigFetcher;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.OTFSWFFont3Description;
import com.adobe.fontengine.font.opentype.OTFSWFFont4Description;
import com.adobe.fontengine.font.opentype.OTSubset;
import com.adobe.fontengine.font.opentype.OpticalSizeData;
import com.adobe.fontengine.font.opentype.Orientation;
import com.adobe.fontengine.font.opentype.Os2;
import com.adobe.fontengine.font.opentype.Post;
import com.adobe.fontengine.font.opentype.Prep;
import com.adobe.fontengine.font.opentype.TTParser;
import com.adobe.fontengine.font.opentype.TTScaler;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.font.opentype.TrueTypeGlyphBBoxCalculator;
import com.adobe.fontengine.font.opentype.Vhea;
import com.adobe.fontengine.font.opentype.Vmtx;
import com.adobe.fontengine.font.opentype.VmtxRaw;
import com.adobe.fontengine.font.opentype.Vorg;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenTypeFont
extends FontData {
    public final Head head;
    public final Hhea hhea;
    public final Hmtx hmtx;
    public final Maxp maxp;
    public final Name name;
    public final Os2 os2;
    public final Cmap cmap;
    public final Post post;
    public final Gpos gpos;
    public final Gsub gsub;
    public final Gdef gdef;
    public final Base base;
    public final Glyf glyf;
    public final Cff cff;
    public final Vhea vhea;
    public final Vmtx vmtx;
    public final Cvt cvt;
    public final Fpgm fpgm;
    public final Prep prep;
    public final Kern kern;
    public final Gasp gasp;
    public final Ltsh ltsh;
    public final Vorg vorg;
    public final Fond fond;
    private final Object invertedcmapMutex = new Object();
    private boolean invertedcmapHasBeenComputed = false;
    private int[] invertedcmap;
    private final String base14CSSName;
    private final String base14PSName;
    private final OTXDCFontDescription xdcDescription;
    private static final boolean testing_subsetAndStreamForSWFEmbedding = false;

    public OpenTypeFont(Map tables, byte[] digest, String base14CSSName, String base14PSName) throws InvalidFontException, UnsupportedFontException {
        super(digest);
        this.base14CSSName = base14CSSName;
        this.base14PSName = base14PSName;
        this.head = (Head)tables.get(new Integer(1751474532));
        this.hhea = (Hhea)tables.get(new Integer(1751672161));
        this.maxp = (Maxp)tables.get(new Integer(1835104368));
        this.name = (Name)tables.get(new Integer(1851878757));
        this.os2 = (Os2)tables.get(new Integer(1330851634));
        this.cmap = (Cmap)tables.get(new Integer(1668112752));
        this.post = (Post)tables.get(new Integer(1886352244));
        this.cff = (Cff)tables.get(new Integer(1128678944));
        this.gpos = (Gpos)tables.get(new Integer(1196445523));
        this.gsub = (Gsub)tables.get(new Integer(1196643650));
        this.gdef = (Gdef)tables.get(new Integer(1195656518));
        this.base = (Base)tables.get(new Integer(1111577413));
        this.vhea = (Vhea)tables.get(new Integer(1986553185));
        this.cvt = (Cvt)tables.get(new Integer(1668707360));
        this.fpgm = (Fpgm)tables.get(new Integer(1718642541));
        this.prep = (Prep)tables.get(new Integer(1886545264));
        this.kern = (Kern)tables.get(new Integer(1801810542));
        this.gasp = (Gasp)tables.get(new Integer(1734439792));
        this.ltsh = (Ltsh)tables.get(new Integer(1280594760));
        this.vorg = (Vorg)tables.get(new Integer(1448038983));
        this.fond = (Fond)tables.get(new Integer(1718578788));
        HmtxRaw hmtxRaw = (HmtxRaw)tables.get(new Integer(1752003704));
        this.hmtx = hmtxRaw != null && this.hhea != null ? new Hmtx(hmtxRaw, this.hhea.getNumberOfHMetrics()) : null;
        VmtxRaw vmtxRaw = (VmtxRaw)tables.get(new Integer(1986884728));
        this.vmtx = vmtxRaw != null && this.vhea != null ? new Vmtx(vmtxRaw, this.vhea.getNumberOfVMetrics()) : null;
        GlyfRaw glyfRaw = (GlyfRaw)tables.get(new Integer(1735162214));
        LocaRaw locaRaw = (LocaRaw)tables.get(new Integer(1819239265));
        this.glyf = locaRaw != null && this.head != null ? new Glyf(glyfRaw, locaRaw, this.head.getIndexToLocFormat()) : null;
        this.xdcDescription = new OTXDCFontDescription();
    }

    @Override
    public boolean isSymbolic() throws UnsupportedFontException, InvalidFontException {
        if (this.cmap != null) {
            return this.cmap.isSymbolic();
        }
        return true;
    }

    @Override
    public int getNumGlyphs() throws InvalidFontException, UnsupportedFontException {
        if (this.maxp != null) {
            return this.maxp.getNumGlyphs();
        }
        if (this.getCFFFont() != null) {
            return this.getCFFFont().getNumGlyphs();
        }
        throw new InvalidFontException("required table (maxp) is missing");
    }

    @Override
    public double getUnitsPerEmX() throws UnsupportedFontException, InvalidFontException {
        if (this.head != null) {
            return this.head.getUnitsPerEm();
        }
        if (this.getCFFFont() != null) {
            return this.getCFFFont().getUnitsPerEmX();
        }
        throw new InvalidFontException("No way to know units per em");
    }

    @Override
    public double getUnitsPerEmY() throws UnsupportedFontException, InvalidFontException {
        if (this.head != null) {
            return this.head.getUnitsPerEm();
        }
        if (this.getCFFFont() != null) {
            return this.getCFFFont().getUnitsPerEmY();
        }
        throw new InvalidFontException("No way to know units per em");
    }

    @Override
    public double getCoolTypeUnitsPerEm() throws UnsupportedFontException, InvalidFontException {
        if (this.head != null) {
            return this.head.getUnitsPerEm();
        }
        if (this.glyf != null) {
            return 2048.0;
        }
        return 1000.0;
    }

    @Override
    public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
        if (this.head != null) {
            return this.head.getFontBBox();
        }
        if (this.getCFFFont() != null) {
            return this.getCFFFont().getFontBBox();
        }
        throw new InvalidFontException("No bbox in font");
    }

    @Override
    public Rect getCoolTypeRawFontBBox() throws InvalidFontException, UnsupportedFontException {
        if (this.cff != null) {
            return this.cff.getFontBBox();
        }
        return this.getFontBBox();
    }

    private CoolTypeScript computeCoolTypeScriptFromCmapSubtables() throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            return null;
        }
        ScriptFromCmapSelector selector = new ScriptFromCmapSelector();
        this.cmap.enumerateCmaps(selector);
        return selector.getScript();
    }

    private CoolTypeScript computeCoolTypeScriptFromOs2CodePage(CoolTypeScript foundScript, int numFound) throws InvalidFontException, UnsupportedFontException {
        int index;
        if (this.os2 != null) {
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1250_LATIN_2_EE)) {
                ++numFound;
                if (foundScript == null) {
                    foundScript = CoolTypeScript.ROMAN;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1251_CYRILLIC) || this.os2.supportsCodePage(Os2.CodePage.CP_866_MSDOS_RUSSIAN) || this.os2.supportsCodePage(Os2.CodePage.CP_855_IBM_CYRILLIC)) {
                ++numFound;
                if (foundScript == null) {
                    foundScript = CoolTypeScript.CYRILLIC;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1253_GREEK) || this.os2.supportsCodePage(Os2.CodePage.CP_869_IBM_GREEK) || this.os2.supportsCodePage(Os2.CodePage.CP_737_GREEK)) {
                ++numFound;
                if (foundScript == null) {
                    foundScript = CoolTypeScript.ROMAN;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1255_HEBREW) || this.os2.supportsCodePage(Os2.CodePage.CP_862_HEBREW)) {
                ++numFound;
                if (foundScript == null) {
                    foundScript = CoolTypeScript.HEBREW;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1256_ARABIC) || this.os2.supportsCodePage(Os2.CodePage.CP_864_ARABIC) || this.os2.supportsCodePage(Os2.CodePage.CP_708_ARABIC)) {
                ++numFound;
                if (foundScript == null) {
                    foundScript = CoolTypeScript.ARABIC;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_874_THAI)) {
                ++numFound;
                if (foundScript == null) {
                    foundScript = CoolTypeScript.THAI;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1252_LATIN_1) || this.os2.supportsCodePage(Os2.CodePage.CP_863_MSDOS_CANADIAN) || this.os2.supportsCodePage(Os2.CodePage.CP_861_MSDOS_ICELANDIC) || this.os2.supportsCodePage(Os2.CodePage.CP_860_MSDOS_PORTUGUESE) || this.os2.supportsCodePage(Os2.CodePage.CP_852_LATIN_2) || this.os2.supportsCodePage(Os2.CodePage.CP_850_WE_LATIN_1) || this.os2.supportsCodePage(Os2.CodePage.CP_437_US)) {
                ++numFound;
                if (foundScript == null) {
                    foundScript = CoolTypeScript.ROMAN;
                }
            }
        }
        if (foundScript != null && numFound > 1 && (index = this.getCoolTypeUnicodeCmapIndex()) != -1 && !this.computeCoolTypeCmapSupportsScript(foundScript, index)) {
            return null;
        }
        return foundScript;
    }

    private CoolTypeScript computeCoolTypeScriptFromOs2CodePageNotNameKeyed() throws InvalidFontException, UnsupportedFontException {
        if (this.os2 == null) {
            return null;
        }
        CoolTypeScript foundScript = null;
        int numFound = 0;
        if (this.os2.supportsCodePage(Os2.CodePage.CP_949_KOREAN_WANSUNG) || this.os2.supportsCodePage(Os2.CodePage.CP_1361_KOREAN_JOHAB)) {
            ++numFound;
            if (foundScript == null) {
                foundScript = CoolTypeScript.KOREAN;
            }
        }
        if (this.os2.supportsCodePage(Os2.CodePage.CP_932_JAPANESE)) {
            ++numFound;
            if (foundScript == null) {
                foundScript = CoolTypeScript.JAPANESE;
            }
        }
        if (this.os2.supportsCodePage(Os2.CodePage.CP_936_CHINESE_SIMPLIFIED)) {
            ++numFound;
            if (foundScript == null) {
                foundScript = CoolTypeScript.SIMPLIFIED_CHINESE;
            }
        }
        if (this.os2.supportsCodePage(Os2.CodePage.CP_950_CHINESE_TRADITIONAL)) {
            ++numFound;
            if (foundScript == null) {
                foundScript = CoolTypeScript.TRADITIONAL_CHINESE;
            }
        }
        return this.computeCoolTypeScriptFromOs2CodePage(foundScript, numFound);
    }

    private CoolTypeScript computeCoolTypeScriptFromOs2UnicodeRange() throws InvalidFontException {
        if (this.os2 == null) {
            return null;
        }
        if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.HANGUL_COMPATIBILITY_JAMO) || this.os2.supportsUnicodeRange(Os2.UnicodeRange.HANGUL_SYLLABLES)) {
            return CoolTypeScript.KOREAN;
        }
        if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.BOPOMOFO)) {
            int count = 0;
            if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.CJK_UNIFIED_IDEOGRAPHS)) {
                ++count;
            }
            if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.CJK_COMPATIBILITY_IDEOGRAPHS)) {
                ++count;
            }
            if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.CJK_COMPATIBILITY_FORMS)) {
                ++count;
            }
            if (count >= 2) {
                return CoolTypeScript.TRADITIONAL_CHINESE;
            }
            return CoolTypeScript.SIMPLIFIED_CHINESE;
        }
        if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.CJK_SYMBOLS_AND_PUNCTUATION) || this.os2.supportsUnicodeRange(Os2.UnicodeRange.CJK_UNIFIED_IDEOGRAPHS) || this.os2.supportsUnicodeRange(Os2.UnicodeRange.HIRAGANA) || this.os2.supportsUnicodeRange(Os2.UnicodeRange.KATAKANA)) {
            return CoolTypeScript.JAPANESE;
        }
        return null;
    }

    private int getCoolTypeUnicodeCmapIndex() throws InvalidFontException {
        int[][] subtables = new int[][]{{3, 1}, {0, 4}, {0, 3}, {0, 2}, {0, 1}, {0, 0}};
        int index = -1;
        for (int i = 0; i < subtables.length && (index = this.cmap.getCmapSubtableIndex(subtables[i][0], subtables[i][1])) == -1; ++i) {
        }
        return index;
    }

    private boolean computeCoolTypeCmapSupportsScript(CoolTypeScript script, int index) throws UnsupportedFontException, InvalidFontException {
        if (script == CoolTypeScript.JAPANESE) {
            return this.cmap.char2glyph(12450, index) > 0;
        }
        if (script == CoolTypeScript.ARABIC) {
            return this.cmap.char2glyph(1570, index) > 0;
        }
        if (script == CoolTypeScript.HEBREW) {
            return this.cmap.char2glyph(1488, index) > 0;
        }
        if (script == CoolTypeScript.EAST_EUROPEAN_ROMAN) {
            return this.cmap.char2glyph(268, index) > 0 || this.cmap.char2glyph(328, index) > 0 || this.cmap.char2glyph(371, index) > 0;
        }
        if (script == CoolTypeScript.CYRILLIC) {
            return this.cmap.char2glyph(1071, index) > 0 || this.cmap.char2glyph(1105, index) > 0;
        }
        if (script == CoolTypeScript.GREEK) {
            return this.cmap.char2glyph(971, index) > 0;
        }
        if (script == CoolTypeScript.ROMAN) {
            return this.cmap.char2glyph(234, index) > 0;
        }
        if (script == CoolTypeScript.THAI) {
            return this.cmap.char2glyph(3585, index) > 0;
        }
        if (script == CoolTypeScript.VIETNAMESE) {
            return this.cmap.char2glyph(8363, index) > 0;
        }
        return true;
    }

    private CoolTypeScript computeCoolTypeScriptFromUnicodeCmap() throws UnsupportedFontException, InvalidFontException {
        if (this.cmap == null) {
            return null;
        }
        int index = this.getCoolTypeUnicodeCmapIndex();
        if (index == -1) {
            return null;
        }
        if (this.cmap.char2glyph(12450, index) != 0) {
            return CoolTypeScript.JAPANESE;
        }
        if (this.cmap.char2glyph(1570, index) != 0) {
            return CoolTypeScript.ARABIC;
        }
        if (this.cmap.char2glyph(1488, index) != 0) {
            return CoolTypeScript.HEBREW;
        }
        if (this.cmap.char2glyph(328, index) != 0 || this.cmap.char2glyph(371, index) != 0) {
            if (this.cmap.char2glyph(234, index) != 0) {
                return CoolTypeScript.ROMAN;
            }
            return CoolTypeScript.EAST_EUROPEAN_ROMAN;
        }
        if (this.cmap.char2glyph(1071, index) != 0 || this.cmap.char2glyph(1105, index) != 0) {
            return CoolTypeScript.CYRILLIC;
        }
        if (this.cmap.char2glyph(971, index) != 0) {
            return CoolTypeScript.GREEK;
        }
        if (this.cmap.char2glyph(234, index) != 0) {
            return CoolTypeScript.ROMAN;
        }
        if (this.cmap.char2glyph(3585, index) != 0) {
            return CoolTypeScript.THAI;
        }
        if (this.cmap.char2glyph(8363, index) != 0) {
            return CoolTypeScript.VIETNAMESE;
        }
        return null;
    }

    private CoolTypeScript computeCoolTypeScriptFromOs2fsSelection() throws InvalidFontException {
        if (this.os2 == null) {
            return null;
        }
        int x = this.os2.getSelection() >> 8;
        if (x == 178 || x == 179) {
            return CoolTypeScript.ARABIC;
        }
        if (x == 177) {
            return CoolTypeScript.HEBREW;
        }
        return null;
    }

    private CoolTypeScript computeCoolTypeScriptFromNameEntriesLanguages() throws InvalidFontException {
        if (this.os2 == null || this.name == null) {
            return null;
        }
        long v = this.os2.getVendor();
        if (v == 1279611986L || v == 1146703425L || v == 1212239443L) {
            if (this.name.hasName(3, -1, Name.MicrosoftLCID.KOREAN_KOREA.getLanguageCode(), 4) || this.name.hasName(3, -1, Name.MicrosoftLCID.KOREAN_KOREA.getLanguageCode(), 0)) {
                return CoolTypeScript.KOREAN;
            }
            if (this.name.hasName(3, -1, Name.MicrosoftLCID.CHINESE_TAIWAN.getLanguageCode(), 4) || this.name.hasName(3, -1, Name.MicrosoftLCID.CHINESE_TAIWAN.getLanguageCode(), 0)) {
                return CoolTypeScript.TRADITIONAL_CHINESE;
            }
            if (this.name.hasName(3, -1, Name.MicrosoftLCID.CHINESE_PRC.getLanguageCode(), 4) || this.name.hasName(3, -1, Name.MicrosoftLCID.CHINESE_PRC.getLanguageCode(), 0)) {
                return CoolTypeScript.SIMPLIFIED_CHINESE;
            }
            if (this.name.hasName(3, -1, Name.MicrosoftLCID.JAPANESE_JAPAN.getLanguageCode(), 4) || this.name.hasName(3, -1, Name.MicrosoftLCID.JAPANESE_JAPAN.getLanguageCode(), 0)) {
                return CoolTypeScript.JAPANESE;
            }
        }
        return null;
    }

    @Override
    public CoolTypeScript getCoolTypeScript() throws UnsupportedFontException, InvalidFontException {
        CoolTypeScript ctScript;
        ROS ros = null;
        if (this.cff != null) {
            ros = this.cff.getROS();
        }
        if ((ctScript = CoolTypeScript.fromWellKnownROS(ros)) != null) {
            return ctScript;
        }
        ctScript = this.computeCoolTypeScriptFromCmapSubtables();
        if (ctScript != null) {
            return ctScript;
        }
        if (this.glyf != null || this.cff.getCFFFont() instanceof CIDKeyedFont ? (ctScript = this.computeCoolTypeScriptFromOs2CodePageNotNameKeyed()) != null : (ctScript = this.computeCoolTypeScriptFromOs2CodePage(null, 0)) != null) {
            return ctScript;
        }
        ctScript = this.computeCoolTypeScriptFromOs2UnicodeRange();
        if (ctScript != null) {
            return ctScript;
        }
        ctScript = this.computeCoolTypeScriptFromOs2fsSelection();
        if (ctScript != null) {
            return ctScript;
        }
        ctScript = this.computeCoolTypeScriptFromNameEntriesLanguages();
        if (ctScript != null) {
            return ctScript;
        }
        ctScript = this.computeCoolTypeScriptFromUnicodeCmap();
        if (ctScript != null) {
            return ctScript;
        }
        ctScript = CoolTypeScript.fromAnyROS(ros);
        if (ctScript != null) {
            return ctScript;
        }
        return CoolTypeScript.ROMAN;
    }

    @Override
    public double getCoolTypeCapHeight() throws InvalidFontException, UnsupportedFontException {
        int capHeight;
        if (this.os2 != null && (capHeight = this.os2.getCapHeight()) != Integer.MAX_VALUE && capHeight != 0) {
            return capHeight;
        }
        return this.getCoolTypeCapHeightFromGlyphs();
    }

    private Rect computeCoolTypeIdeoEmBoxFromBaseTable() throws UnsupportedFontException, InvalidFontException {
        if (this.base == null) {
            return null;
        }
        int ideoH = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_ideo);
        if (ideoH == Integer.MAX_VALUE) {
            return null;
        }
        int romnH = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_romn);
        if (romnH != Integer.MAX_VALUE && romnH < ideoH) {
            return null;
        }
        double ymin = ideoH;
        int idtpH = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_idtp);
        double ymax = idtpH != Integer.MAX_VALUE ? (double)idtpH : ymin + this.getUnitsPerEmY();
        double xmin = 0.0;
        int idtpV = this.base.getBaselinePosition(Orientation.VERTICAL, Tag.script_DFLT, Tag.baseline_idtp);
        double xmax = idtpV != Integer.MAX_VALUE ? (double)idtpV : xmin + this.getUnitsPerEmX();
        return new Rect(xmin, ymin, xmax, ymax);
    }

    private boolean validateOs2OrHheaIdeoEmBox(int ascender, int descender) throws UnsupportedFontException, InvalidFontException {
        for (int i = 0; i < typicalCharactersForIdeoEmBoxComputation.length; ++i) {
            int gid = this.getCoolTypeGlyphForChar(typicalCharactersForIdeoEmBoxComputation[i]);
            if (gid == 0) continue;
            Rect r = this.getGlyphBBox(gid);
            double diff = Math.abs((double)ascender - r.ymax - (r.ymin - (double)descender));
            double unitsPerEmY = this.getUnitsPerEmY();
            return (double)descender <= r.ymin && r.ymax <= (double)ascender && diff <= 0.003 * unitsPerEmY;
        }
        return false;
    }

    private Rect computeCoolTypeIdeoEmBoxFromOs2OrHhea() throws UnsupportedFontException, InvalidFontException {
        int ascender = -1;
        int descender = 0;
        if (this.os2 != null) {
            ascender = this.os2.getTypoAscender();
            descender = this.os2.getTypoDescender();
        }
        if (ascender <= descender && (ascender = this.hhea.getAscender()) <= (descender = this.hhea.getDescender())) {
            return null;
        }
        double unitsPerEmX = this.getUnitsPerEmX();
        double unitsPerEmY = this.getUnitsPerEmY();
        if (this.cff != null || (double)(ascender - descender) == unitsPerEmY || this.validateOs2OrHheaIdeoEmBox(ascender, descender)) {
            return new Rect(0.0, descender, unitsPerEmX, ascender);
        }
        return null;
    }

    private Rect computeCoolTypeIdeoEmBoxFromCapHeight() throws InvalidFontException, UnsupportedFontException {
        int romnH;
        double capHeight = this.getCoolTypeCapHeight();
        if (Double.isNaN(capHeight)) {
            return null;
        }
        if (this.base != null && (romnH = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_romn)) != Integer.MAX_VALUE) {
            capHeight -= (double)romnH;
        }
        double unitsPerEmX = this.getUnitsPerEmX();
        double unitsPerEmY = this.getUnitsPerEmY();
        double ymin = -(unitsPerEmY - capHeight) / 2.0;
        return new Rect(0.0, ymin, unitsPerEmX, ymin + unitsPerEmY);
    }

    @Override
    public Rect getCoolTypeIdeoEmBox() throws InvalidFontException, UnsupportedFontException {
        Rect r = this.computeCoolTypeIdeoEmBoxFromBaseTable();
        if (r != null) {
            return r;
        }
        if (this.useCoolTypeCJKHeuristics()) {
            r = this.computeCoolTypeIdeoEmBoxFromOs2OrHhea();
            if (r != null) {
                return r;
            }
            r = this.getCoolTypeIdeoEmBoxFromFullBoxCharacter();
            if (r != null) {
                return r;
            }
            r = this.getCoolTypeIdeoEmBoxFromTypicalCharacter();
            if (r != null) {
                return r;
            }
        } else {
            r = this.computeCoolTypeIdeoEmBoxFromCapHeight();
            if (r != null) {
                return r;
            }
        }
        double unitsPerEmX = this.getUnitsPerEmX();
        double unitsPerEmY = this.getUnitsPerEmY();
        return new Rect(0.0, -0.12 * unitsPerEmY, unitsPerEmX, 0.88 * unitsPerEmY);
    }

    private Rect computeCoolTypeIcfBoxFromBaseTable(Rect ideoEmBox) throws InvalidFontException, UnsupportedFontException {
        double xmax;
        if (this.base == null) {
            return null;
        }
        int icfbH = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_icfb);
        if (icfbH == Integer.MAX_VALUE) {
            return null;
        }
        int icfbV = this.base.getBaselinePosition(Orientation.VERTICAL, Tag.script_DFLT, Tag.baseline_icfb);
        int icftH = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_icft);
        int icftV = this.base.getBaselinePosition(Orientation.VERTICAL, Tag.script_DFLT, Tag.baseline_icft);
        double ymin = icfbH;
        double ymax = icftH != Integer.MAX_VALUE ? (double)icftH : ideoEmBox.ymax - (ymin - ideoEmBox.ymin);
        double xmin = icfbV != Integer.MAX_VALUE ? (double)icfbV : ymin - ideoEmBox.ymin;
        double d = xmax = icftV != Integer.MAX_VALUE ? (double)icftV : ideoEmBox.xmax - (xmin - ideoEmBox.xmin);
        if (this.useCoolTypeCJKHeuristics() && (ymin < ideoEmBox.ymin || ideoEmBox.ymax < ymax || xmin < ideoEmBox.xmin || ideoEmBox.xmax < xmax)) {
            return null;
        }
        return new Rect(xmin, ymin, xmax, ymax);
    }

    @Override
    public Rect getCoolTypeIcfBox() throws InvalidFontException, UnsupportedFontException {
        Rect ideoEmBox = this.getCoolTypeIdeoEmBox();
        Rect r = this.computeCoolTypeIcfBoxFromBaseTable(ideoEmBox);
        if (r != null) {
            return r;
        }
        if (this.useCoolTypeCJKHeuristics() && (r = this.getCoolTypeIcfBoxFromTypicalCharacter(ideoEmBox)) != null) {
            return r;
        }
        return this.getCoolTypeIcfBoxFromIdeoEmBox(ideoEmBox);
    }

    private boolean useOs2() throws InvalidFontException {
        if (this.os2 == null) {
            return false;
        }
        int a = this.os2.getTypoAscender();
        int d = this.os2.getTypoDescender();
        if (d > 0 && this.head != null && this.head.getYMin() <= 0) {
            d = -d;
        }
        return d < a;
    }

    private double computeCoolTypeLineGapForCJK() throws UnsupportedFontException, InvalidFontException {
        if ((this.cff == null || this.head == null || !this.head.isConverted()) && this.useOs2()) {
            return Math.abs(this.os2.getTypoLineGap());
        }
        if (this.cff == null) {
            return Math.abs(this.hhea.getLineGap());
        }
        return this.getUnitsPerEmY() / 2.0;
    }

    private LineMetrics computeCoolTypeLineMetricsFromTypicalCharacters(double linegap) throws UnsupportedFontException, InvalidFontException {
        double ascender;
        double descender;
        int dGid = this.getCoolTypeGlyphForChar(100);
        int pGid = this.getCoolTypeGlyphForChar(112);
        if (dGid != 0 && pGid != 0 && (descender = this.getGlyphBBox((int)pGid).ymin) < (ascender = this.getGlyphBBox((int)dGid).ymax)) {
            return new LineMetrics(ascender, descender, linegap);
        }
        return null;
    }

    private LineMetrics computeCoolTypeLineMetricsFromICFBox(double linegap) throws UnsupportedFontException, InvalidFontException {
        Rect icfBox = this.getCoolTypeIcfBox();
        return new LineMetrics(icfBox.ymax, icfBox.ymax - this.getUnitsPerEmY(), linegap);
    }

    private LineMetrics computeCoolTypeLineMetricsFromOs2() throws UnsupportedFontException, InvalidFontException {
        if (this.os2 == null) {
            return null;
        }
        int ascender = this.os2.getTypoAscender();
        int descender = this.os2.getTypoDescender();
        if (descender > 0 && this.head != null && this.head.getYMin() <= 0) {
            descender = -descender;
        }
        if (descender < ascender) {
            return new LineMetrics(ascender, descender, Math.abs(this.os2.getTypoLineGap()));
        }
        return null;
    }

    private LineMetrics computeCoolTypeLineMetricsFromHhea() throws UnsupportedFontException, InvalidFontException {
        int ascender = this.hhea.getAscender();
        int descender = this.hhea.getDescender();
        if (descender < ascender) {
            return new LineMetrics(ascender, descender, Math.abs(this.hhea.getLineGap()));
        }
        return null;
    }

    @Override
    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException {
        LineMetrics lm;
        if (this.useCoolTypeCJKHeuristics()) {
            double linegap = this.computeCoolTypeLineGapForCJK();
            LineMetrics lm2 = this.computeCoolTypeLineMetricsFromTypicalCharacters(linegap);
            if (lm2 != null) {
                return lm2;
            }
            return this.computeCoolTypeLineMetricsFromICFBox(linegap);
        }
        if (!(this.cff != null && this.head != null && this.head.isConverted() || (lm = this.computeCoolTypeLineMetricsFromOs2()) == null)) {
            return lm;
        }
        if (this.glyf != null && (lm = this.computeCoolTypeLineMetricsFromHhea()) != null) {
            return lm;
        }
        return this.getCoolTypeLineMetricsFromFontBbox();
    }

    @Override
    public LineMetrics getLineMetrics() throws UnsupportedFontException, InvalidFontException {
        if (this.os2 != null) {
            return this.os2.getLineMetrics();
        }
        return null;
    }

    @Override
    public UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException {
        int gid;
        double unitsPerEmY = this.getUnitsPerEmY();
        if (this.cff != null) {
            return this.cff.getCoolTypeUnderlineMetrics(this.getCoolTypeUnitsPerEm(), unitsPerEmY);
        }
        if (this.post != null) {
            int p = this.post.getUnderlinePosition();
            int u = this.post.getUnderlineThickness();
            if (p != 0 || u != 0) {
                return new UnderlineMetrics(p, Math.abs(u));
            }
        }
        if (this.glyf != null && this.useCoolTypeCJKHeuristics() && (gid = this.getCoolTypeGlyphForChar(26412)) != 0) {
            Rect r = this.getGlyphBBox(gid);
            return new UnderlineMetrics(r.ymin - 0.05 * unitsPerEmY / 2.0, 0.05 * unitsPerEmY);
        }
        if (this.useCoolTypeCJKHeuristics()) {
            return new UnderlineMetrics(-0.1 * unitsPerEmY, 0.05 * unitsPerEmY);
        }
        return new UnderlineMetrics(-0.15 * unitsPerEmY, 0.05 * unitsPerEmY);
    }

    @Override
    public boolean getCoolTypeProportionalRomanFromFontProperties() throws InvalidFontException {
        if (this.os2 != null) {
            switch (this.os2.panoseIndicatesProportional()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.cff != null) {
            return this.cff.getCFFFont().getCoolTypeProportionalRomanFromFontProperties();
        }
        return false;
    }

    public int computeRomanBaselineH() throws InvalidFontException {
        if (this.base != null) {
            int bRomnH = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_romn);
            if (bRomnH == Integer.MAX_VALUE) {
                return 0;
            }
            int bIdeoH = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_ideo);
            if (bIdeoH == Integer.MAX_VALUE || bRomnH >= bIdeoH) {
                return bRomnH;
            }
        }
        return 0;
    }

    public double computeRomanBaselineV() throws UnsupportedFontException, InvalidFontException {
        int bRomnV;
        if (this.base != null && (bRomnV = this.base.getBaselinePosition(Orientation.VERTICAL, Tag.script_DFLT, Tag.baseline_romn)) != Integer.MAX_VALUE) {
            return bRomnV;
        }
        Rect ideoEmBox = this.getCoolTypeIdeoEmBox();
        int romanBaselineH = this.computeRomanBaselineH();
        return -ideoEmBox.ymin - (double)romanBaselineH + ideoEmBox.xmin;
    }

    @Override
    public int getGlyphForChar(int usv) throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            return 0;
        }
        return this.cmap.unicodeChar2glyph(usv);
    }

    @Override
    public int getCoolTypeGlyphForChar(int usv) throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            return 0;
        }
        return this.cmap.coolTypeUnicodeChar2glyph(usv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCharForGlyph(int gid) throws UnsupportedFontException, InvalidFontException {
        Object object = this.invertedcmapMutex;
        synchronized (object) {
            if (!this.invertedcmapHasBeenComputed) {
                if (this.cmap == null) {
                    return -1;
                }
                int index = this.cmap.getCmapSubtableIndex(3, 1);
                this.invertedcmap = (int[])(index != -1 ? this.cmap.glyph2char(this.getNumGlyphs(), index) : null);
                this.invertedcmapHasBeenComputed = true;
            }
            if (this.invertedcmap != null) {
                return this.invertedcmap[gid];
            }
            return -1;
        }
    }

    @Override
    public double getHorizontalAdvance(int gid) throws InvalidFontException, UnsupportedFontException {
        if (this.hmtx != null) {
            return this.hmtx.getHorizontalAdvance(gid);
        }
        if (this.getCFFFont() != null) {
            return this.getCFFFont().getHorizontalAdvance(gid);
        }
        throw new InvalidFontException("No way to know horizontal advance");
    }

    public void getGlyphOutline(int gid, OutlineConsumer consumer, int pathType) throws UnsupportedFontException, InvalidFontException {
        if (this.cff != null) {
            this.cff.getOutline(gid, consumer);
        } else {
            TTParser parser = new TTParser();
            parser.parse(this, gid, consumer, pathType);
        }
    }

    @Override
    public void getGlyphOutline(int gid, OutlineConsumer consumer) throws UnsupportedFontException, InvalidFontException {
        if (this.cff != null) {
            this.cff.getOutline(gid, consumer);
        } else {
            TTParser parser = new TTParser();
            parser.parse(this, gid, consumer);
        }
    }

    @Override
    public Rect getGlyphBBox(int gid) throws UnsupportedFontException, InvalidFontException {
        if (this.cff != null) {
            Rect result = this.cff.getGlyphBoundingBoxInMetricSpace(gid);
            if (Math.abs(this.getUnitsPerEmX() - this.cff.getCFFFont().getUnitsPerEmX()) < 0.1 && Math.abs(this.getUnitsPerEmY() - this.cff.getCFFFont().getUnitsPerEmY()) < 0.1) {
                return result;
            }
            double cffUnitsPerEmX = this.cff.getCFFFont().getUnitsPerEmX();
            double cffUnitsPerEmY = this.cff.getCFFFont().getUnitsPerEmY();
            return new Rect(result.xmin * this.getUnitsPerEmX() / cffUnitsPerEmX, result.ymin * this.getUnitsPerEmY() / cffUnitsPerEmY, result.xmax * this.getUnitsPerEmX() / cffUnitsPerEmX, result.ymax * this.getUnitsPerEmY() / cffUnitsPerEmY);
        }
        return this.glyf.getGlyphBoundingBox(gid);
    }

    @Override
    public Scaler getScaler(ScanConverter c) throws InvalidFontException, UnsupportedFontException {
        if (this.glyf != null) {
            if (c == null) {
                c = new TTScan();
            }
            return new TTScaler(this, c);
        }
        if (c == null) {
            c = new CScan(false, 1.0, true);
        }
        return new CFFScaler(this.cff.cffFont, c);
    }

    public String getGlyphName(int glyphID) throws UnsupportedFontException, InvalidFontException {
        int usv;
        String s = null;
        if (glyphID == 0) {
            return ".notdef";
        }
        if (this.post != null) {
            s = this.post.getGlyphName(glyphID);
        }
        if (s == null && this.cff != null) {
            s = this.cff.getGlyphName(glyphID);
        }
        if (s == null && (usv = this.getCharForGlyph(glyphID)) != -1) {
            s = GlyphNames.resolveUSVToAGNCName(usv);
        }
        if (s == null) {
            return "g" + glyphID;
        }
        return s;
    }

    public ROS getROS() {
        if (this.cff != null) {
            return this.cff.getROS();
        }
        return null;
    }

    public int getCIDCount() {
        if (this.cff != null && this.cff.getCFFFont() instanceof CIDKeyedFont) {
            return ((CIDKeyedFont)this.cff.getCFFFont()).getCIDCount();
        }
        return -1;
    }

    public int getGlyphCid(int glyphID) throws InvalidFontException, UnsupportedFontException {
        if (this.cff != null) {
            return this.cff.getGlyphCid(glyphID);
        }
        return -1;
    }

    @Override
    public SWFFontDescription getSWFFontDescription(boolean wasEmbedded) throws UnsupportedFontException, InvalidFontException {
        return new OTFSWFFont3Description(this, wasEmbedded);
    }

    @Override
    public SWFFont4Description getSWFFont4Description(boolean wasEmbedded) throws UnsupportedFontException, InvalidFontException {
        return new OTFSWFFont4Description(this, wasEmbedded);
    }

    @Override
    public PDFFontDescription getPDFFontDescription(Font font) {
        return this.xdcDescription;
    }

    @Override
    public XDCFontDescription getXDCFontDescription(Font font) {
        return this.xdcDescription;
    }

    @Override
    public Permission getEmbeddingPermission(boolean wasEmbedded) throws InvalidFontException, UnsupportedFontException {
        if (this.os2 == null) {
            if (this.cff != null) {
                return this.cff.getEmbeddingPermission(wasEmbedded);
            }
            return EmbeddingPermission.getTrueTypeDefaultPermission();
        }
        return this.os2.getEmbeddingPermission();
    }

    @Override
    public Subset createSubset() throws UnsupportedFontException, InvalidFontException {
        return new OTSubset(this, this.cff != null);
    }

    @Override
    public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS) throws InvalidFontException, UnsupportedFontException, IOException {
        this.subsetAndStream(subset, null, out, preserveROS);
    }

    private void streamTablesForEditting(OutputStream out, Map tables) throws InvalidFontException, UnsupportedFontException, IOException {
        if (this.hmtx != null) {
            this.hmtx.stream(tables);
        }
        if (this.hhea != null) {
            this.hhea.stream(tables);
        }
        if (this.os2 != null) {
            this.os2.stream(tables);
        }
        if (this.gsub != null) {
            this.gsub.stream(tables);
        }
        if (this.gpos != null) {
            this.gpos.stream(tables);
        }
        if (this.gdef != null) {
            this.gdef.stream(tables);
        }
        if (this.base != null) {
            this.base.stream(tables);
        }
        if (this.cff != null) {
            this.cff.stream(tables, null);
        }
    }

    void streamSFNTForPDFEditting(OutputStream out) throws InvalidFontException, UnsupportedFontException, IOException {
        TreeMap tables = new TreeMap();
        this.streamTablesForEditting(out, tables);
        if (this.name != null) {
            OpticalSizeData data = this.getOpticalSizeData();
            int[] nameIds = data == null ? null : new int[]{data.nameId};
            this.name.stream(tables, true, nameIds);
        }
        if (this.cmap != null) {
            this.cmap.stream(tables);
        }
        if (this.maxp != null) {
            this.maxp.stream(tables);
        }
        if (this.glyf != null) {
            this.glyf.stream(tables);
        }
        if (this.cvt != null) {
            this.cvt.stream(tables);
        }
        if (this.fpgm != null) {
            this.fpgm.stream(tables);
        }
        if (this.prep != null) {
            this.prep.stream(tables);
        }
        if (this.post != null) {
            this.post.stream(tables);
        }
        OTByteArray.OTByteArrayBuilder headData = null;
        if (this.head != null) {
            headData = this.head.stream(tables);
        }
        this.finalizeStreamData(headData, tables, out, this.glyf != null);
    }

    void streamSFNTForSWFEditting(OutputStream out) throws UnsupportedFontException, InvalidFontException, IOException {
        TreeMap tables = new TreeMap();
        this.streamTablesForEditting(out, tables);
        if (this.name != null) {
            OpticalSizeData data = this.getOpticalSizeData();
            int[] nameIds = data == null ? null : new int[]{data.nameId};
            this.name.stream(tables, false, nameIds);
        }
        if (this.cmap != null) {
            this.cmap.streamForSWF(tables, this.getNumGlyphs());
        }
        if (this.maxp != null) {
            if (this.glyf != null) {
                this.maxp.subsetAndStreamForCFF(this.getNumGlyphs(), tables);
            } else {
                this.maxp.stream(tables);
            }
        }
        if (this.glyf != null) {
            this.glyf.streamForCFF(this, tables, true);
        }
        if (this.post != null) {
            if (this.glyf != null) {
                this.post.subsetAndStreamForCFF(tables);
            } else {
                this.post.stream(tables);
            }
        }
        if (this.vorg != null) {
            this.vorg.stream(tables);
        } else if (this.vmtx != null) {
            SubsetDefaultImpl subset = new SubsetDefaultImpl(this.getNumGlyphs(), false);
            Vorg.subsetAndStream(subset, tables, new NoVORGVertOrigFetcher(this));
        }
        if (this.kern != null) {
            this.kern.stream(tables);
        }
        if (this.vhea != null) {
            this.vhea.stream(tables);
        }
        if (this.vmtx != null) {
            this.vmtx.stream(tables);
        }
        OTByteArray.OTByteArrayBuilder headData = null;
        if (this.head != null) {
            headData = this.head.stream(tables);
        }
        this.finalizeStreamData(headData, tables, out, false);
    }

    private void finalizeStreamData(OTByteArray.OTByteArrayBuilder headData, Map tables, OutputStream out, boolean useTTVersion) throws InvalidFontException, IOException {
        int headerSize = 12 + 16 * tables.size();
        int searchRange = 1;
        int entrySelector = 0;
        while (searchRange <= tables.size()) {
            searchRange *= 2;
            ++entrySelector;
        }
        --entrySelector;
        int rangeShift = tables.size() * 16 - (searchRange *= 8);
        OTByteArray.OTByteArrayBuilder headerBuilder = OTByteArray.getOTByteArrayBuilderInstance(headerSize);
        if (useTTVersion) {
            headerBuilder.setFixed(0, 1, 0);
        } else {
            headerBuilder.setFixed(0, 20308, 21583);
        }
        headerBuilder.setuint16(4, tables.size());
        headerBuilder.setuint16(6, searchRange);
        headerBuilder.setuint16(8, entrySelector);
        headerBuilder.setuint16(10, rangeShift);
        long offset = headerSize;
        int headerOffset = 12;
        long fileChecksum = 0L;
        if (this.head != null) {
            Head.clearChecksumAdjust(headData);
        }
        for (Integer tag : tables.keySet()) {
            OTByteArray.OTByteArrayBuilder data = (OTByteArray.OTByteArrayBuilder)tables.get(tag);
            long tableChecksum = data.checksum(0, data.getSize(), 0L);
            fileChecksum = fileChecksum + tableChecksum & 0xFFFFFFFFL;
            headerBuilder.setuint32(headerOffset, tag);
            headerBuilder.setuint32(headerOffset + 4, (int)tableChecksum);
            headerBuilder.setuint32(headerOffset + 8, (int)offset);
            headerBuilder.setuint32(headerOffset + 12, data.getSize());
            headerOffset += 16;
            offset += (long)data.getSize();
            if (data.getSize() % 4 == 0) continue;
            offset += (long)(4 - data.getSize() % 4);
        }
        fileChecksum = fileChecksum + headerBuilder.checksum(0, headerBuilder.getSize(), 0L) & 0xFFFFFFFFL;
        long checksumAdjust = 2981146554L - fileChecksum & 0xFFFFFFFFL;
        Head.setChecksumAdjust(headData, checksumAdjust);
        OTByteArray header = headerBuilder.toOTByteArray();
        header.write(out);
        for (Integer tag : tables.keySet()) {
            OTByteArray.OTByteArrayBuilder builder = (OTByteArray.OTByteArrayBuilder)tables.get(tag);
            OTByteArray data = builder.toOTByteArray();
            data.write(out);
            if (data.getSize() % 4 == 0) continue;
            int pad = (data.getSize() / 4 + 1) * 4 - data.getSize();
            for (int k = 0; k < pad; ++k) {
                out.write(0);
            }
        }
    }

    public void subsetAndStreamForSWFEmbedding(Subset subset, OutputStream out, TreeMap<Integer, List> gsubLookups, TreeSet cmapData, boolean includeVariationCmap) throws InvalidFontException, UnsupportedFontException, IOException {
        TreeMap tables = new TreeMap();
        TreeMap gposLookups = new TreeMap();
        if (this.hmtx != null) {
            this.hmtx.subsetAndStream(subset, tables);
        }
        if (this.hhea != null) {
            this.hhea.subsetAndStream(subset, tables);
        }
        if (this.os2 != null) {
            this.os2.subsetAndStream(subset, tables);
        }
        if (this.gsub != null) {
            this.gsub.subsetAndStream(subset, gsubLookups, tables, this.getNumGlyphs());
        }
        if (this.kern != null) {
            this.kern.subsetAndStreamForSWF(subset, tables);
        }
        if (this.gpos != null) {
            GposHarvester harvester = new GposHarvester(this.gpos, this.getNumGlyphs());
            gposLookups = harvester.gatherPossibleLookups(subset);
            this.gpos.subsetAndStream(subset, gposLookups, tables, this.getNumGlyphs(), tables.containsKey(new Integer(1801810542)));
        }
        if (this.gdef != null) {
            this.gdef.subsetAndStream(subset, this.getNumGlyphs(), tables);
        }
        if (this.base != null) {
            this.base.subsetAndStream(subset, tables);
        }
        if (this.cff != null) {
            this.cff.subsetAndStream(subset, tables, false, null, true);
        } else if (this.glyf != null) {
            this.glyf.subsetAndStreamForCFF(subset, this, tables, true);
        } else {
            throw new InvalidFontException("Either cff or glyf must be present");
        }
        if (this.vmtx != null) {
            Vorg.subsetAndStream(subset, tables, this.vorg != null ? this.vorg : new NoVORGVertOrigFetcher(this));
        }
        if (this.cmap != null) {
            this.cmap.subsetAndStreamForSWF(cmapData, subset, tables, includeVariationCmap);
        }
        if (this.name != null) {
            this.name.subsetAndStream(subset, false, null, tables);
        }
        if (this.maxp != null) {
            if (this.cff != null) {
                this.maxp.subsetAndStream(subset, tables);
            } else {
                this.maxp.subsetAndStreamForCFF(subset.getNumGlyphs(), tables);
            }
        }
        if (this.post != null) {
            if (this.cff != null) {
                this.post.stream(tables);
            } else {
                this.post.subsetAndStreamForCFF(tables);
            }
        }
        if (this.vhea != null) {
            this.vhea.subsetAndStream(subset, tables);
        }
        if (this.vmtx != null) {
            this.vmtx.subsetAndStream(subset, tables);
        }
        OTByteArray.OTByteArrayBuilder headData = null;
        if (this.head != null) {
            headData = this.head.subsetAndStream(subset, tables);
        }
        this.finalizeStreamData(headData, tables, out, false);
    }

    private void subsetAndStream(Subset subset, SubsetSimpleTrueType ttSubset, OutputStream out, boolean preserveROS) throws InvalidFontException, UnsupportedFontException, IOException {
        if (this.cff != null) {
            this.cff.subsetAndStream(subset, out, preserveROS, this.os2 != null ? new Integer(this.os2.getRawFSType()) : null);
            return;
        }
        if (this.glyf == null) {
            throw new InvalidFontException("cff or glyf table required");
        }
        TreeMap tables = new TreeMap();
        if (this.hmtx != null) {
            this.hmtx.subsetAndStream(subset, tables);
        }
        if (this.hhea != null) {
            this.hhea.subsetAndStream(subset, tables);
        }
        if (this.maxp != null) {
            this.maxp.subsetAndStream(subset, tables);
        }
        if (this.os2 != null) {
            this.os2.subsetAndStream(subset, tables);
        }
        this.glyf.subsetAndStream(subset, tables);
        if (this.name != null) {
            this.name.subsetAndStream(subset, true, null, tables);
        }
        if (this.cmap != null) {
            this.cmap.subsetAndStream(subset, ttSubset, tables);
        }
        if (this.post != null) {
            this.post.subsetAndStream(subset, ttSubset, tables);
        }
        if (this.cvt != null) {
            this.cvt.subsetAndStream(subset, tables);
        }
        if (this.fpgm != null) {
            this.fpgm.subsetAndStream(subset, tables);
        }
        if (this.prep != null) {
            this.prep.subsetAndStream(subset, tables);
        }
        OTByteArray.OTByteArrayBuilder headData = null;
        if (this.head != null) {
            headData = this.head.subsetAndStream(subset, tables);
        }
        this.finalizeStreamData(headData, tables, out, true);
    }

    @Override
    public CacheSupportInfo getCacheSupportInfo() throws InvalidFontException, UnsupportedFontException {
        return new CacheSupportInfo(this.getClass().getSimpleName(), this.getNumGlyphs(), this.cff != null);
    }

    @Override
    public PostscriptFontDescription[] getPostscriptFontDescription() throws InvalidFontException, UnsupportedFontException {
        if (this.base14PSName != null) {
            PostscriptFontDescription[] retVal = new PostscriptFontDescription[]{new PostscriptFontDescription(this.base14PSName)};
            return retVal;
        }
        if (this.name == null) {
            if (this.cff != null) {
                return this.cff.cffFont.getPostscriptFontDescription();
            }
            return new PostscriptFontDescription[0];
        }
        Set s = this.name.getPostscriptNames();
        int numEntries = s.size();
        PostscriptFontDescription[] retVal = new PostscriptFontDescription[numEntries];
        Iterator iter = s.iterator();
        for (int i = 0; i < numEntries; ++i) {
            retVal[i] = new PostscriptFontDescription((String)iter.next());
        }
        return retVal;
    }

    @Override
    public Set getCSSFamilyNames() throws InvalidFontException, UnsupportedFontException {
        if (this.base14CSSName != null) {
            HashSet<String> s = new HashSet<String>();
            s.add(this.base14CSSName);
            return s;
        }
        if (this.name != null) {
            return this.name.getCSSFamilyNames();
        }
        return new HashSet();
    }

    @Override
    public String getPreferredCSSFamilyName() throws InvalidFontException, UnsupportedFontException {
        if (this.base14CSSName != null) {
            return this.base14CSSName;
        }
        if (this.name != null) {
            return this.name.getPreferredCSSFamilyName();
        }
        return null;
    }

    @Override
    public boolean isCSSStyleNormal() throws InvalidFontException, UnsupportedFontException {
        return this.os2 == null || (this.os2.getSelection() & 1) == 0 || this.gsub != null && this.gsub.featureIsPresent(Tag.feature_ital);
    }

    @Override
    public boolean isCSSStyleItalic() throws InvalidFontException, UnsupportedFontException {
        return this.os2 != null && (this.os2.getSelection() & 1) != 0 || this.gsub != null && this.gsub.featureIsPresent(Tag.feature_ital);
    }

    @Override
    public boolean isCSSStyleOblique() throws InvalidFontException, UnsupportedFontException {
        return this.isCSSStyleItalic();
    }

    @Override
    public boolean isCSSVariantNormal() {
        return true;
    }

    @Override
    public boolean isCSSVariantSmallCaps() {
        return true;
    }

    @Override
    public int getCSSWeight() throws InvalidFontException {
        if (this.os2 != null) {
            return this.os2.getWeightClass();
        }
        return 400;
    }

    @Override
    protected CSS20Attribute.CSSStretchValue getCSSStretchValue() throws InvalidFontException {
        if (this.os2 != null) {
            switch (this.os2.getWidthClass()) {
                case 1: {
                    return CSS20Attribute.CSSStretchValue.ULTRACONDENSED;
                }
                case 2: {
                    return CSS20Attribute.CSSStretchValue.EXTRACONDENSED;
                }
                case 3: {
                    return CSS20Attribute.CSSStretchValue.CONDENSED;
                }
                case 4: {
                    return CSS20Attribute.CSSStretchValue.SEMICONDENSED;
                }
                case 5: {
                    return CSS20Attribute.CSSStretchValue.NORMAL;
                }
                case 6: {
                    return CSS20Attribute.CSSStretchValue.SEMIEXPANDED;
                }
                case 7: {
                    return CSS20Attribute.CSSStretchValue.EXPANDED;
                }
                case 8: {
                    return CSS20Attribute.CSSStretchValue.EXTRAEXPANDED;
                }
                case 9: {
                    return CSS20Attribute.CSSStretchValue.ULTRAEXPANDED;
                }
            }
        }
        return CSS20Attribute.CSSStretchValue.NORMAL;
    }

    @Override
    public FXGFontDescription[] getFXGFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException {
        ArrayList<FXGFontDescription> fxgDescriptions = new ArrayList<FXGFontDescription>();
        if (this.name != null) {
            Set macFamilyNames = null;
            if (platform == null || platform == Platform.MAC_OSX) {
                macFamilyNames = this.name.getMacFXGFamilyNames(locale);
            }
            Set winFamilyNames = null;
            if ((platform == null || platform == Platform.WINDOWS) && this.os2 != null) {
                winFamilyNames = this.name.getWindowsFXGFamilyNames(locale);
            }
            if (macFamilyNames != null) {
                for (Name.NameEntry name : macFamilyNames) {
                    ULocale uLocale = Name.getLocaleForLocaleID(name.getPlatformID(), name.getLanguage());
                    String familyName = name.getName();
                    if (uLocale == null || familyName == null) continue;
                    fxgDescriptions.add(new FXGFontDescription(Platform.MAC_OSX, uLocale, familyName, false, false));
                }
            }
            if (winFamilyNames != null) {
                Iterator namesIter = winFamilyNames.iterator();
                int selectionBits = this.os2.getSelection();
                while (namesIter.hasNext()) {
                    Name.NameEntry name = (Name.NameEntry)namesIter.next();
                    ULocale uLocale = Name.getLocaleForLocaleID(name.getPlatformID(), name.getLanguage());
                    String familyName = name.getName();
                    if (uLocale == null || familyName == null) continue;
                    fxgDescriptions.add(new FXGFontDescription(Platform.WINDOWS, uLocale, familyName, (selectionBits & 0x20) > 0, (selectionBits & 1) > 0));
                }
            }
        }
        if (this.fond != null) {
            ULocale fondLocale = this.fond.getLocale();
            if ((platform == Platform.MAC_OSX || platform == null) && Name.NameEntrySet.isContainedWithin(fondLocale, locale)) {
                FXGFontDescription fxgDesc = new FXGFontDescription(Platform.MAC_OSX, fondLocale, this.fond.getName(), this.fond.isBold(), this.fond.isItalic());
                String fxgDescStr = fxgDesc.toString();
                for (FXGFontDescription desc : fxgDescriptions) {
                    if (!desc.toString().equals(fxgDescStr)) continue;
                    fxgDesc = null;
                    break;
                }
                if (fxgDesc != null) {
                    fxgDescriptions.add(fxgDesc);
                }
            }
        }
        return fxgDescriptions.toArray(new FXGFontDescription[fxgDescriptions.size()]);
    }

    @Override
    public PlatformFontDescription[] getPlatformFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException {
        String familyName;
        ULocale uLocale;
        if (this.name == null) {
            return new PlatformFontDescription[0];
        }
        Set macFamilyNames = null;
        if (platform == null || platform == Platform.MAC_OSX) {
            macFamilyNames = this.name.getMacPlatformNames(locale);
        }
        Set winFamilyNames = null;
        if (platform == null || platform == Platform.WINDOWS) {
            winFamilyNames = this.name.getWindowsPlatformNames(locale);
        }
        ArrayList<PlatformFontDescription> platformDescriptions = new ArrayList<PlatformFontDescription>();
        if (macFamilyNames != null) {
            for (Name.NameEntry name : macFamilyNames) {
                uLocale = Name.getLocaleForLocaleID(name.getPlatformID(), name.getLanguage());
                familyName = name.getName();
                if (uLocale == null || familyName == null) continue;
                platformDescriptions.add(new PlatformFontDescription(Platform.MAC_OSX, uLocale, familyName));
            }
        }
        if (winFamilyNames != null) {
            for (Name.NameEntry name : winFamilyNames) {
                uLocale = Name.getLocaleForLocaleID(name.getPlatformID(), name.getLanguage());
                familyName = name.getName();
                if (uLocale == null || familyName == null) continue;
                platformDescriptions.add(new PlatformFontDescription(Platform.WINDOWS, uLocale, familyName));
            }
        }
        return platformDescriptions.toArray(new PlatformFontDescription[platformDescriptions.size()]);
    }

    public OpticalSizeData getOpticalSizeData() throws InvalidFontException {
        if (this.gpos == null) {
            return null;
        }
        OpticalSizeData osd = this.gpos.getOpticalSizeData(false);
        if (osd == null) {
            return null;
        }
        boolean plausible = osd.designSize == 0 ? false : (osd.subfamilyId == 0 && osd.nameId == 0 && osd.minSize == 0 && osd.maxSize == 0 ? true : osd.designSize >= osd.minSize && osd.maxSize >= osd.designSize && osd.nameId >= 256 && osd.nameId <= Short.MAX_VALUE && (this.name == null || this.name.getName(-1, osd.nameId) != null));
        if (!plausible) {
            osd = this.gpos.getOpticalSizeData(true);
        }
        return osd;
    }

    @Override
    public double[] getPointSizeRange() throws InvalidFontException {
        OpticalSizeData osd = this.getOpticalSizeData();
        if (osd == null || osd.subfamilyId == 0) {
            return new double[]{0.0, Double.POSITIVE_INFINITY};
        }
        return new double[]{osd.minSize, osd.maxSize};
    }

    private String getVersion() throws InvalidFontException, UnsupportedFontException {
        int end;
        int start;
        String version = null;
        try {
            if (this.name == null) {
                return "";
            }
            version = this.name.getName(3, 1, 1033, 5);
            if (version == null) {
                version = this.name.getName(3, 0, 1033, 5);
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (version == null) {
            return "";
        }
        for (start = 0; start < version.length() && (version.charAt(start) < '0' || '9' < version.charAt(start)); ++start) {
        }
        for (end = start; end < version.length() && '0' <= version.charAt(end) && version.charAt(end) <= '9'; ++end) {
        }
        if (start == end) {
            return version;
        }
        if (end < version.length() && '.' == version.charAt(end)) {
            ++end;
            while (end < version.length() && '0' <= version.charAt(end) && version.charAt(end) <= '9') {
                ++end;
            }
        }
        return version.substring(start, end);
    }

    @Override
    public CatalogDescription getSelectionDescription() throws InvalidFontException, UnsupportedFontException {
        final HashSet<String> names = new HashSet<String>();
        if (this.name != null) {
            NameConsumer ncWindows = new NameConsumer(){

                public boolean nameFound(String n, int nameID, int platformID, int encodingId, int languageId) throws InvalidFontException, UnsupportedFontException {
                    String style = null;
                    try {
                        style = OpenTypeFont.this.name.getName(platformID, encodingId, languageId, 2);
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    if (style == null) {
                        style = "Regular";
                    }
                    n = n + ", " + style;
                    if (this.bestName == null || languageId == Name.MicrosoftLCID.ENGLISH_UNITED_STATES.getLanguageCode()) {
                        this.bestName = n;
                        this.bestNameLanguage = languageId;
                    }
                    names.add(n);
                    return false;
                }
            };
            this.name.enumerateNames(ncWindows, 1);
            NameConsumer ncPreferred = new NameConsumer(){

                public boolean nameFound(String n, int nameID, int platformId, int encodingId, int languageId) throws InvalidFontException, UnsupportedFontException {
                    String style = null;
                    try {
                        style = OpenTypeFont.this.name.getName(platformId, encodingId, languageId, 17);
                        if (style == null) {
                            style = OpenTypeFont.this.name.getName(platformId, encodingId, languageId, 2);
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    if (style == null) {
                        style = "Regular";
                    }
                    names.add(n + ", " + style);
                    return false;
                }
            };
            this.name.enumerateNames(ncPreferred, 16);
            String bestName = ncPreferred.bestName != null ? ncPreferred.bestName : ncWindows.bestName;
            return new CatalogDescription("OT", names, bestName, this.getVersion());
        }
        names.add("<no name table>");
        return new CatalogDescription("OT", names, "<no best name>", "<no version>");
    }

    @Override
    public Rect getCoolTypeGlyphBBox(int glyphID) throws UnsupportedFontException, InvalidFontException {
        if (this.cff != null) {
            return this.getGlyphBBox(glyphID);
        }
        TrueTypeGlyphBBoxCalculator calculator = new TrueTypeGlyphBBoxCalculator(true, 1000);
        Rect bbox = calculator.calculateBBox(this, glyphID);
        Rect retVal = new Rect(bbox.xmin * this.getUnitsPerEmX() / 1000.0, bbox.ymin * this.getUnitsPerEmX() / 1000.0, bbox.xmax * this.getUnitsPerEmX() / 1000.0, bbox.ymax * this.getUnitsPerEmX() / 1000.0);
        return retVal;
    }

    public CFFFont getCFFFont() {
        if (this.cff == null) {
            return null;
        }
        return this.cff.getCFFFont();
    }

    static class NameConsumer
    implements Name.NameSelector {
        public String bestName;
        public int bestNameLanguage;

        NameConsumer() {
        }

        public boolean nameFound(String name, int nameID, int platformID, int encodingID, int languageID) throws InvalidFontException, UnsupportedFontException {
            return false;
        }
    }

    private class OTXDCFontDescription
    extends XDCFontDescription {
        private OTXDCFontDescription() {
        }

        public int getGlyphCid(int glyphID) throws UnsupportedFontException, InvalidFontException {
            return OpenTypeFont.this.getGlyphCid(glyphID);
        }

        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            PostscriptFontDescription[] descs;
            if (this.getBase14Name() != null) {
                return this.getBase14Name();
            }
            if (OpenTypeFont.this.name != null) {
                SinglePostscriptName s = new SinglePostscriptName();
                OpenTypeFont.this.name.enumerateNames(s, 6);
                if (s.getSelection() != null) {
                    return s.getSelection();
                }
            }
            if (OpenTypeFont.this.cff != null && (descs = OpenTypeFont.this.cff.getCFFFont().getPostscriptFontDescription()).length != 0) {
                return descs[0].getPSName();
            }
            return null;
        }

        public String getFontFamily() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.name == null) {
                return null;
            }
            SingleFamilyName s = new SingleFamilyName();
            OpenTypeFont.this.name.enumerateNames(s, OpenTypeFont.this.name.selectFamilyNameId());
            return s.getSelection();
        }

        public int getNumGlyphs() throws UnsupportedFontException, InvalidFontException {
            return OpenTypeFont.this.getNumGlyphs();
        }

        public double getAdvance(int glyphID) throws InvalidFontException, UnsupportedFontException {
            return OpenTypeFont.this.getHorizontalAdvance(glyphID) * 1000.0 / OpenTypeFont.this.getUnitsPerEmX();
        }

        public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.head == null) {
                return null;
            }
            Rect b = OpenTypeFont.this.head.getFontBBox();
            int unitsPerEm = OpenTypeFont.this.head.getUnitsPerEm();
            return new Rect(b.xmin * 1000.0 / (double)unitsPerEm, b.ymin * 1000.0 / (double)unitsPerEm, b.xmax * 1000.0 / (double)unitsPerEm, b.ymax * 1000.0 / (double)unitsPerEm);
        }

        public double getCapHeight() throws UnsupportedFontException, InvalidFontException {
            double capHeight = OpenTypeFont.this.getCoolTypeCapHeight();
            if (Double.isNaN(capHeight)) {
                return 0.0;
            }
            return capHeight * (1000.0 / OpenTypeFont.this.getUnitsPerEmY());
        }

        public double getXHeight() throws UnsupportedFontException, InvalidFontException {
            double xHeight = OpenTypeFont.this.getCoolTypeXHeight();
            if (Double.isNaN(xHeight)) {
                return 0.0;
            }
            return xHeight * (1000.0 / OpenTypeFont.this.getUnitsPerEmY());
        }

        public double getItalicAngle() throws InvalidFontException {
            double angle = 0.0;
            if (OpenTypeFont.this.hhea == null) {
                return 0.0;
            }
            int rise = OpenTypeFont.this.hhea.getRise();
            int run = OpenTypeFont.this.hhea.getRun();
            if (rise != 0 && run != 0) {
                angle = Math.atan((double)(-run) / (double)rise) / Math.PI * 180.0;
                if (run < 0) {
                    angle += 180.0;
                }
            }
            return angle;
        }

        public ROS getROS() throws UnsupportedFontException, InvalidFontException {
            if (OpenTypeFont.this.cff != null) {
                return OpenTypeFont.this.getROS();
            }
            return null;
        }

        public boolean pdfFontIsTrueType() {
            return OpenTypeFont.this.cff == null;
        }

        private double calculateTTStemV() throws UnsupportedFontException, InvalidFontException {
            double control;
            StemFinder finder = new StemFinder(true, true);
            TTParser parser = new TTParser();
            int gidh = OpenTypeFont.this.getGlyphForChar(104);
            int gidl = OpenTypeFont.this.getGlyphForChar(108);
            int gid1 = OpenTypeFont.this.getGlyphForChar(49);
            int gid4 = OpenTypeFont.this.getGlyphForChar(52);
            double stemComputed = 0.0;
            double italicAngle = this.getItalicAngle();
            if (gidl != 0) {
                finder.reset();
                parser.parse(OpenTypeFont.this, gidl, finder);
                stemComputed = finder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(gidl), italicAngle);
            }
            if (gidh != 0) {
                finder.reset();
                parser.parse(OpenTypeFont.this, gidh, finder);
                control = finder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(gidh), italicAngle);
                if (stemComputed == 0.0 || control < stemComputed && control != 0.0 && stemComputed - control > 20.0 && stemComputed - control < 70.0) {
                    stemComputed = control;
                }
            }
            if (stemComputed == 0.0 && gid1 != 0) {
                finder.reset();
                parser.parse(OpenTypeFont.this, gid1, finder);
                stemComputed = finder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(gid1), italicAngle);
                if (stemComputed == 0.0 && gid4 != 0) {
                    finder.reset();
                    parser.parse(OpenTypeFont.this, gid4, finder);
                    stemComputed = finder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(gid4), italicAngle);
                } else if (gid4 != 0) {
                    finder.reset();
                    parser.parse(OpenTypeFont.this, gid4, finder);
                    control = finder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(gid4), italicAngle);
                    if (control != 0.0 && stemComputed - control > 50.0) {
                        stemComputed = control;
                    }
                }
            } else if (gid1 != 0) {
                finder.reset();
                parser.parse(OpenTypeFont.this, gid1, finder);
                control = finder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(gid1), italicAngle);
                if (control != 0.0 && stemComputed - control > 50.0) {
                    stemComputed = control;
                }
            }
            return stemComputed;
        }

        public double getStemV() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.cff != null) {
                int glyphID = OpenTypeFont.this.getGlyphForChar(108);
                if (glyphID == 0) {
                    glyphID = OpenTypeFont.this.getGlyphForChar(73);
                }
                if (glyphID == 0) {
                    return 0.0;
                }
                return OpenTypeFont.this.cff.getCFFFont().getStemVForGlyph(glyphID);
            }
            return this.calculateTTStemV();
        }

        public String getBase14Name() {
            return OpenTypeFont.this.base14PSName;
        }

        public String getGlyphName(int gid) throws InvalidFontException, UnsupportedFontException {
            return OpenTypeFont.this.getGlyphName(gid);
        }

        public boolean isSerifFont() throws InvalidFontException, UnsupportedFontException {
            int gid1 = OpenTypeFont.this.getGlyphForChar(108);
            int gid2 = OpenTypeFont.this.getGlyphForChar(73);
            return OpenTypeFont.this.isSerifFont(gid1, gid2, this.getItalicAngle());
        }

        public boolean isSmallCapFont() throws InvalidFontException, UnsupportedFontException {
            if (!this.isAllCapFont()) {
                double xHeight;
                int gid1 = OpenTypeFont.this.getGlyphForChar(104);
                int gid2 = OpenTypeFont.this.getGlyphForChar(120);
                if (gid2 != 0) {
                    xHeight = OpenTypeFont.this.getGlyphBBox((int)gid2).ymax;
                } else if (OpenTypeFont.this.os2 != null) {
                    xHeight = OpenTypeFont.this.os2.getxHeight();
                } else {
                    return false;
                }
                return OpenTypeFont.this.isSmallCapFont(gid1, xHeight);
            }
            return false;
        }

        public boolean isAllCapFont() throws InvalidFontException, UnsupportedFontException {
            int gid1 = OpenTypeFont.this.getGlyphForChar(75);
            int gid2 = OpenTypeFont.this.getGlyphForChar(107);
            return OpenTypeFont.this.isAllCapFont(gid1, gid2);
        }

        public int getCIDCount() {
            return OpenTypeFont.this.getCIDCount();
        }

        public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS) throws InvalidFontException, UnsupportedFontException, IOException {
            OpenTypeFont.this.subsetAndStream(subset, out, preserveROS);
        }

        public void subsetAndStream(SubsetSimpleType1 t1Subset, OutputStream out) throws InvalidFontException, UnsupportedFontException, IOException {
            if (OpenTypeFont.this.cff == null || !(OpenTypeFont.this.cff.getCFFFont() instanceof NameKeyedFont)) {
                throw new UnsupportedFontException("Not a name-keyed font");
            }
            NameKeyedFont nk = (NameKeyedFont)OpenTypeFont.this.cff.getCFFFont();
            NameKeyedSubset subset = (NameKeyedSubset)nk.createSubset();
            subset.addGlyphs(nk, t1Subset.getGlyphNames());
            nk.subsetAndStream((Subset)subset, out, OpenTypeFont.this.os2 != null ? new Integer(OpenTypeFont.this.os2.getRawFSType()) : null, true, null);
        }

        public void subsetAndStream(SubsetSimpleTrueType ttSubset, OutputStream out) throws InvalidFontException, UnsupportedFontException, IOException {
            int platSpecID;
            if (OpenTypeFont.this.cff != null) {
                throw new UnsupportedFontException("Not a TrueType font");
            }
            if (OpenTypeFont.this.cmap == null) {
                throw new UnsupportedFontException("Font contains no cmaps");
            }
            int platformID = ttSubset.getPlatformID();
            int index = OpenTypeFont.this.cmap.offsetToIndex(OpenTypeFont.this.cmap.probe(platformID, platSpecID = ttSubset.getPlatformSpecificID()));
            if (index < 0) {
                throw new InvalidFontException("Invalid cmap ID");
            }
            Subset subset = OpenTypeFont.this.createSubset();
            int[] cps = ttSubset.getCodePoints();
            for (int i = 0; i < cps.length; ++i) {
                int gid = OpenTypeFont.this.cmap.char2glyph(cps[i], index);
                if (gid >= this.getNumGlyphs()) {
                    throw new InvalidFontException("GID greater than glyph count");
                }
                if (gid <= 0) {
                    throw new InvalidFontException("Font does not contain required codepoint");
                }
                subset.getSubsetGid(gid);
            }
            String[] postNames = ttSubset.getPostNames();
            if (postNames != null) {
                for (int i = 0; i < postNames.length; ++i) {
                    String glyphName = postNames[i];
                    if (glyphName == null) continue;
                    int gid = 0;
                    if (OpenTypeFont.this.post != null) {
                        gid = OpenTypeFont.this.post.glyphName2gid(glyphName);
                    }
                    if (gid >= this.getNumGlyphs()) {
                        throw new InvalidFontException("GID greater than glyph count");
                    }
                    if (gid <= 0 && !glyphName.equals(".notdef")) {
                        throw new InvalidFontException("Font does not contain required codepoint");
                    }
                    subset.getSubsetGid(gid);
                }
            }
            OpenTypeFont.this.subsetAndStream(subset, ttSubset, out, false);
        }

        public CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException {
            int index;
            HashSet<CodePage> codePageSet = new HashSet<CodePage>();
            CoolTypeScript script = OpenTypeFont.this.getCoolTypeScript();
            if (script == CoolTypeScript.ROMAN) {
                if (OpenTypeFont.this.cmap != null && (index = OpenTypeFont.this.getCoolTypeUnicodeCmapIndex()) != -1 && OpenTypeFont.this.cmap.char2glyph(65, index) != 0) {
                    codePageSet.add(CodePage.ROMAN1);
                }
            } else if (script == CoolTypeScript.EAST_EUROPEAN_ROMAN) {
                codePageSet.add(CodePage.ROMAN2);
            } else if (script == CoolTypeScript.JAPANESE) {
                codePageSet.add(CodePage.JAPANESE);
            } else if (script == CoolTypeScript.KOREAN) {
                codePageSet.add(CodePage.KOREAN);
            } else if (script == CoolTypeScript.SIMPLIFIED_CHINESE) {
                codePageSet.add(CodePage.SIMPLIFIED_CHINESE);
            } else if (script == CoolTypeScript.TRADITIONAL_CHINESE) {
                codePageSet.add(CodePage.TRADITIONAL_CHINESE);
            }
            if (OpenTypeFont.this.os2 != null && OpenTypeFont.this.os2.getTableVersion() > 0) {
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_1252_LATIN_1)) {
                    codePageSet.add(CodePage.ROMAN1);
                }
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_1250_LATIN_2_EE)) {
                    codePageSet.add(CodePage.ROMAN2);
                }
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_932_JAPANESE)) {
                    codePageSet.add(CodePage.JAPANESE);
                }
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_949_KOREAN_WANSUNG)) {
                    codePageSet.add(CodePage.KOREAN);
                }
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_936_CHINESE_SIMPLIFIED)) {
                    codePageSet.add(CodePage.SIMPLIFIED_CHINESE);
                }
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_950_CHINESE_TRADITIONAL)) {
                    codePageSet.add(CodePage.TRADITIONAL_CHINESE);
                }
            } else {
                if (OpenTypeFont.this.cff != null) {
                    CodePage[] cffList = OpenTypeFont.this.cff.getCFFFont().getXDCFontDescription(null).getXDCCodePages();
                    for (int i = 0; i < cffList.length; ++i) {
                        codePageSet.add(cffList[i]);
                    }
                }
                if (OpenTypeFont.this.cmap != null && (index = OpenTypeFont.this.getCoolTypeUnicodeCmapIndex()) >= 0) {
                    if (OpenTypeFont.this.cmap.char2glyph(234, index) != 0) {
                        codePageSet.add(CodePage.ROMAN1);
                    }
                    if (OpenTypeFont.this.cmap.char2glyph(268, index) != 0 || OpenTypeFont.this.cmap.char2glyph(328, index) != 0) {
                        codePageSet.add(CodePage.ROMAN2);
                    }
                    if (OpenTypeFont.this.cmap.char2glyph(12450, index) != 0) {
                        codePageSet.add(CodePage.JAPANESE);
                    }
                }
            }
            CodePage[] retVal = new CodePage[codePageSet.size()];
            Iterator iter = codePageSet.iterator();
            int index2 = 0;
            while (iter.hasNext()) {
                retVal[index2++] = (CodePage)iter.next();
            }
            return retVal;
        }

        public void stream(OutputStream out, boolean openTypeFontsAllowed) throws InvalidFontException, UnsupportedFontException, IOException {
            if (openTypeFontsAllowed || OpenTypeFont.this.cff == null) {
                OpenTypeFont.this.streamSFNTForPDFEditting(out);
            } else {
                OpenTypeFont.this.cff.getCFFFont().stream(out, OpenTypeFont.this.os2 != null ? new Integer(OpenTypeFont.this.os2.getRawFSType()) : null);
            }
        }
    }

    static class SinglePostscriptName
    extends SingleNameSelector {
        SinglePostscriptName() {
        }

        public boolean nameFound(String name, int nameID, int platformID, int encoding, int language) {
            if (name == null || name.length() == 0 || name.charAt(0) == '\u0000') {
                return false;
            }
            if (this.currentPlatformID == -1) {
                this.currentSelection = name;
                this.currentPlatformID = platformID;
                this.currentEncoding = encoding;
                this.currentLanguage = language;
                return false;
            }
            if (this.currentPlatformID == 3 && platformID == 1 && (this.currentLanguage == Name.MicrosoftLCID.ENGLISH_UNITED_STATES.getLanguageCode() || encoding != 0) || this.currentPlatformID == 1 && platformID == 3 && language != Name.MicrosoftLCID.ENGLISH_UNITED_STATES.getLanguageCode() && this.currentEncoding == 0) {
                return false;
            }
            if (this.currentPlatformID != platformID) {
                this.currentSelection = name;
                this.currentPlatformID = platformID;
                this.currentEncoding = encoding;
                this.currentLanguage = language;
                return false;
            }
            if (this.currentPlatformID == 3) {
                if (this.pickMSLanguage(language)) {
                    this.currentSelection = name;
                    this.currentPlatformID = platformID;
                    this.currentEncoding = encoding;
                    this.currentLanguage = language;
                }
                return false;
            }
            if (this.pickMacName(encoding)) {
                this.currentSelection = name;
                this.currentPlatformID = platformID;
                this.currentEncoding = encoding;
                this.currentLanguage = language;
            }
            return false;
        }

        String getSelection() {
            return this.currentSelection;
        }
    }

    static class SingleFamilyName
    extends SingleNameSelector {
        SingleFamilyName() {
        }

        protected boolean pickMSName(int encoding, int language) {
            if (this.currentEncoding == encoding) {
                return this.pickMSLanguage(language);
            }
            if (this.currentEncoding == 10) {
                return false;
            }
            if (encoding == 10) {
                return true;
            }
            if (this.currentEncoding == 1) {
                return false;
            }
            return encoding == 1;
        }

        public boolean nameFound(String name, int nameID, int platformID, int encoding, int language) {
            if (name == null || name.length() == 0 || name.charAt(0) == '\u0000') {
                return false;
            }
            if (this.currentPlatformID == -1) {
                this.currentSelection = name;
                this.currentPlatformID = platformID;
                this.currentEncoding = encoding;
                this.currentLanguage = language;
                return false;
            }
            if (this.currentPlatformID == 3 && platformID == 1) {
                return false;
            }
            if (platformID == 3 && this.currentPlatformID == 1) {
                this.currentSelection = name;
                this.currentPlatformID = platformID;
                this.currentEncoding = encoding;
                this.currentLanguage = language;
                return false;
            }
            if (this.currentPlatformID == 3) {
                if (this.pickMSName(encoding, language)) {
                    this.currentSelection = name;
                    this.currentPlatformID = platformID;
                    this.currentEncoding = encoding;
                    this.currentLanguage = language;
                }
                return false;
            }
            if (this.pickMacName(encoding)) {
                this.currentSelection = name;
                this.currentPlatformID = platformID;
                this.currentEncoding = encoding;
                this.currentLanguage = language;
            }
            return false;
        }

        String getSelection() {
            return this.currentSelection;
        }
    }

    static abstract class SingleNameSelector
    implements Name.NameSelector {
        protected String currentSelection = null;
        protected int currentPlatformID = -1;
        protected int currentEncoding;
        protected int currentLanguage;

        SingleNameSelector() {
        }

        protected boolean pickMSLanguage(int language) {
            return this.currentLanguage != Name.MicrosoftLCID.ENGLISH_UNITED_STATES.getLanguageCode() && language == Name.MicrosoftLCID.ENGLISH_UNITED_STATES.getLanguageCode();
        }

        protected boolean pickMacName(int encoding) {
            return encoding == 0 && this.currentEncoding != 0;
        }
    }

    private class ScriptFromCmapSelector
    implements Cmap.CmapSelector {
        int macCount = 0;
        int msCount = 0;
        CoolTypeScript macScript = null;
        CoolTypeScript msScript = null;

        private ScriptFromCmapSelector() {
        }

        public void cmapFound(int platformID, int platformEncoding, int index) throws InvalidFontException, UnsupportedFontException {
            if (platformID == 1) {
                if (platformEncoding == 1) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.JAPANESE;
                } else if (platformEncoding == 2) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.TRADITIONAL_CHINESE;
                } else if (platformEncoding == 3) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.KOREAN;
                } else if (platformEncoding == 5) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.HEBREW;
                } else if (platformEncoding == 4) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.ARABIC;
                } else if (platformEncoding == 25) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.SIMPLIFIED_CHINESE;
                }
            } else if (platformID == 3) {
                if (platformEncoding == 2) {
                    ++this.msCount;
                    this.msScript = CoolTypeScript.JAPANESE;
                } else if (platformEncoding == 4) {
                    ++this.msCount;
                    this.msScript = CoolTypeScript.TRADITIONAL_CHINESE;
                } else if (platformEncoding == 3) {
                    ++this.msCount;
                    this.msScript = CoolTypeScript.SIMPLIFIED_CHINESE;
                } else if (platformEncoding == 6) {
                    ++this.msCount;
                    this.msScript = CoolTypeScript.KOREAN;
                } else if (platformEncoding == 5) {
                    ++this.msCount;
                    this.msScript = CoolTypeScript.KOREAN;
                }
            }
        }

        CoolTypeScript getScript() {
            if (this.macCount <= 1 && this.msCount <= 1) {
                if (this.msCount == 0) {
                    return this.macScript;
                }
                if (this.macCount == 0 || this.macScript == this.msScript) {
                    return this.msScript;
                }
            }
            return null;
        }
    }

    static interface ScriptHeuristicChars {
        public static final int ARABIC = 1570;
        public static final int CYRILLIC1 = 1071;
        public static final int CYRILLIC2 = 1105;
        public static final int EASTERNEUROPEAN1 = 268;
        public static final int EASTERNEUROPEAN2 = 328;
        public static final int EASTERNEUROPEAN3 = 371;
        public static final int GREEK = 971;
        public static final int HEBREW = 1488;
        public static final int JAPANESE = 12450;
        public static final int ROMAN1 = 328;
        public static final int ROMAN2 = 371;
        public static final int ROMAN3 = 234;
        public static final int THAI = 3585;
        public static final int VIETNAMESE = 8363;
    }
}

