/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.TTInterpreter;
import com.adobe.fontengine.font.opentype.TTOutline;
import com.adobe.fontengine.font.opentype.TTPoint;
import com.adobe.fontengine.font.opentype.TTSimpleOutline;
import com.adobe.fontengine.math.F26Dot6;
import com.adobe.fontengine.math.F26Dot6Vector;
import java.util.ArrayList;

public final class TTCompositeOutline
extends TTOutline {
    private TTComponent[] components;
    public TTSimpleOutline merged;
    private OTByteArray instructions;
    private int instructionsOffset;
    private int instructionsLength;
    private boolean isScaled = false;
    private boolean isInstructed = false;
    private int currentUnitsPerEm = -1;
    private Matrix currentEm2px = null;
    private int scanType;
    boolean isMerged = false;

    public TTCompositeOutline(ArrayList comps, int l, int r, int t, int b, OTByteArray instructions, int instructionsOffset, int instructionsLength) throws InvalidFontException {
        this.components = comps.toArray(new TTComponent[0]);
        this.instructions = instructions;
        this.instructionsOffset = instructionsOffset;
        this.instructionsLength = instructionsLength;
        this.merged = new TTSimpleOutline();
        this.merged.unscaledCoordinatesAreInvalid = true;
        int numCountours = 0;
        int numPoints = 0;
        for (int c = 0; c < this.components.length; ++c) {
            numCountours += this.components[c].outline.getNumContours();
            numPoints += this.components[c].outline.getNumOutlinePoints();
        }
        this.merged.contourEndPoints = new int[numCountours];
        this.merged.points = new TTPoint[numPoints + 4];
        this.merged.points[numPoints + 0] = new TTPoint(l, 0, false);
        this.merged.points[numPoints + 1] = new TTPoint(r, 0, false);
        this.merged.points[numPoints + 2] = new TTPoint(0, t, false);
        this.merged.points[numPoints + 3] = new TTPoint(0, b, false);
    }

    TTPoint getPoint(int index) throws InvalidGlyphException {
        return this.merged.getPoint(index);
    }

    int getNumOutlinePoints() throws InvalidGlyphException {
        return this.merged.getNumOutlinePoints();
    }

    int getNumContours() {
        return this.merged.getNumContours();
    }

    int getContourNextPoint(int contour, int index) throws InvalidGlyphException {
        return this.merged.getContourNextPoint(contour, index);
    }

    int getContourFirstPoint(int contour) throws InvalidGlyphException {
        return this.merged.getContourFirstPoint(contour);
    }

    int getContourLastPoint(int contour) throws InvalidGlyphException {
        return this.merged.getContourLastPoint(contour);
    }

    public TTSimpleOutline getMerged() {
        this.mergeComponents();
        return this.merged;
    }

    public void scale(int unitsPerEm, Matrix em2px) {
        int nbOutlinePoints;
        if (this.isScaled && this.currentUnitsPerEm == unitsPerEm && em2px.equals(this.currentEm2px)) {
            return;
        }
        for (int c = 0; c < this.components.length; ++c) {
            this.components[c].scale(unitsPerEm, em2px);
        }
        for (int i = nbOutlinePoints = this.merged.points.length - 4; i < nbOutlinePoints + 4; ++i) {
            this.merged.points[i].scale(unitsPerEm, em2px);
        }
        int width = F26Dot6.roundHalfUp(F26Dot6.fromDouble(em2px.applyToXYGetX((double)(this.merged.points[nbOutlinePoints + 1].unscaled.x - this.merged.points[nbOutlinePoints].unscaled.x) / (double)unitsPerEm, 0.0)));
        this.merged.points[nbOutlinePoints + 1].hinted.x = this.merged.points[nbOutlinePoints].hinted.x + width;
        this.merged.points[nbOutlinePoints + 2].hinted.y = F26Dot6.round(this.merged.points[nbOutlinePoints + 2].hinted.y);
        int height = F26Dot6.roundHalfUp(F26Dot6.fromDouble(em2px.applyToXYGetY(0.0, (double)(this.merged.points[nbOutlinePoints + 3].unscaled.y - this.merged.points[nbOutlinePoints + 2].unscaled.y) / (double)unitsPerEm)));
        this.merged.points[nbOutlinePoints + 3].hinted.y = this.merged.points[nbOutlinePoints + 2].hinted.y + height;
        this.isScaled = true;
        this.currentUnitsPerEm = unitsPerEm;
        this.currentEm2px = em2px;
        this.isInstructed = false;
    }

    public int getScanType() {
        return this.scanType;
    }

    public void instruct(TTInterpreter interpreter) throws InvalidGlyphException, UnsupportedFontException {
        if (this.isInstructed) {
            return;
        }
        for (int c = 0; c < this.components.length; ++c) {
            this.components[c].instruct(interpreter);
        }
        this.isMerged = false;
        this.mergeComponents();
        int roundedPosition = F26Dot6.roundHalfUp(this.merged.points[this.merged.points.length - 4].unhinted.x);
        this.shiftPoints(roundedPosition - this.merged.points[this.merged.points.length - 4].unhinted.x, 0, 0, this.merged.points.length);
        if (this.instructions != null) {
            interpreter.runGlyf(this.merged, this.instructions, this.instructionsOffset, this.instructionsOffset + this.instructionsLength);
            this.scanType = interpreter.getScanType();
        } else {
            this.scanType = 0;
        }
        this.isInstructed = true;
    }

    protected void mergeComponents() {
        if (this.isMerged) {
            return;
        }
        int k = 0;
        int p = 0;
        for (int c = 0; c < this.components.length; ++c) {
            int i;
            TTSimpleOutline src = this.components[c].outline.getMerged();
            for (i = 0; i < src.contourEndPoints.length; ++i) {
                this.merged.contourEndPoints[k] = src.contourEndPoints[i] + p;
                ++k;
            }
            for (i = 0; i < src.points.length - 4; ++i) {
                this.merged.points[p] = (TTPoint)src.points[i].clone();
                this.merged.points[p].hinted.x = F26Dot6.multiplyByF2Dot14(src.points[i].hinted.x, this.components[c].a) + F26Dot6.multiplyByF2Dot14(src.points[i].hinted.y, this.components[c].b);
                this.merged.points[p].hinted.y = F26Dot6.multiplyByF2Dot14(src.points[i].hinted.x, this.components[c].c) + F26Dot6.multiplyByF2Dot14(src.points[i].hinted.y, this.components[c].d);
                this.merged.points[p].hinted.x += this.components[c].offset.x;
                this.merged.points[p].hinted.y += this.components[c].offset.y;
                this.merged.points[p].unhinted.x = this.merged.points[p].hinted.x;
                this.merged.points[p].unhinted.y = this.merged.points[p].hinted.y;
                this.merged.points[p].original.x = F26Dot6.multiplyByF2Dot14(src.points[i].original.x, this.components[c].a) + F26Dot6.multiplyByF2Dot14(src.points[i].original.y, this.components[c].b);
                this.merged.points[p].original.y = F26Dot6.multiplyByF2Dot14(src.points[i].original.x, this.components[c].c) + F26Dot6.multiplyByF2Dot14(src.points[i].original.y, this.components[c].d);
                this.merged.points[p].original.x += this.components[c].offset.x;
                this.merged.points[p].original.y += this.components[c].offset.y;
                ++p;
            }
        }
        this.isMerged = true;
    }

    public void toConsumer(OutlineConsumer c) throws InvalidFontException {
        this.mergeComponents();
        this.merged.toConsumer(c);
    }

    public void toConsumer2(OutlineConsumer2 c) throws InvalidFontException {
        this.mergeComponents();
        this.merged.toConsumer2(c);
    }

    public void translate() {
        int roundedX = F26Dot6.roundHalfUp(this.merged.points[this.merged.points.length - 4].hinted.x);
        int roundedY = F26Dot6.roundHalfUp(this.merged.points[this.merged.points.length - 4].hinted.y);
        this.shiftPoints(-roundedX, -roundedY, 0, this.merged.points.length);
    }

    private void shiftPoints(int dx, int dy, int startingPoint, int numPoints) {
        for (int i = startingPoint; i < numPoints; ++i) {
            this.merged.points[i].hinted.x += dx;
            this.merged.points[i].hinted.y += dy;
        }
    }

    public static final class TTComponent {
        public TTOutline outline;
        public int argument1;
        public int argument2;
        public boolean alignByPosition;
        public boolean roundXYToGrid;
        public boolean useThisMetrics;
        public boolean scaledOffsets;
        public boolean unscaledOffset;
        public F26Dot6Vector offset;
        public int a;
        public int b;
        public int c;
        public int d;

        public void scale(int unitsPerEm, Matrix em2px) {
            if (this.alignByPosition) {
                int x = F26Dot6.fromDouble(em2px.applyToXYGetX((double)this.argument1 / (double)unitsPerEm, 0.0));
                int y = F26Dot6.fromDouble(em2px.applyToXYGetY(0.0, (double)this.argument2 / (double)unitsPerEm));
                if (this.roundXYToGrid) {
                    x = F26Dot6.roundHalfUp(x);
                    y = F26Dot6.roundHalfUp(y);
                }
                this.offset = new F26Dot6Vector(x, y);
            }
            this.outline.scale(unitsPerEm, em2px);
        }

        public void instruct(TTInterpreter interpreter) throws InvalidGlyphException, UnsupportedFontException {
            this.outline.instruct(interpreter);
        }
    }
}

