/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.comments;

import com.adobe.granite.comments.CommentException;
import com.adobe.granite.comments.CommentingProvider;
import com.adobe.granite.comments.internal.Util;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.annotation.versioning.ConsumerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public abstract class AbstractCommentingProvider
implements CommentingProvider {
    private final Logger log = LoggerFactory.getLogger(AbstractCommentingProvider.class);
    private final Predicate COMMENT_RESOURCE_TYPE_PREDICATE = new Predicate(){

        @Override
        public boolean evaluate(Object o) {
            Resource resource = (Resource)o;
            return ResourceUtil.isA(resource, AbstractCommentingProvider.this.getCommentResourceType());
        }
    };
    public static final String RELATIVE_TARGET_ROOT = "comments";
    public static final String PN_ANNOTATIONDATA = "annotationData";
    public static final String PN_AUTHOR = "author";
    public static final String PN_MESSAGE = "jcr:description";
    public static final String JCR_CREATED_BY = "jcr:createdBy";
    public static final String SLING_RESOURCE_TYPE = "sling:resourceType";

    public final Resource createCollectionResource(Resource target) {
        String rootPath = this.getCollectionResourcePath(target);
        Session session = target.getResourceResolver().adaptTo(Session.class);
        try {
            if (session.itemExists(rootPath)) {
                throw new CommentException("Collection already exists: " + rootPath);
            }
            Node collectionRoot = this.createCollectionNode(rootPath, session);
            if (StringUtils.isNotBlank(this.getCollectionResourceType())) {
                collectionRoot.setProperty(SLING_RESOURCE_TYPE, this.getCollectionResourceType());
            }
            collectionRoot.addMixin("{http://www.jcp.org/jcr/mix/1.0}lastModified");
            if (!collectionRoot.hasProperty("jcr:created")) {
                collectionRoot.setProperty("jcr:created", Calendar.getInstance());
            }
            if (!collectionRoot.hasProperty(JCR_CREATED_BY)) {
                collectionRoot.setProperty(JCR_CREATED_BY, session.getUserID());
            }
            this.customizeCollectionNode(target, collectionRoot);
            session.save();
            return target.getResourceResolver().getResource(collectionRoot.getPath());
        }
        catch (RepositoryException e) {
            this.log.error("error while creating collection root for target [{}]: ", (Object)target.getPath(), (Object)e);
            throw new CommentException("Could not create collection root for target: " + target.getPath(), e);
        }
    }

    public final Resource createCommentResource(Resource collectionResource, String message, String author, String annotationData) {
        try {
            ResourceResolver resolver = collectionResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            Node collectionNode = session.getNode(collectionResource.getPath());
            String commentPath = this.getCommentResourcePath(collectionResource, message);
            Node commentNode = this.createCommentNode(commentPath, collectionNode, session);
            if (StringUtils.isNotBlank(this.getCommentResourceType())) {
                commentNode.setProperty(SLING_RESOURCE_TYPE, this.getCommentResourceType());
            }
            commentNode.setProperty(PN_MESSAGE, message);
            this.customizeCommentNode(collectionResource, commentNode);
            Calendar now = Calendar.getInstance();
            commentNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}lastModified");
            if (!commentNode.hasProperty("jcr:created")) {
                commentNode.setProperty("jcr:created", now);
            }
            if (!commentNode.hasProperty(JCR_CREATED_BY)) {
                commentNode.setProperty(JCR_CREATED_BY, session.getUserID());
            }
            if (StringUtils.isNotBlank(author)) {
                commentNode.setProperty(PN_AUTHOR, author);
            }
            if (StringUtils.isNotBlank(annotationData)) {
                commentNode.setProperty(PN_ANNOTATIONDATA, annotationData);
            }
            collectionNode.setProperty("jcr:lastModified", now);
            session.save();
            return resolver.getResource(commentNode.getPath());
        }
        catch (RepositoryException e) {
            this.log.error("error while creating comment for collection [{}]: ", (Object)collectionResource.getPath(), (Object)e);
            throw new CommentException("Could not x for collection: " + collectionResource.getPath(), e);
        }
    }

    public Iterator<Resource> getCommentResources(Resource collectionResource) {
        Iterator<Resource> children = collectionResource.listChildren();
        return new FilterIterator(children, this.COMMENT_RESOURCE_TYPE_PREDICATE);
    }

    public void removeCommentResource(Resource resource) {
        try {
            Session session = resource.getResourceResolver().adaptTo(Session.class);
            Node node = session.getNode(resource.getPath());
            node.remove();
            session.save();
        }
        catch (RepositoryException e) {
            this.log.error("error while removing comment [{}]: ", (Object)resource.getPath(), (Object)e);
            throw new CommentException("Could not remove comment: " + resource.getPath(), e);
        }
    }

    public void removeCollectionResource(Resource resource) {
        try {
            ResourceResolver resolver = resource.getResourceResolver();
            if (null != resolver.getResource(resource.getPath())) {
                Session session = resolver.adaptTo(Session.class);
                session.removeItem(resource.getPath());
                session.save();
            }
        }
        catch (RepositoryException e) {
            this.log.error("error while removing collection [{}]: ", (Object)resource.getPath(), (Object)e);
            throw new CommentException("Could not remove collection: " + resource.getPath(), e);
        }
    }

    public final Resource createAttachmentResource(Resource commentResource, String name, InputStream inputStream, String mimeType) {
        try {
            ResourceResolver resolver = commentResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            Calendar time = Calendar.getInstance();
            Node node = session.getNode(commentResource.getPath());
            Node attachment = JcrUtils.getOrCreateUniqueByPath(node, this.getAttachmentResourcePath(name), "nt:file");
            Node content = attachment.addNode("jcr:content", "nt:unstructured");
            content.setProperty("jcr:created", time);
            content.setProperty(JCR_CREATED_BY, node.getSession().getUserID());
            content.setProperty("jcr:lastModified", time);
            content.setProperty("jcr:mimeType", mimeType);
            content.setProperty("jcr:data", node.getSession().getValueFactory().createBinary(inputStream));
            this.customizeAttachmentNode(commentResource, content);
            session.save();
            return resolver.getResource(attachment.getPath());
        }
        catch (RepositoryException e) {
            this.log.error("error while creating attachment for comment [{}]: ", (Object)commentResource.getPath(), (Object)e);
            throw new CommentException("Could not create attachment for comment: " + commentResource.getPath(), e);
        }
    }

    public Resource getAttachmentResource(Resource commentResource, String name) {
        Resource child = commentResource.getChild(this.getAttachmentResourcePath(name));
        return ResourceUtil.isA(child, "nt:file") ? child : null;
    }

    public void removeAttachmentResource(Resource commentResource, String name) {
        try {
            Resource attachment = commentResource.getChild(this.getAttachmentResourcePath(name));
            if (null != attachment) {
                Session session = attachment.getResourceResolver().adaptTo(Session.class);
                session.removeItem(attachment.getPath());
                session.save();
            }
        }
        catch (RepositoryException e) {
            this.log.error("error while removing attachment from comment [{}]: ", (Object)commentResource.getPath(), (Object)e);
            throw new CommentException("Could not remove attachment from comment: " + commentResource.getPath(), e);
        }
    }

    public final Map<String, Resource> getAttachmentMap(Resource commentResource) throws CommentException {
        HashMap<String, Resource> attachments = new HashMap<String, Resource>();
        Iterator<Resource> iterator = this.getAttachments(commentResource);
        while (iterator.hasNext()) {
            Resource child = iterator.next();
            if (!ResourceUtil.isA(child, "nt:file")) continue;
            attachments.put(child.getName(), child);
        }
        return attachments;
    }

    protected final Resource getCollectionResource(Resource target) throws CommentException {
        return target.getResourceResolver().getResource(this.getCollectionResourcePath(target));
    }

    protected Node createCollectionNode(String rootPath, Session session) {
        try {
            Node root = null;
            String path = rootPath;
            while (root == null && StringUtils.isNotBlank(path)) {
                if (!session.nodeExists(path = Text.getRelativeParent(path, 1))) continue;
                root = session.getNode(path);
            }
            if (root != null) {
                String relPath = StringUtils.removeStart(rootPath, path + '/');
                return JcrUtils.getOrCreateByPath(root, relPath, false, "nt:unstructured", "nt:unstructured", false);
            }
            throw new CommentException("Unable to access parent nodes of new collection");
        }
        catch (RepositoryException e) {
            throw new CommentException("Error creating collection root at: " + rootPath, e);
        }
    }

    protected Node createCommentNode(String commentPath, Node collectionNode, Session session) {
        try {
            return JcrUtils.getOrCreateUniqueByPath(collectionNode, commentPath, "nt:unstructured");
        }
        catch (RepositoryException e) {
            throw new CommentException("Error creating comment node at: " + commentPath, e);
        }
    }

    protected void customizeCollectionNode(Resource target, Node collectionNode) {
    }

    protected void customizeCommentNode(Resource collectionResource, Node commentNode) {
    }

    protected void customizeAttachmentNode(Resource commentResource, Node attachmentContentNode) {
    }

    protected String getCollectionResourcePath(Resource target) {
        Resource contentResource = target.getChild("jcr:content");
        String path = null != contentResource ? contentResource.getPath() : target.getPath();
        return path + "/" + RELATIVE_TARGET_ROOT;
    }

    protected String getCommentResourcePath(Resource collectionResource, String message) {
        return Util.createValidName((String)message);
    }

    protected String getAttachmentResourcePath(String name) {
        return name;
    }

    protected Iterator<Resource> getAttachments(Resource commentResource) {
        return commentResource.listChildren();
    }

    public abstract String getCollectionResourceType();

    public abstract String getCommentResourceType();
}

