/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crypto.spi.base;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.spi.Algorithms;
import com.adobe.granite.crypto.spi.KeyGenerator;
import com.adobe.granite.crypto.spi.KeyProvider;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class KeyProviderBase
implements KeyProvider {
    private static final String AES_KEY_PROPERTY = "master";
    private static final String HMAC_KEY_PROPERTY = "hmac";
    protected KeyGenerator keyGenerator;

    protected KeyProviderBase(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    @Override
    public final byte[] obtainKey(Algorithms algorithm) throws CryptoException {
        String algoProp;
        if (Algorithms.AES == algorithm) {
            algoProp = AES_KEY_PROPERTY;
        } else if (Algorithms.HMAC == algorithm) {
            algoProp = HMAC_KEY_PROPERTY;
        } else {
            if (algorithm == null) {
                throw new IllegalArgumentException("Algorithm must not be null or empty");
            }
            throw new IllegalArgumentException("Unrecognised or unsupported signature algorithm: " + (Object)((Object)algorithm));
        }
        try {
            return this.getOrCreateKey(algorithm, algoProp);
        }
        catch (Exception e) {
            throw new CryptoException("Exception while trying to provide a key");
        }
    }

    protected abstract void establishConnection() throws Exception;

    protected abstract void dropConnection();

    protected abstract byte[] readKey(String var1) throws Exception;

    protected abstract void writeKey(String var1, byte[] var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getOrCreateKey(Algorithms algorithm, String algoProp) throws Exception {
        try {
            this.establishConnection();
            byte[] key = this.readKey(algoProp);
            if (this.keyGenerator == null) {
                throw new CryptoException("Exception while trying to generate a new key");
            }
            if (key == null && this.keyGenerator != null) {
                key = this.keyGenerator.initKey(algorithm);
                this.writeKey(algoProp, key);
            }
            byte[] byArray = key;
            return byArray;
        }
        finally {
            this.dropConnection();
        }
    }
}

