/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.security.user.util;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.security.user.internal.AggregatedUserProperties;
import com.adobe.granite.security.user.internal.AuthorizableInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizableUtil {
    private static Logger log = LoggerFactory.getLogger(AuthorizableUtil.class);
    static final String FAMILY_NAME = "profile/familyName";
    static final String GIVEN_NAME = "profile/givenName";
    @Deprecated
    private static final String PROPERTY_NAME = "rep:fullname";
    @Deprecated
    private static final String PROPERTY_DESCRIPTION = "rep:description";
    @Deprecated
    private static final String PROPERTY_FIRST_NAME = "cq:first-name";
    @Deprecated
    private static final String PROPERTY_LAST_NAME = "cq:last-name";

    public static UserProperties getProfile(@Nonnull UserPropertiesManager userPropertiesManager, @Nonnull String authorizableId) throws RepositoryException {
        UserProperties profiles = userPropertiesManager.getUserProperties(authorizableId, "profiles", UserPropertiesManager.DESCENDING_RANKING_COMPARATOR);
        UserProperties deprecatedProfile = userPropertiesManager.getUserProperties(authorizableId, "profile");
        List<UserProperties> agg = profiles.getAggregatedUserProperties();
        if (agg.isEmpty()) {
            return deprecatedProfile;
        }
        AuthorizableInfo info = new AuthorizableInfo(profiles.getAuthorizableID(), profiles.getAuthorizablePath(), profiles.isGroupProperties(), profiles.getPrincipalName());
        ArrayList<UserProperties> l = new ArrayList<UserProperties>();
        if (deprecatedProfile != null) {
            l.add(deprecatedProfile);
        }
        l.addAll(agg);
        return new AggregatedUserProperties(info, profiles.getNode(), l);
    }

    @Deprecated
    public static String getName(Authorizable authorizable) throws RepositoryException {
        String name = AuthorizableUtil.getProperty(authorizable, GIVEN_NAME, PROPERTY_FIRST_NAME);
        if (authorizable.isGroup()) {
            if (name != null && !name.isEmpty()) {
                return name;
            }
            name = AuthorizableUtil.getProperty(authorizable, PROPERTY_NAME);
            if (name != null && !name.isEmpty()) {
                return name;
            }
            name = AuthorizableUtil.getProperty(authorizable, PROPERTY_DESCRIPTION);
            if (name != null && !name.isEmpty()) {
                return name;
            }
        } else {
            String familyName;
            StringBuilder buf = new StringBuilder();
            if (name != null) {
                buf.append(name);
            }
            if ((familyName = AuthorizableUtil.getProperty(authorizable, FAMILY_NAME, PROPERTY_LAST_NAME)) != null && !familyName.isEmpty()) {
                buf.append(' ').append(familyName);
            }
            if (buf.length() > 0) {
                return buf.toString();
            }
        }
        return authorizable.getID();
    }

    public static String getFormattedName(ResourceResolver resolver, String userId) {
        return AuthorizableUtil.getFormattedName(resolver, null, userId, null);
    }

    public static String getFormattedName(ResourceResolver resolver, Authorizable authorizable) {
        return AuthorizableUtil.getFormattedName(resolver, authorizable, null, null);
    }

    public static String getFormattedName(ResourceResolver resolver, String userId, String nameDisplayOrder) {
        return AuthorizableUtil.getFormattedName(resolver, null, userId, nameDisplayOrder);
    }

    public static String getFormattedName(ResourceResolver resolver, Authorizable authorizable, String nameDisplayOrder) {
        return AuthorizableUtil.getFormattedName(resolver, authorizable, null, nameDisplayOrder);
    }

    private static String getFormattedName(ResourceResolver resolver, Authorizable authorizable, String userId, String nameDisplayOrder) {
        if (!(resolver == null || authorizable == null && StringUtils.isEmpty(userId))) {
            try {
                UserPropertiesManager upm = resolver.adaptTo(UserPropertiesManager.class);
                if (upm != null) {
                    String displayName;
                    UserProperties props;
                    UserProperties userProperties = props = authorizable != null ? AuthorizableUtil.getProfile(upm, authorizable.getID()) : AuthorizableUtil.getProfile(upm, userId);
                    if (props != null && StringUtils.isNotEmpty(displayName = props.getDisplayName(nameDisplayOrder))) {
                        return displayName;
                    }
                }
            }
            catch (RepositoryException e) {
                log.warn("Unable to get display name for " + userId, e);
            }
        }
        try {
            return authorizable != null ? authorizable.getID() : userId;
        }
        catch (RepositoryException e) {
            log.error("Unable to get authorizable id", e);
            return null;
        }
    }

    private static String getProperty(Authorizable authorizable, String propertyName) {
        return AuthorizableUtil.getProperty(authorizable, propertyName, null);
    }

    private static String getProperty(Authorizable authorizable, String propertyName, String fallbackName) {
        try {
            Value[] vs;
            if (authorizable.hasProperty(propertyName) && (vs = authorizable.getProperty(propertyName)) != null && vs.length > 0) {
                return vs[0].getString();
            }
            if (fallbackName != null && authorizable.hasProperty(fallbackName) && (vs = authorizable.getProperty(fallbackName)) != null && vs.length > 0) {
                return vs[0].getString();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }
}

