/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.Value;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class Field {
    @Nonnull
    private Config cfg;
    @Nonnull
    public static String HIDE_IN_DEFAULT_CLASS = "foundation-field-hide-in-default";
    @Nonnull
    public static String IS_MIXED_SUFFIX = ".granite.mixed";
    private static final String BULK_EDIT_MODE_ATTRIBUTE = "granite.ui.field.bulkedit";

    public Field() {
        throw new UnsupportedOperationException("Please use the other constructor");
    }

    public Field(@Nonnull Config cfg) {
        this.cfg = cfg;
    }

    @Nonnull
    public String getRootClass(boolean isEmpty) {
        return Field.getRootClass(this.cfg, isEmpty);
    }

    @Nonnull
    public String getRootClass(@CheckForNull String value) {
        return Field.getRootClass(this.cfg, value);
    }

    public boolean isMixed(@Nonnull Value value) {
        return Field.isMixed(this.cfg, value);
    }

    public boolean isBulkEditAllowed() {
        return this.cfg.get("allowBulkEdit", false);
    }

    public static boolean isBulkEditMode(@Nonnull HttpServletRequest request) {
        Boolean isBulkEditMode = (Boolean)request.getAttribute(BULK_EDIT_MODE_ATTRIBUTE);
        return isBulkEditMode == null ? false : isBulkEditMode;
    }

    public static void setBulkEditMode(@Nonnull HttpServletRequest request) {
        request.setAttribute(BULK_EDIT_MODE_ATTRIBUTE, (Object)true);
    }

    public static void clearBulkEditMode(@Nonnull HttpServletRequest request) {
        request.removeAttribute(BULK_EDIT_MODE_ATTRIBUTE);
    }

    @Nonnull
    public static String getRootClass(@Nonnull Config cfg, boolean isEmpty) {
        String cls = "";
        if (isEmpty && cfg.get("renderReadOnly", false).booleanValue() && !cfg.get("showEmptyInReadOnly", false).booleanValue()) {
            cls = cls + HIDE_IN_DEFAULT_CLASS;
        }
        return cls;
    }

    @Nonnull
    public static String getRootClass(@Nonnull Config cfg, @CheckForNull String value) {
        return Field.getRootClass(cfg, value == null || "".equals(value));
    }

    public static boolean isMixed(@Nonnull Config cfg, @Nonnull Value value) {
        String name = cfg.get("name") + IS_MIXED_SUFFIX;
        return value.getContentValue(name, false);
    }
}

