/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.htl;

import com.adobe.granite.ui.components.AttrBuilder;
import com.adobe.granite.ui.components.Options;
import com.adobe.granite.ui.components.impl.BaseComponentHelper;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.script.Bindings;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.scripting.sightly.pojo.Use;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComponentHelper
implements Use {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentHelper.class);
    private BaseComponentHelper base;
    private StringWriter writer;
    private SlingBindings slingBindings = new SlingBindings();
    private Resource resource;
    private ResourceResolver resourceResolver;
    private AttrBuilder attrs;

    @Override
    public final void init(Bindings scriptBindings) {
        this.slingBindings.putAll(scriptBindings);
        this.writer = new StringWriter();
        SlingScriptHelper sling = this.slingBindings.getSling();
        if (sling == null) {
            throw new RuntimeException("SlingScriptHelper is not available");
        }
        SlingHttpServletRequest request = this.slingBindings.getRequest();
        if (request == null) {
            throw new RuntimeException("SlingHttpServletRequest is not available");
        }
        this.base = new BaseComponentHelper(sling, request, (SlingHttpServletResponse)new PrintWriterResponseWrapper(new PrintWriter(this.writer), this.slingBindings.getResponse()));
        try {
            this.activate();
        }
        catch (Exception e) {
            LOG.error("Failed to activate Use class", e);
        }
    }

    protected final void setSlingBindings(@Nonnull SlingBindings slingBindings) {
        this.slingBindings = slingBindings;
    }

    protected final void setBaseComponentHelper(@Nonnull BaseComponentHelper baseHelper) {
        this.base = baseHelper;
    }

    protected abstract void activate() throws Exception;

    @CheckForNull
    protected final <T> T get(String name, Class<T> type) {
        Object obj = this.slingBindings.get(name);
        try {
            return type.cast(obj);
        }
        catch (ClassCastException e) {
            LOG.error("Failed to cast value", e);
            return null;
        }
    }

    @Nonnull
    protected final SlingHttpServletRequest getRequest() {
        return this.base.getRequest();
    }

    @Nonnull
    protected final Resource getResource() {
        if (this.resource == null) {
            this.resource = this.slingBindings.getResource();
        }
        return this.resource;
    }

    @Nonnull
    protected final ResourceResolver getResourceResolver() {
        if (this.resourceResolver == null) {
            this.resourceResolver = this.getRequest().getResourceResolver();
        }
        return this.resourceResolver;
    }

    @Nonnull
    protected final Options getOptions() {
        return this.base.getOptions();
    }

    @Nonnull
    protected final I18n getI18n() {
        return this.base.getI18n();
    }

    @Nonnull
    protected final XSSAPI getXss() {
        return this.base.getXss();
    }

    @Nonnull
    protected final AttrBuilder getInheritedAttrs() {
        if (this.attrs == null) {
            this.attrs = this.base.consumeTag().getAttrs();
        }
        if (this.attrs == null) {
            this.attrs = new AttrBuilder(this.getRequest(), this.base.getXss());
        }
        return this.attrs;
    }

    @Nonnull
    protected String include(@Nonnull Resource resource, @CheckForNull String resourceType, @CheckForNull String selectors, @Nonnull Options options) throws ServletException, IOException {
        this.base.include(resource, resourceType, selectors, options);
        return this.writer.toString();
    }

    @Nonnull
    protected String call(@Nonnull String script, @Nonnull Options options) throws ServletException, IOException {
        this.base.call(script, options);
        return this.writer.toString();
    }

    protected void populateCommonAttrs(@Nonnull AttrBuilder attrs) {
        this.base.populateCommonAttrs(attrs);
    }

    private class PrintWriterResponseWrapper
    extends SlingHttpServletResponseWrapper {
        private final PrintWriter writer;

        public PrintWriterResponseWrapper(PrintWriter writer, SlingHttpServletResponse wrappedResponse) {
            super(wrappedResponse);
            this.writer = writer;
        }

        public PrintWriter getWriter() throws IOException {
            return this.writer;
        }
    }
}

