/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.encryption.IdentityEncryptionHandlerState;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandlerState;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler;
import java.io.IOException;

public final class IdentityEncryptionHandler
implements EncryptionHandler {
    @Override
    public byte[] encrypt(byte[] content, byte[] key) {
        return content;
    }

    @Override
    public byte[] decrypt(byte[] content, byte[] key) {
        return content;
    }

    @Override
    public void encrypt(InputByteStream src, OutputByteStream dest, byte[] key) throws PDFIOException {
        try {
            IO.copy(src, dest);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    @Override
    public void decrypt(InputByteStream src, OutputByteStream dest, byte[] key) throws PDFIOException {
        try {
            IO.copy(src, dest);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public byte[] getBaseEncryptionKey() {
        return null;
    }

    public SecurityHandler getSecurityHandler() {
        return null;
    }

    public String getAlgorithm() {
        return "Identity";
    }

    public String getHandlerName() {
        return "";
    }

    @Override
    public EncryptionHandlerState createEncryptionHandlerState() {
        return new IdentityEncryptionHandlerState();
    }
}

