/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.pdftoolkit.core.encryption.JCECipherEncryptionHandler;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandler;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class JCEAESEncryptionHandler
extends JCECipherEncryptionHandler
implements EncryptionHandler {
    private static final String PRNG = "SHA1PRNG";
    private static final byte[] SALT = new byte[]{115, 65, 108, 84};
    private Provider mSHA1prngProvider = null;
    private SecureRandom mRandomGenerator = null;

    public JCEAESEncryptionHandler(byte[] encryptionKey, MessageDigest md5Digest, Provider aesProvider, Provider sha1prngProvider, SecureRandom randomGenerator) throws PDFSecurityConfigurationException {
        super("AES/CBC/PKCS5Padding", encryptionKey, md5Digest, aesProvider);
        this.mAddition = SALT;
        this.mSHA1prngProvider = sha1prngProvider;
        this.mRandomGenerator = randomGenerator;
    }

    @Override
    protected byte[] initCipher(Cipher cipher, byte[] content, int len, byte[] key, int mode) throws PDFSecurityConfigurationException {
        byte[] newContent;
        int algLen = "AES/CBC/PKCS5Padding".indexOf(47);
        if (algLen == -1) {
            algLen = "AES/CBC/PKCS5Padding".length();
        }
        String keyAlgorithm = "AES/CBC/PKCS5Padding".substring(0, algLen);
        IvParameterSpec iv = null;
        if (mode == 2) {
            iv = new IvParameterSpec(content, 0, 16);
            newContent = new byte[len - 16];
            System.arraycopy(content, 16, newContent, 0, newContent.length);
        } else {
            byte[] random = new byte[16];
            if (this.mRandomGenerator == null) {
                try {
                    this.mRandomGenerator = this.mSHA1prngProvider == null ? SecureRandom.getInstance(PRNG) : SecureRandom.getInstance(PRNG, this.mSHA1prngProvider);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new PDFSecurityConfigurationException("Cannot generate random number for AES cipher", e);
                }
            }
            this.mRandomGenerator.nextBytes(random);
            iv = new IvParameterSpec(random);
            newContent = new byte[len + 16];
            System.arraycopy(iv.getIV(), 0, newContent, 0, iv.getIV().length);
            System.arraycopy(content, 0, newContent, iv.getIV().length, len);
        }
        SecretKeySpec mEncryptKey = new SecretKeySpec(key, keyAlgorithm);
        try {
            cipher.init(mode, (Key)mEncryptKey, iv);
        }
        catch (InvalidKeyException e) {
            throw new PDFSecurityConfigurationException("Error in AES/CBC/PKCS5Padding encryption handler", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PDFSecurityConfigurationException("Error in AES/CBC/PKCS5Padding encryption handler", e);
        }
        return newContent;
    }

    SecureRandom getSHA1PRNG() {
        return this.mRandomGenerator;
    }
}

