/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption.impl;

import com.adobe.internal.pdftoolkit.core.encryption.impl.PKCS7Utils;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.lang.reflect.Method;

public class KDFDataDecryptor {
    private static final int encryptKeySize = 32;
    private OctetStringContainer encryptedKey;
    private byte[] keyEncryptionOID;
    private OctetStringContainer userKeyingMaterialContainer;
    private byte[] messageDigestOID;

    protected KDFDataDecryptor(OctetStringContainer encryptedKey, byte[] keyEncryptionOID, OctetStringContainer userKeyingMaterialContainer, byte[] messageDigestOID) {
        this.encryptedKey = encryptedKey;
        this.keyEncryptionOID = keyEncryptionOID;
        this.userKeyingMaterialContainer = userKeyingMaterialContainer;
        this.messageDigestOID = messageDigestOID;
    }

    JSAFE_SecretKey getDecodedData(byte[] secret) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException, JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_InputException, JSAFE_PaddingException, IOException {
        byte[] kdfKey = this.applyKDFWrap(secret);
        return this.decryptEncryptedKey(kdfKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] applyKDFWrap(byte[] secret) throws JSAFE_InvalidUseException, JSAFE_UnimplementedException, JSAFE_InvalidParameterException, IOException {
        JSAFE_MessageDigest digester = null;
        byte[] digest = null;
        byte[] counter = this.getCounter(1);
        try {
            digester = PKCS7Utils.getKDFHash(this.messageDigestOID);
            digester.digestInit();
            digester.digestUpdate(secret, 0, secret.length);
            digester.digestUpdate(counter, 0, counter.length);
            digester.digestUpdate(this.userKeyingMaterialContainer.data, this.userKeyingMaterialContainer.dataOffset, this.userKeyingMaterialContainer.dataLen);
            digest = digester.digestFinal();
        }
        finally {
            if (digester != null) {
                digester.clearSensitiveData();
            }
        }
        return digest;
    }

    private byte[] getCounter(int intValue) {
        byte[] result = new byte[]{(byte)(intValue >> 24), (byte)(intValue >> 16), (byte)(intValue >> 8), (byte)intValue};
        return result;
    }

    private JSAFE_SecretKey decryptEncryptedKey(byte[] kdfKey) throws IOException {
        try {
            Class<?> JSAFE_KeyWrapCipher = Class.forName("com.rsa.jsafe.JSAFE_KeyWrapCipher");
            Method getInstance = JSAFE_KeyWrapCipher.getDeclaredMethod("getInstance", String.class, String.class);
            Object symmetricCipher = getInstance.invoke(null, "AESKeyWrapRFC3394", "Native/Java");
            JSAFE_SecretKey secKey = PKCS7Utils.getJSAFE_SecretKey(this.keyEncryptionOID);
            secKey.setSecretKeyData(kdfKey, 0, kdfKey.length / 2);
            Method decryptInit = JSAFE_KeyWrapCipher.getDeclaredMethod("decryptInit", JSAFE_SecretKey.class);
            decryptInit.invoke(symmetricCipher, secKey);
            Method unwrapSecretKey = JSAFE_KeyWrapCipher.getDeclaredMethod("unwrapSecretKey", byte[].class, Integer.TYPE, Integer.TYPE, String.class);
            return (JSAFE_SecretKey)unwrapSecretKey.invoke(symmetricCipher, this.encryptedKey.data, this.encryptedKey.dataOffset, this.encryptedKey.dataLen, "AES");
        }
        catch (Exception exception) {
            throw new IOException("Update to new RSA jars which have EC support.");
        }
    }

    byte[] encryptKey(byte[] kdfKey, JSAFE_SecretKey secretKey) throws IOException, JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_InvalidKeyException, JSAFE_InvalidUseException, JSAFE_InputException {
        try {
            Class<?> JSAFE_KeyWrapCipher = Class.forName("com.rsa.jsafe.JSAFE_KeyWrapCipher");
            Method getInstance = JSAFE_KeyWrapCipher.getDeclaredMethod("getInstance", String.class, String.class);
            Object symmetricCipher = getInstance.invoke(null, "AESKeyWrapRFC3394", "Native/Java");
            JSAFE_SecretKey secKey = PKCS7Utils.getJSAFE_SecretKey(this.keyEncryptionOID);
            secKey.setSecretKeyData(kdfKey, 0, 32);
            Method decryptInit = JSAFE_KeyWrapCipher.getDeclaredMethod("encryptInit", JSAFE_SecretKey.class);
            decryptInit.invoke(symmetricCipher, secKey);
            Method wrapSecretKey = JSAFE_KeyWrapCipher.getDeclaredMethod("wrapSecretKey", JSAFE_SecretKey.class);
            return (byte[])wrapSecretKey.invoke(symmetricCipher, secretKey);
        }
        catch (Exception exception) {
            throw new IOException("Update to new RSA jars which have EC support.");
        }
    }
}

