/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.traverser;

import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosList;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.traverser.GeneralDispatcher;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.util.ArrayListStack;
import java.util.Set;

public class GeneralTraverser {
    private GeneralDispatcher mDispatcher;
    private boolean mNeedsProcessing;

    public GeneralTraverser(GeneralDispatcher dispatcher) {
        this.mDispatcher = dispatcher;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean traverseCosGraph(CosContainer root, Set excludedKeys) throws PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        if (this.mDispatcher == null) {
            return true;
        }
        CosList seenObjects = new CosList();
        CosContainerValuesIterator containerIter = root.getValuesIterator();
        ArrayListStack<TraverserStackItem> traverserStack = new ArrayListStack<TraverserStackItem>();
        traverserStack.push(null);
        seenObjects.add(root.getObjNum(), root);
        CosContainerValuesIterator.Entry curEntry = null;
        while (true) {
            if (containerIter.hasNext()) {
                try {
                    CosObject curObject;
                    curEntry = containerIter.next();
                    if (curEntry == null || (curObject = curEntry.getValue()) == null) continue;
                    ASName curKey = curEntry.getKey();
                    if (excludedKeys != null && excludedKeys.contains(curKey)) continue;
                    boolean wasSeen = curObject.isIndirect() && seenObjects.containsIndex(curEntry.getValue().getObjNum());
                    boolean needsTraversing = true;
                    this.mNeedsProcessing = this.mDispatcher.isCandidate(curEntry, traverserStack, wasSeen);
                    if (this.mNeedsProcessing) {
                        needsTraversing = this.mDispatcher.startDispatch(curEntry, traverserStack, wasSeen);
                    }
                    if (needsTraversing) {
                        if (curObject instanceof CosContainer && !wasSeen) {
                            if (curObject.isIndirect()) {
                                seenObjects.add(curObject.getObjNum(), curObject);
                            }
                            traverserStack.push(new TraverserStackItem(curEntry, containerIter, this.mNeedsProcessing));
                            containerIter = ((CosContainer)curEntry.getValue()).getValuesIterator();
                            continue;
                        }
                        if (this.finishEntry(curEntry, traverserStack)) continue;
                        return this.badReturn();
                    }
                    if (this.finishEntry(curEntry, traverserStack)) continue;
                    return this.badReturn();
                }
                catch (PDFInvalidDocumentException e) {
                    if (this.mDispatcher.continueTraversing(e)) continue;
                    return this.badReturn();
                }
            }
            TraverserStackItem stackItem = (TraverserStackItem)traverserStack.pop();
            if (stackItem == null) {
                return true;
            }
            containerIter = stackItem.getIterator();
            curEntry = stackItem.get_Entry();
            this.mNeedsProcessing = stackItem.needsProcessing();
            try {
                if (this.finishEntry(curEntry, traverserStack)) continue;
                return this.badReturn();
            }
            catch (PDFInvalidDocumentException e) {
                if (!this.mDispatcher.continueTraversing(e)) return this.badReturn();
                continue;
            }
            break;
        }
    }

    private boolean finishEntry(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        return this.mNeedsProcessing ? this.mDispatcher.finishDispatch(entry, visitorStack) : true;
    }

    private boolean badReturn() {
        return false;
    }

    public static class TraverserStackItem {
        private CosContainerValuesIterator.Entry mEntry;
        private CosContainerValuesIterator mIterator;
        private boolean mNeedsProcessing;

        TraverserStackItem(CosContainerValuesIterator.Entry entry, CosContainerValuesIterator iterator, boolean needsProcessing) {
            this.mEntry = entry;
            this.mIterator = iterator;
            this.mNeedsProcessing = needsProcessing;
        }

        public CosContainerValuesIterator.Entry get_Entry() {
            return this.mEntry;
        }

        public CosContainerValuesIterator getIterator() {
            return this.mIterator;
        }

        public boolean needsProcessing() {
            return this.mNeedsProcessing;
        }
    }
}

