/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASBoolean;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ASDictionary
extends ASObject
implements Map<ASName, ASObject> {
    private Map<ASName, ASObject> map = new LinkedHashMap<ASName, ASObject>();

    @Override
    public ASObject replace(ASName name, ASObject clientObject) {
        return this.map.put(name, clientObject);
    }

    public boolean exists(ASName name) {
        return this.map.containsKey(name);
    }

    public Object remove(ASName name) {
        return this.map.remove(name);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("<<");
        Set<ASName> keySet = this.map.keySet();
        for (ASName key : keySet) {
            ASObject value = this.map.get(key);
            str.append(' ');
            str.append(key.toString());
            str.append(' ');
            str.append(value.toString());
        }
        str.append(">>");
        return str.toString();
    }

    @Override
    public void write(OutputByteStream outputByteStream) throws PDFIOException {
        try {
            Set<ASName> keySet = this.map.keySet();
            outputByteStream.write(60);
            outputByteStream.write(60);
            Iterator<ASName> iter = keySet.iterator();
            while (iter.hasNext()) {
                ASName key = iter.next();
                key.write(outputByteStream);
                outputByteStream.write(32);
                ASObject value = this.map.get(key);
                value.write(outputByteStream);
                if (!iter.hasNext()) continue;
                outputByteStream.write(32);
            }
            outputByteStream.write(62);
            outputByteStream.write(62);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public ASNumber getNumber(ASName key) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.map.get(key);
        if (obj != null && !(obj instanceof ASNumber)) {
            throw new PDFUnableToCompleteOperationException("ASNumber Expected");
        }
        return (ASNumber)obj;
    }

    public ASBoolean getBoolean(ASName key) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.map.get(key);
        if (obj != null && !(obj instanceof ASBoolean)) {
            throw new PDFUnableToCompleteOperationException("ASBoolean Expected");
        }
        return (ASBoolean)obj;
    }

    public ASName getName(ASName key) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.map.get(key);
        if (obj != null && !(obj instanceof ASName)) {
            throw new PDFUnableToCompleteOperationException("ASName Expected");
        }
        return (ASName)obj;
    }

    public ASString getString(ASName key) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.map.get(key);
        if (obj != null && !(obj instanceof ASString)) {
            throw new PDFUnableToCompleteOperationException("ASString Expected");
        }
        return (ASString)obj;
    }

    public ASArray getArray(ASName key) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.map.get(key);
        if (obj != null && !(obj instanceof ASArray)) {
            throw new PDFUnableToCompleteOperationException("ASArray Expected");
        }
        return (ASArray)obj;
    }

    public ASDictionary getDictionary(ASName key) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.map.get(key);
        if (obj != null && !(obj instanceof ASDictionary)) {
            throw new PDFUnableToCompleteOperationException("ASDictionary Expected");
        }
        return (ASDictionary)obj;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Collection<ASObject> values() {
        return this.map.values();
    }

    @Override
    public void putAll(Map<? extends ASName, ? extends ASObject> t) {
        this.map.putAll(t);
    }

    @Override
    public Set<Map.Entry<ASName, ASObject>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Set<ASName> keySet() {
        return this.map.keySet();
    }

    @Override
    public ASObject get(Object key) {
        return this.map.get(key);
    }

    @Override
    public ASObject remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public ASObject put(ASName key, ASObject value) {
        return this.map.put(key, value);
    }
}

