/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public class Content {
    protected PDFDocument document;
    protected PDFResources resources;
    protected PDFContents contents;
    protected boolean resourcesDetached;
    protected boolean contentsDetached;

    protected Content(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.document = pdfDocument;
        this.contents = PDFContents.newInstance(pdfDocument);
        this.resources = PDFResources.newInstance(pdfDocument);
    }

    protected Content(PDFContents contents, boolean contentDetached, PDFResources resources, boolean resourcesDetached) {
        this.document = contents.getPDFDocument();
        this.contents = contents;
        this.contentsDetached = contentDetached;
        this.resources = resources;
        this.resourcesDetached = resourcesDetached;
    }

    public static Content newInstance(PDFContents contents, PDFResources resources) {
        return new Content(contents, false, resources, false);
    }

    public static Content newInstance(PDFXObjectForm xobjectForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFContents contents = xobjectForm.getContents();
        PDFResources resources = xobjectForm.getResources();
        boolean contentDetached = false;
        boolean resourcesDetached = false;
        if (contents == null) {
            contents = PDFContents.newInstance(xobjectForm.getPDFDocument());
            contentDetached = true;
        }
        if (resources == null) {
            resources = PDFResources.newInstance(xobjectForm.getPDFDocument());
            resourcesDetached = true;
        }
        return new Content(contents, contentDetached, resources, resourcesDetached);
    }

    public static Content newInstance(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFContents contents = page.getContents();
        PDFResources resources = page.getResources();
        boolean contentDetached = false;
        boolean resourcesDetached = false;
        if (contents == null) {
            contents = PDFContents.newInstance(page.getPDFDocument());
            contentDetached = true;
        }
        if (resources == null) {
            resources = PDFResources.newInstance(page.getPDFDocument());
            resourcesDetached = true;
        }
        return new Content(contents, contentDetached, resources, resourcesDetached);
    }

    public static Content getInstance(PDFContents contents, PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new Content(contents, false, resources, false);
    }

    public static Content newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new Content(pdfDocument);
    }

    public PDFContents getContents() {
        return this.contents;
    }

    public boolean contentsDetached() {
        return this.contentsDetached;
    }

    public InputByteStream getContentStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.contents.getContents();
    }

    public PDFResources getResources() {
        return this.resources;
    }

    public boolean resourcesDetached() {
        return this.resourcesDetached;
    }

    public PDFDocument getPDFDocument() {
        return this.document;
    }
}

