/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureArtifact;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;

public class MarkedContentOperands {
    public static final ASName k_Artifact = ASName.create("Artifact");
    public static final ASName k_Attached = ASName.create("Attached");
    private PDFStructureElement mElement;
    private int mMCID;
    private PDFStructureArtifact mArtifact;
    private ASName mTag;
    private ASDictionary mParams = null;

    public MarkedContentOperands(PDFStructureElement element, int mcid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.mElement = element;
        this.mMCID = mcid;
        this.mArtifact = null;
        this.mTag = element.requireStructureType();
        this.mParams = new ASDictionary();
        this.mParams.put(ASName.k_MCID, new ASNumber(mcid));
    }

    public MarkedContentOperands(PDFStructureArtifact artifact) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString[] batesNumber;
        ASName[] position;
        PDFRectangle bBox;
        ASName subtype;
        this.mArtifact = artifact;
        this.mElement = null;
        this.mMCID = -1;
        this.mTag = k_Artifact;
        this.mParams = new ASDictionary();
        ASName type = artifact.getType();
        this.mParams.put(ASName.k_Type, type);
        if (type.equals(PDFStructureArtifact.k_Pagination) && (subtype = artifact.getSubtype()) != null) {
            this.mParams.put(ASName.k_Subtype, subtype);
        }
        if ((bBox = artifact.getBBox()) != null) {
            ASArray location = new ASArray();
            location.add(new ASNumber(bBox.left()));
            location.add(new ASNumber(bBox.bottom()));
            location.add(new ASNumber(bBox.right()));
            location.add(new ASNumber(bBox.top()));
            this.mParams.put(ASName.k_BBox, location);
        }
        if ((position = artifact.getPosition()) != null) {
            ASArray posArray = new ASArray();
            for (int posInd = 0; posInd < position.length; ++posInd) {
                posArray.add(position[posInd]);
            }
            this.mParams.put(k_Attached, posArray);
        }
        if ((batesNumber = artifact.getContents()) != null && batesNumber.length > 0) {
            if (batesNumber.length == 1) {
                this.mParams.put(ASName.k_Contents, batesNumber[0]);
            } else {
                ASArray batesArray = new ASArray();
                for (int iBates = 0; iBates < batesNumber.length; ++iBates) {
                    if (batesNumber == null) continue;
                    batesArray.add(batesNumber[iBates]);
                }
                this.mParams.put(ASName.k_Contents, batesArray);
            }
        }
    }

    public PDFStructureArtifact getArtifact() {
        return this.mArtifact;
    }

    public ASName getTag() {
        return this.mTag;
    }

    public ASDictionary getParameters() {
        return this.mParams;
    }

    public PDFStructureElement getElement() {
        return this.mElement;
    }

    public int getMCID() {
        return this.mMCID;
    }

    public Instruction startMarkedContent() {
        return this.mParams == null ? InstructionFactory.newBeginMarkedContent(this.getTag()) : InstructionFactory.newBeginMarkedContent(this.getTag(), this.getParameters());
    }
}

