/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;

class TextPositioningOperator
extends ContentOperator {
    static final int Td = 1;
    static final int TD = 2;
    static final int Tm = 3;
    static final int TStar = 4;

    TextPositioningOperator(int type, ASName name) {
        super(type, name);
    }

    @Override
    public void process(Instruction instruction, IOperatorHandler opHandlers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        OperandStack opStack = instruction.getReadonlyOperands();
        switch (this.getType()) {
            case 1: {
                double ty = opStack.popNumber().doubleValue();
                double tx = opStack.popNumber().doubleValue();
                opHandlers.Td(tx, ty, instruction);
                break;
            }
            case 2: {
                double ty = opStack.popNumber().doubleValue();
                double tx = opStack.popNumber().doubleValue();
                opHandlers.TD(tx, ty, instruction);
                break;
            }
            case 3: {
                double f = opStack.popNumber().doubleValue();
                double e = opStack.popNumber().doubleValue();
                double d = opStack.popNumber().doubleValue();
                double c = opStack.popNumber().doubleValue();
                double b = opStack.popNumber().doubleValue();
                double a = opStack.popNumber().doubleValue();
                opHandlers.Tm(a, b, c, d, e, f, instruction);
                break;
            }
            case 4: {
                opHandlers.TStar(instruction);
            }
        }
    }
}

