/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocMDPPermissions;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParameters;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFTransformParametersDocMDP
extends PDFTransformParameters {
    private PDFTransformParametersDocMDP(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    static PDFTransformParametersDocMDP getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFTransformParametersDocMDP pdfObject = (PDFTransformParametersDocMDP)PDFCosObject.getCachedInstance(cosObject, PDFTransformParametersDocMDP.class);
        if (pdfObject == null) {
            pdfObject = new PDFTransformParametersDocMDP(cosObject);
        }
        return pdfObject;
    }

    public static PDFTransformParametersDocMDP newInstance(PDFDocument pdfDocument, PDFDocMDPPermissions perms) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        PDFTransformParametersDocMDP pdfObject = new PDFTransformParametersDocMDP(cosObject);
        if (perms != null) {
            pdfObject.setDictionaryIntValue(ASName.k_P, perms.getValue());
        } else {
            pdfObject.setDictionaryIntValue(ASName.k_P, PDFDocMDPPermissions.FormChanges.getValue());
        }
        pdfObject.setVersion("1.2");
        pdfObject.setType();
        return pdfObject;
    }

    public PDFDocMDPPermissions getPermissions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosPerm = this.getDictionaryCosObjectValue(ASName.k_P);
        if (cosPerm == null) {
            return PDFDocMDPPermissions.FormChanges;
        }
        return PDFDocMDPPermissions.getInstance(cosPerm.intValue());
    }

    public void setPermissions(PDFDocMDPPermissions perms) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (perms == null) {
            this.removeValue(ASName.k_P);
        } else {
            this.setDictionaryIntValue(ASName.k_P, perms.getValue());
        }
    }
}

