/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class PDFCosArrayList<V extends PDFCosObjectContainer>
extends PDFCosObject
implements List<V> {
    protected PDFCosArrayList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
        if (!(cosObject instanceof CosArray)) {
            throw new PDFInvalidDocumentException("CosArray expected, found" + cosObject.getClass() + ". Object number of invalid cosObject:" + cosObject.getObjNum());
        }
    }

    protected abstract V itemInstantiator(CosObject var1) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException;

    @Override
    public int size() {
        return this.getCosArray().size();
    }

    @Override
    public void clear() {
        int i;
        CosObject[] cosObjects = new CosObject[this.size()];
        for (i = 0; i < this.size(); ++i) {
            try {
                cosObjects[i] = this.getCosArray().get(i);
                continue;
            }
            catch (PDFException e) {
                // empty catch block
            }
        }
        for (i = 0; i < this.size(); ++i) {
            try {
                this.getCosArray().remove(cosObjects[i]);
                continue;
            }
            catch (PDFException e) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        Object[] objects = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            objects[i] = this.get(i);
        }
        return objects;
    }

    @Override
    public V get(int index) {
        try {
            CosObject cosObj = this.getCosArray().get(index);
            return this.itemInstantiator(cosObj);
        }
        catch (PDFException e) {
            throw new RuntimeException("Error fetching PDFCosObject at index " + index, e);
        }
    }

    @Override
    public V remove(int index) {
        Object obj = this.get(index);
        if (obj == null) {
            return null;
        }
        try {
            this.getCosArray().remove(obj.getPDFCosObject().getCosObject());
        }
        catch (PDFException e) {
            throw new RuntimeException("Error deleting PDFCosObject at index " + index, e);
        }
        return (V)obj;
    }

    @Override
    public void add(int index, V element) {
        CosObject cosObject = element.getPDFCosObject().getCosObject();
        try {
            this.getCosArray().add(index, cosObject);
        }
        catch (PDFException e) {
            IllegalArgumentException newException = new IllegalArgumentException("Error during add to the PDFCosArrayList.");
            newException.initCause(e);
            throw newException;
        }
    }

    @Override
    public int indexOf(Object element) {
        if (!(element instanceof PDFCosObjectContainer)) {
            return -1;
        }
        CosObject findThisCosObject = ((PDFCosObjectContainer)element).getPDFCosObject().getCosObject();
        CosArray cosArray = this.getCosArray();
        for (int i = 0; i < cosArray.size(); ++i) {
            try {
                if (findThisCosObject != cosArray.get(i)) continue;
                return i;
            }
            catch (PDFException e) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int curSize = this.size();
        if (o == null) {
            for (int i = curSize - 1; i >= 0; --i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = curSize - 1; i >= 0; --i) {
                if (!o.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean add(V element) {
        CosObject cosObject = element.getPDFCosObject().getCosObject();
        try {
            return this.getCosArray().add(cosObject);
        }
        catch (PDFException e) {
            IllegalArgumentException newException = new IllegalArgumentException("Error during add to the PDFCosArrayList.");
            newException.initCause(e);
            throw newException;
        }
    }

    public void addList(PDFCosArrayList<V> list) {
        if (list == null) {
            return;
        }
        Iterator<V> listIter = list.iterator();
        while (listIter.hasNext()) {
            this.add((V)((PDFCosObjectContainer)listIter.next()));
        }
    }

    @Override
    public boolean contains(Object element) {
        if (!(element instanceof PDFCosObjectContainer)) {
            return false;
        }
        CosObject findThisCosObject = ((PDFCosObjectContainer)element).getPDFCosObject().getCosObject();
        CosArray cosArray = this.getCosArray();
        for (int i = 0; i < cosArray.size(); ++i) {
            try {
                if (findThisCosObject != cosArray.get(i)) continue;
                return true;
            }
            catch (PDFException e) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object element) {
        if (!(element instanceof PDFCosObjectContainer)) {
            return false;
        }
        CosObject cosObject = ((PDFCosObjectContainer)element).getPDFCosObject().getCosObject();
        try {
            return this.getCosArray().remove(cosObject);
        }
        catch (PDFException e) {
            return false;
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) {
        Iterator<V> cIter = c.iterator();
        while (cIter.hasNext()) {
            this.add(index++, (V)((PDFCosObjectContainer)cIter.next()));
        }
        return !c.isEmpty();
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeOrRetainAll(c, true);
    }

    private boolean removeOrRetainAll(Collection<?> c, boolean remove) {
        boolean modified = false;
        Iterator<V> e = this.iterator();
        while (e.hasNext()) {
            boolean removeElement = !(c.contains(e.next()) ^ remove);
            if (!removeElement) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.removeOrRetainAll(c, false);
    }

    @Override
    public Iterator<V> iterator() {
        return new PDFCosArrayListIterator();
    }

    protected Iterator<V> iterator(PDFObjectFilter filter) {
        return new PDFCosArrayFilteredIterator(filter);
    }

    public Iterator<V> iterator(int index) {
        return new PDFCosArrayListIterator(index);
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        return null;
    }

    @Override
    public ListIterator<V> listIterator() {
        return new PDFCosArrayListIterator();
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        return new PDFCosArrayListIterator(index);
    }

    @Override
    public V set(int index, V element) {
        CosObject cosObject = element.getPDFCosObject().getCosObject();
        try {
            this.getCosArray().set(index, cosObject);
        }
        catch (PDFException e) {
            IllegalArgumentException newException = new IllegalArgumentException("Error during set on the PDFCosArrayList.");
            newException.initCause(e);
            throw newException;
        }
        return null;
    }

    @Override
    public Object[] toArray(Object[] objects) {
        if (objects.length < this.size()) {
            objects = (Object[])Array.newInstance(objects.getClass().getComponentType(), this.size());
        }
        for (int i = 0; i < this.size(); ++i) {
            objects[i] = this.get(i);
        }
        return objects;
    }

    public class PDFCosArrayListIterator
    implements ListIterator<V> {
        private final ListIterator<CosObject> mIterator;

        PDFCosArrayListIterator() {
            this.mIterator = PDFCosArrayList.this.getCosArray().listIterator();
        }

        PDFCosArrayListIterator(int index) {
            this.mIterator = PDFCosArrayList.this.getCosArray().listIterator();
            while (this.mIterator.hasNext() && index > 0) {
                this.mIterator.next();
                --index;
            }
        }

        public PDFCosArrayListIterator(CosArray array) {
            this.mIterator = array.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public V next() {
            try {
                return PDFCosArrayList.this.itemInstantiator(this.mIterator.next());
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException("Error during add to the PDFCosArrayList.");
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public void remove() {
            this.mIterator.remove();
        }

        @Override
        public int nextIndex() {
            return this.mIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.mIterator.previousIndex();
        }

        @Override
        public boolean hasPrevious() {
            return this.mIterator.hasPrevious();
        }

        @Override
        public V previous() {
            try {
                return PDFCosArrayList.this.itemInstantiator(this.mIterator.previous());
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException("Error during add to the PDFCosArrayList.");
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public void add(V o) {
            this.mIterator.add(o.getPDFCosObject().getCosObject());
        }

        @Override
        public void set(V o) {
            this.mIterator.set(o.getPDFCosObject().getCosObject());
        }
    }

    private class PDFCosArrayFilteredIterator
    implements Iterator<V> {
        private final PDFObjectFilter mFilter;
        private final ListIterator<CosObject> mIterator;
        private CosObject next;
        private int lastIndex = -1;

        private PDFCosArrayFilteredIterator(PDFObjectFilter filter) {
            this.mIterator = PDFCosArrayList.this.getCosArray().listIterator();
            this.mFilter = filter;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.mFilter == null) {
                    return this.mIterator.hasNext();
                }
                if (this.next != null) {
                    return true;
                }
                while (this.mIterator.hasNext()) {
                    this.next = this.mIterator.next();
                    if (!this.mFilter.accept(this.next)) continue;
                    return true;
                }
            }
            catch (PDFException e) {
                throw new RuntimeException(e);
            }
            return false;
        }

        @Override
        public V next() {
            try {
                if (this.hasNext()) {
                    CosObject obj = this.next;
                    this.next = null;
                    this.lastIndex = this.mIterator.nextIndex();
                    return PDFCosArrayList.this.itemInstantiator(obj);
                }
                return null;
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException("Error during next() of the PDFCosArrayList.");
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public void remove() {
            for (int currentIndex = this.mIterator.nextIndex(); currentIndex > this.lastIndex; --currentIndex) {
                this.mIterator.previous();
            }
            this.mIterator.remove();
        }
    }

    public static interface PDFObjectFilter {
        public boolean accept(CosObject var1) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException;
    }
}

