/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.agl.util.ULocale;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosEncryption;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRefAdapter;
import com.adobe.internal.pdftoolkit.core.cos.CosSaveParams;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.cos.PDFCore;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.securityframework.DecryptedState;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityKey;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityLock;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.DocumentListenerRegistryImpl;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocumentInfo;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFile;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEncryption;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEncryptionType;
import com.adobe.internal.pdftoolkit.pdf.document.PDFExtensions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedEmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveFullOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveIncrementalOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveLinearOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistry;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterCrypt;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFViewerPreferences;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFileAttachment;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.xmp.XMPMetaFactoryMonitor;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.options.ParseOptions;
import com.adobe.internal.xmp.properties.XMPProperty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public class PDFDocument {
    protected CosDocument mCosDocument;
    protected DocumentListenerRegistryImpl listenerRegistry = new DocumentListenerRegistryImpl(this);
    protected PDFEncryption mEncryption = null;
    protected boolean newDocument;
    private static final int INIT_PDFOBJECT_CACHE_SIZE = 1024;
    public final Map<CosObjectRefAdapter, Object> pdfObjectCache = new WeakHashMap<CosObjectRefAdapter, Object>(1024);
    public static final Locale ROOT_LOCALE = ULocale.ROOT.toLocale();
    private PDFDocumentType pdfDocType;
    private boolean isComputed = false;
    private boolean hasMarker = false;
    private static final String NS_PDFA_ID = "http://www.aiim.org/pdfa/ns/id/";

    public static PDFDocument newInstance(PDFOpenOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFDocument(options);
    }

    public static PDFDocument newInstance(ASRectangle mediaBox, PDFOpenOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (mediaBox == null) {
            throw new PDFInvalidParameterException("A valid media box must be provided");
        }
        PDFDocument doc = new PDFDocument(options);
        PDFRectangle mediaBoxRect = PDFRectangle.newInstance(doc, mediaBox);
        PDFPage firstPage = PDFPage.newInstance(doc, mediaBoxRect);
        PDFPageTree.newInstance(doc, firstPage);
        return doc;
    }

    public static PDFDocument newInstance(ByteReader src, PDFOpenOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFDocument(src, options);
    }

    public static PDFDocument newInstance(PDFCore core) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFUnsupportedFeatureException {
        return new PDFDocument(core);
    }

    protected PDFDocument(ByteReader src, PDFOpenOptions options) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFOpenOptions ourOptions = new PDFOpenOptions(options);
        this.mCosDocument = CosDocument.newDocument(src, ourOptions);
        this.mCosDocument.setPDFDocument(this);
        this.newDocument = false;
    }

    protected PDFDocument(PDFOpenOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOpenOptions ourOptions = new PDFOpenOptions(options);
        this.mCosDocument = CosDocument.newDocument(ourOptions);
        this.mCosDocument.setPDFDocument(this);
        this.newDocument = true;
    }

    protected PDFDocument(PDFCore core) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFUnsupportedFeatureException {
        this.mCosDocument = CosDocument.newDocument(core);
        if (this.mCosDocument.getPdfDocument() != null) {
            throw new PDFUnsupportedFeatureException("A PDFDocument has been instantiated from this PDFCore object. Cannot instantiate another one.");
        }
        this.mCosDocument.setPDFDocument(this);
        this.newDocument = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFCore finish() throws PDFUnableToCompleteOperationException {
        PDFUnableToCompleteOperationException[] exceptions = null;
        try {
            exceptions = this.listenerRegistry.sendMessage(new DocumentMessage(DocumentMessage.FINISH, this), true);
        }
        catch (PDFException pDFException) {
            // empty catch block
        }
        try {
            this.mCosDocument.setPDFDocument(null);
            PDFCore pDFCore = this.mCosDocument.finish();
            return pDFCore;
        }
        finally {
            if (exceptions != null) {
                try {
                    this.mCosDocument.close();
                }
                catch (PDFException e) {
                    throw new PDFUnableToCompleteOperationException("Error within an error during the closing of document listeners.", e);
                }
                this.internalClose();
                throw new PDFUnableToCompleteOperationException("Error during the closing of document listeners.", exceptions[0]);
            }
            this.internalClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFUnableToCompleteOperationException[] exceptions = null;
        try {
            exceptions = this.listenerRegistry.sendMessage(new DocumentMessage(DocumentMessage.CLOSE, this), true);
        }
        catch (PDFException pDFException) {
            // empty catch block
        }
        try {
            if (this.mCosDocument != null) {
                this.mCosDocument.close();
            }
        }
        finally {
            this.internalClose();
            if (exceptions != null) {
                throw new PDFUnableToCompleteOperationException("Error during the closing of document listeners.", exceptions[0]);
            }
        }
    }

    private void internalClose() {
        XMPMetaFactoryMonitor.clear(this);
        this.mCosDocument = null;
    }

    public DocumentListenerRegistry getListenerRegistry() {
        return this.listenerRegistry;
    }

    public int getNumRevisions() {
        return this.mCosDocument.getNumRevisions();
    }

    public PDFCatalog requireCatalog() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            return PDFCatalog.requireInstance(this.mCosDocument.getRoot());
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Could not get document catalog", e);
        }
        catch (PDFCosParseException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public PDFDocumentInfo getDocumentInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDocumentInfo.getInstance(this.mCosDocument.getInfo());
    }

    public byte[] getDocCreationID() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.getID(0);
    }

    public byte[] getDocModificationID() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.getID(1);
    }

    private byte[] getID(int which) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray array = this.getCosDocument().getTrailer().getCosArray(ASName.k_ID);
        if (array == null) {
            return null;
        }
        CosString creationID = (CosString)array.get(which);
        return creationID.byteArrayValue();
    }

    public PDFPageTree requirePages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.requireCatalog().requirePages();
    }

    public PDFInteractiveForm getInteractiveForm() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.requireCatalog().getInteractiveForm();
    }

    public void setInteractiveForm(PDFInteractiveForm pdfInteractiveForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.requireCatalog().setInteractiveForm(pdfInteractiveForm);
    }

    public void setDocumentInfo(PDFDocumentInfo info) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (info == null) {
            this.mCosDocument.getTrailer().remove(ASName.k_Info);
        } else {
            this.mCosDocument.getTrailer().put(ASName.k_Info, info.getCosObject());
        }
    }

    public boolean exportXMP(OutputStream metadata) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFMetadata pdfMetadata;
        if (metadata != null && (pdfMetadata = this.requireCatalog().getMetadata()) != null) {
            pdfMetadata.getXMLData(metadata);
            return true;
        }
        return false;
    }

    public void importXMP(InputStream metadata) throws PDFInvalidXMLException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFMetadata pdfMetadata = this.requireCatalog().getMetadata();
        if (pdfMetadata == null) {
            pdfMetadata = PDFMetadata.newInstance(this, metadata, 2048);
            this.requireCatalog().setMetadata(pdfMetadata);
        } else {
            pdfMetadata.setData(metadata, 2048);
        }
    }

    public boolean hasXMP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.requireCatalog().dictionaryContains(ASName.k_Metadata);
    }

    public boolean hasInfo() {
        boolean result = this.getCosDocument().getTrailer().containsKey(ASName.k_Info);
        return result;
    }

    public PDFViewerPreferences getViewerPreferences() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.requireCatalog().getViewerPreferences();
    }

    public void setViewerPreferences(PDFViewerPreferences pdfViewerPreferences) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.requireCatalog().setViewerPreferences(pdfViewerPreferences);
    }

    public PDFViewerPreferences procureViewerPreferences() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.requireCatalog().procureViewerPreferences();
    }

    public void freeDuplicateResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDocument().freeDuplicateResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAndClose(ByteWriter byteWriter, PDFSaveOptions options) throws PDFInvalidParameterException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFUnableToCompleteOperationException {
        boolean oldCloseAfterSave = options.getCloseAfterSave();
        try {
            try {
                options.setCloseAfterSave(true);
                this.save(byteWriter, options);
            }
            finally {
                this.close();
            }
        }
        finally {
            options.setCloseAfterSave(oldCloseAfterSave);
        }
    }

    public void save(ByteWriter byteWriter, PDFSaveOptions options) throws PDFInvalidParameterException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFUnableToCompleteOperationException {
        this.preSave(options);
        this.doSave(byteWriter, options);
        this.postSave(options);
    }

    protected void preSave(PDFSaveOptions options) throws PDFUnableToCompleteOperationException {
        this.listenerRegistry.sendMessage(new DocumentMessage(DocumentMessage.SAVE, this), false);
        if (options != null && options.getCloseAfterSave()) {
            this.listenerRegistry.sendMessage(new DocumentMessage(DocumentMessage.CLOSE, this), false);
        }
    }

    protected void postSave(PDFSaveOptions options) {
        if (options != null && options.getCloseAfterSave()) {
            this.internalClose();
        }
    }

    protected void doSave(ByteWriter byteWriter, PDFSaveOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setExtensions(options);
        if (options instanceof PDFSaveFullOptions) {
            this.saveFull(byteWriter, (PDFSaveFullOptions)options);
        } else if (options instanceof PDFSaveIncrementalOptions) {
            this.saveIncremental(byteWriter, (PDFSaveIncrementalOptions)options);
        } else if (options instanceof PDFSaveLinearOptions) {
            this.saveLinear(byteWriter, (PDFSaveLinearOptions)options);
        } else {
            throw new PDFInvalidParameterException("Unrecognized save options.");
        }
    }

    private void saveFull(ByteWriter byteWriter, PDFSaveFullOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.requirePages();
        CosSaveParams cosParams = null;
        if (options == null) {
            cosParams = new CosSaveParams(2);
        } else {
            cosParams = options.getCosSaveParams();
            this.handleEncryption(options);
        }
        this.handleDigSigEncryption(options);
        this.getCosDocument().save(byteWriter, cosParams);
    }

    public boolean canIncrementallySaveInPlace() {
        return this.mCosDocument.getInPlaceByteWriter() != null;
    }

    private void saveIncremental(ByteWriter byteWriter, PDFSaveIncrementalOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (this.newDocument) {
            throw new UnsupportedOperationException("Cannot incrementally save new document");
        }
        this.requirePages();
        CosSaveParams cosParams = null;
        cosParams = options == null ? new CosSaveParams(1) : options.getCosSaveParams();
        if (this.isEncrypted()) {
            Map<String, Object> securityParams = this.getEncryption().getEncryptParameters();
            if (securityParams != null) {
                this.handleEFF(securityParams);
            }
            if (!this.isUnlocked()) {
                throw new UnsupportedOperationException("Cannot incrementally save non-unlocked, encrypted document");
            }
        }
        try {
            this.getCosDocument().save(byteWriter, cosParams);
        }
        catch (PDFInvalidParameterException e) {
            if (options == null) {
                throw new RuntimeException("Invalid internal default save options.", e);
            }
            throw e;
        }
    }

    private void saveLinear(ByteWriter byteWriter, PDFSaveLinearOptions options) throws PDFInvalidDocumentException, PDFInvalidParameterException, PDFIOException, PDFSecurityException {
        this.requirePages();
        ByteWriter tempWriter = null;
        CosSaveParams cosParams = null;
        if (options == null) {
            cosParams = new CosSaveParams(3);
        } else {
            cosParams = options.getCosSaveParams();
            tempWriter = options.getTempByteWriter();
            this.handleEncryption(options);
        }
        this.handleDigSigEncryption(options);
        cosParams.setTempByteWriter(tempWriter);
        this.getCosDocument().save(byteWriter, cosParams);
    }

    public CosDocument getCosDocument() {
        return this.mCosDocument;
    }

    public StreamManager getStreamManager() {
        return this.getCosDocument().getStreamManager();
    }

    public boolean unlock(SecurityKey key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isEncrypted()) {
            if (this.isUnlocked()) {
                return false;
            }
            this.getCosDocument().getEncryption().setDecryptionSecurityManager(key.getSecurityManager());
            this.getCosDocument().getEncryption().authenticateDecryption(null);
        }
        return true;
    }

    public boolean unlock(DecryptedState decryptedState) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isEncrypted()) {
            if (this.isUnlocked()) {
                return false;
            }
            this.getCosDocument().getEncryption().setDecryptionSecurityManager(decryptedState.getSecurityManager(this.getCosDocument()));
            this.getCosDocument().getEncryption().authenticateDecryption(decryptedState);
        }
        return true;
    }

    public void resetUnlock() {
        this.getCosDocument().getEncryption().resetDecryptionSecurityManager();
    }

    public boolean isUnlocked() {
        boolean bRet = false;
        if (this.isEncrypted()) {
            SecurityManager mgr = this.getCosDocument().getEncryption().getDecryptionSecurityManager();
            if (mgr != null) {
                bRet = true;
            }
        } else {
            bRet = true;
        }
        return bRet;
    }

    public boolean isEncrypted() {
        return this.getCosDocument().isEncrypted();
    }

    public PDFEncryptionType getEncryptionType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEncryption encryption = this.getEncryption();
        if (encryption == null) {
            return PDFEncryptionType.None;
        }
        return encryption.getEncryptionType();
    }

    public PDFEncryption getEncryption() throws PDFInvalidDocumentException {
        return this.isEncrypted() ? PDFEncryption.getInstance(this.getCosDocument().getEncryption().getEncryption()) : null;
    }

    private void handleDigSigEncryption(PDFSaveOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPermissions perms;
        int sigFlags;
        SecurityLock securityLock;
        SecurityLock securityLock2 = securityLock = options != null ? options.getSecurityLock() : null;
        if (!(this.isEncrypted() || securityLock != null && securityLock.shouldEncrypt())) {
            return;
        }
        PDFInteractiveForm acroForm = this.getInteractiveForm();
        if (acroForm != null && ((sigFlags = acroForm.getSigFlags()) & 2) != 2) {
            return;
        }
        if (acroForm != null) {
            Iterator<PDFField> fieldIter = acroForm.iterator();
            while (fieldIter.hasNext()) {
                PDFField curField = fieldIter.next();
                if (!(curField instanceof PDFFieldSignature)) continue;
                this.setDigSigEncryption(curField.getDictionaryCosObjectValue(ASName.k_V));
            }
        }
        if ((perms = this.requireCatalog().getPermissions()) != null) {
            this.setDigSigEncryption(perms.getDictionaryCosObjectValue(ASName.k_DocMDP));
            this.setDigSigEncryption(perms.getDictionaryCosObjectValue(ASName.k_UR3));
        }
    }

    private void setDigSigEncryption(CosObject sig) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (sig == null) {
            return;
        }
        if (sig.getType() == 6) {
            CosObject contents = null;
            try {
                contents = ((CosDictionary)sig).get(ASName.k_Contents);
                this.protectDigSigKeysFromEncryption(contents);
            }
            catch (PDFCosParseException e) {
                throw new PDFInvalidDocumentException(e);
            }
            CosArray referenceCosArray = ((CosDictionary)sig).getCosArray(ASName.k_Reference);
            if (referenceCosArray != null) {
                Iterator<CosObject> iter = referenceCosArray.iterator();
                while (iter.hasNext()) {
                    CosObject digestValue = null;
                    try {
                        CosDictionary referenceDict = (CosDictionary)iter.next();
                        digestValue = referenceDict.get(ASName.k_DigestValue);
                        this.protectDigSigKeysFromEncryption(digestValue);
                    }
                    catch (PDFCosParseException e) {
                        throw new PDFInvalidDocumentException(e);
                    }
                }
            }
        }
    }

    private void protectDigSigKeysFromEncryption(CosObject cosObject) {
        if (cosObject != null && cosObject.getType() == 4) {
            ((CosString)cosObject).setIsEncrypted(false);
            ((CosString)cosObject).setToEncrypt(false);
            ((CosString)cosObject).setWriteHex(true);
        }
    }

    private void handleEncryption(PDFSaveOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SecurityLock securityLock = options.getSecurityLock();
        Map securityParams = null;
        if (securityLock != null) {
            securityParams = securityLock.getEncryptParameters();
        }
        if (securityParams != null) {
            this.handleEFF(securityParams);
        }
        if (securityLock != null) {
            if (!securityLock.shouldEncrypt()) {
                this.getCosDocument().getEncryption().resetEncryptionSecurityManager();
                return;
            }
            this.getCosDocument().getEncryption().setEncryptionSecurityManager(securityLock.getSecurityManager(), securityLock.getEncryptParameters());
        }
    }

    private void handleEFF(Map<?, ?> securityParams) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEmbeddedFile file;
        PDFFileSpecification fileSpec;
        String effKey = "EFF";
        if (!securityParams.containsKey(effKey)) {
            return;
        }
        String filterVal = (String)securityParams.get(effKey);
        if (filterVal == null || filterVal.length() == 0) {
            return;
        }
        PDFFilterCrypt effFilter = PDFFilterCrypt.newInstance(this, filterVal);
        PDFNameDictionary namedDict = this.requireCatalog().getNameDictionary();
        if (namedDict == null) {
            return;
        }
        PDFNamedEmbeddedFiles efTree = namedDict.getNamedEmbeddedFiles();
        if (efTree != null) {
            Iterator<PDFTree.Entry> efTreeIter = efTree.iterator();
            while (efTreeIter.hasNext()) {
                PDFTree.Entry entry = efTreeIter.next();
                fileSpec = (PDFFileSpecification)entry.getValue();
                if (fileSpec == null || (file = fileSpec.getEmbeddedFile()) == null) continue;
                this.createEFFOutputFilterList(file, effFilter);
            }
        }
        PDFAnnotationIterator annotIter = this.requirePages().getAnnotationsIterator();
        while (annotIter.hasNext()) {
            PDFAnnotationFileAttachment fileAnnot;
            PDFAnnotation annot = annotIter.next();
            if (!(annot instanceof PDFAnnotationFileAttachment) || (fileSpec = (fileAnnot = (PDFAnnotationFileAttachment)annot).getFileSpecification()) == null || (file = fileSpec.getEmbeddedFile()) == null) continue;
            this.createEFFOutputFilterList(file, effFilter);
        }
    }

    private void createEFFOutputFilterList(PDFEmbeddedFile file, PDFFilterCrypt effFilter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (file == null) {
            return;
        }
        PDFFilterList outputFilters = file.procureOutputFilters();
        if (outputFilters.hasNamedCryptFilter(effFilter)) {
            return;
        }
        outputFilters.remove("Crypt");
        outputFilters.add(0, effFilter);
        file.setOutputFilters(outputFilters);
    }

    public PDFVersion getToSaveVersion() {
        String version = this.getCosDocument().getToSaveVersion();
        if (version == null) {
            return null;
        }
        return PDFVersion.getInstance(version, this.getCosDocument().getToSaveExtensions());
    }

    public PDFVersion procureToSaveVersion() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        String version = this.getCosDocument().procureToSaveVersion();
        PDFVersion cosVersion = PDFVersion.getInstance(version);
        Map extensions = this.getCosDocument().isToSaveExtensionsInitialized() ? this.getCosDocument().getToSaveExtensions() : this.extensionsMap();
        return PDFVersion.newInstance(cosVersion.getMajorversion(), cosVersion.getMinorversion(), extensions);
    }

    public void setToSaveVersion(PDFVersion version) {
        if (version == null) {
            return;
        }
        this.getCosDocument().setToSaveVersion(version.getVersionValue());
        this.getCosDocument().setToSaveExtensions(version.getExtensions());
    }

    private Map<?, ?> extensionsMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.requireCatalog().hasExtensions() ? this.requireCatalog().getExtensions().asMap() : null;
    }

    private void setExtensions(PDFSaveOptions options) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        Map toSaveExtensions = this.getCosDocument().getToSaveExtensions();
        PDFVersion toSaveVersion = options.getVersion();
        if (toSaveExtensions == null && toSaveVersion != null) {
            toSaveExtensions = toSaveVersion.getExtensions();
        }
        if (toSaveExtensions != null) {
            this.requireCatalog().setExtensions(PDFExtensions.newInstance(this, toSaveExtensions));
        } else if (toSaveVersion != null) {
            this.requireCatalog().setExtensions(null);
        }
    }

    public PDFVersion getOriginalVersion() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        String version = this.getCosDocument().getOriginalVersion();
        if (version == null) {
            return null;
        }
        return PDFVersion.getInstance(version, this.extensionsMap());
    }

    Map<CosObjectRefAdapter, Object> getPDFObjectCache() {
        return this.pdfObjectCache;
    }

    public SecurityHandler getEncryptionSecurityHandler() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosEncryption cosEncryption = this.getCosDocument().getEncryption();
        if (cosEncryption == null) {
            return null;
        }
        SecurityManager secMgr = cosEncryption.getEncryptionSecurityManager();
        if (secMgr == null) {
            return null;
        }
        return secMgr.getSecurityHandler(null, cosEncryption.getEncryptionMap());
    }

    public long getFileSize() throws PDFIOException {
        return this.getCosDocument().getFileSize();
    }

    public String[] getDocID() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        String[] arr = new String[2];
        CosArray docIdArr = this.getCosDocument().getTrailer().getCosArray(ASName.k_ID);
        if (docIdArr != null && docIdArr.size() > 1) {
            arr[0] = docIdArr.getHexString(0).asString();
            arr[1] = docIdArr.getHexString(1).asString();
            return arr;
        }
        return null;
    }

    public boolean isDirty() {
        return this.isInternalStateDirty() || this.isExternalStateDirty();
    }

    public boolean wasRepaired() {
        return this.getCosDocument().wasRepaired();
    }

    public boolean isInternalStateDirty() {
        CosDocument cosDocument = this.getCosDocument();
        if (cosDocument == null) {
            return false;
        }
        return cosDocument.isDirty();
    }

    public boolean isExternalStateDirty() {
        return this.getListenerRegistry().isAnyListenerDirty();
    }

    public void markDirty(boolean dirty) {
        CosDocument cosDocument = this.getCosDocument();
        if (dirty) {
            cosDocument.markDirty();
        } else {
            cosDocument.markNotDirty();
        }
    }

    public boolean requiresFullSave() {
        return !this.canIncrementallySaveInPlace();
    }

    public Locale getDocumentLocale() {
        Locale docLocale = this.getCosDocument().getOptions().getDocLocale();
        if (docLocale == null) {
            return this.getSystemLocale();
        }
        return docLocale;
    }

    private Locale getSystemLocale() {
        return new Locale(Locale.getDefault().toString());
    }

    public PDFDocumentType getPDFDocumentType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfDocType;
    }

    public void setPDFDocumentType(PDFDocumentType pdfDocType) {
        this.pdfDocType = pdfDocType;
    }

    public DecryptedState getDecryptedState() {
        SecurityHandler handler;
        if (this.isEncrypted() && this.isUnlocked() && (handler = this.getCosDocument().getEncryption().getEncryptionImpl().getSecurityHandler()) != null) {
            return handler.getDecryptedState();
        }
        return null;
    }

    public boolean documentHasPDFAMarker(PDFDocument document) {
        try {
            if (document == null) {
                return false;
            }
            XMPMeta metadata = null;
            if (!this.isComputed) {
                this.isComputed = true;
                metadata = this.getDocumentXMP(document.requireCatalog().getMetadata());
                if (metadata == null) {
                    return false;
                }
                XMPProperty part = metadata.getProperty(NS_PDFA_ID, "part");
                XMPProperty conformance = metadata.getProperty(NS_PDFA_ID, "conformance");
                String partString = part == null ? null : part.getValue();
                String conformanceString = conformance == null ? null : conformance.getValue();
                this.hasMarker = !(!"1".equals(partString) && !"2".equals(partString) && !"3".equals(partString) || !"A".equals(conformanceString) && !"B".equals(conformanceString) && !"U".equals(conformanceString));
            }
            return this.hasMarker;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMPMeta getDocumentXMP(PDFMetadata pdfMetadata) throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream outStm = null;
        try {
            if (pdfMetadata != null) {
                outStm = new ByteArrayOutputStream(pdfMetadata.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)pdfMetadata.getLength());
                pdfMetadata.getStreamData(outStm);
                is = new ByteArrayInputStream(outStm.toByteArray());
                ParseOptions options = new ParseOptions();
                options.setAcceptLatin1(false);
                options.setFixControlChars(false);
                options.setOmitNormalization(true);
                XMPMeta xMPMeta = XMPMetaFactoryMonitor.parse(is, options, pdfMetadata.getPDFDocument());
                return xMPMeta;
            }
        }
        catch (Exception e) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (outStm != null) {
                    outStm.close();
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (outStm != null) {
                    outStm.close();
                }
            }
        }
        return null;
    }

    public static enum PDFDocumentType {
        Flat(false, false, false),
        Acroform(false, false, false),
        StaticShellXFA(false, true, true),
        StaticNonShellXFA(false, true, false),
        DynamicShellXFA(true, false, true),
        DynamicNonShellXFA(true, false, false);

        private final boolean isDynamic;
        private final boolean isStatic;
        private final boolean isShell;

        private PDFDocumentType(boolean isDynamic, boolean isStatic, boolean isShell) {
            this.isDynamic = isDynamic;
            this.isStatic = isStatic;
            this.isShell = isShell;
        }

        public boolean isXFA() {
            return this.isDynamic || this.isStatic;
        }

        public boolean isDynamic() {
            return this.isDynamic;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public boolean isShell() {
            return this.isShell;
        }
    }
}

