/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.pdftoolkit.core.cos.CosSaveParams;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityLock;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;

public class PDFSaveLinearOptions
extends PDFSaveOptions {
    public static final int CURRENT_XREF = 0;
    public static final int XREFTABLE = 1;
    public static final int XREFSTREAM = 2;
    public static final int XREFHYBRID = 3;
    private SecurityLock mLock = null;
    private ByteWriter mTempWriter = null;

    private PDFSaveLinearOptions() {
        this.mCosSaveParams = new CosSaveParams(3);
    }

    public static PDFSaveLinearOptions newInstance() {
        return new PDFSaveLinearOptions();
    }

    public static PDFSaveLinearOptions newInstance(PDFVersion version) {
        PDFSaveLinearOptions options = PDFSaveLinearOptions.newInstance();
        options.setVersion(version);
        return options;
    }

    public static PDFSaveLinearOptions newInstance(SecurityLock lock) {
        PDFSaveLinearOptions options = PDFSaveLinearOptions.newInstance();
        options.setSecurityLock(lock);
        return options;
    }

    public void setSecurityLock(SecurityLock lock) {
        this.mLock = lock;
    }

    @Override
    public SecurityLock getSecurityLock() {
        return this.mLock;
    }

    public ByteWriter getTempByteWriter() {
        return this.mTempWriter;
    }

    public void setTempByteWriter(ByteWriter tempWriter) {
        this.mTempWriter = tempWriter;
    }

    void setCosSaveParams(CosSaveParams cosParams) {
        this.mCosSaveParams = cosParams;
    }

    CosSaveParams getCosSaveParams() {
        return this.mCosSaveParams;
    }
}

