/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTreeLeaf;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTreeList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTreeNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class PDFTree<K, V>
extends PDFTreeNode<K, V> {
    protected PDFTree(CosObject cosObject, ASName nameDictionaryKey) throws PDFInvalidDocumentException {
        super(cosObject, nameDictionaryKey);
    }

    private void addFirstEntry(CosScalar name, CosObject value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFDocument pdfDocument = this.getPDFDocument();
        ASName keyName = this.getNameDictionaryKey();
        PDFTreeLeaf leaf = PDFTreeLeaf.newInstance(pdfDocument, null, keyName, name, value);
        PDFTreeList kids = PDFTreeList.newInstance(pdfDocument, null, keyName, leaf);
        this.getCosDictionary().put(ASName.k_Kids, kids.getCosObject());
    }

    private void setChildren(PDFTreeList<K, V> kids) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.k_Kids, kids.getCosObject());
    }

    private PDFTreeLeaf<K, V> getLeaf() throws PDFInvalidDocumentException {
        return PDFTreeLeaf.getInstance(this.getCosObject(), null, this.getNameDictionaryKey());
    }

    @Override
    protected void resetLimits() {
    }

    @Override
    protected void setLimitLower(CosScalar lower) {
    }

    @Override
    protected void setLimitUpper(CosScalar upper) {
    }

    @Override
    protected int inRange(CosScalar name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasChildren()) {
            return super.inRange(name);
        }
        PDFTreeLeaf<K, V> leaf = this.getLeaf();
        if (leaf == null) {
            return -1;
        }
        return leaf.inRange(name);
    }

    @Override
    protected CosObject keyValue(CosScalar name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasChildren()) {
            return super.keyValue(name);
        }
        PDFTreeLeaf<K, V> leaf = this.getLeaf();
        if (leaf == null) {
            return null;
        }
        return leaf.keyValue(name);
    }

    @Override
    protected CosScalar previousKey(CosScalar name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasChildren()) {
            return super.previousKey(name);
        }
        PDFTreeLeaf<K, V> leaf = this.getLeaf();
        if (leaf == null) {
            return null;
        }
        return leaf.previousKey(name);
    }

    @Override
    public boolean isEmpty() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasChildren()) {
            return super.isEmpty();
        }
        PDFTreeLeaf<K, V> leaf = this.getLeaf();
        if (leaf == null) {
            return true;
        }
        return leaf.isEmpty();
    }

    @Override
    protected boolean deleteValue(CosScalar name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasChildren()) {
            boolean deleted = super.deleteValue(name);
            this.removeRootLimits();
            return deleted;
        }
        PDFTreeLeaf<K, V> leaf = this.getLeaf();
        if (leaf == null) {
            return false;
        }
        boolean deleted = leaf.deleteValue(name);
        this.removeRootLimits();
        return deleted;
    }

    private void removeRootLimits() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosDict = this.getCosDictionary();
        if (cosDict.containsKey(ASName.k_Limits)) {
            cosDict.remove(ASName.k_Limits);
        }
    }

    @Override
    protected PDFTreeNode<K, V> putValue(CosScalar name, CosObject value, boolean replace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.hasChildren()) {
            PDFTreeList orgKids = this.getChildren();
            PDFTreeList splitKids = orgKids.putValue(name, value, replace);
            if (splitKids != null) {
                PDFTreeNode kid_a = PDFTreeNode.newInstance(this.getPDFDocument(), this.getNameDictionaryKey(), orgKids);
                PDFTreeNode kid_b = PDFTreeNode.newInstance(this.getPDFDocument(), this.getNameDictionaryKey(), splitKids);
                PDFTreeList newKids = PDFTreeList.newInstance(this.getPDFDocument(), this, this.getNameDictionaryKey());
                newKids.add(kid_a);
                newKids.add(kid_b);
                this.setChildren(newKids);
            }
            return null;
        }
        PDFTreeLeaf<K, V> leaf = this.getLeaf();
        if (leaf == null) {
            this.addFirstEntry(name, value);
            return null;
        }
        PDFTreeNode<K, V> kid_a = leaf.putValue(name, value, replace);
        if (kid_a != null) {
            PDFTreeList newKids = PDFTreeList.newInstance(this.getPDFDocument(), this, this.getNameDictionaryKey());
            PDFTreeLeaf kid_b = PDFTreeLeaf.newInstance(this.getPDFDocument(), this, this.getNameDictionaryKey(), this.getDictionaryArrayValue(this.getNameDictionaryKey()));
            newKids.add(kid_b);
            newKids.add(kid_a);
            this.setChildren(newKids);
            this.getCosDictionary().remove(this.getNameDictionaryKey());
        }
        this.removeRootLimits();
        return null;
    }

    private boolean addValue(CosScalar name, V value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            this.putValue(name, this.internalGetCosObjectFromValue(value), false);
            return true;
        }
        catch (PDFInvalidParameterException exception) {
            return false;
        }
    }

    private boolean replaceValue(CosScalar name, V value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            this.putValue(name, this.internalGetCosObjectFromValue(value), true);
            return true;
        }
        catch (PDFInvalidParameterException exception) {
            return false;
        }
    }

    public Iterator<K> keyIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new KeyIterator();
    }

    public Iterator<Entry> iterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.listIterator();
    }

    public Set<V> values() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashSet value = new HashSet();
        ListIterator<Entry> iter = this.listIterator();
        Entry next = null;
        while (iter.hasNext()) {
            next = (Entry)iter.next();
            value.add(next.getValue());
        }
        return value;
    }

    public ListIterator<Entry> listIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new EntryIterator(this.treeNodeIterator());
    }

    ListIterator<PDFTreeNode.InternalEntry> treeNodeIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFTreeList kids = this.getChildren();
        if (kids != null) {
            return super.treeNodeListIterator();
        }
        PDFTreeLeaf<K, V> leaf = this.getLeaf();
        return leaf.treeNodeListIterator();
    }

    protected abstract V makeValueType(CosObject var1) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    protected abstract CosScalar makeInternalKeyType(K var1) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    protected abstract K makeExternalKeyType(CosScalar var1) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    protected abstract CosObject getCosObjectFromValue(V var1) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    private CosObject internalGetCosObjectFromValue(V value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return value != null ? this.getCosObjectFromValue(value) : PDFCosObject.newCosNull(this.getPDFDocument());
    }

    public V getEntry(K key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosScalar internalKey = this.makeInternalKeyType(key);
        CosObject cosObject = this.keyValue(internalKey);
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return this.makeValueType(cosObject);
    }

    public boolean hasEntry(K key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosScalar internalKey = this.makeInternalKeyType(key);
        CosObject cosObject = this.keyValue(internalKey);
        return PDFCosObject.checkNullCosObject(cosObject) != null;
    }

    public boolean addEntry(K key, V value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosScalar internalKey = this.makeInternalKeyType(key);
        return this.addValue(internalKey, value);
    }

    public boolean removeEntry(K key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosScalar internalKey = this.makeInternalKeyType(key);
        return this.deleteValue(internalKey);
    }

    public boolean replaceEntry(K key, V value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosScalar internalKey = this.makeInternalKeyType(key);
        return this.replaceValue(internalKey, value);
    }

    public K previousKey(K key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosScalar internalKey = this.makeInternalKeyType(key);
        CosScalar previousKey = this.previousKey(internalKey);
        if (previousKey == null) {
            return null;
        }
        return this.makeExternalKeyType(previousKey);
    }

    class KeyIterator
    implements Iterator<K> {
        private final Iterator<Entry> keyIterator;
        private Set<Integer> visitedSet;
        private Integer lastAccessedkey;

        public KeyIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.keyIterator = PDFTree.this.listIterator();
            this.visitedSet = new HashSet<Integer>();
        }

        public KeyIterator(Iterator<Entry> iterator) {
            this.keyIterator = iterator;
            this.visitedSet = new HashSet<Integer>();
        }

        @Override
        public void remove() {
            this.keyIterator.remove();
            this.visitedSet.remove(this.lastAccessedkey);
        }

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext();
        }

        @Override
        public K next() {
            Object key;
            block3: {
                Entry entry = this.keyIterator.next();
                key = null;
                try {
                    key = entry.getKey();
                    if (!(key instanceof CosObject)) break block3;
                    CosObject cosObject = (CosObject)key;
                    this.lastAccessedkey = cosObject.getObjNum();
                    if (this.lastAccessedkey == 0) break block3;
                    if (!this.visitedSet.contains(this.lastAccessedkey)) {
                        this.visitedSet.add(this.lastAccessedkey);
                        break block3;
                    }
                    throw new RuntimeException("Cycle has been detected in PDF Tree");
                }
                catch (PDFException e) {
                    NoSuchElementException newException = new NoSuchElementException("Error generating next PDF object.");
                    newException.initCause(e);
                    throw newException;
                }
            }
            return key;
        }
    }

    private class EntryIterator
    implements ListIterator<Entry> {
        private final ListIterator<PDFTreeNode.InternalEntry> nodeIterator;
        private Set<Integer> visitedSet;
        private Integer lastAccessedEntry;

        public EntryIterator(ListIterator<PDFTreeNode.InternalEntry> nodeIterator) {
            this.nodeIterator = nodeIterator;
            this.visitedSet = new HashSet<Integer>();
        }

        @Override
        public boolean hasNext() {
            return this.nodeIterator.hasNext();
        }

        @Override
        public Entry next() {
            PDFTreeNode.InternalEntry entry = this.nodeIterator.next();
            CosScalar key = entry.getKey();
            this.lastAccessedEntry = key.getObjNum();
            if (this.lastAccessedEntry != 0) {
                if (this.visitedSet.contains(this.lastAccessedEntry)) {
                    throw new RuntimeException("Cycle has been detected in PDF Tree");
                }
                this.visitedSet.add(this.lastAccessedEntry);
            }
            Entry next = null;
            try {
                next = new Entry(key, PDFTree.this.makeValueType(entry.getValue()));
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException("Error generating next PDF object.");
                newException.initCause(e);
                throw newException;
            }
            return next;
        }

        @Override
        public void remove() {
            this.nodeIterator.remove();
            this.visitedSet.remove(this.lastAccessedEntry);
        }

        @Override
        public void add(Entry o) {
            try {
                this.nodeIterator.add(new PDFTreeNode.InternalEntry(o.key, PDFTree.this.internalGetCosObjectFromValue(o.value)));
            }
            catch (PDFException e) {
                IllegalArgumentException newException = new IllegalArgumentException("Error generating next PDF object.");
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.nodeIterator.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.nodeIterator.nextIndex();
        }

        @Override
        public Entry previous() {
            PDFTreeNode.InternalEntry entry = this.nodeIterator.previous();
            Entry previous = null;
            try {
                previous = new Entry(entry.getKey(), PDFTree.this.makeValueType(entry.getValue()));
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException("Error generating next PDF object.");
                newException.initCause(e);
                throw newException;
            }
            return previous;
        }

        @Override
        public int previousIndex() {
            return this.nodeIterator.previousIndex();
        }

        @Override
        public void set(Entry o) {
            try {
                this.nodeIterator.set(new PDFTreeNode.InternalEntry(o.key, PDFTree.this.internalGetCosObjectFromValue(o.value)));
            }
            catch (PDFException e) {
                IllegalArgumentException newException = new IllegalArgumentException("Error generating next PDF object.");
                newException.initCause(e);
                throw newException;
            }
        }
    }

    public class Entry {
        private final CosScalar key;
        private final V value;

        protected Entry(CosScalar key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return PDFTree.this.makeExternalKeyType(this.key);
        }

        public V getValue() {
            return this.value;
        }

        public String toString() {
            try {
                StringBuilder builder = new StringBuilder();
                builder.append("[");
                builder.append(this.getKey());
                builder.append(", ");
                builder.append(this.getValue());
                builder.append("]");
                return builder.toString();
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

