/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosScalarOps;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTreeNode;
import java.util.ListIterator;

class PDFTreeLeaf<K, V>
extends PDFTreeNode<K, V> {
    private PDFTreeLeaf(CosObject cosObject, ASName nameDictionaryKey) throws PDFInvalidDocumentException {
        super(cosObject, nameDictionaryKey);
    }

    public static <K, V> PDFTreeLeaf<K, V> getInstance(CosObject cosObject, PDFTreeNode<K, V> parent, ASName keyName) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFTreeLeaf<K, V> pdfObject = (PDFTreeLeaf<K, V>)PDFCosObject.getCachedInstance(cosObject, PDFTreeLeaf.class);
        if (pdfObject == null) {
            pdfObject = new PDFTreeLeaf<K, V>(cosObject, keyName);
        }
        pdfObject.setParent(parent);
        return pdfObject;
    }

    static <K, V> PDFTreeLeaf<K, V> newInstance(PDFDocument pdfDocument, PDFTreeNode<K, V> parent, ASName nameDictionaryKey, CosScalar name, CosObject value) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFTreeLeaf<K, V> pdfObject = new PDFTreeLeaf<K, V>(cosObject, nameDictionaryKey);
        pdfObject.addValue(name, value);
        pdfObject.setParent(parent);
        return pdfObject;
    }

    static <K, V> PDFTreeLeaf<K, V> newInstance(PDFDocument pdfDocument, PDFTreeNode<K, V> parent, ASName nameDictionaryKey, CosArray namedValues) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFTreeLeaf<K, V> pdfObject = new PDFTreeLeaf<K, V>(cosObject, nameDictionaryKey);
        pdfObject.setParent(parent);
        pdfObject.getCosDictionary().put(nameDictionaryKey, namedValues);
        pdfObject.resetLimits();
        return pdfObject;
    }

    @Override
    protected int inRange(CosScalar name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int rslt = 0;
        CosScalar lower = this.getLimitLower();
        if (lower != null && (rslt = CosScalarOps.compareTo(name, lower)) <= 0) {
            return rslt;
        }
        CosScalar upper = this.getLimitUpper();
        if (upper != null && (rslt = CosScalarOps.compareTo(name, upper)) >= 0) {
            return rslt;
        }
        return 0;
    }

    @Override
    protected CosObject keyValue(CosScalar name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray namedValues = this.getDictionaryArrayValue(this.getNameDictionaryKey());
        if (namedValues != null) {
            for (int i = 0; i < namedValues.size(); i += 2) {
                CosScalar stringKey;
                CosObject obj = namedValues.get(i);
                if (obj == null || !(obj instanceof CosScalar) || !CosScalarOps.equivalent(stringKey = (CosScalar)obj, name)) continue;
                return namedValues.get(i + 1);
            }
        }
        return null;
    }

    @Override
    protected CosScalar previousKey(CosScalar name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosScalar lastKey = null;
        CosArray namedValues = this.getDictionaryArrayValue(this.getNameDictionaryKey());
        if (namedValues != null) {
            for (int i = 0; i < namedValues.size(); i += 2) {
                CosScalar stringKey = (CosScalar)namedValues.get(i);
                if (CosScalarOps.compareTo(stringKey, name) >= 0) {
                    return lastKey;
                }
                lastKey = stringKey;
            }
        }
        return lastKey;
    }

    @Override
    public boolean isEmpty() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray namedValues = this.getDictionaryArrayValue(this.getNameDictionaryKey());
        if (namedValues == null) {
            return true;
        }
        return namedValues.isEmpty();
    }

    @Override
    protected boolean deleteValue(CosScalar name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.inRange(name) != 0) {
            return false;
        }
        CosArray namedValues = this.getDictionaryArrayValue(this.getNameDictionaryKey());
        int size = namedValues.size();
        for (int index = 0; index < size; index += 2) {
            CosScalar orgName = (CosScalar)namedValues.get(index);
            if (CosScalarOps.compareTo(orgName, name) != 0) continue;
            namedValues.remove(index);
            namedValues.remove(index);
            if (namedValues.size() != 0) {
                this.resetLimits();
            }
            return true;
        }
        return false;
    }

    PDFTreeNode<K, V> addValue(CosScalar name, CosObject value) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        return this.putValue(name, value, false);
    }

    PDFTreeNode<K, V> replaceValue(CosScalar name, CosObject value) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        return this.putValue(name, value, true);
    }

    @Override
    protected PDFTreeNode<K, V> putValue(CosScalar name, CosObject value, boolean replaceOperation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosArray namedVals = this.getDictionaryArrayValue(this.getNameDictionaryKey());
        if (namedVals == null) {
            CosArray newNamedValues = PDFCosObject.newCosArray(this.getPDFDocument());
            newNamedValues.add(name);
            newNamedValues.add(value);
            this.setDictionaryValue(this.getNameDictionaryKey(), newNamedValues);
            this.setLimits(name, name);
            return null;
        }
        boolean done = false;
        int siz = namedVals.size();
        for (int i = 0; i < siz && !done; i += 2) {
            CosScalar curName = (CosScalar)namedVals.get(i);
            int nameCompare = CosScalarOps.compareTo(curName, name);
            if (nameCompare < 0) continue;
            if (!replaceOperation && nameCompare == 0) {
                throw new PDFInvalidParameterException("Value already associated with this name, " + name);
            }
            if (replaceOperation && nameCompare == 0) {
                namedVals.set(i, name);
                namedVals.set(i + 1, value);
            } else {
                namedVals.add(i, value);
                namedVals.add(i, name);
            }
            done = true;
        }
        if (!done) {
            namedVals.add(name);
            namedVals.add(value);
        }
        this.resetLimits();
        return this.split();
    }

    @Override
    protected void resetLimits() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mParentNode == null) {
            return;
        }
        CosArray namedValues = this.getDictionaryArrayValue(this.getNameDictionaryKey());
        if (namedValues == null) {
            return;
        }
        this.setLimitLower((CosScalar)namedValues.get(0));
        this.setLimitUpper((CosScalar)namedValues.get(namedValues.size() - 2));
        this.mParentNode.resetLimits();
    }

    private CosArray split(CosArray orgNamedValues) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        int nNames = orgNamedValues.size() >> 1;
        if (nNames <= 64) {
            return null;
        }
        nNames = nNames >> 1 << 1;
        return orgNamedValues.splitBefore(nNames);
    }

    PDFTreeNode<K, V> split() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray orgNamedValues = this.getDictionaryArrayValue(this.getNameDictionaryKey());
        CosArray newNamedValues = this.split(orgNamedValues);
        if (newNamedValues == null) {
            return null;
        }
        this.resetLimits();
        return PDFTreeLeaf.newInstance(this.getPDFDocument(), this.getParent(), this.getNameDictionaryKey(), newNamedValues);
    }

    @Override
    protected ListIterator<PDFTreeNode.InternalEntry> treeNodeListIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFTreeLeafIterator();
    }

    private class PDFTreeLeafIterator
    implements ListIterator<PDFTreeNode.InternalEntry> {
        private ListIterator<CosObject> mIterator;
        boolean nextCalled = false;
        boolean prevCalled = false;

        PDFTreeLeafIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosArray namedValues = PDFTreeLeaf.this.getDictionaryArrayValue(PDFTreeLeaf.this.getNameDictionaryKey());
            if (namedValues != null) {
                this.mIterator = namedValues.listIterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.mIterator == null) {
                return false;
            }
            return this.mIterator.hasNext();
        }

        @Override
        public PDFTreeNode.InternalEntry next() {
            if (this.mIterator == null) {
                return null;
            }
            CosScalar key = (CosScalar)this.mIterator.next();
            CosObject value = this.mIterator.next();
            this.nextCalled = true;
            this.prevCalled = false;
            return new PDFTreeNode.InternalEntry(key, value);
        }

        @Override
        public void remove() {
            if (this.mIterator != null) {
                if (!this.nextCalled && !this.prevCalled) {
                    throw new IllegalStateException("neither next nor previous have been called, or remove or add have been called after the last call to * next or previous.");
                }
                this.mIterator.remove();
                if (this.nextCalled) {
                    this.mIterator.previous();
                } else {
                    this.mIterator.next();
                }
                this.mIterator.remove();
                this.prevCalled = false;
                this.nextCalled = false;
            }
            try {
                if (!PDFTreeLeaf.this.isEmpty()) {
                    PDFTreeLeaf.this.resetLimits();
                }
            }
            catch (PDFException e) {
                IllegalStateException newException = new IllegalStateException("Error during PDFTreeLeafIterator.remove().");
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            if (this.mIterator == null) {
                return false;
            }
            return this.mIterator.hasPrevious();
        }

        @Override
        public PDFTreeNode.InternalEntry previous() {
            CosObject value = this.mIterator.previous();
            CosScalar key = (CosScalar)this.mIterator.previous();
            this.nextCalled = false;
            this.prevCalled = true;
            return new PDFTreeNode.InternalEntry(key, value);
        }

        @Override
        public void add(PDFTreeNode.InternalEntry o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(PDFTreeNode.InternalEntry o) {
            throw new UnsupportedOperationException();
        }
    }
}

