/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDomain;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionsArray;

public class PDFFunctionType3
extends PDFFunction {
    private PDFFunctionType3(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFunctionType3 newInstance(PDFDocument pdfDocument, PDFDomain key_Domain, CosArray key_Encode, PDFFunctionsArray key_Functions, CosArray key_Bounds) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Domain == null) {
            throw new PDFInvalidParameterException("Domain is required when creating newInstance of PDFFunctionType3.");
        }
        if (key_Encode == null) {
            throw new PDFInvalidParameterException("Encode is required when creating newInstance of PDFFunctionType3.");
        }
        if (key_Functions == null) {
            throw new PDFInvalidParameterException("Functions is required when creating newInstance of PDFFunctionType3.");
        }
        if (key_Bounds == null) {
            throw new PDFInvalidParameterException("Bounds is required when creating newInstance of PDFFunctionType3.");
        }
        int k = key_Functions.size();
        if (key_Bounds.size() != k - 1) {
            throw new PDFInvalidDocumentException("Bounds array should be of size " + (k - 1) + " in Stitching Function Dictionary.");
        }
        if (key_Encode.size() != 2 * k) {
            throw new PDFInvalidDocumentException("Encode array should be of size " + 2 * k + " in Stitching Function Dictionary.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFFunctionType3 pdfObject = new PDFFunctionType3(cosObject);
        pdfObject.setFunctionDomain(key_Domain);
        pdfObject.setEncode(key_Encode);
        pdfObject.setFunctionType();
        pdfObject.setFunctions(key_Functions);
        pdfObject.setBounds(key_Bounds);
        return pdfObject;
    }

    public static PDFFunctionType3 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFunctionType3 pdfObject = (PDFFunctionType3)PDFCosObject.getCachedInstance(cosObject, PDFFunctionType3.class);
        if (pdfObject == null) {
            pdfObject = new PDFFunctionType3(cosObject);
        }
        return pdfObject;
    }

    public PDFFunctionsArray getFunctions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFunctionsArray.getInstance(this.getDictionaryCosObjectValue(ASName.k_Functions));
    }

    public void setFunctions(PDFFunctionsArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (children == null) {
            throw new PDFInvalidParameterException("Functions is a required key therefore cannot be removed.");
        }
        this.setDictionaryArrayValue(ASName.k_Functions, children.getCosArray());
    }

    public boolean hasFunctions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Functions);
    }

    public void setFunctionType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_FunctionType, 3L);
    }

    public int requireFunctionType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_FunctionType);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get FunctionType.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public CosArray getEncode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray encode = this.getDictionaryArrayValue(ASName.k_Encode);
        int k = this.getFunctions().size();
        if (encode.size() != 2 * k) {
            throw new PDFInvalidDocumentException("Encode array should be of size " + 2 * k + " in Stitching Function Dictionary.");
        }
        return encode;
    }

    public void setEncode(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Encode is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Encode, value);
    }

    public boolean hasEncode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Encode);
    }

    public CosArray getBounds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray bounds = this.getDictionaryArrayValue(ASName.k_Bounds);
        int k = this.getFunctions().size();
        if (bounds.size() != k - 1) {
            throw new PDFInvalidDocumentException("Bounds array should be of size " + (k - 1) + " in Stitching Function Dictionary.");
        }
        return bounds;
    }

    public void setBounds(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Bounds is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Bounds, value);
    }

    public boolean hasBounds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Bounds);
    }
}

