/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDomain;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRange;

public class PDFFunctionType4
extends PDFFunction {
    private PDFFunctionType4(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFunctionType4 newInstance(PDFDocument pdfDocument, PDFRange key_Range, PDFDomain key_Domain) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Range == null) {
            throw new PDFInvalidParameterException("Range is required when creating newInstance of PDFFunctionType4.");
        }
        if (key_Domain == null) {
            throw new PDFInvalidParameterException("Domain is required when creating newInstance of PDFFunctionType4.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFFunctionType4 pdfObject = new PDFFunctionType4(cosObject);
        pdfObject.setFunctionRange(key_Range);
        pdfObject.setFunctionDomain(key_Domain);
        pdfObject.setFunctionType();
        return pdfObject;
    }

    public static PDFFunctionType4 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFunctionType4 pdfObject = (PDFFunctionType4)PDFCosObject.getCachedInstance(cosObject, PDFFunctionType4.class);
        if (pdfObject == null) {
            pdfObject = new PDFFunctionType4(cosObject);
        }
        return pdfObject;
    }

    private void setFunctionType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_FunctionType, 4L);
    }

    public int requireFunctionType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_FunctionType);
    }
}

